/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.tools.rewrite;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.xk72.util.G;
import com.xk72.util.H;

@XStreamAlias(value="rewriteRule")
@G
@H
public class RewriteRule
implements Cloneable {
    public static final int TYPE_HEADER_ADD = 1;
    public static final String NAME_HEADER_ADD = "Add Header";
    public static final int TYPE_HEADER_REMOVE = 2;
    public static final String NAME_HEADER_REMOVE = "Remove Header";
    public static final int TYPE_HEADER_MODIFY = 3;
    public static final String NAME_HEADER_MODIFY = "Modify Header";
    public static final int TYPE_URL_HOST = 4;
    public static final String NAME_URL_HOST = "Host";
    public static final int TYPE_URL_PATH = 5;
    public static final String NAME_URL_PATH = "Path";
    public static final int TYPE_URL = 6;
    public static final String NAME_URL = "URL";
    public static final int TYPE_BODY = 7;
    public static final String NAME_BODY = "Body";
    public static final int TYPE_URL_QUERY_ADD = 8;
    public static final String NAME_URL_QUERY_ADD = "Add Query Param";
    public static final int TYPE_URL_QUERY_MODIFY = 9;
    public static final String NAME_URL_QUERY_MODIFY = "Modify Query Param";
    public static final int TYPE_URL_QUERY_REMOVE = 10;
    public static final String NAME_URL_QUERY_REMOVE = "Remove Query Param";
    public static final int TYPE_RESPONSE_STATUS = 11;
    public static final String NAME_RESPONSE_STATUS = "Response Status";
    public static final int REPLACE_LEGACY = 0;
    public static final int REPLACE_FIRST = 1;
    public static final int REPLACE_ALL = 2;
    private static final int[] ruleTypes = new int[]{1, 3, 2, 4, 5, 6, 8, 9, 10, 11, 7};
    private static final String[] ruleTypeNames = new String[]{"Add Header", "Modify Header", "Remove Header", "Host", "Path", "URL", "Add Query Param", "Modify Query Param", "Remove Query Param", "Response Status", "Body"};
    private boolean active;
    private int ruleType;
    private String matchHeader;
    private String matchValue;
    private boolean matchHeaderRegex;
    private boolean matchValueRegex;
    private boolean matchRequest;
    private boolean matchResponse;
    private String newHeader;
    private String newValue;
    private boolean newHeaderRegex;
    private boolean newValueRegex;
    private boolean matchWholeValue;
    private Boolean caseSensitive;
    private int replaceType;

    public void init() {
        this.correctForLegacy();
    }

    public String getRuleTypeDescription() {
        switch (this.ruleType) {
            case 1: {
                return "Append";
            }
            case 3: {
                return "Modify";
            }
            case 2: {
                return "Remove";
            }
            case 8: {
                return "Append Query";
            }
            case 9: {
                return "Modify Query";
            }
            case 10: {
                return "Remove Query";
            }
            case 11: {
                return "Status";
            }
        }
        String string = RewriteRule.ruleTypeToName(this.ruleType);
        if (string != null) {
            return string;
        }
        return "Unknown";
    }

    public String getMatchAndNewDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.ruleType == 4 || this.ruleType == 5 || this.ruleType == 6) {
            boolean bl = false;
            if (this.matchValue != null && this.matchValue.length() > 0) {
                stringBuffer.append(this.matchValue);
                bl = true;
            }
            if (bl) {
                stringBuffer.append(" -> ");
            }
            if (this.newValue != null && this.newValue.length() > 0) {
                stringBuffer.append(this.newValue);
            }
        } else if (this.ruleType == 7) {
            boolean bl = false;
            if (this.matchValue != null && this.matchValue.length() > 0) {
                stringBuffer.append(this.matchValue);
                bl = true;
            }
            if (bl) {
                stringBuffer.append(" -> ");
            }
            if (this.newValue != null && this.newValue.length() > 0) {
                stringBuffer.append(this.newValue);
            }
        } else {
            boolean bl = false;
            if (this.matchHeader != null && this.matchHeader.length() > 0) {
                stringBuffer.append(this.matchHeader);
                stringBuffer.append(':');
                bl = true;
            }
            if (this.matchValue != null && this.matchValue.length() > 0) {
                stringBuffer.append(this.matchValue);
                bl = true;
            }
            if (this.ruleType != 2) {
                if (bl) {
                    stringBuffer.append(" -> ");
                }
                if (this.newHeader != null && this.newHeader.length() > 0) {
                    stringBuffer.append(this.newHeader);
                    stringBuffer.append(':');
                }
                if (this.newValue != null && this.newValue.length() > 0) {
                    stringBuffer.append(this.newValue);
                }
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(RewriteRule.ruleTypeToName(this.ruleType));
        stringBuffer.append(": ");
        boolean bl = false;
        if (this.matchHeader != null && this.matchHeader.length() > 0) {
            stringBuffer.append(this.matchHeader);
            stringBuffer.append(':');
            bl = true;
        }
        if (this.matchValue != null && this.matchValue.length() > 0) {
            stringBuffer.append(this.matchValue);
            bl = true;
        }
        if (this.ruleType != 2) {
            if (bl) {
                stringBuffer.append(" -> ");
            }
            if (this.newHeader != null && this.newHeader.length() > 0) {
                stringBuffer.append(this.newHeader);
                stringBuffer.append(':');
            }
            if (this.newValue != null && this.newValue.length() > 0) {
                stringBuffer.append(this.newValue);
            }
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("<Empty Rule>");
        }
        return stringBuffer.toString();
    }

    public static String[] getRuleTypeNames() {
        return ruleTypeNames;
    }

    public static int ruleNameToType(String string) {
        for (int i2 = 0; i2 < ruleTypeNames.length; ++i2) {
            if (string != ruleTypeNames[i2]) continue;
            return ruleTypes[i2];
        }
        return -1;
    }

    public static String ruleTypeToName(int n2) {
        for (int i2 = 0; i2 < ruleTypes.length; ++i2) {
            if (n2 != ruleTypes[i2]) continue;
            return ruleTypeNames[i2];
        }
        return null;
    }

    public RewriteRule clone() {
        try {
            return (RewriteRule)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public String getMatchHeader() {
        return this.matchHeader;
    }

    public void setMatchHeader(String string) {
        this.matchHeader = string;
    }

    public boolean isMatchHeaderRegex() {
        return this.matchHeaderRegex;
    }

    public void setMatchHeaderRegex(boolean bl) {
        this.matchHeaderRegex = bl;
    }

    public boolean isMatchRequest() {
        switch (this.ruleType) {
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
            case 11: {
                return false;
            }
        }
        return this.matchRequest;
    }

    public void setMatchRequest(boolean bl) {
        this.matchRequest = bl;
    }

    public boolean isMatchResponse() {
        switch (this.ruleType) {
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                return false;
            }
            case 11: {
                return true;
            }
        }
        return this.matchResponse;
    }

    public void setMatchResponse(boolean bl) {
        this.matchResponse = bl;
    }

    public String getMatchValue() {
        return this.matchValue;
    }

    public void setMatchValue(String string) {
        this.matchValue = string;
    }

    public boolean isMatchValueRegex() {
        return this.matchValueRegex;
    }

    public void setMatchValueRegex(boolean bl) {
        this.matchValueRegex = bl;
    }

    public String getNewHeader() {
        return this.newHeader;
    }

    public void setNewHeader(String string) {
        this.newHeader = string;
    }

    public boolean isNewHeaderRegex() {
        return this.newHeaderRegex;
    }

    public void setNewHeaderRegex(boolean bl) {
        this.newHeaderRegex = bl;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String string) {
        this.newValue = string;
    }

    public boolean isNewValueRegex() {
        return this.newValueRegex;
    }

    public void setNewValueRegex(boolean bl) {
        this.newValueRegex = bl;
    }

    public int getRuleType() {
        return this.ruleType;
    }

    public void setRuleType(int n2) {
        this.ruleType = n2;
    }

    public boolean isMatchWholeValue() {
        return this.matchWholeValue;
    }

    public void setMatchWholeValue(boolean bl) {
        this.matchWholeValue = bl;
    }

    public boolean isCaseSensitive() {
        if (this.caseSensitive == null) {
            this.caseSensitive = this.ruleType == 7 || this.isURLRule() && !this.matchValueRegex ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.caseSensitive;
    }

    private boolean isURLRule() {
        switch (this.ruleType) {
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    private void correctForLegacy() {
        if (this.replaceType == 0) {
            this.replaceType = this.ruleType == 7 ? 2 : 1;
            if (this.matchValueRegex && this.ruleType != 7) {
                this.matchWholeValue = true;
            }
        }
    }

    public int getReplaceType() {
        return this.replaceType;
    }

    public void setReplaceType(int n2) {
        this.replaceType = n2;
    }
}

