/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.proxy;

import com.xk72.proxy.Fields$ParseException;
import com.xk72.proxy.io.j;
import com.xk72.proxy.io.m;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Fields
implements Serializable {
    private static final Logger b = Logger.getLogger("com.xk72.proxy.Fields");
    private static final long serialVersionUID = 801536825957185048L;
    private static Charset c = Charset.forName("ISO-8859-1");
    protected static final byte[] a = "\r\n".getBytes(c);
    private static final byte[] d = ": ".getBytes(c);
    protected ArrayList<String> fieldNames = new ArrayList();
    protected ArrayList<String> fieldValues = new ArrayList();

    public void reset() {
        this.fieldNames.clear();
        this.fieldValues.clear();
    }

    public void read(m m2) {
        this.fieldNames.clear();
        this.fieldValues.clear();
        String string = m2.f_();
        String string2 = null;
        StringBuffer stringBuffer = null;
        while (string != null && string.length() != 0) {
            if (b.isLoggable(Level.FINEST)) {
                b.finest(string);
            }
            if (string.startsWith(" ")) {
                if (stringBuffer == null) {
                    throw new IOException("Found header field continuation before a header field!: \"" + string + "\"");
                }
                stringBuffer.append(string);
            } else {
                int n2;
                int n3 = string.indexOf(58);
                if (n3 == 0 && (n2 = string.indexOf(58, 1)) > 0) {
                    n3 = n2;
                }
                if (n3 == -1) {
                    if (stringBuffer != null) {
                        stringBuffer.append(' ');
                        stringBuffer.append(string);
                    } else if (string.length() > 0 && b.isLoggable(Level.WARNING)) {
                        b.warning("Header line broken: " + string);
                    }
                } else {
                    if (string2 != null) {
                        this.addField(string2, stringBuffer.toString().trim());
                    }
                    string2 = string.substring(0, n3).trim();
                    stringBuffer = new StringBuffer();
                    if (n3 + 1 < string.length()) {
                        stringBuffer.append(string.substring(n3 + 1));
                    }
                }
            }
            string = m2.f_();
        }
        if (string2 != null) {
            this.addField(string2, stringBuffer.toString().trim());
        }
        if (string == null) {
            throw new EOFException("EOF reading HTTP headers");
        }
    }

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.write(byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException during Fields.toByteArray", iOException);
        }
    }

    protected void write(ByteArrayOutputStream byteArrayOutputStream) {
        int n2 = this.fieldNames.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this.fieldNames.get(i2);
            String string2 = i2 < this.fieldValues.size() ? this.fieldValues.get(i2) : null;
            if (string2 == null) {
                b.warning("FIELDNAMES vs FIELDVALUES SIZE MISMATCH");
            }
            byteArrayOutputStream.write(j.c(string));
            byteArrayOutputStream.write(d);
            if (string2 != null) {
                byteArrayOutputStream.write(j.c(string2));
            }
            byteArrayOutputStream.write(a);
        }
        byteArrayOutputStream.write(a);
    }

    public void concat(Fields fields) {
        this.fieldNames.addAll(fields.getFieldNames());
        this.fieldValues.addAll(fields.getFieldValues());
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public List<String> getFieldValues() {
        return this.fieldValues;
    }

    public String get(String string) {
        return this.getField(string);
    }

    public String getField(String string) {
        int n2 = this.indexOf(string);
        if (n2 != -1) {
            return this.fieldValues.get(n2);
        }
        return null;
    }

    public int indexOf(String string) {
        int n2 = this.fieldNames.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = this.fieldNames.get(i2);
            if (!string2.equalsIgnoreCase(string)) continue;
            return i2;
        }
        return -1;
    }

    public String getFieldName(int n2) {
        return this.fieldNames.get(n2);
    }

    public String getFieldValue(int n2) {
        return this.fieldValues.get(n2);
    }

    public int getFieldCount() {
        return this.fieldNames.size();
    }

    public int getIntField(String string) {
        return this.getIntField(string, -1);
    }

    public int getIntField(String string, int n2) {
        if ((string = this.getField(string)) != null) {
            string = string.trim();
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                int n3 = -1;
                for (int i2 = 1; i2 <= string.length(); ++i2) {
                    try {
                        n3 = Integer.parseInt(string.substring(0, i2));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        if (i2 <= 1) break;
                        return n3;
                    }
                }
                throw numberFormatException;
            }
        }
        return n2;
    }

    public long getLongField(String string) {
        return this.getLongField(string, -1L);
    }

    public long getLongField(String string, long l2) {
        if ((string = this.getField(string)) != null) {
            string = string.trim();
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                long l3 = -1L;
                for (int i2 = 1; i2 <= string.length(); ++i2) {
                    try {
                        l3 = Long.parseLong(string.substring(0, i2));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        if (i2 <= 1) break;
                        return l3;
                    }
                }
                throw numberFormatException;
            }
        }
        return l2;
    }

    public String[] getFieldValues(String string) {
        int n2 = this.fieldNames.size();
        ArrayList<String> arrayList = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = this.fieldNames.get(i2);
            if (!string2.equalsIgnoreCase(string)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(this.fieldValues.get(i2));
        }
        if (arrayList == null) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public void addField(String string, String string2) {
        this.fieldNames.add(string.intern());
        this.fieldValues.add(string2 != null ? string2.intern() : null);
    }

    public void removeField(String string) {
        int n2 = this.fieldNames.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = this.fieldNames.get(i2);
            if (!string2.equalsIgnoreCase(string)) continue;
            this.fieldNames.remove(i2);
            this.fieldValues.remove(i2);
            --i2;
            --n2;
        }
    }

    public Fields clone() {
        Fields fields = new Fields();
        new Fields().fieldNames = new ArrayList<String>(this.fieldNames);
        fields.fieldValues = new ArrayList<String>(this.fieldValues);
        return fields;
    }

    public String toString() {
        return new String(this.toByteArray(), c);
    }

    public void parse(String object) {
        object = new j(new ByteArrayInputStream(((String)object + "\n\n").getBytes(c)));
        try {
            String string;
            this.read((m)object);
            while ((string = ((j)object).f_()) != null) {
                if (string.isEmpty()) continue;
                throw new Fields$ParseException("Header contained an empty line");
            }
            return;
        }
        catch (IOException iOException) {
            throw new Fields$ParseException(iOException.getMessage(), iOException);
        }
    }

    public void removeField(int n2) {
        this.fieldNames.remove(n2);
        this.fieldValues.remove(n2);
    }

    public void setField(String string, String string2) {
        int n2 = this.indexOf(string);
        if (n2 != -1) {
            this.setField(n2, string, string2);
            return;
        }
        this.addField(string, string2);
    }

    public void setField(int n2, String string, String string2) {
        this.fieldNames.set(n2, string.intern());
        this.fieldValues.set(n2, string2.intern());
    }

    public String getHost() {
        return this.getField("Host");
    }

    public void setHost(String string) {
        if (string == null) {
            this.removeField("Host");
            return;
        }
        this.setField("Host", string);
    }

    public String getCookies() {
        return this.getField("Cookie");
    }

    public void setCookies(String string) {
        if (string == null) {
            this.removeField("Cookie");
            return;
        }
        this.setField("Cookie", string);
    }

    public static int byteLength(String string) {
        return string.getBytes(c).length;
    }
}

