/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jdesktop.layout.Baseline;
import org.jdesktop.layout.LayoutStyle;

public class GroupLayout
implements LayoutManager2 {
    private static final int MIN_SIZE = 0;
    private static final int PREF_SIZE = 1;
    private static final int MAX_SIZE = 2;
    private static final int SPECIFIC_SIZE = 3;
    private static final int UNSET = Integer.MIN_VALUE;
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    private static final int NO_ALIGNMENT = 0;
    public static final int LEADING = 1;
    public static final int TRAILING = 2;
    public static final int CENTER = 4;
    public static final int BASELINE = 3;
    public static final int DEFAULT_SIZE = -1;
    public static final int PREFERRED_SIZE = -2;
    private boolean autocreatePadding;
    private boolean autocreateContainerPadding;
    private Group horizontalGroup;
    private Group verticalGroup;
    private Map componentInfos;
    private Container host;
    private Set tmpParallelSet;
    private boolean springsChanged;
    private boolean isValid;
    private boolean hasPreferredPaddingSprings;
    private LayoutStyle layoutStyle;
    private boolean honorsVisibility;

    private static void checkSize(int min, int pref, int max, boolean isComponentSpring) {
        GroupLayout.checkResizeType(min, isComponentSpring);
        if (!isComponentSpring && pref < 0) {
            throw new IllegalArgumentException("Pref must be >= 0");
        }
        if (isComponentSpring) {
            GroupLayout.checkResizeType(pref, true);
        }
        GroupLayout.checkResizeType(max, isComponentSpring);
        GroupLayout.checkLessThan(min, pref);
        GroupLayout.checkLessThan(pref, max);
    }

    private static void checkResizeType(int type, boolean isComponentSpring) {
        if (type < 0 && (isComponentSpring && type != -1 && type != -2 || !isComponentSpring && type != -2)) {
            throw new IllegalArgumentException("Invalid size");
        }
    }

    private static void checkLessThan(int min, int max) {
        if (min >= 0 && max >= 0 && min > max) {
            throw new IllegalArgumentException("Following is not met: min<=pref<=max");
        }
    }

    public GroupLayout(Container host) {
        if (host == null) {
            throw new IllegalArgumentException("Container must be non-null");
        }
        this.honorsVisibility = true;
        this.host = host;
        this.setHorizontalGroup(this.createParallelGroup(1, true));
        this.setVerticalGroup(this.createParallelGroup(1, true));
        this.componentInfos = new HashMap();
        this.tmpParallelSet = new HashSet();
    }

    public void setHonorsVisibility(boolean honorsVisibility) {
        if (this.honorsVisibility != honorsVisibility) {
            this.honorsVisibility = honorsVisibility;
            this.springsChanged = true;
            this.isValid = false;
            this.invalidateHost();
        }
    }

    public boolean getHonorsVisibility() {
        return this.honorsVisibility;
    }

    public void setHonorsVisibility(Component component, Boolean honorsVisibility) {
        if (component == null) {
            throw new IllegalArgumentException("Component must be non-null");
        }
        this.getComponentInfo(component).setHonorsVisibility(honorsVisibility);
        this.springsChanged = true;
        this.isValid = false;
        this.invalidateHost();
    }

    public String toString() {
        if (this.springsChanged) {
            this.registerComponents(this.horizontalGroup, 1);
            this.registerComponents(this.verticalGroup, 2);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("HORIZONTAL\n");
        this.dump(buffer, this.horizontalGroup, "  ", 1);
        buffer.append("\nVERTICAL\n");
        this.dump(buffer, this.verticalGroup, "  ", 2);
        return buffer.toString();
    }

    private void dump(StringBuffer buffer, Spring spring, String indent, int axis) {
        String origin = "";
        String padding = "";
        if (spring instanceof ComponentSpring) {
            ComponentSpring cSpring = (ComponentSpring)spring;
            origin = Integer.toString(cSpring.getOrigin()) + " ";
            String name = cSpring.getComponent().getName();
            if (name != null) {
                origin = "name=" + name + ", ";
            }
        }
        if (spring instanceof AutopaddingSpring) {
            AutopaddingSpring paddingSpring = (AutopaddingSpring)spring;
            padding = ", userCreated=" + paddingSpring.getUserCreated() + ", matches=" + paddingSpring.getMatchDescription();
        }
        buffer.append(indent + spring.getClass().getName() + " " + Integer.toHexString(spring.hashCode()) + " " + origin + ", size=" + spring.getSize() + ", alignment=" + spring.getAlignment() + " prefs=[" + spring.getMinimumSize(axis) + " " + spring.getPreferredSize(axis) + " " + spring.getMaximumSize(axis) + padding + "]\n");
        if (spring instanceof Group) {
            List springs = ((Group)spring).springs;
            indent = indent + "  ";
            for (int counter = 0; counter < springs.size(); ++counter) {
                this.dump(buffer, (Spring)springs.get(counter), indent, axis);
            }
        }
    }

    public void setAutocreateGaps(boolean autocreatePadding) {
        if (this.autocreatePadding != autocreatePadding) {
            this.autocreatePadding = autocreatePadding;
            this.invalidateHost();
        }
    }

    public boolean getAutocreateGaps() {
        return this.autocreatePadding;
    }

    public void setAutocreateContainerGaps(boolean autocreatePadding) {
        if (autocreatePadding != this.autocreateContainerPadding) {
            this.autocreateContainerPadding = autocreatePadding;
            this.horizontalGroup = this.createTopLevelGroup(this.getHorizontalGroup());
            this.verticalGroup = this.createTopLevelGroup(this.getVerticalGroup());
            this.invalidateHost();
        }
    }

    public boolean getAutocreateContainerGaps() {
        return this.autocreateContainerPadding;
    }

    public void setHorizontalGroup(Group group) {
        if (group == null) {
            throw new IllegalArgumentException("Group must be non-null");
        }
        this.horizontalGroup = this.createTopLevelGroup(group);
        this.invalidateHost();
    }

    public Group getHorizontalGroup() {
        int index = 0;
        if (this.horizontalGroup.springs.size() > 1) {
            index = 1;
        }
        return (Group)this.horizontalGroup.springs.get(index);
    }

    public void setVerticalGroup(Group group) {
        if (group == null) {
            throw new IllegalArgumentException("Group must be non-null");
        }
        this.verticalGroup = this.createTopLevelGroup(group);
        this.invalidateHost();
    }

    public Group getVerticalGroup() {
        int index = 0;
        if (this.verticalGroup.springs.size() > 1) {
            index = 1;
        }
        return (Group)this.verticalGroup.springs.get(index);
    }

    private Group createTopLevelGroup(Group specifiedGroup) {
        SequentialGroup group = this.createSequentialGroup();
        if (this.getAutocreateContainerGaps()) {
            group.addSpring(new ContainerAutopaddingSpring());
            group.add(specifiedGroup);
            group.addSpring(new ContainerAutopaddingSpring());
        } else {
            group.add(specifiedGroup);
        }
        return group;
    }

    public SequentialGroup createSequentialGroup() {
        return new SequentialGroup();
    }

    public ParallelGroup createParallelGroup() {
        return this.createParallelGroup(1);
    }

    public ParallelGroup createParallelGroup(int alignment) {
        return this.createParallelGroup(alignment, true);
    }

    public ParallelGroup createParallelGroup(int alignment, boolean resizable) {
        if (alignment == 3) {
            return new BaselineGroup(resizable);
        }
        return new ParallelGroup(alignment, resizable);
    }

    public ParallelGroup createBaselineGroup(boolean resizable, boolean anchorBaselineToTop) {
        return new BaselineGroup(resizable, anchorBaselineToTop);
    }

    public void linkSize(Component[] components) {
        this.linkSize(components, 3);
    }

    public void linkSize(Component[] components, int axis) {
        boolean vertical;
        if (components == null) {
            throw new IllegalArgumentException("Components must be non-null");
        }
        boolean horizontal = (axis & 1) == 1;
        boolean bl = vertical = (axis & 2) == 2;
        if (!vertical && !horizontal) {
            throw new IllegalArgumentException("Axis must contain HORIZONTAL or VERTICAL");
        }
        for (int counter = components.length - 1; counter >= 0; --counter) {
            Component c = components[counter];
            if (components[counter] == null) {
                throw new IllegalArgumentException("Components must be non-null");
            }
            this.getComponentInfo(c);
        }
        if (horizontal) {
            this.linkSize0(components, 1);
        }
        if (vertical) {
            this.linkSize0(components, 2);
        }
        this.invalidateHost();
    }

    private void linkSize0(Component[] components, int axis) {
        LinkInfo master = this.getComponentInfo(components[components.length - 1]).getLinkInfo(axis);
        for (int counter = components.length - 2; counter >= 0; --counter) {
            master.add(this.getComponentInfo(components[counter]));
        }
    }

    public void replace(Component existingComponent, Component newComponent) {
        ComponentInfo info;
        if (existingComponent == null || newComponent == null) {
            throw new IllegalArgumentException("Components must be non-null");
        }
        if (this.springsChanged) {
            this.registerComponents(this.horizontalGroup, 1);
            this.registerComponents(this.verticalGroup, 2);
        }
        if ((info = (ComponentInfo)this.componentInfos.remove(existingComponent)) == null) {
            throw new IllegalArgumentException("Component must already exist");
        }
        this.host.remove(existingComponent);
        if (newComponent.getParent() != this.host) {
            this.host.add(newComponent);
        }
        info.setComponent(newComponent);
        this.componentInfos.put(newComponent, info);
        this.invalidateHost();
    }

    public void setLayoutStyle(LayoutStyle layoutStyle) {
        this.layoutStyle = layoutStyle;
        this.invalidateHost();
    }

    public LayoutStyle getLayoutStyle() {
        return this.layoutStyle;
    }

    private LayoutStyle getLayoutStyle0() {
        LayoutStyle layoutStyle = this.getLayoutStyle();
        if (layoutStyle == null) {
            layoutStyle = LayoutStyle.getSharedInstance();
        }
        return layoutStyle;
    }

    private void invalidateHost() {
        if (this.host instanceof JComponent) {
            ((JComponent)this.host).revalidate();
        } else {
            this.host.invalidate();
        }
        this.host.repaint();
    }

    @Override
    public void addLayoutComponent(String name, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
        ComponentInfo info = (ComponentInfo)this.componentInfos.remove(component);
        if (info != null) {
            info.dispose();
            this.springsChanged = true;
            this.isValid = false;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        this.checkParent(parent);
        this.prepare(1);
        return this.adjustSize(this.horizontalGroup.getPreferredSize(1), this.verticalGroup.getPreferredSize(2));
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        this.checkParent(parent);
        this.prepare(0);
        return this.adjustSize(this.horizontalGroup.getMinimumSize(1), this.verticalGroup.getMinimumSize(2));
    }

    @Override
    public void layoutContainer(Container parent) {
        this.prepare(3);
        Insets insets = parent.getInsets();
        int width = parent.getWidth() - insets.left - insets.right;
        int height = parent.getHeight() - insets.top - insets.bottom;
        boolean ltr = this.isLeftToRight();
        if (this.getAutocreateGaps() || this.getAutocreateContainerGaps() || this.hasPreferredPaddingSprings) {
            this.calculateAutopadding(this.horizontalGroup, 1, 3, 0, width);
            this.calculateAutopadding(this.verticalGroup, 2, 3, 0, height);
        }
        this.horizontalGroup.setSize(1, 0, width);
        this.verticalGroup.setSize(2, 0, height);
        for (ComponentInfo info : this.componentInfos.values()) {
            Component c = info.getComponent();
            info.setBounds(insets, width, ltr);
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object constraints) {
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        this.checkParent(parent);
        this.prepare(2);
        return this.adjustSize(this.horizontalGroup.getMaximumSize(1), this.verticalGroup.getMaximumSize(2));
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        this.checkParent(parent);
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        this.checkParent(parent);
        return 0.5f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateLayout(Container parent) {
        this.checkParent(parent);
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.isValid = false;
        }
    }

    private void prepare(int sizeType) {
        boolean visChanged = false;
        if (!this.isValid) {
            this.isValid = true;
            this.horizontalGroup.setSize(1, Integer.MIN_VALUE, Integer.MIN_VALUE);
            this.verticalGroup.setSize(2, Integer.MIN_VALUE, Integer.MIN_VALUE);
            for (ComponentInfo ci : this.componentInfos.values()) {
                if (ci.updateVisibility()) {
                    visChanged = true;
                }
                ci.clearCachedSize();
            }
        }
        if (this.springsChanged) {
            this.registerComponents(this.horizontalGroup, 1);
            this.registerComponents(this.verticalGroup, 2);
        }
        if (this.springsChanged || visChanged) {
            this.checkComponents();
            this.horizontalGroup.removeAutopadding();
            this.verticalGroup.removeAutopadding();
            if (this.getAutocreateGaps()) {
                this.insertAutopadding(true);
            } else if (this.hasPreferredPaddingSprings || this.getAutocreateContainerGaps()) {
                this.insertAutopadding(false);
            }
            this.springsChanged = false;
        }
        if (sizeType != 3 && (this.getAutocreateGaps() || this.getAutocreateContainerGaps() || this.hasPreferredPaddingSprings)) {
            this.calculateAutopadding(this.horizontalGroup, 1, sizeType, 0, 0);
            this.calculateAutopadding(this.verticalGroup, 2, sizeType, 0, 0);
        }
    }

    private void calculateAutopadding(Group group, int axis, int sizeType, int origin, int size) {
        group.unsetAutopadding();
        switch (sizeType) {
            case 0: {
                size = group.getMinimumSize(axis);
                break;
            }
            case 1: {
                size = group.getPreferredSize(axis);
                break;
            }
            case 2: {
                size = group.getMaximumSize(axis);
            }
        }
        group.setSize(axis, origin, size);
        group.calculateAutopadding(axis);
    }

    private void checkComponents() {
        for (ComponentInfo info : this.componentInfos.values()) {
            if (info.horizontalSpring == null) {
                throw new IllegalStateException(info.component + " is not attached to a horizontal group");
            }
            if (info.verticalSpring != null) continue;
            throw new IllegalStateException(info.component + " is not attached to a vertical group");
        }
    }

    private void registerComponents(Group group, int axis) {
        List springs = group.springs;
        for (int counter = springs.size() - 1; counter >= 0; --counter) {
            Spring spring = (Spring)springs.get(counter);
            if (spring instanceof ComponentSpring) {
                ((ComponentSpring)spring).installIfNecessary(axis);
                continue;
            }
            if (!(spring instanceof Group)) continue;
            this.registerComponents((Group)spring, axis);
        }
    }

    private Dimension adjustSize(int width, int height) {
        Insets insets = this.host.getInsets();
        return new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
    }

    private void checkParent(Container parent) {
        if (parent != this.host) {
            throw new IllegalArgumentException("GroupLayout can only be used with one Container at a time");
        }
    }

    private ComponentInfo getComponentInfo(Component component) {
        ComponentInfo info = (ComponentInfo)this.componentInfos.get(component);
        if (info == null) {
            info = new ComponentInfo(component);
            this.componentInfos.put(component, info);
            if (component.getParent() != this.host) {
                this.host.add(component);
            }
        }
        return info;
    }

    private void insertAutopadding(boolean insert) {
        this.horizontalGroup.insertAutopadding(1, new ArrayList(1), new ArrayList(1), new ArrayList(1), new ArrayList(1), insert);
        this.verticalGroup.insertAutopadding(2, new ArrayList(1), new ArrayList(1), new ArrayList(1), new ArrayList(1), insert);
    }

    private boolean areParallelSiblings(Component source, Component target, int axis) {
        Spring spring;
        ComponentSpring targetSpring;
        ComponentSpring sourceSpring;
        ComponentInfo sourceInfo = this.getComponentInfo(source);
        ComponentInfo targetInfo = this.getComponentInfo(target);
        if (axis == 1) {
            sourceSpring = sourceInfo.horizontalSpring;
            targetSpring = targetInfo.horizontalSpring;
        } else {
            sourceSpring = sourceInfo.verticalSpring;
            targetSpring = targetInfo.verticalSpring;
        }
        Set sourcePath = this.tmpParallelSet;
        sourcePath.clear();
        for (spring = sourceSpring.getParent(); spring != null; spring = spring.getParent()) {
            sourcePath.add(spring);
        }
        for (spring = targetSpring.getParent(); spring != null; spring = spring.getParent()) {
            if (!sourcePath.contains(spring)) continue;
            sourcePath.clear();
            while (spring != null) {
                if (spring instanceof ParallelGroup) {
                    return true;
                }
                spring = spring.getParent();
            }
            return false;
        }
        sourcePath.clear();
        return false;
    }

    private boolean isLeftToRight() {
        return this.host.getComponentOrientation().isLeftToRight();
    }

    private final class ComponentInfo {
        private Component component;
        ComponentSpring horizontalSpring;
        ComponentSpring verticalSpring;
        private LinkInfo horizontalMaster;
        private LinkInfo verticalMaster;
        private boolean visible;
        private Boolean honorsVisibility;

        ComponentInfo(Component component) {
            this.component = component;
            this.updateVisibility();
        }

        public void dispose() {
            this.removeSpring(this.horizontalSpring);
            this.horizontalSpring = null;
            this.removeSpring(this.verticalSpring);
            this.verticalSpring = null;
            if (this.horizontalMaster != null) {
                this.horizontalMaster.remove(this);
            }
            if (this.verticalMaster != null) {
                this.verticalMaster.remove(this);
            }
        }

        void setHonorsVisibility(Boolean honorsVisibility) {
            this.honorsVisibility = honorsVisibility;
        }

        private void removeSpring(Spring spring) {
            if (spring != null) {
                ((Group)spring.getParent()).springs.remove(spring);
            }
        }

        public boolean isVisible() {
            return this.visible;
        }

        boolean updateVisibility() {
            boolean newVisible;
            boolean honorsVisibility = this.honorsVisibility == null ? GroupLayout.this.getHonorsVisibility() : this.honorsVisibility.booleanValue();
            boolean bl = newVisible = honorsVisibility ? this.component.isVisible() : true;
            if (this.visible != newVisible) {
                this.visible = newVisible;
                return true;
            }
            return false;
        }

        public void setBounds(Insets insets, int parentWidth, boolean ltr) {
            int x = this.horizontalSpring.getOrigin();
            int w = this.horizontalSpring.getSize();
            int y = this.verticalSpring.getOrigin();
            int h = this.verticalSpring.getSize();
            if (!ltr) {
                x = parentWidth - x - w;
            }
            this.component.setBounds(x + insets.left, y + insets.top, w, h);
        }

        public void setComponent(Component component) {
            this.component = component;
            if (this.horizontalSpring != null) {
                this.horizontalSpring.setComponent(component);
            }
            if (this.verticalSpring != null) {
                this.verticalSpring.setComponent(component);
            }
        }

        public Component getComponent() {
            return this.component;
        }

        public boolean isLinked(int axis) {
            if (axis == 1) {
                return this.horizontalMaster != null;
            }
            return this.verticalMaster != null;
        }

        private void setLinkInfo(int axis, LinkInfo linkInfo) {
            if (axis == 1) {
                this.horizontalMaster = linkInfo;
            } else {
                this.verticalMaster = linkInfo;
            }
        }

        public LinkInfo getLinkInfo(int axis) {
            return this.getLinkInfo(axis, true);
        }

        private LinkInfo getLinkInfo(int axis, boolean create) {
            if (axis == 1) {
                if (this.horizontalMaster == null && create) {
                    new LinkInfo(1).add(this);
                }
                return this.horizontalMaster;
            }
            if (this.verticalMaster == null && create) {
                new LinkInfo(2).add(this);
            }
            return this.verticalMaster;
        }

        public void clearCachedSize() {
            if (this.horizontalMaster != null) {
                this.horizontalMaster.clearCachedSize();
            }
            if (this.verticalMaster != null) {
                this.verticalMaster.clearCachedSize();
            }
        }

        int getLinkSize(int axis, int type) {
            if (axis == 1) {
                return this.horizontalMaster.getSize(axis);
            }
            return this.verticalMaster.getSize(axis);
        }
    }

    private static final class LinkInfo {
        private final int axis;
        private final List linked = new ArrayList();
        private int size = Integer.MIN_VALUE;

        LinkInfo(int axis) {
            this.axis = axis;
        }

        public void add(ComponentInfo child) {
            LinkInfo childMaster = child.getLinkInfo(this.axis, false);
            if (childMaster == null) {
                this.linked.add(child);
                child.setLinkInfo(this.axis, this);
            } else if (childMaster != this) {
                this.linked.addAll(childMaster.linked);
                for (int i = 0; i < childMaster.linked.size(); ++i) {
                    ComponentInfo childInfo = (ComponentInfo)childMaster.linked.get(i);
                    childInfo.setLinkInfo(this.axis, this);
                }
            }
            this.clearCachedSize();
        }

        public void remove(ComponentInfo info) {
            this.linked.remove(info);
            info.setLinkInfo(this.axis, null);
            if (this.linked.size() == 1) {
                ((ComponentInfo)this.linked.get(0)).setLinkInfo(this.axis, null);
            }
            this.clearCachedSize();
        }

        public void clearCachedSize() {
            this.size = Integer.MIN_VALUE;
        }

        public int getSize(int axis) {
            if (this.size == Integer.MIN_VALUE) {
                this.size = this.calculateLinkedSize(axis);
            }
            return this.size;
        }

        private int calculateLinkedSize(int axis) {
            int size = 0;
            for (int i = 0; i < this.linked.size(); ++i) {
                ComponentInfo info = (ComponentInfo)this.linked.get(i);
                ComponentSpring spring = axis == 1 ? info.horizontalSpring : info.verticalSpring;
                size = Math.max(size, spring.calculateNonlinkedPreferredSize(axis));
            }
            return size;
        }
    }

    private class ContainerAutopaddingSpring
    extends AutopaddingSpring {
        private List targets;

        ContainerAutopaddingSpring() {
            this.setUserCreated(true);
        }

        ContainerAutopaddingSpring(int pref, int max) {
            super(pref, max);
            this.setUserCreated(true);
        }

        @Override
        public void addTarget(ComponentSpring spring, int axis) {
            if (this.targets == null) {
                this.targets = new ArrayList(1);
            }
            this.targets.add(spring);
        }

        @Override
        public void calculatePadding(int axis) {
            LayoutStyle p = GroupLayout.this.getLayoutStyle0();
            int maxPadding = 0;
            this.size = 0;
            if (this.targets != null) {
                int position = axis == 1 ? (GroupLayout.this.isLeftToRight() ? 7 : 3) : 5;
                for (int i = this.targets.size() - 1; i >= 0; --i) {
                    ComponentSpring targetSpring = (ComponentSpring)this.targets.get(i);
                    int padding = 10;
                    if (targetSpring.getComponent() instanceof JComponent) {
                        padding = p.getContainerGap((JComponent)targetSpring.getComponent(), position, GroupLayout.this.host);
                        maxPadding = Math.max(padding, maxPadding);
                        padding -= targetSpring.getOrigin();
                    } else {
                        maxPadding = Math.max(padding, maxPadding);
                    }
                    this.size = Math.max(this.size, padding);
                }
            } else {
                int position = axis == 1 ? (GroupLayout.this.isLeftToRight() ? 3 : 7) : 5;
                if (this.sources != null) {
                    for (int i = this.sources.size() - 1; i >= 0; --i) {
                        ComponentSpring sourceSpring = (ComponentSpring)this.sources.get(i);
                        maxPadding = Math.max(maxPadding, this.updateSize(p, sourceSpring, position));
                    }
                } else if (this.source != null) {
                    maxPadding = this.updateSize(p, this.source, position);
                }
            }
            if (this.lastSize != Integer.MIN_VALUE) {
                this.size += Math.min(maxPadding, this.lastSize);
            }
        }

        private int updateSize(LayoutStyle p, ComponentSpring sourceSpring, int position) {
            int padding = 10;
            if (sourceSpring.getComponent() instanceof JComponent) {
                padding = p.getContainerGap((JComponent)sourceSpring.getComponent(), position, GroupLayout.this.host);
            }
            int delta = Math.max(0, this.getParent().getSize() - sourceSpring.getSize() - sourceSpring.getOrigin());
            this.size = Math.max(this.size, padding - delta);
            return padding;
        }

        @Override
        String getMatchDescription() {
            if (this.targets != null) {
                return "leading: " + this.targets.toString();
            }
            if (this.sources != null) {
                return "trailing: " + this.sources.toString();
            }
            return "--";
        }
    }

    private static final class AutopaddingMatch {
        public final ComponentSpring source;
        public final ComponentSpring target;

        AutopaddingMatch(ComponentSpring source, ComponentSpring target) {
            this.source = source;
            this.target = target;
        }

        private String toString(ComponentSpring spring) {
            return spring.getComponent().getName();
        }

        public String toString() {
            return "[" + this.toString(this.source) + "-" + this.toString(this.target) + "]";
        }
    }

    private class AutopaddingSpring
    extends Spring {
        List sources;
        ComponentSpring source;
        private List matches;
        int size;
        int lastSize;
        private final int pref;
        private final int max;
        private int type;
        private boolean userCreated;

        private AutopaddingSpring() {
            this.pref = -2;
            this.max = -2;
            this.type = 0;
        }

        AutopaddingSpring(int pref, int max) {
            this.pref = pref;
            this.max = max;
        }

        AutopaddingSpring(int type, int pref, int max) {
            this.type = type;
            this.pref = pref;
            this.max = max;
            this.userCreated = true;
        }

        public void setSource(ComponentSpring source) {
            this.source = source;
        }

        public void setSources(List sources) {
            this.sources = new ArrayList(sources);
        }

        public void setUserCreated(boolean userCreated) {
            this.userCreated = userCreated;
        }

        public boolean getUserCreated() {
            return this.userCreated;
        }

        @Override
        void unset() {
            this.lastSize = this.getSize();
            super.unset();
            this.size = 0;
        }

        public void reset() {
            this.size = 0;
            this.sources = null;
            this.source = null;
            this.matches = null;
        }

        public void calculatePadding(int axis) {
            this.size = Integer.MIN_VALUE;
            int maxPadding = Integer.MIN_VALUE;
            if (this.matches != null) {
                LayoutStyle p = GroupLayout.this.getLayoutStyle0();
                int position = axis == 1 ? (GroupLayout.this.isLeftToRight() ? 3 : 7) : 5;
                for (int i = this.matches.size() - 1; i >= 0; --i) {
                    AutopaddingMatch match = (AutopaddingMatch)this.matches.get(i);
                    maxPadding = Math.max(maxPadding, this.calculatePadding(p, position, match.source, match.target));
                }
            }
            if (this.size == Integer.MIN_VALUE) {
                this.size = 0;
            }
            if (maxPadding == Integer.MIN_VALUE) {
                maxPadding = 0;
            }
            if (this.lastSize != Integer.MIN_VALUE) {
                this.size += Math.min(maxPadding, this.lastSize);
            }
        }

        private int calculatePadding(LayoutStyle p, int position, ComponentSpring source, ComponentSpring target) {
            int delta = target.getOrigin() - (source.getOrigin() + source.getSize());
            if (delta >= 0) {
                int padding = source.getComponent() instanceof JComponent && target.getComponent() instanceof JComponent ? p.getPreferredGap((JComponent)source.getComponent(), (JComponent)target.getComponent(), this.type, position, GroupLayout.this.host) : 10;
                if (padding > delta) {
                    this.size = Math.max(this.size, padding - delta);
                }
                return padding;
            }
            return 0;
        }

        public void addTarget(ComponentSpring spring, int axis) {
            int oAxis;
            int n = oAxis = axis == 1 ? 2 : 1;
            if (this.source != null) {
                if (GroupLayout.this.areParallelSiblings(this.source.getComponent(), spring.getComponent(), oAxis)) {
                    this.addValidTarget(this.source, spring);
                }
            } else {
                Component component = spring.getComponent();
                for (int counter = this.sources.size() - 1; counter >= 0; --counter) {
                    ComponentSpring source = (ComponentSpring)this.sources.get(counter);
                    if (!GroupLayout.this.areParallelSiblings(source.getComponent(), component, oAxis)) continue;
                    this.addValidTarget(source, spring);
                }
            }
        }

        private void addValidTarget(ComponentSpring source, ComponentSpring target) {
            if (this.matches == null) {
                this.matches = new ArrayList(1);
            }
            this.matches.add(new AutopaddingMatch(source, target));
        }

        @Override
        int calculateMinimumSize(int axis) {
            return this.size;
        }

        @Override
        int calculatePreferredSize(int axis) {
            if (this.pref == -2 || this.pref == -1) {
                return this.size;
            }
            return Math.max(this.size, this.pref);
        }

        @Override
        int calculateMaximumSize(int axis) {
            if (this.max >= 0) {
                return Math.max(this.getPreferredSize(axis), this.max);
            }
            return this.size;
        }

        String getMatchDescription() {
            return this.matches == null ? "" : this.matches.toString();
        }

        public String toString() {
            return super.toString() + this.getMatchDescription();
        }
    }

    private final class GapSpring
    extends Spring {
        private final int min;
        private final int pref;
        private final int max;

        GapSpring(int min, int pref, int max) {
            GroupLayout.checkSize(min, pref, max, false);
            this.min = min;
            this.pref = pref;
            this.max = max;
        }

        @Override
        int calculateMinimumSize(int axis) {
            if (this.min == -2) {
                return this.getPreferredSize(axis);
            }
            return this.min;
        }

        @Override
        int calculatePreferredSize(int axis) {
            return this.pref;
        }

        @Override
        int calculateMaximumSize(int axis) {
            if (this.max == -2) {
                return this.getPreferredSize(axis);
            }
            return this.max;
        }
    }

    private final class PaddingSpring
    extends Spring {
        private final JComponent source;
        private final JComponent target;
        private final int type;
        private final boolean canGrow;

        PaddingSpring(JComponent source, JComponent target, int type, boolean canGrow) {
            this.source = source;
            this.target = target;
            this.type = type;
            this.canGrow = canGrow;
        }

        @Override
        int calculateMinimumSize(int axis) {
            return this.getPadding(axis);
        }

        @Override
        int calculatePreferredSize(int axis) {
            return this.getPadding(axis);
        }

        @Override
        int calculateMaximumSize(int axis) {
            if (this.canGrow) {
                return Short.MAX_VALUE;
            }
            return this.getPadding(axis);
        }

        private int getPadding(int axis) {
            int position = axis == 1 ? 3 : 5;
            return GroupLayout.this.getLayoutStyle0().getPreferredGap(this.source, this.target, this.type, position, GroupLayout.this.host);
        }
    }

    private final class ComponentSpring
    extends Spring {
        private Component component;
        private int origin;
        private final int min;
        private final int pref;
        private final int max;
        private int baseline;
        private boolean installed;

        private ComponentSpring(Component component, int min, int pref, int max) {
            this.baseline = -1;
            this.component = component;
            if (component == null) {
                throw new IllegalArgumentException("Component must be non-null");
            }
            GroupLayout.checkSize(min, pref, max, true);
            this.min = min;
            this.max = max;
            this.pref = pref;
            GroupLayout.this.getComponentInfo(component);
        }

        @Override
        int calculateMinimumSize(int axis) {
            if (this.isLinked(axis)) {
                return this.getLinkSize(axis, 0);
            }
            return this.calculateNonlinkedMinimumSize(axis);
        }

        @Override
        int calculatePreferredSize(int axis) {
            if (this.isLinked(axis)) {
                return this.getLinkSize(axis, 1);
            }
            int min = this.getMinimumSize(axis);
            int pref = this.calculateNonlinkedPreferredSize(axis);
            int max = this.getMaximumSize(axis);
            return Math.min(max, Math.max(min, pref));
        }

        @Override
        int calculateMaximumSize(int axis) {
            if (this.isLinked(axis)) {
                return this.getLinkSize(axis, 2);
            }
            return Math.max(this.getMinimumSize(axis), this.calculateNonlinkedMaximumSize(axis));
        }

        boolean isVisible() {
            return GroupLayout.this.getComponentInfo(this.getComponent()).isVisible();
        }

        int calculateNonlinkedMinimumSize(int axis) {
            if (!this.isVisible()) {
                return 0;
            }
            if (this.min >= 0) {
                return this.min;
            }
            if (this.min == -2) {
                return this.calculateNonlinkedPreferredSize(axis);
            }
            return this.getSizeAlongAxis(axis, this.component.getMinimumSize());
        }

        int calculateNonlinkedPreferredSize(int axis) {
            if (!this.isVisible()) {
                return 0;
            }
            if (this.pref >= 0) {
                return this.pref;
            }
            return this.getSizeAlongAxis(axis, this.component.getPreferredSize());
        }

        int calculateNonlinkedMaximumSize(int axis) {
            if (!this.isVisible()) {
                return 0;
            }
            if (this.max >= 0) {
                return this.max;
            }
            if (this.max == -2) {
                return this.calculateNonlinkedPreferredSize(axis);
            }
            return this.getSizeAlongAxis(axis, this.component.getMaximumSize());
        }

        private int getSizeAlongAxis(int axis, Dimension size) {
            return axis == 1 ? size.width : size.height;
        }

        private int getLinkSize(int axis, int type) {
            if (!this.isVisible()) {
                return 0;
            }
            ComponentInfo ci = GroupLayout.this.getComponentInfo(this.component);
            return ci.getLinkSize(axis, type);
        }

        @Override
        void setSize(int axis, int origin, int size) {
            super.setSize(axis, origin, size);
            this.origin = origin;
            if (size == Integer.MIN_VALUE) {
                this.baseline = -1;
            }
        }

        int getOrigin() {
            return this.origin;
        }

        void setComponent(Component component) {
            this.component = component;
        }

        Component getComponent() {
            return this.component;
        }

        @Override
        int getBaseline() {
            if (this.baseline == -1 && this.component instanceof JComponent) {
                ComponentSpring horizontalSpring = ((GroupLayout)GroupLayout.this).getComponentInfo((Component)this.component).horizontalSpring;
                int width = horizontalSpring.getPreferredSize(1);
                int height = this.getPreferredSize(2);
                if (width > 0 && height > 0) {
                    this.baseline = Baseline.getBaseline((JComponent)this.component, width, this.getPreferredSize(2));
                }
            }
            return this.baseline;
        }

        @Override
        int getBaselineResizeBehavior() {
            return Baseline.getBaselineResizeBehavior(this.getComponent());
        }

        private boolean isLinked(int axis) {
            return GroupLayout.this.getComponentInfo(this.component).isLinked(axis);
        }

        void installIfNecessary(int axis) {
            if (!this.installed) {
                this.installed = true;
                if (axis == 1) {
                    ((GroupLayout)GroupLayout.this).getComponentInfo((Component)this.component).horizontalSpring = this;
                } else {
                    ((GroupLayout)GroupLayout.this).getComponentInfo((Component)this.component).verticalSpring = this;
                }
            }
        }
    }

    private class BaselineGroup
    extends ParallelGroup {
        private boolean allSpringsHaveBaseline;
        private int prefAscent;
        private int prefDescent;
        private boolean baselineAnchorSet;
        private boolean baselineAnchoredToTop;
        private boolean calcedBaseline;

        BaselineGroup(boolean resizable) {
            super(1, resizable);
            this.prefDescent = -1;
            this.prefAscent = -1;
            this.calcedBaseline = false;
        }

        BaselineGroup(boolean resizable, boolean baselineAnchoredToTop) {
            this(resizable);
            this.baselineAnchoredToTop = baselineAnchoredToTop;
            this.baselineAnchorSet = true;
        }

        @Override
        void unset() {
            super.unset();
            this.prefDescent = -1;
            this.prefAscent = -1;
            this.calcedBaseline = false;
        }

        @Override
        void setValidSize(int axis, int origin, int size) {
            this.checkAxis(axis);
            if (this.prefAscent == -1) {
                super.setValidSize(axis, origin, size);
            } else {
                this.baselineLayout(origin, size);
            }
        }

        @Override
        int calculateSize(int axis, int type) {
            this.checkAxis(axis);
            if (!this.calcedBaseline) {
                this.calculateBaselineAndResizeBehavior();
            }
            if (type == 0) {
                return this.calculateMinSize();
            }
            if (type == 2) {
                return this.calculateMaxSize();
            }
            if (this.allSpringsHaveBaseline) {
                return this.prefAscent + this.prefDescent;
            }
            return Math.max(this.prefAscent + this.prefDescent, super.calculateSize(axis, type));
        }

        private void calculateBaselineAndResizeBehavior() {
            this.prefAscent = 0;
            this.prefDescent = 0;
            int baselineSpringCount = 0;
            int resizeBehavior = 0;
            for (int counter = this.springs.size() - 1; counter >= 0; --counter) {
                int baseline;
                Spring spring = this.getSpring(counter);
                if (spring.getAlignment() != 0 && spring.getAlignment() != 3 || (baseline = spring.getBaseline()) < 0) continue;
                if (spring.isResizable(2)) {
                    int brb = spring.getBaselineResizeBehavior();
                    if (resizeBehavior == 0) {
                        resizeBehavior = brb;
                    } else if (brb != resizeBehavior) {
                        resizeBehavior = 1;
                    }
                }
                this.prefAscent = Math.max(this.prefAscent, baseline);
                this.prefDescent = Math.max(this.prefDescent, spring.getPreferredSize(2) - baseline);
                ++baselineSpringCount;
            }
            if (!this.baselineAnchorSet) {
                this.baselineAnchoredToTop = resizeBehavior != 2;
            }
            this.allSpringsHaveBaseline = baselineSpringCount == this.springs.size();
            this.calcedBaseline = true;
        }

        private int calculateMaxSize() {
            int maxAscent = this.prefAscent;
            int maxDescent = this.prefDescent;
            int nonBaselineMax = 0;
            for (int counter = this.springs.size() - 1; counter >= 0; --counter) {
                int baseline;
                Spring spring = this.getSpring(counter);
                int springMax = spring.getMaximumSize(2);
                if ((spring.getAlignment() == 0 || spring.getAlignment() == 3) && (baseline = spring.getBaseline()) >= 0) {
                    int springPref = spring.getPreferredSize(2);
                    if (springPref == springMax) continue;
                    switch (spring.getBaselineResizeBehavior()) {
                        case 1: {
                            if (!this.baselineAnchoredToTop) break;
                            maxDescent = Math.max(maxDescent, springMax - baseline);
                            break;
                        }
                        case 2: {
                            if (this.baselineAnchoredToTop) break;
                            maxAscent = Math.max(maxAscent, springMax - springPref + baseline);
                            break;
                        }
                    }
                    continue;
                }
                nonBaselineMax = Math.max(nonBaselineMax, springMax);
            }
            return Math.max(nonBaselineMax, maxAscent + maxDescent);
        }

        private int calculateMinSize() {
            int minAscent = 0;
            int minDescent = 0;
            int nonBaselineMin = 0;
            if (this.baselineAnchoredToTop) {
                minAscent = this.prefAscent;
            } else {
                minDescent = this.prefDescent;
            }
            for (int counter = this.springs.size() - 1; counter >= 0; --counter) {
                int baseline;
                Spring spring = this.getSpring(counter);
                int springMin = spring.getMinimumSize(2);
                if ((spring.getAlignment() == 0 || spring.getAlignment() == 3) && (baseline = spring.getBaseline()) >= 0) {
                    int springPref = spring.getPreferredSize(2);
                    switch (spring.getBaselineResizeBehavior()) {
                        case 1: {
                            if (this.baselineAnchoredToTop) {
                                minDescent = Math.max(springMin - baseline, minDescent);
                                break;
                            }
                            minAscent = Math.max(baseline, minAscent);
                            break;
                        }
                        case 2: {
                            if (!this.baselineAnchoredToTop) {
                                minAscent = Math.max(baseline - (springPref - springMin), minAscent);
                                break;
                            }
                            minDescent = Math.max(springPref - baseline, minDescent);
                            break;
                        }
                        default: {
                            minAscent = Math.max(baseline, minAscent);
                            minDescent = Math.max(springPref - baseline, minDescent);
                            break;
                        }
                    }
                    continue;
                }
                nonBaselineMin = Math.max(nonBaselineMin, springMin);
            }
            return Math.max(nonBaselineMin, minAscent + minDescent);
        }

        private void baselineLayout(int origin, int size) {
            int descent;
            int ascent;
            if (this.baselineAnchoredToTop) {
                ascent = this.prefAscent;
                descent = size - ascent;
            } else {
                ascent = size - this.prefDescent;
                descent = this.prefDescent;
            }
            for (int counter = this.springs.size() - 1; counter >= 0; --counter) {
                Spring spring = this.getSpring(counter);
                int alignment = spring.getAlignment();
                if (alignment == 0 || alignment == 3) {
                    int baseline = spring.getBaseline();
                    if (baseline >= 0) {
                        int y;
                        int springPref;
                        int springMax = spring.getMaximumSize(2);
                        int height = springPref = spring.getPreferredSize(2);
                        switch (spring.getBaselineResizeBehavior()) {
                            case 1: {
                                y = origin + ascent - baseline;
                                height = Math.min(descent, springMax - baseline) + baseline;
                                break;
                            }
                            case 2: {
                                height = Math.min(ascent, springMax - springPref + baseline) + (springPref - baseline);
                                y = origin + ascent + (springPref - baseline) - height;
                                break;
                            }
                            default: {
                                y = origin + ascent - baseline;
                            }
                        }
                        spring.setSize(2, y, height);
                        continue;
                    }
                    this.setChildSize(spring, 2, origin, size);
                    continue;
                }
                this.setChildSize(spring, 2, origin, size);
            }
        }

        @Override
        int getBaseline() {
            if (this.springs.size() > 1) {
                this.getPreferredSize(2);
                return this.prefAscent;
            }
            if (this.springs.size() == 1) {
                return this.getSpring(0).getBaseline();
            }
            return -1;
        }

        @Override
        int getBaselineResizeBehavior() {
            if (this.springs.size() == 1) {
                return this.getSpring(0).getBaselineResizeBehavior();
            }
            if (this.baselineAnchoredToTop) {
                return 1;
            }
            return 2;
        }

        private void checkAxis(int axis) {
            if (axis == 1) {
                throw new IllegalStateException("Baseline must be used along vertical axis");
            }
        }
    }

    public class ParallelGroup
    extends Group {
        private final int childAlignment;
        private final boolean resizable;

        ParallelGroup(int childAlignment, boolean resizable) {
            this.childAlignment = childAlignment;
            this.resizable = resizable;
        }

        public ParallelGroup add(Group group) {
            return (ParallelGroup)this.addSpring(group);
        }

        public ParallelGroup add(Component component) {
            return this.add(component, -1, -1, -1);
        }

        public ParallelGroup add(Component component, int min, int pref, int max) {
            return (ParallelGroup)this.addSpring(new ComponentSpring(component, min, pref, max));
        }

        public ParallelGroup add(int pref) {
            return this.add(pref, pref, pref);
        }

        public ParallelGroup add(int min, int pref, int max) {
            return (ParallelGroup)this.addSpring(new GapSpring(min, pref, max));
        }

        public ParallelGroup add(int alignment, Group group) {
            this.checkChildAlignment(alignment);
            group.setAlignment(alignment);
            return (ParallelGroup)this.addSpring(group);
        }

        public ParallelGroup add(int alignment, Component component) {
            return this.add(alignment, component, -1, -1, -1);
        }

        public ParallelGroup add(int alignment, Component component, int min, int pref, int max) {
            this.checkChildAlignment(alignment);
            ComponentSpring spring = new ComponentSpring(component, min, pref, max);
            spring.setAlignment(alignment);
            return (ParallelGroup)this.addSpring(spring);
        }

        boolean isResizable() {
            return this.resizable;
        }

        @Override
        int operator(int a, int b) {
            return Math.max(a, b);
        }

        @Override
        int calculateMinimumSize(int axis) {
            if (!this.isResizable()) {
                return this.getPreferredSize(axis);
            }
            return super.calculateMinimumSize(axis);
        }

        @Override
        int calculateMaximumSize(int axis) {
            if (!this.isResizable()) {
                return this.getPreferredSize(axis);
            }
            return super.calculateMaximumSize(axis);
        }

        @Override
        void setValidSize(int axis, int origin, int size) {
            int max = this.springs.size();
            for (int i = 0; i < max; ++i) {
                this.setChildSize(this.getSpring(i), axis, origin, size);
            }
        }

        void setChildSize(Spring spring, int axis, int origin, int size) {
            int alignment = spring.getAlignment();
            int springSize = Math.min(Math.max(spring.getMinimumSize(axis), size), spring.getMaximumSize(axis));
            if (alignment == 0) {
                alignment = this.childAlignment;
            }
            switch (alignment) {
                case 2: {
                    spring.setSize(axis, origin + size - springSize, springSize);
                    break;
                }
                case 4: {
                    spring.setSize(axis, origin + (size - springSize) / 2, springSize);
                    break;
                }
                default: {
                    spring.setSize(axis, origin, springSize);
                }
            }
        }

        @Override
        void insertAutopadding(int axis, List leadingPadding, List trailingPadding, List leading, List trailing, boolean insert) {
            int max = this.springs.size();
            for (int counter = 0; counter < max; ++counter) {
                Spring spring = this.getSpring(counter);
                if (spring instanceof ComponentSpring) {
                    for (int i = 0; i < leadingPadding.size(); ++i) {
                        ((AutopaddingSpring)leadingPadding.get(i)).addTarget((ComponentSpring)spring, axis);
                    }
                    trailing.add(spring);
                    continue;
                }
                if (spring instanceof Group) {
                    ((Group)spring).insertAutopadding(axis, leadingPadding, trailingPadding, leading, trailing, insert);
                    continue;
                }
                if (!(spring instanceof AutopaddingSpring)) continue;
                trailingPadding.add(spring);
            }
        }

        private void checkChildAlignment(int alignment) {
            boolean allowsBaseline = this instanceof BaselineGroup;
            if (!allowsBaseline && alignment == 3) {
                throw new IllegalArgumentException("Alignment must be one of:LEADING, TRAILING or CENTER");
            }
            if (alignment != 4 && alignment != 3 && alignment != 1 && alignment != 2) {
                throw new IllegalArgumentException("Alignment must be one of:LEADING, TRAILING or CENTER");
            }
        }
    }

    private static final class SpringDelta
    implements Comparable {
        public final int index;
        public int delta;

        public SpringDelta(int index, int delta) {
            this.index = index;
            this.delta = delta;
        }

        public int compareTo(Object o) {
            return this.delta - ((SpringDelta)o).delta;
        }

        public boolean equals(Object obj) {
            return obj instanceof SpringDelta ? this.compareTo(obj) == 0 : false;
        }

        public int hashCode() {
            return this.delta;
        }

        public String toString() {
            return super.toString() + "[index=" + this.index + ", delta=" + this.delta + "]";
        }
    }

    public class SequentialGroup
    extends Group {
        private Spring baselineSpring;

        SequentialGroup() {
        }

        public SequentialGroup add(Group group) {
            return (SequentialGroup)this.addSpring(group);
        }

        public SequentialGroup add(boolean useAsBaseline, Group group) {
            this.add(group);
            if (useAsBaseline) {
                this.baselineSpring = group;
            }
            return this;
        }

        public SequentialGroup add(Component component) {
            return this.add(component, -1, -1, -1);
        }

        public SequentialGroup add(boolean useAsBaseline, Component component) {
            this.add(component);
            if (useAsBaseline) {
                this.baselineSpring = this.getSpring(this.springs.size() - 1);
            }
            return this;
        }

        public SequentialGroup add(Component component, int min, int pref, int max) {
            return (SequentialGroup)this.addSpring(new ComponentSpring(component, min, pref, max));
        }

        public SequentialGroup add(boolean useAsBaseline, Component component, int min, int pref, int max) {
            this.add(component, min, pref, max);
            if (useAsBaseline) {
                this.baselineSpring = this.getSpring(this.springs.size() - 1);
            }
            return this;
        }

        public SequentialGroup add(int pref) {
            return this.add(pref, pref, pref);
        }

        public SequentialGroup add(int min, int pref, int max) {
            return (SequentialGroup)this.addSpring(new GapSpring(min, pref, max));
        }

        public SequentialGroup addPreferredGap(JComponent comp1, JComponent comp2, int type) {
            return this.addPreferredGap(comp1, comp2, type, false);
        }

        public SequentialGroup addPreferredGap(JComponent comp1, JComponent comp2, int type, boolean canGrow) {
            if (type != 0 && type != 1 && type != 3) {
                throw new IllegalArgumentException("Invalid type argument");
            }
            if (comp1 == null || comp2 == null) {
                throw new IllegalArgumentException("Components must be non-null");
            }
            return (SequentialGroup)this.addSpring(new PaddingSpring(comp1, comp2, type, canGrow));
        }

        public SequentialGroup addPreferredGap(int type) {
            return this.addPreferredGap(type, -1, -1);
        }

        public SequentialGroup addPreferredGap(int type, int pref, int max) {
            if (type != 0 && type != 1) {
                throw new IllegalArgumentException("Padding type must be one of Padding.RELATED or Padding.UNRELATED");
            }
            if (pref < 0 && pref != -1 && pref != -2 || max < 0 && max != -1 && max != -2 || pref >= 0 && max >= 0 && pref > max) {
                throw new IllegalArgumentException("Pref and max must be either DEFAULT_SIZE, PREFERRED_SIZE, or >= 0 and pref <= max");
            }
            GroupLayout.this.hasPreferredPaddingSprings = true;
            return (SequentialGroup)this.addSpring(new AutopaddingSpring(type, pref, max));
        }

        public SequentialGroup addContainerGap() {
            return this.addContainerGap(-1, -1);
        }

        public SequentialGroup addContainerGap(int pref, int max) {
            if (pref < 0 && pref != -1 || max < 0 && max != -1 && max != -2 || pref >= 0 && max >= 0 && pref > max) {
                throw new IllegalArgumentException("Pref and max must be either DEFAULT_VALUE or >= 0 and pref <= max");
            }
            GroupLayout.this.hasPreferredPaddingSprings = true;
            return (SequentialGroup)this.addSpring(new ContainerAutopaddingSpring(pref, max));
        }

        @Override
        int operator(int a, int b) {
            return this.constrain(a) + this.constrain(b);
        }

        @Override
        void setValidSize(int axis, int origin, int size) {
            int pref = this.getPreferredSize(axis);
            if (size == pref) {
                int max = this.springs.size();
                for (int counter = 0; counter < max; ++counter) {
                    Spring spring = this.getSpring(counter);
                    int springPref = spring.getPreferredSize(axis);
                    spring.setSize(axis, origin, springPref);
                    origin += springPref;
                }
            } else if (this.springs.size() == 1) {
                Spring spring = this.getSpring(0);
                spring.setSize(axis, origin, Math.min(Math.max(size, spring.getMinimumSize(axis)), spring.getMaximumSize(axis)));
            } else if (this.springs.size() > 1) {
                this.setValidSizeNotPreferred(axis, origin, size);
            }
        }

        private void setValidSizeNotPreferred(int axis, int origin, int size) {
            List resizable;
            int resizableCount;
            int delta = size - this.getPreferredSize(axis);
            boolean useMin = delta < 0;
            int springCount = this.springs.size();
            if (useMin) {
                delta *= -1;
            }
            if ((resizableCount = (resizable = this.buildResizableList(axis, useMin)).size()) > 0) {
                int counter;
                int sDelta = delta / resizableCount;
                int slop = delta - sDelta * resizableCount;
                int[] sizes = new int[springCount];
                int sign = useMin ? -1 : 1;
                for (counter = 0; counter < resizableCount; ++counter) {
                    SpringDelta springDelta = (SpringDelta)resizable.get(counter);
                    if (counter + 1 == resizableCount) {
                        sDelta += slop;
                    }
                    springDelta.delta = Math.min(sDelta, springDelta.delta);
                    delta -= springDelta.delta;
                    if (springDelta.delta != sDelta && counter + 1 < resizableCount) {
                        sDelta = delta / (resizableCount - counter - 1);
                        slop = delta - sDelta * (resizableCount - counter - 1);
                    }
                    sizes[springDelta.index] = sign * springDelta.delta;
                }
                for (counter = 0; counter < springCount; ++counter) {
                    Spring spring = this.getSpring(counter);
                    int sSize = spring.getPreferredSize(axis) + sizes[counter];
                    spring.setSize(axis, origin, sSize);
                    origin += sSize;
                }
            } else {
                for (int counter = 0; counter < springCount; ++counter) {
                    Spring spring = this.getSpring(counter);
                    int sSize = useMin ? spring.getMinimumSize(axis) : spring.getMaximumSize(axis);
                    spring.setSize(axis, origin, sSize);
                    origin += sSize;
                }
            }
        }

        private List buildResizableList(int axis, boolean useMin) {
            int size = this.springs.size();
            ArrayList<SpringDelta> sorted = new ArrayList<SpringDelta>(size);
            for (int counter = 0; counter < size; ++counter) {
                Spring spring = this.getSpring(counter);
                int sDelta = useMin ? spring.getPreferredSize(axis) - spring.getMinimumSize(axis) : spring.getMaximumSize(axis) - spring.getPreferredSize(axis);
                if (sDelta <= 0) continue;
                sorted.add(new SpringDelta(counter, sDelta));
            }
            Collections.sort(sorted);
            return sorted;
        }

        @Override
        void insertAutopadding(int axis, List leadingPadding, List trailingPadding, List leading, List trailing, boolean insert) {
            ArrayList<AutopaddingSpring> newLeadingPadding = new ArrayList<AutopaddingSpring>(leadingPadding);
            ArrayList newTrailingPadding = new ArrayList(1);
            ArrayList<ComponentSpring> newLeading = new ArrayList<ComponentSpring>(leading);
            ArrayList newTrailing = null;
            for (int counter = 0; counter < this.springs.size(); ++counter) {
                AutopaddingSpring padding;
                Spring spring = this.getSpring(counter);
                if (spring instanceof AutopaddingSpring) {
                    padding = (AutopaddingSpring)spring;
                    padding.setSources(newLeading);
                    newLeading.clear();
                    if (counter + 1 == this.springs.size()) {
                        if (padding instanceof ContainerAutopaddingSpring) continue;
                        trailingPadding.add(padding);
                        continue;
                    }
                    newLeadingPadding.clear();
                    newLeadingPadding.add(padding);
                    continue;
                }
                if (newLeading.size() > 0 && insert) {
                    padding = new AutopaddingSpring();
                    this.springs.add(counter--, padding);
                    continue;
                }
                if (spring instanceof ComponentSpring) {
                    ComponentSpring cSpring = (ComponentSpring)spring;
                    if (!cSpring.isVisible()) continue;
                    for (int i = 0; i < newLeadingPadding.size(); ++i) {
                        ((AutopaddingSpring)newLeadingPadding.get(i)).addTarget(cSpring, axis);
                    }
                    newLeading.clear();
                    newLeadingPadding.clear();
                    if (counter + 1 == this.springs.size()) {
                        trailing.add(cSpring);
                        continue;
                    }
                    newLeading.add(cSpring);
                    continue;
                }
                if (spring instanceof Group) {
                    if (newTrailing == null) {
                        newTrailing = new ArrayList(1);
                    } else {
                        newTrailing.clear();
                    }
                    newTrailingPadding.clear();
                    ((Group)spring).insertAutopadding(axis, newLeadingPadding, newTrailingPadding, newLeading, newTrailing, insert);
                    newLeading.clear();
                    newLeadingPadding.clear();
                    if (counter + 1 == this.springs.size()) {
                        trailing.addAll(newTrailing);
                        trailingPadding.addAll(newTrailingPadding);
                        continue;
                    }
                    newLeading.addAll(newTrailing);
                    newLeadingPadding.addAll(newTrailingPadding);
                    continue;
                }
                newLeadingPadding.clear();
                newLeading.clear();
            }
        }

        @Override
        int getBaseline() {
            int baseline;
            if (this.baselineSpring != null && (baseline = this.baselineSpring.getBaseline()) >= 0) {
                int size = 0;
                int max = this.springs.size();
                for (int i = 0; i < max; ++i) {
                    Spring spring = this.getSpring(i);
                    if (spring == this.baselineSpring) {
                        return size + baseline;
                    }
                    size += spring.getPreferredSize(2);
                }
            }
            return -1;
        }

        @Override
        int getBaselineResizeBehavior() {
            if (this.isResizable(2)) {
                if (!this.baselineSpring.isResizable(2)) {
                    Spring spring;
                    boolean leadingResizable = false;
                    int max = this.springs.size();
                    for (int i = 0; i < max && (spring = this.getSpring(i)) != this.baselineSpring; ++i) {
                        if (!spring.isResizable(2)) continue;
                        leadingResizable = true;
                        break;
                    }
                    boolean trailingResizable = false;
                    for (int i = this.springs.size() - 1; i >= 0 && (spring = this.getSpring(i)) != this.baselineSpring; --i) {
                        if (!spring.isResizable(2)) continue;
                        trailingResizable = true;
                        break;
                    }
                    if (leadingResizable && !trailingResizable) {
                        return 2;
                    }
                    if (!leadingResizable && trailingResizable) {
                        return 1;
                    }
                } else {
                    int brb = this.baselineSpring.getBaselineResizeBehavior();
                    if (brb == 1) {
                        int max = this.springs.size();
                        for (int i = 0; i < max; ++i) {
                            Spring spring = this.getSpring(i);
                            if (spring == this.baselineSpring) {
                                return 1;
                            }
                            if (!spring.isResizable(2)) continue;
                            return 4;
                        }
                    } else if (brb == 2) {
                        for (int i = this.springs.size() - 1; i >= 0; --i) {
                            Spring spring = this.getSpring(i);
                            if (spring == this.baselineSpring) {
                                return 2;
                            }
                            if (!spring.isResizable(2)) continue;
                            return 4;
                        }
                    }
                }
                return 4;
            }
            return 1;
        }
    }

    public abstract class Group
    extends Spring {
        List springs;

        Group() {
            this.springs = new ArrayList();
        }

        int indexOf(Spring spring) {
            return this.springs.indexOf(spring);
        }

        Group addSpring(Spring spring) {
            this.springs.add(spring);
            spring.setParent(this);
            if (!(spring instanceof AutopaddingSpring) || !((AutopaddingSpring)spring).getUserCreated()) {
                GroupLayout.this.springsChanged = true;
            }
            return this;
        }

        @Override
        void setSize(int axis, int origin, int size) {
            super.setSize(axis, origin, size);
            if (size == Integer.MIN_VALUE) {
                for (int counter = this.springs.size() - 1; counter >= 0; --counter) {
                    this.getSpring(counter).setSize(axis, origin, size);
                }
            } else {
                this.setValidSize(axis, origin, size);
            }
        }

        abstract void setValidSize(int var1, int var2, int var3);

        @Override
        int calculateMinimumSize(int axis) {
            return this.calculateSize(axis, 0);
        }

        @Override
        int calculatePreferredSize(int axis) {
            return this.calculateSize(axis, 1);
        }

        @Override
        int calculateMaximumSize(int axis) {
            return this.calculateSize(axis, 2);
        }

        abstract int operator(int var1, int var2);

        int calculateSize(int axis, int type) {
            int count = this.springs.size();
            if (count == 0) {
                return 0;
            }
            if (count == 1) {
                return this.getSpringSize(this.getSpring(0), axis, type);
            }
            int size = this.constrain(this.operator(this.getSpringSize(this.getSpring(0), axis, type), this.getSpringSize(this.getSpring(1), axis, type)));
            for (int counter = 2; counter < count; ++counter) {
                size = this.constrain(this.operator(size, this.getSpringSize(this.getSpring(counter), axis, type)));
            }
            return size;
        }

        Spring getSpring(int index) {
            return (Spring)this.springs.get(index);
        }

        int getSpringSize(Spring spring, int axis, int type) {
            switch (type) {
                case 0: {
                    return spring.getMinimumSize(axis);
                }
                case 1: {
                    return spring.getPreferredSize(axis);
                }
                case 2: {
                    return spring.getMaximumSize(axis);
                }
            }
            return 0;
        }

        abstract void insertAutopadding(int var1, List var2, List var3, List var4, List var5, boolean var6);

        void removeAutopadding() {
            this.unset();
            for (int counter = this.springs.size() - 1; counter >= 0; --counter) {
                Spring spring = (Spring)this.springs.get(counter);
                if (spring instanceof AutopaddingSpring) {
                    if (((AutopaddingSpring)spring).getUserCreated()) {
                        ((AutopaddingSpring)spring).reset();
                        continue;
                    }
                    this.springs.remove(counter);
                    continue;
                }
                if (!(spring instanceof Group)) continue;
                ((Group)spring).removeAutopadding();
            }
        }

        void unsetAutopadding() {
            this.unset();
            for (int counter = this.springs.size() - 1; counter >= 0; --counter) {
                Spring spring = (Spring)this.springs.get(counter);
                if (spring instanceof AutopaddingSpring) {
                    ((AutopaddingSpring)spring).unset();
                    continue;
                }
                if (!(spring instanceof Group)) continue;
                ((Group)spring).unsetAutopadding();
            }
        }

        void calculateAutopadding(int axis) {
            for (int counter = this.springs.size() - 1; counter >= 0; --counter) {
                Spring spring = (Spring)this.springs.get(counter);
                if (spring instanceof AutopaddingSpring) {
                    spring.unset();
                    ((AutopaddingSpring)spring).calculatePadding(axis);
                    continue;
                }
                if (!(spring instanceof Group)) continue;
                ((Group)spring).calculateAutopadding(axis);
            }
            this.unset();
        }
    }

    abstract class Spring {
        private int size;
        private int min;
        private int max = Integer.MIN_VALUE;
        private int pref = Integer.MIN_VALUE;
        private Spring parent;
        private int alignment;

        Spring() {
            this.min = Integer.MIN_VALUE;
        }

        abstract int calculateMinimumSize(int var1);

        abstract int calculatePreferredSize(int var1);

        abstract int calculateMaximumSize(int var1);

        void setParent(Spring parent) {
            this.parent = parent;
        }

        Spring getParent() {
            return this.parent;
        }

        void setAlignment(int alignment) {
            this.alignment = alignment;
        }

        int getAlignment() {
            return this.alignment;
        }

        final int getMinimumSize(int axis) {
            if (this.min == Integer.MIN_VALUE) {
                this.min = this.constrain(this.calculateMinimumSize(axis));
            }
            return this.min;
        }

        final int getPreferredSize(int axis) {
            if (this.pref == Integer.MIN_VALUE) {
                this.pref = this.constrain(this.calculatePreferredSize(axis));
            }
            return this.pref;
        }

        final int getMaximumSize(int axis) {
            if (this.max == Integer.MIN_VALUE) {
                this.max = this.constrain(this.calculateMaximumSize(axis));
            }
            return this.max;
        }

        void unset() {
            this.max = Integer.MIN_VALUE;
            this.pref = Integer.MIN_VALUE;
            this.min = Integer.MIN_VALUE;
            this.size = Integer.MIN_VALUE;
        }

        void setSize(int axis, int origin, int size) {
            this.size = size;
            if (size == Integer.MIN_VALUE) {
                this.unset();
            }
        }

        int getSize() {
            return this.size;
        }

        int constrain(int value) {
            return Math.min(value, Short.MAX_VALUE);
        }

        int getBaseline() {
            return -1;
        }

        int getBaselineResizeBehavior() {
            return 4;
        }

        final boolean isResizable(int axis) {
            int pref;
            int min = this.getMinimumSize(axis);
            return min != (pref = this.getPreferredSize(axis)) || pref != this.getMaximumSize(axis);
        }
    }
}

