/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DHPrivateKey;
import com.sun.crypto.provider.DHPublicKey;
import com.sun.crypto.provider.SunJCE;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHParameterSpec;
import sun.security.provider.ParameterCache;

public final class DHKeyPairGenerator
extends KeyPairGeneratorSpi {
    private DHParameterSpec params;
    private int pSize;
    private int lSize;
    private SecureRandom random;

    public DHKeyPairGenerator() {
        this.initialize(1024, null);
    }

    private static void checkKeySize(int n) throws InvalidParameterException {
        if (n < 512 || n > 8192 || (n & 0x3F) != 0) {
            throw new InvalidParameterException("DH key size must be multiple of 64, and can only range from 512 to 8192 (inclusive). The specific key size " + n + " is not supported");
        }
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        DHKeyPairGenerator.checkKeySize(n);
        this.params = ParameterCache.getCachedDHParameterSpec(n);
        if (this.params == null && n > 1024) {
            throw new InvalidParameterException("Unsupported " + n + "-bit DH parameter generation");
        }
        this.pSize = n;
        this.lSize = 0;
        this.random = secureRandom;
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Inappropriate parameter type");
        }
        this.params = (DHParameterSpec)algorithmParameterSpec;
        this.pSize = this.params.getP().bitLength();
        try {
            DHKeyPairGenerator.checkKeySize(this.pSize);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new InvalidAlgorithmParameterException(invalidParameterException.getMessage());
        }
        this.lSize = this.params.getL();
        if (this.lSize != 0 && this.lSize > this.pSize) {
            throw new InvalidAlgorithmParameterException("Exponent size must not be larger than modulus size");
        }
        this.random = secureRandom;
    }

    @Override
    public KeyPair generateKeyPair() {
        BigInteger bigInteger;
        if (this.random == null) {
            this.random = SunJCE.getRandom();
        }
        if (this.params == null) {
            try {
                this.params = ParameterCache.getDHParameterSpec(this.pSize, this.random);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new ProviderException(generalSecurityException);
            }
        }
        BigInteger bigInteger2 = this.params.getP();
        BigInteger bigInteger3 = this.params.getG();
        if (this.lSize <= 0) {
            this.lSize = this.pSize >> 1;
            if (this.lSize < 384) {
                this.lSize = 384;
            }
        }
        BigInteger bigInteger4 = bigInteger2.subtract(BigInteger.valueOf(2L));
        while ((bigInteger = new BigInteger(this.lSize, this.random)).compareTo(BigInteger.ONE) < 0 || bigInteger.compareTo(bigInteger4) > 0 || bigInteger.bitLength() != this.lSize) {
        }
        BigInteger bigInteger5 = bigInteger3.modPow(bigInteger, bigInteger2);
        DHPublicKey dHPublicKey = new DHPublicKey(bigInteger5, bigInteger2, bigInteger3, this.lSize);
        DHPrivateKey dHPrivateKey = new DHPrivateKey(bigInteger, bigInteger2, bigInteger3, this.lSize);
        return new KeyPair(dHPublicKey, dHPrivateKey);
    }
}

