/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AlgorithmConstraints;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.Subject;
import sun.security.action.GetPropertyAction;
import sun.security.ssl.Alerts;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.DHClientKeyExchange;
import sun.security.ssl.DHCrypt;
import sun.security.ssl.Debug;
import sun.security.ssl.ECDHClientKeyExchange;
import sun.security.ssl.ECDHCrypt;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.Handshaker;
import sun.security.ssl.HelloExtension;
import sun.security.ssl.JsseJce;
import sun.security.ssl.KerberosClientKeyExchange;
import sun.security.ssl.Krb5Helper;
import sun.security.ssl.ProtocolList;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.RSAClientKeyExchange;
import sun.security.ssl.RandomCookie;
import sun.security.ssl.RenegotiationInfoExtension;
import sun.security.ssl.SSLAlgorithmDecomposer;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLSessionContextImpl;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.SSLSocketImpl;
import sun.security.ssl.ServerNameExtension;
import sun.security.ssl.SignatureAlgorithmsExtension;
import sun.security.ssl.SignatureAndHashAlgorithm;
import sun.security.ssl.SupportedEllipticCurvesExtension;
import sun.security.util.KeyUtil;
import sun.security.util.LegacyAlgorithmConstraints;

final class ServerHandshaker
extends Handshaker {
    private byte doClientAuth;
    private X509Certificate[] certs;
    private PrivateKey privateKey;
    private Object serviceCreds;
    private boolean needClientVerify = false;
    private PrivateKey tempPrivateKey;
    private PublicKey tempPublicKey;
    private DHCrypt dh;
    private ECDHCrypt ecdh;
    private ProtocolVersion clientRequestedVersion;
    private SupportedEllipticCurvesExtension supportedCurves;
    SignatureAndHashAlgorithm preferableSignatureAlgorithm;
    private static final boolean useSmartEphemeralDHKeys;
    private static final boolean useLegacyEphemeralDHKeys;
    private static final int customizedDHKeySize;
    private static final AlgorithmConstraints legacyAlgorithmConstraints;

    ServerHandshaker(SSLSocketImpl sSLSocketImpl, SSLContextImpl sSLContextImpl, ProtocolList protocolList, byte by, ProtocolVersion protocolVersion, boolean bl, boolean bl2, byte[] byArray, byte[] byArray2) {
        super(sSLSocketImpl, sSLContextImpl, protocolList, by != 0, false, protocolVersion, bl, bl2, byArray, byArray2);
        this.doClientAuth = by;
    }

    ServerHandshaker(SSLEngineImpl sSLEngineImpl, SSLContextImpl sSLContextImpl, ProtocolList protocolList, byte by, ProtocolVersion protocolVersion, boolean bl, boolean bl2, byte[] byArray, byte[] byArray2) {
        super(sSLEngineImpl, sSLContextImpl, protocolList, by != 0, false, protocolVersion, bl, bl2, byArray, byArray2);
        this.doClientAuth = by;
    }

    void setClientAuth(byte by) {
        this.doClientAuth = by;
    }

    @Override
    void processMessage(byte by, int n) throws IOException {
        if (this.state >= by && this.state != 16 && by != 15) {
            throw new SSLProtocolException("Handshake message sequence violation, state = " + this.state + ", type = " + by);
        }
        switch (by) {
            case 1: {
                HandshakeMessage.ClientHello clientHello = new HandshakeMessage.ClientHello(this.input, n);
                this.clientHello(clientHello);
                break;
            }
            case 11: {
                if (this.doClientAuth == 0) {
                    this.fatalSE((byte)10, "client sent unsolicited cert chain");
                }
                this.clientCertificate(new HandshakeMessage.CertificateMsg(this.input));
                break;
            }
            case 16: {
                SecretKey secretKey;
                switch (this.keyExchange) {
                    case K_RSA: 
                    case K_RSA_EXPORT: {
                        RSAClientKeyExchange rSAClientKeyExchange = new RSAClientKeyExchange(this.protocolVersion, this.clientRequestedVersion, this.sslContext.getSecureRandom(), this.input, n, this.privateKey);
                        secretKey = this.clientKeyExchange(rSAClientKeyExchange);
                        break;
                    }
                    case K_KRB5: 
                    case K_KRB5_EXPORT: {
                        secretKey = this.clientKeyExchange(new KerberosClientKeyExchange(this.protocolVersion, this.clientRequestedVersion, this.sslContext.getSecureRandom(), this.input, this.getAccSE(), this.serviceCreds));
                        break;
                    }
                    case K_DHE_RSA: 
                    case K_DHE_DSS: 
                    case K_DH_ANON: {
                        secretKey = this.clientKeyExchange(new DHClientKeyExchange(this.input));
                        break;
                    }
                    case K_ECDH_RSA: 
                    case K_ECDH_ECDSA: 
                    case K_ECDHE_RSA: 
                    case K_ECDHE_ECDSA: 
                    case K_ECDH_ANON: {
                        secretKey = this.clientKeyExchange(new ECDHClientKeyExchange(this.input));
                        break;
                    }
                    default: {
                        throw new SSLProtocolException("Unrecognized key exchange: " + (Object)((Object)this.keyExchange));
                    }
                }
                this.calculateKeys(secretKey, this.clientRequestedVersion);
                break;
            }
            case 15: {
                this.clientCertificateVerify(new HandshakeMessage.CertificateVerify(this.input, this.getLocalSupportedSignAlgs(), this.protocolVersion));
                break;
            }
            case 20: {
                if (!this.receivedChangeCipherSpec()) {
                    this.fatalSE((byte)40, "Received Finished message before ChangeCipherSpec");
                }
                this.clientFinished(new HandshakeMessage.Finished(this.protocolVersion, this.input, this.cipherSuite));
                break;
            }
            default: {
                throw new SSLProtocolException("Illegal server handshake msg, " + by);
            }
        }
        if (this.state < by) {
            this.state = by == 15 ? by + 2 : (int)by;
        }
    }

    private void clientHello(HandshakeMessage.ClientHello clientHello) throws IOException {
        Collection<SignatureAndHashAlgorithm> collection;
        Object object;
        Collection<SignatureAndHashAlgorithm> collection2;
        Object object2;
        RenegotiationInfoExtension renegotiationInfoExtension;
        if (debug != null && Debug.isOn("handshake")) {
            clientHello.print(System.out);
        }
        if (rejectClientInitiatedRenego && !this.isInitialHandshake && this.state != 0) {
            this.fatalSE((byte)40, "Client initiated renegotiation is not allowed");
        }
        ServerNameExtension serverNameExtension = (ServerNameExtension)clientHello.extensions.get(ExtensionType.EXT_SERVER_NAME);
        if (!this.sniMatchers.isEmpty() && serverNameExtension != null && !serverNameExtension.isMatched(this.sniMatchers)) {
            this.fatalSE((byte)112, "Unrecognized server name indication");
        }
        boolean bl = false;
        CipherSuiteList cipherSuiteList = clientHello.getCipherSuites();
        if (cipherSuiteList.contains(CipherSuite.C_SCSV)) {
            bl = true;
            if (this.isInitialHandshake) {
                this.secureRenegotiation = true;
            } else if (this.secureRenegotiation) {
                this.fatalSE((byte)40, "The SCSV is present in a secure renegotiation");
            } else {
                this.fatalSE((byte)40, "The SCSV is present in a insecure renegotiation");
            }
        }
        if ((renegotiationInfoExtension = (RenegotiationInfoExtension)clientHello.extensions.get(ExtensionType.EXT_RENEGOTIATION_INFO)) != null) {
            bl = true;
            if (this.isInitialHandshake) {
                if (!renegotiationInfoExtension.isEmpty()) {
                    this.fatalSE((byte)40, "The renegotiation_info field is not empty");
                }
                this.secureRenegotiation = true;
            } else {
                if (!this.secureRenegotiation) {
                    this.fatalSE((byte)40, "The renegotiation_info is present in a insecure renegotiation");
                }
                if (!MessageDigest.isEqual(this.clientVerifyData, renegotiationInfoExtension.getRenegotiatedConnection())) {
                    this.fatalSE((byte)40, "Incorrect verify data in ClientHello renegotiation_info message");
                }
            }
        } else if (!this.isInitialHandshake && this.secureRenegotiation) {
            this.fatalSE((byte)40, "Inconsistent secure renegotiation indication");
        }
        if (!bl || !this.secureRenegotiation) {
            if (this.isInitialHandshake) {
                if (!allowLegacyHelloMessages) {
                    this.fatalSE((byte)40, "Failed to negotiate the use of secure renegotiation");
                }
                if (debug != null && Debug.isOn("handshake")) {
                    System.out.println("Warning: No renegotiation indication in ClientHello, allow legacy ClientHello");
                }
            } else if (!allowUnsafeRenegotiation) {
                if (this.activeProtocolVersion.v >= ProtocolVersion.TLS10.v) {
                    this.warningSE((byte)100);
                    this.invalidated = true;
                    if (this.input.available() > 0) {
                        this.fatalSE((byte)10, "ClientHello followed by an unexpected  handshake message");
                    }
                    return;
                }
                this.fatalSE((byte)40, "Renegotiation is not allowed");
            } else if (debug != null && Debug.isOn("handshake")) {
                System.out.println("Warning: continue with insecure renegotiation");
            }
        }
        this.input.digestNow();
        HandshakeMessage.ServerHello serverHello = new HandshakeMessage.ServerHello();
        this.clientRequestedVersion = clientHello.protocolVersion;
        ProtocolVersion protocolVersion = this.selectProtocolVersion(this.clientRequestedVersion);
        if (protocolVersion == null || protocolVersion.v == ProtocolVersion.SSL20Hello.v) {
            this.fatalSE((byte)40, "Client requested protocol " + this.clientRequestedVersion + " not enabled or not supported");
        }
        this.handshakeHash.protocolDetermined(protocolVersion);
        this.setVersion(protocolVersion);
        serverHello.protocolVersion = this.protocolVersion;
        this.clnt_random = clientHello.clnt_random;
        serverHello.svr_random = this.svr_random = new RandomCookie(this.sslContext.getSecureRandom());
        this.session = null;
        if (clientHello.sessionId.length() != 0 && (object2 = ((SSLSessionContextImpl)this.sslContext.engineGetServerSessionContext()).get(clientHello.sessionId.getId())) != null) {
            this.resumingSession = ((SSLSessionImpl)object2).isRejoinable();
            if (this.resumingSession && (collection2 = ((SSLSessionImpl)object2).getProtocolVersion()) != this.protocolVersion) {
                this.resumingSession = false;
            }
            if (this.resumingSession) {
                collection2 = ((SSLSessionImpl)object2).getRequestedServerNames();
                if (serverNameExtension != null) {
                    if (!serverNameExtension.isIdentical((List<SNIServerName>)collection2)) {
                        this.resumingSession = false;
                    }
                } else if (!collection2.isEmpty()) {
                    this.resumingSession = false;
                }
                if (!this.resumingSession && debug != null && Debug.isOn("handshake")) {
                    System.out.println("The requested server name indication is not identical to the previous one");
                }
            }
            if (this.resumingSession && this.doClientAuth == 2) {
                try {
                    ((SSLSessionImpl)object2).getPeerPrincipal();
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    this.resumingSession = false;
                }
            }
            if (this.resumingSession) {
                collection2 = ((SSLSessionImpl)object2).getSuite();
                if (((CipherSuite)((Object)collection2)).keyExchange == CipherSuite.KeyExchange.K_KRB5 || ((CipherSuite)((Object)collection2)).keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
                    block96: {
                        object = ((SSLSessionImpl)object2).getLocalPrincipal();
                        collection = null;
                        try {
                            collection = AccessController.doPrivileged(new PrivilegedExceptionAction<Subject>(){

                                @Override
                                public Subject run() throws Exception {
                                    return Krb5Helper.getServerSubject(ServerHandshaker.this.getAccSE());
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            collection = null;
                            if (debug == null || !Debug.isOn("session")) break block96;
                            System.out.println("Attempt to obtain subject failed!");
                        }
                    }
                    if (collection != null) {
                        if (Krb5Helper.isRelated((Subject)((Object)collection), (Principal)object)) {
                            if (debug != null && Debug.isOn("session")) {
                                System.out.println("Subject can provide creds for princ");
                            }
                        } else {
                            this.resumingSession = false;
                            if (debug != null && Debug.isOn("session")) {
                                System.out.println("Subject cannot provide creds for princ");
                            }
                        }
                    } else {
                        this.resumingSession = false;
                        if (debug != null && Debug.isOn("session")) {
                            System.out.println("Kerberos credentials are not present in the current Subject; check if  javax.security.auth.useSubjectAsCreds system property has been set to false");
                        }
                    }
                }
            }
            if (this.resumingSession) {
                collection2 = ((SSLSessionImpl)object2).getSuite();
                if (!this.isNegotiable((CipherSuite)((Object)collection2)) || !clientHello.getCipherSuites().contains((CipherSuite)((Object)collection2))) {
                    this.resumingSession = false;
                } else {
                    this.setCipherSuite((CipherSuite)((Object)collection2));
                }
            }
            if (this.resumingSession) {
                this.session = object2;
                if (debug != null && (Debug.isOn("handshake") || Debug.isOn("session"))) {
                    System.out.println("%% Resuming " + this.session);
                }
            }
        }
        if (this.session == null) {
            if (!this.enableNewSession) {
                throw new SSLException("Client did not resume a session");
            }
            this.supportedCurves = (SupportedEllipticCurvesExtension)clientHello.extensions.get(ExtensionType.EXT_ELLIPTIC_CURVES);
            if (this.protocolVersion.v >= ProtocolVersion.TLS12.v && (object2 = (SignatureAlgorithmsExtension)clientHello.extensions.get(ExtensionType.EXT_SIGNATURE_ALGORITHMS)) != null) {
                collection2 = ((SignatureAlgorithmsExtension)object2).getSignAlgorithms();
                if (collection2 == null || collection2.isEmpty()) {
                    throw new SSLHandshakeException("No peer supported signature algorithms");
                }
                object = SignatureAndHashAlgorithm.getSupportedAlgorithms(this.algorithmConstraints, collection2);
                if (object.isEmpty()) {
                    throw new SSLHandshakeException("No signature and hash algorithm in common");
                }
                this.setPeerSupportedSignAlgs((Collection<SignatureAndHashAlgorithm>)object);
            }
            this.session = new SSLSessionImpl(this.protocolVersion, CipherSuite.C_NULL, this.getLocalSupportedSignAlgs(), this.sslContext.getSecureRandom(), this.getHostAddressSE(), this.getPortSE());
            if (this.protocolVersion.v >= ProtocolVersion.TLS12.v && this.peerSupportedSignAlgs != null) {
                this.session.setPeerSupportedSignatureAlgorithms(this.peerSupportedSignAlgs);
            }
            object2 = Collections.emptyList();
            if (serverNameExtension != null) {
                object2 = serverNameExtension.getServerNames();
            }
            this.session.setRequestedServerNames((List<SNIServerName>)object2);
            this.setHandshakeSessionSE(this.session);
            this.chooseCipherSuite(clientHello);
            this.session.setSuite(this.cipherSuite);
            this.session.setLocalPrivateKey(this.privateKey);
        } else {
            this.setHandshakeSessionSE(this.session);
        }
        if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
            this.handshakeHash.setFinishedAlg(this.cipherSuite.prfAlg.getPRFHashAlg());
        }
        serverHello.cipherSuite = this.cipherSuite;
        serverHello.sessionId = this.session.getSessionId();
        serverHello.compression_method = this.session.getCompression();
        if (this.secureRenegotiation) {
            object2 = new RenegotiationInfoExtension(this.clientVerifyData, this.serverVerifyData);
            serverHello.extensions.add((HelloExtension)object2);
        }
        if (!this.sniMatchers.isEmpty() && serverNameExtension != null && !this.resumingSession) {
            object2 = new ServerNameExtension();
            serverHello.extensions.add((HelloExtension)object2);
        }
        if (debug != null && Debug.isOn("handshake")) {
            serverHello.print(System.out);
            System.out.println("Cipher suite:  " + this.session.getSuite());
        }
        serverHello.write(this.output);
        if (this.resumingSession) {
            this.calculateConnectionKeys(this.session.getMasterSecret());
            this.sendChangeCipherAndFinish(false);
            return;
        }
        if (this.keyExchange != CipherSuite.KeyExchange.K_KRB5 && this.keyExchange != CipherSuite.KeyExchange.K_KRB5_EXPORT) {
            if (this.keyExchange != CipherSuite.KeyExchange.K_DH_ANON && this.keyExchange != CipherSuite.KeyExchange.K_ECDH_ANON) {
                if (this.certs == null) {
                    throw new RuntimeException("no certificates");
                }
                object2 = new HandshakeMessage.CertificateMsg(this.certs);
                this.session.setLocalCertificates(this.certs);
                if (debug != null && Debug.isOn("handshake")) {
                    ((HandshakeMessage.CertificateMsg)object2).print(System.out);
                }
                ((HandshakeMessage)object2).write(this.output);
            } else if (this.certs != null) {
                throw new RuntimeException("anonymous keyexchange with certs");
            }
        }
        switch (this.keyExchange) {
            case K_RSA: 
            case K_KRB5: 
            case K_KRB5_EXPORT: {
                object2 = null;
                break;
            }
            case K_RSA_EXPORT: {
                if (JsseJce.getRSAKeyLength(this.certs[0].getPublicKey()) > 512) {
                    try {
                        object2 = new HandshakeMessage.RSA_ServerKeyExchange(this.tempPublicKey, this.privateKey, this.clnt_random, this.svr_random, this.sslContext.getSecureRandom());
                        this.privateKey = this.tempPrivateKey;
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        ServerHandshaker.throwSSLException("Error generating RSA server key exchange", generalSecurityException);
                        object2 = null;
                    }
                    break;
                }
                object2 = null;
                break;
            }
            case K_DHE_RSA: 
            case K_DHE_DSS: {
                try {
                    object2 = new HandshakeMessage.DH_ServerKeyExchange(this.dh, this.privateKey, this.clnt_random.random_bytes, this.svr_random.random_bytes, this.sslContext.getSecureRandom(), this.preferableSignatureAlgorithm, this.protocolVersion);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    ServerHandshaker.throwSSLException("Error generating DH server key exchange", generalSecurityException);
                    object2 = null;
                }
                break;
            }
            case K_DH_ANON: {
                object2 = new HandshakeMessage.DH_ServerKeyExchange(this.dh, this.protocolVersion);
                break;
            }
            case K_ECDHE_RSA: 
            case K_ECDHE_ECDSA: 
            case K_ECDH_ANON: {
                try {
                    object2 = new HandshakeMessage.ECDH_ServerKeyExchange(this.ecdh, this.privateKey, this.clnt_random.random_bytes, this.svr_random.random_bytes, this.sslContext.getSecureRandom(), this.preferableSignatureAlgorithm, this.protocolVersion);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    ServerHandshaker.throwSSLException("Error generating ECDH server key exchange", generalSecurityException);
                    object2 = null;
                }
                break;
            }
            case K_ECDH_RSA: 
            case K_ECDH_ECDSA: {
                object2 = null;
                break;
            }
            default: {
                throw new RuntimeException("internal error: " + (Object)((Object)this.keyExchange));
            }
        }
        if (object2 != null) {
            if (debug != null && Debug.isOn("handshake")) {
                ((HandshakeMessage)object2).print(System.out);
            }
            ((HandshakeMessage)object2).write(this.output);
        }
        if (this.doClientAuth != 0 && this.keyExchange != CipherSuite.KeyExchange.K_DH_ANON && this.keyExchange != CipherSuite.KeyExchange.K_ECDH_ANON && this.keyExchange != CipherSuite.KeyExchange.K_KRB5 && this.keyExchange != CipherSuite.KeyExchange.K_KRB5_EXPORT) {
            collection = null;
            if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                collection = this.getLocalSupportedSignAlgs();
                if (collection.isEmpty()) {
                    throw new SSLHandshakeException("No supported signature algorithm");
                }
                Set<String> set = SignatureAndHashAlgorithm.getHashAlgorithmNames(collection);
                if (set.isEmpty()) {
                    throw new SSLHandshakeException("No supported signature algorithm");
                }
            }
            object = this.sslContext.getX509TrustManager().getAcceptedIssuers();
            collection2 = new HandshakeMessage.CertificateRequest((X509Certificate[])object, this.keyExchange, collection, this.protocolVersion);
            if (debug != null && Debug.isOn("handshake")) {
                ((HandshakeMessage.CertificateRequest)((Object)collection2)).print(System.out);
            }
            ((HandshakeMessage)((Object)collection2)).write(this.output);
        }
        collection2 = new HandshakeMessage.ServerHelloDone();
        if (debug != null && Debug.isOn("handshake")) {
            ((HandshakeMessage.ServerHelloDone)((Object)collection2)).print(System.out);
        }
        ((HandshakeMessage)((Object)collection2)).write(this.output);
        this.output.flush();
    }

    private void chooseCipherSuite(HandshakeMessage.ClientHello clientHello) throws IOException {
        CipherSuiteList cipherSuiteList;
        CipherSuiteList cipherSuiteList2;
        if (this.preferLocalCipherSuites) {
            cipherSuiteList2 = this.getActiveCipherSuites();
            cipherSuiteList = clientHello.getCipherSuites();
        } else {
            cipherSuiteList2 = clientHello.getCipherSuites();
            cipherSuiteList = this.getActiveCipherSuites();
        }
        ArrayList<CipherSuite> arrayList = new ArrayList<CipherSuite>();
        for (CipherSuite cipherSuite : cipherSuiteList2.collection()) {
            if (!ServerHandshaker.isNegotiable(cipherSuiteList, cipherSuite) || this.doClientAuth == 2 && (cipherSuite.keyExchange == CipherSuite.KeyExchange.K_DH_ANON || cipherSuite.keyExchange == CipherSuite.KeyExchange.K_ECDH_ANON)) continue;
            if (!legacyAlgorithmConstraints.permits(null, cipherSuite.name, null)) {
                arrayList.add(cipherSuite);
                continue;
            }
            if (!this.trySetCipherSuite(cipherSuite)) continue;
            return;
        }
        for (CipherSuite cipherSuite : arrayList) {
            if (!this.trySetCipherSuite(cipherSuite)) continue;
            return;
        }
        this.fatalSE((byte)40, "no cipher suites in common");
    }

    boolean trySetCipherSuite(CipherSuite cipherSuite) {
        if (this.resumingSession) {
            return true;
        }
        if (!cipherSuite.isNegotiable()) {
            return false;
        }
        if (this.protocolVersion.v >= cipherSuite.obsoleted) {
            return false;
        }
        if (this.protocolVersion.v < cipherSuite.supported) {
            return false;
        }
        CipherSuite.KeyExchange keyExchange = cipherSuite.keyExchange;
        this.privateKey = null;
        this.certs = null;
        this.dh = null;
        this.tempPrivateKey = null;
        this.tempPublicKey = null;
        Collection<SignatureAndHashAlgorithm> collection = null;
        if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
            if (this.peerSupportedSignAlgs != null) {
                collection = this.peerSupportedSignAlgs;
            } else {
                SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
                switch (keyExchange) {
                    case K_RSA: 
                    case K_DHE_RSA: 
                    case K_ECDH_RSA: 
                    case K_ECDHE_RSA: 
                    case K_DH_RSA: {
                        signatureAndHashAlgorithm = SignatureAndHashAlgorithm.valueOf(SignatureAndHashAlgorithm.HashAlgorithm.SHA1.value, SignatureAndHashAlgorithm.SignatureAlgorithm.RSA.value, 0);
                        break;
                    }
                    case K_DHE_DSS: 
                    case K_DH_DSS: {
                        signatureAndHashAlgorithm = SignatureAndHashAlgorithm.valueOf(SignatureAndHashAlgorithm.HashAlgorithm.SHA1.value, SignatureAndHashAlgorithm.SignatureAlgorithm.DSA.value, 0);
                        break;
                    }
                    case K_ECDH_ECDSA: 
                    case K_ECDHE_ECDSA: {
                        signatureAndHashAlgorithm = SignatureAndHashAlgorithm.valueOf(SignatureAndHashAlgorithm.HashAlgorithm.SHA1.value, SignatureAndHashAlgorithm.SignatureAlgorithm.ECDSA.value, 0);
                        break;
                    }
                }
                if (signatureAndHashAlgorithm == null) {
                    collection = Collections.emptySet();
                } else {
                    collection = new ArrayList(1);
                    collection.add(signatureAndHashAlgorithm);
                    collection = SignatureAndHashAlgorithm.getSupportedAlgorithms(this.algorithmConstraints, collection);
                }
                this.session.setPeerSupportedSignatureAlgorithms(collection);
            }
        }
        switch (keyExchange) {
            case K_RSA: {
                if (this.setupPrivateKeyAndChain("RSA")) break;
                return false;
            }
            case K_RSA_EXPORT: {
                if (!this.setupPrivateKeyAndChain("RSA")) {
                    return false;
                }
                try {
                    if (JsseJce.getRSAKeyLength(this.certs[0].getPublicKey()) > 512 && !this.setupEphemeralRSAKeys(cipherSuite.exportable)) {
                        return false;
                    }
                    break;
                }
                catch (RuntimeException runtimeException) {
                    return false;
                }
            }
            case K_DHE_RSA: {
                if (!this.setupPrivateKeyAndChain("RSA")) {
                    return false;
                }
                if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                    this.preferableSignatureAlgorithm = SignatureAndHashAlgorithm.getPreferableAlgorithm(collection, "RSA", this.privateKey);
                    if (this.preferableSignatureAlgorithm == null) {
                        if (debug != null && Debug.isOn("handshake")) {
                            System.out.println("No signature and hash algorithm for cipher " + cipherSuite);
                        }
                        return false;
                    }
                }
                this.setupEphemeralDHKeys(cipherSuite.exportable, this.privateKey);
                break;
            }
            case K_ECDHE_RSA: {
                if (!this.setupPrivateKeyAndChain("RSA")) {
                    return false;
                }
                if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                    this.preferableSignatureAlgorithm = SignatureAndHashAlgorithm.getPreferableAlgorithm(collection, "RSA", this.privateKey);
                    if (this.preferableSignatureAlgorithm == null) {
                        if (debug != null && Debug.isOn("handshake")) {
                            System.out.println("No signature and hash algorithm for cipher " + cipherSuite);
                        }
                        return false;
                    }
                }
                if (this.setupEphemeralECDHKeys()) break;
                return false;
            }
            case K_DHE_DSS: {
                if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                    this.preferableSignatureAlgorithm = SignatureAndHashAlgorithm.getPreferableAlgorithm(collection, "DSA");
                    if (this.preferableSignatureAlgorithm == null) {
                        if (debug != null && Debug.isOn("handshake")) {
                            System.out.println("No signature and hash algorithm for cipher " + cipherSuite);
                        }
                        return false;
                    }
                }
                if (!this.setupPrivateKeyAndChain("DSA")) {
                    return false;
                }
                this.setupEphemeralDHKeys(cipherSuite.exportable, this.privateKey);
                break;
            }
            case K_ECDHE_ECDSA: {
                if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                    this.preferableSignatureAlgorithm = SignatureAndHashAlgorithm.getPreferableAlgorithm(collection, "ECDSA");
                    if (this.preferableSignatureAlgorithm == null) {
                        if (debug != null && Debug.isOn("handshake")) {
                            System.out.println("No signature and hash algorithm for cipher " + cipherSuite);
                        }
                        return false;
                    }
                }
                if (!this.setupPrivateKeyAndChain("EC")) {
                    return false;
                }
                if (this.setupEphemeralECDHKeys()) break;
                return false;
            }
            case K_ECDH_RSA: {
                if (!this.setupPrivateKeyAndChain("EC")) {
                    return false;
                }
                this.setupStaticECDHKeys();
                break;
            }
            case K_ECDH_ECDSA: {
                if (!this.setupPrivateKeyAndChain("EC")) {
                    return false;
                }
                this.setupStaticECDHKeys();
                break;
            }
            case K_KRB5: 
            case K_KRB5_EXPORT: {
                if (this.setupKerberosKeys()) break;
                return false;
            }
            case K_DH_ANON: {
                this.setupEphemeralDHKeys(cipherSuite.exportable, null);
                break;
            }
            case K_ECDH_ANON: {
                if (this.setupEphemeralECDHKeys()) break;
                return false;
            }
            default: {
                throw new RuntimeException("Unrecognized cipherSuite: " + cipherSuite);
            }
        }
        this.setCipherSuite(cipherSuite);
        if (this.protocolVersion.v >= ProtocolVersion.TLS12.v && this.peerSupportedSignAlgs == null) {
            this.setPeerSupportedSignAlgs(collection);
        }
        return true;
    }

    private boolean setupEphemeralRSAKeys(boolean bl) {
        KeyPair keyPair = this.sslContext.getEphemeralKeyManager().getRSAKeyPair(bl, this.sslContext.getSecureRandom());
        if (keyPair == null) {
            return false;
        }
        this.tempPublicKey = keyPair.getPublic();
        this.tempPrivateKey = keyPair.getPrivate();
        return true;
    }

    private void setupEphemeralDHKeys(boolean bl, Key key) {
        int n;
        int n2 = n = bl ? 512 : 1024;
        if (!bl) {
            if (useLegacyEphemeralDHKeys) {
                n = 768;
            } else if (useSmartEphemeralDHKeys) {
                if (key != null) {
                    int n3 = KeyUtil.getKeySize(key);
                    n = n3 <= 1024 ? 1024 : 2048;
                }
            } else if (customizedDHKeySize > 0) {
                n = customizedDHKeySize;
            }
        }
        this.dh = new DHCrypt(n, this.sslContext.getSecureRandom());
    }

    private boolean setupEphemeralECDHKeys() {
        int n = -1;
        if (this.supportedCurves != null) {
            for (int n2 : this.supportedCurves.curveIds()) {
                if (!SupportedEllipticCurvesExtension.isSupported(n2)) continue;
                n = n2;
                break;
            }
            if (n < 0) {
                return false;
            }
        } else {
            n = SupportedEllipticCurvesExtension.DEFAULT.curveIds()[0];
        }
        String string = SupportedEllipticCurvesExtension.getCurveOid(n);
        this.ecdh = new ECDHCrypt(string, this.sslContext.getSecureRandom());
        return true;
    }

    private void setupStaticECDHKeys() {
        this.ecdh = new ECDHCrypt(this.privateKey, this.certs[0].getPublicKey());
    }

    private boolean setupPrivateKeyAndChain(String string) {
        X509ExtendedKeyManager x509ExtendedKeyManager = this.sslContext.getX509KeyManager();
        String string2 = this.conn != null ? x509ExtendedKeyManager.chooseServerAlias(string, null, this.conn) : x509ExtendedKeyManager.chooseEngineServerAlias(string, null, this.engine);
        if (string2 == null) {
            return false;
        }
        PrivateKey privateKey = x509ExtendedKeyManager.getPrivateKey(string2);
        if (privateKey == null) {
            return false;
        }
        X509Certificate[] x509CertificateArray = x509ExtendedKeyManager.getCertificateChain(string2);
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            return false;
        }
        String string3 = string.split("_")[0];
        PublicKey publicKey = x509CertificateArray[0].getPublicKey();
        if (!privateKey.getAlgorithm().equals(string3) || !publicKey.getAlgorithm().equals(string3)) {
            return false;
        }
        if (string3.equals("EC")) {
            if (!(publicKey instanceof ECPublicKey)) {
                return false;
            }
            ECParameterSpec eCParameterSpec = ((ECPublicKey)publicKey).getParams();
            int n = SupportedEllipticCurvesExtension.getCurveIndex(eCParameterSpec);
            if (!SupportedEllipticCurvesExtension.isSupported(n)) {
                return false;
            }
            if (this.supportedCurves != null && !this.supportedCurves.contains(n)) {
                return false;
            }
        }
        this.privateKey = privateKey;
        this.certs = x509CertificateArray;
        return true;
    }

    private boolean setupKerberosKeys() {
        if (this.serviceCreds != null) {
            return true;
        }
        try {
            final AccessControlContext accessControlContext = this.getAccSE();
            this.serviceCreds = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return Krb5Helper.getServiceCreds(accessControlContext);
                }
            });
            if (this.serviceCreds != null) {
                String string;
                if (debug != null && Debug.isOn("handshake")) {
                    System.out.println("Using Kerberos creds");
                }
                if ((string = Krb5Helper.getServerPrincipalName(this.serviceCreds)) != null) {
                    SecurityManager securityManager = System.getSecurityManager();
                    try {
                        if (securityManager != null) {
                            securityManager.checkPermission(Krb5Helper.getServicePermission(string, "accept"), accessControlContext);
                        }
                    }
                    catch (SecurityException securityException) {
                        this.serviceCreds = null;
                        if (debug != null && Debug.isOn("handshake")) {
                            System.out.println("Permission to access Kerberos secret key denied");
                        }
                        return false;
                    }
                }
            }
            return this.serviceCreds != null;
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("Attempt to obtain Kerberos key failed: " + privilegedActionException.toString());
            }
            return false;
        }
    }

    private SecretKey clientKeyExchange(KerberosClientKeyExchange kerberosClientKeyExchange) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            kerberosClientKeyExchange.print(System.out);
        }
        this.session.setPeerPrincipal(kerberosClientKeyExchange.getPeerPrincipal());
        this.session.setLocalPrincipal(kerberosClientKeyExchange.getLocalPrincipal());
        byte[] byArray = kerberosClientKeyExchange.getUnencryptedPreMasterSecret();
        return new SecretKeySpec(byArray, "TlsPremasterSecret");
    }

    private SecretKey clientKeyExchange(DHClientKeyExchange dHClientKeyExchange) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            dHClientKeyExchange.print(System.out);
        }
        BigInteger bigInteger = dHClientKeyExchange.getClientPublicKey();
        this.dh.checkConstraints(this.algorithmConstraints, bigInteger);
        return this.dh.getAgreedSecret(bigInteger, false);
    }

    private SecretKey clientKeyExchange(ECDHClientKeyExchange eCDHClientKeyExchange) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            eCDHClientKeyExchange.print(System.out);
        }
        byte[] byArray = eCDHClientKeyExchange.getEncodedPoint();
        this.ecdh.checkConstraints(this.algorithmConstraints, byArray);
        return this.ecdh.getAgreedSecret(byArray);
    }

    private void clientCertificateVerify(HandshakeMessage.CertificateVerify certificateVerify) throws IOException {
        Object object;
        if (debug != null && Debug.isOn("handshake")) {
            certificateVerify.print(System.out);
        }
        if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
            object = certificateVerify.getPreferableSignatureAlgorithm();
            if (object == null) {
                throw new SSLHandshakeException("Illegal CertificateVerify message");
            }
            String string = SignatureAndHashAlgorithm.getHashAlgorithmName((SignatureAndHashAlgorithm)object);
            if (string == null || string.length() == 0) {
                throw new SSLHandshakeException("No supported hash algorithm");
            }
        }
        try {
            object = this.session.getPeerCertificates()[0].getPublicKey();
            boolean bl = certificateVerify.verify(this.protocolVersion, this.handshakeHash, (PublicKey)object, this.session.getMasterSecret());
            if (!bl) {
                this.fatalSE((byte)42, "certificate verify message signature error");
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.fatalSE((byte)42, "certificate verify format error", generalSecurityException);
        }
        this.needClientVerify = false;
    }

    private void clientFinished(HandshakeMessage.Finished finished) throws IOException {
        boolean bl;
        if (debug != null && Debug.isOn("handshake")) {
            finished.print(System.out);
        }
        if (this.doClientAuth == 2) {
            this.session.getPeerPrincipal();
        }
        if (this.needClientVerify) {
            this.fatalSE((byte)40, "client did not send certificate verify message");
        }
        if (!(bl = finished.verify(this.handshakeHash, 1, this.session.getMasterSecret()))) {
            this.fatalSE((byte)40, "client 'finished' message doesn't verify");
        }
        if (this.secureRenegotiation) {
            this.clientVerifyData = finished.getVerifyData();
        }
        if (!this.resumingSession) {
            this.input.digestNow();
            this.sendChangeCipherAndFinish(true);
        }
        this.session.setLastAccessedTime(System.currentTimeMillis());
        if (!this.resumingSession && this.session.isRejoinable()) {
            ((SSLSessionContextImpl)this.sslContext.engineGetServerSessionContext()).put(this.session);
            if (debug != null && Debug.isOn("session")) {
                System.out.println("%% Cached server session: " + this.session);
            }
        } else if (!this.resumingSession && debug != null && Debug.isOn("session")) {
            System.out.println("%% Didn't cache non-resumable server session: " + this.session);
        }
    }

    private void sendChangeCipherAndFinish(boolean bl) throws IOException {
        this.output.flush();
        HandshakeMessage.Finished finished = new HandshakeMessage.Finished(this.protocolVersion, this.handshakeHash, 2, this.session.getMasterSecret(), this.cipherSuite);
        this.sendChangeCipherSpec(finished, bl);
        if (this.secureRenegotiation) {
            this.serverVerifyData = finished.getVerifyData();
        }
        if (bl) {
            this.state = 20;
        }
    }

    @Override
    HandshakeMessage getKickstartMessage() {
        return new HandshakeMessage.HelloRequest();
    }

    @Override
    void handshakeAlert(byte by) throws SSLProtocolException {
        String string = Alerts.alertDescription(by);
        if (debug != null && Debug.isOn("handshake")) {
            System.out.println("SSL -- handshake alert:  " + string);
        }
        if (by == 41 && this.doClientAuth == 1) {
            return;
        }
        throw new SSLProtocolException("handshake alert: " + string);
    }

    private SecretKey clientKeyExchange(RSAClientKeyExchange rSAClientKeyExchange) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            rSAClientKeyExchange.print(System.out);
        }
        return rSAClientKeyExchange.preMaster;
    }

    private void clientCertificate(HandshakeMessage.CertificateMsg certificateMsg) throws IOException {
        X509Certificate[] x509CertificateArray;
        block8: {
            if (debug != null && Debug.isOn("handshake")) {
                certificateMsg.print(System.out);
            }
            if ((x509CertificateArray = certificateMsg.getCertificateChain()).length == 0) {
                if (this.doClientAuth == 1) {
                    return;
                }
                this.fatalSE((byte)42, "null cert chain");
            }
            X509TrustManager x509TrustManager = this.sslContext.getX509TrustManager();
            try {
                PublicKey publicKey = x509CertificateArray[0].getPublicKey();
                String string = publicKey.getAlgorithm();
                String string2 = string.equals("RSA") ? "RSA" : (string.equals("DSA") ? "DSA" : (string.equals("EC") ? "EC" : "UNKNOWN"));
                if (x509TrustManager instanceof X509ExtendedTrustManager) {
                    if (this.conn != null) {
                        ((X509ExtendedTrustManager)x509TrustManager).checkClientTrusted((X509Certificate[])x509CertificateArray.clone(), string2, this.conn);
                    } else {
                        ((X509ExtendedTrustManager)x509TrustManager).checkClientTrusted((X509Certificate[])x509CertificateArray.clone(), string2, this.engine);
                    }
                    break block8;
                }
                throw new CertificateException("Improper X509TrustManager implementation");
            }
            catch (CertificateException certificateException) {
                this.fatalSE((byte)46, certificateException);
            }
        }
        this.needClientVerify = true;
        this.session.setPeerCertificates(x509CertificateArray);
    }

    static {
        legacyAlgorithmConstraints = new LegacyAlgorithmConstraints("jdk.tls.legacyAlgorithms", new SSLAlgorithmDecomposer());
        String string = AccessController.doPrivileged(new GetPropertyAction("jdk.tls.ephemeralDHKeySize"));
        if (string == null || string.length() == 0) {
            useLegacyEphemeralDHKeys = false;
            useSmartEphemeralDHKeys = false;
            customizedDHKeySize = -1;
        } else if ("matched".equals(string)) {
            useLegacyEphemeralDHKeys = false;
            useSmartEphemeralDHKeys = true;
            customizedDHKeySize = -1;
        } else if ("legacy".equals(string)) {
            useLegacyEphemeralDHKeys = true;
            useSmartEphemeralDHKeys = false;
            customizedDHKeySize = -1;
        } else {
            useLegacyEphemeralDHKeys = false;
            useSmartEphemeralDHKeys = false;
            try {
                customizedDHKeySize = Integer.parseUnsignedInt(string);
                if (customizedDHKeySize < 1024 || customizedDHKeySize > 8192 || (customizedDHKeySize & 0x3F) != 0) {
                    throw new IllegalArgumentException("Unsupported customized DH key size: " + customizedDHKeySize + ". The key size must be multiple of 64, and can only range from 1024 to 8192 (inclusive)");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Invalid system property jdk.tls.ephemeralDHKeySize");
            }
        }
    }
}

