/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.interfaces.DSAParams;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import sun.security.jca.JCAUtil;
import sun.security.provider.DSAKeyFactory;
import sun.security.provider.DSAPrivateKey;
import sun.security.provider.DSAPublicKey;
import sun.security.provider.DSAPublicKeyImpl;
import sun.security.provider.ParameterCache;

public class DSAKeyPairGenerator
extends KeyPairGenerator
implements java.security.interfaces.DSAKeyPairGenerator {
    private int plen;
    private int qlen;
    private boolean forceNewParameters;
    private DSAParameterSpec params;
    private SecureRandom random;

    public DSAKeyPairGenerator() {
        super("DSA");
        this.initialize(1024, null);
    }

    private static void checkStrength(int n, int n2) {
        if (!(n >= 512 && n <= 1024 && n % 64 == 0 && n2 == 160 || n == 2048 && (n2 == 224 || n2 == 256) || n == 3072 && n2 == 256)) {
            throw new InvalidParameterException("Unsupported prime and subprime size combination: " + n + ", " + n2);
        }
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        this.initialize(n, true, secureRandom);
        this.forceNewParameters = false;
    }

    @Override
    public void initialize(int n, boolean bl, SecureRandom secureRandom) throws InvalidParameterException {
        int n2 = -1;
        if (n <= 1024) {
            n2 = 160;
        } else if (n == 2048) {
            n2 = 224;
        } else if (n == 3072) {
            n2 = 256;
        }
        DSAKeyPairGenerator.checkStrength(n, n2);
        if (bl) {
            this.params = null;
        } else {
            this.params = ParameterCache.getCachedDSAParameterSpec(n, n2);
            if (this.params == null) {
                throw new InvalidParameterException("No precomputed parameters for requested modulus size available");
            }
        }
        this.plen = n;
        this.qlen = n2;
        this.random = secureRandom;
        this.forceNewParameters = bl;
    }

    @Override
    public void initialize(DSAParams dSAParams, SecureRandom secureRandom) throws InvalidParameterException {
        if (dSAParams == null) {
            throw new InvalidParameterException("Params must not be null");
        }
        DSAParameterSpec dSAParameterSpec = new DSAParameterSpec(dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
        this.initialize0(dSAParameterSpec, secureRandom);
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Inappropriate parameter");
        }
        this.initialize0((DSAParameterSpec)algorithmParameterSpec, secureRandom);
    }

    private void initialize0(DSAParameterSpec dSAParameterSpec, SecureRandom secureRandom) {
        int n = dSAParameterSpec.getP().bitLength();
        int n2 = dSAParameterSpec.getQ().bitLength();
        DSAKeyPairGenerator.checkStrength(n, n2);
        this.plen = n;
        this.qlen = n2;
        this.params = dSAParameterSpec;
        this.random = secureRandom;
        this.forceNewParameters = false;
    }

    @Override
    public KeyPair generateKeyPair() {
        DSAParameterSpec dSAParameterSpec;
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        try {
            if (this.forceNewParameters) {
                dSAParameterSpec = ParameterCache.getNewDSAParameterSpec(this.plen, this.qlen, this.random);
            } else {
                if (this.params == null) {
                    this.params = ParameterCache.getDSAParameterSpec(this.plen, this.qlen, this.random);
                }
                dSAParameterSpec = this.params;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ProviderException(generalSecurityException);
        }
        return this.generateKeyPair(dSAParameterSpec.getP(), dSAParameterSpec.getQ(), dSAParameterSpec.getG(), this.random);
    }

    public KeyPair generateKeyPair(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, SecureRandom secureRandom) {
        BigInteger bigInteger4 = this.generateX(secureRandom, bigInteger2);
        BigInteger bigInteger5 = this.generateY(bigInteger4, bigInteger, bigInteger3);
        try {
            DSAPublicKey dSAPublicKey = DSAKeyFactory.SERIAL_INTEROP ? new DSAPublicKey(bigInteger5, bigInteger, bigInteger2, bigInteger3) : new DSAPublicKeyImpl(bigInteger5, bigInteger, bigInteger2, bigInteger3);
            DSAPrivateKey dSAPrivateKey = new DSAPrivateKey(bigInteger4, bigInteger, bigInteger2, bigInteger3);
            KeyPair keyPair = new KeyPair(dSAPublicKey, dSAPrivateKey);
            return keyPair;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException);
        }
    }

    private BigInteger generateX(SecureRandom secureRandom, BigInteger bigInteger) {
        BigInteger bigInteger2 = null;
        byte[] byArray = new byte[this.qlen];
        do {
            secureRandom.nextBytes(byArray);
        } while ((bigInteger2 = new BigInteger(1, byArray).mod(bigInteger)).signum() <= 0 || bigInteger2.compareTo(bigInteger) >= 0);
        return bigInteger2;
    }

    BigInteger generateY(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger, bigInteger2);
        return bigInteger4;
    }
}

