﻿/*
	

Duik
Copyright (c) 2008 - 2013 Nicolas Dufresne
http://ik.duduf.fr
http://ik.duduf.com

Many thanks to :
Kevin Schires - including the images needed by Duik directly in the Script
Eric Epstein - making the IK's work with 3D Layers
Zeg - designing the buttons

This file is part of Duik.

    Duik is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Duik is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Duik. If not, see <http://www.gnu.org/licenses/>.
*/	


function DuIK(wnd)
{

	//================
	var version = "14 alpha 4";
	//================
	
//===============================================
//PREFERENCES
//===============================================
{
if (! app.settings.haveSetting("duik", "lang")){app.settings.saveSetting("duik","lang","ENGLISH");}
if (! app.settings.haveSetting("duik", "version")){app.settings.saveSetting("duik","version","oui");}
if (! app.settings.haveSetting("duik", "morpherKey")){app.settings.saveSetting("duik","morpherKey","oui");}
if (! app.settings.haveSetting("duik", "notes")){app.settings.saveSetting("duik","notes","");}
if (! app.settings.haveSetting("duik", "pano")){app.settings.saveSetting("duik","pano","0");}
}


//===============================================
//TRADUCTIONS
//===============================================
#include "Duik_translations.jsxinc"

//===============================================
//CHARGEMENT DES IMAGES
//===============================================
{
//	>> Utils
function dialog_preferences_general()
{
	//	Valide au moins depuis CS4,
	app.executeCommand(2359);
}

function checkFile(name, content)
{
	var file = new File(name);
	var fileContent = "";


	if (file.exists)
	{
		file.encoding = "BINARY"; 
		if (file.open("r", "TEXT", "????"))
		{
			fileContent = file.read();

			file.close(); 
		}
	}
	else
	{
		var folder = new Folder(file.path);
		if (!folder.exists)
		{
			folder.create();
		}
	}

	var success = fileContent == content;

	if (!success)
	{
		file.encoding = "BINARY"; 
		if (file.open("w"))
		{
			success = file.write(content);

			file.close(); 
		}
	}

	return success;
}
//	<< Utils

//	On va devoir écrire les fichiers d'image, donc ça ne sert à rien de continuer si on ne peux pas:
if (app.preferences.getPrefAsLong("Main Pref Section","Pref_SCRIPTING_FILE_NETWORK_SECURITY") != 1)
{
	alert(getMessage(1), "DuIK");

	//	Ouvre les préférences générales pour laisser l'utilisateur autoriser les scripts
	dialog_preferences_general();

	//	Seconds chance ...
	if (app.preferences.getPrefAsLong("Main Pref Section","Pref_SCRIPTING_FILE_NETWORK_SECURITY") != 1)
	{
		//	rien à faire ...
		return;
	}
}

#include "Duik_images.jsxinc"

var imgFolder = new Folder(Folder.userData.fsName + "/DuIK").fsName;

for (var k in scriptMng.files)
{
	if (scriptMng.files.hasOwnProperty(k))
	{
		if (!checkFile(imgFolder + k, scriptMng.files[k]))
		{
			alert("Error writing file: " + k);
		}
	}
}

//=========================== IMAGES CHARGEES, debut du script ==================
}

//======= FONCTION PRINCIPALE
function IKtools(thisObj){


//===============================================
//LES FONCTIONS
//===============================================
 {

//FONCTION POUR CHERCHER UNE MISE A JOUR
function MAJ(version){
var reply = "";
//socket
conn = new Socket;
// se connecter à duduf.com
if (conn.open ("www.duduf.com:80")) {
// récupérer la version actuelle
if(conn.writeln ("GET /ressources/duik/version.txt  HTTP/1.0\nHost: duduf.com\n"))
reply = conn.read(1000);
conn.close();
//chercher la version dans la réponse du serveur :
var reponse = reply.lastIndexOf("version",reply.length);
if(reponse != -1){
newVersion = reply.slice(reponse+8,reply.length+1);
if (version == newVersion) {return true} else {alert(getMessage(2));}
}else {alert(getMessage(3),"Attention",true);}
} else {alert(getMessage(4),"Attention",true);}
}

//FONCTION QUAND ON CLIQUE SUR CREER
function ik(){
	if (verifNoms()) {
		var calques = app.project.activeItem.selectedLayers;
	if (calques.length == 2 || calques.length == 3 || calques.length == 4) {
		var calquetridi = false;
		var ncalquetridi = 0;
	for (i=0;i<calques.length;i++){
		if (calques[i].threeDLayer) {ncalquetridi = i+1;}
		}
	if (ncalquetridi == 0 || ncalquetridi == calques.length) {
		if (ncalquetridi == calques.length) calquetridi = true;
		if (calques.length == 2) { calquetridi ? alert(getMessage(5)) : onebone();}
		if (calques.length == 3) {twobones(calquetridi,boutonFront.value);}
		if (calques.length == 4) {twoplusbones(calquetridi,boutonFront.value);}
	} else {alert(getMessage(6));}
	} else{alert(getMessage(7));}
	} else{alert(getMessage(8));}
	}

//FONCTION QUI APPLIQUE UN IK SUR UN SEUL BONE (LOOKAT)
function onebone(){

	//récupérer le bone
	var bonename = app.project.activeItem.selectedLayers[0].name;
	var bone = app.project.activeItem.selectedLayers[0];
	var origine = bone.transform.rotation.value;
	//récupérer le controleur
	var controleurname = app.project.activeItem.selectedLayers[1].name;
	var controleur = app.project.activeItem.selectedLayers[1];

				//  début de groupe d'annulation
				app.beginUndoGroup("LookAt " + bonename);

	//=========================================================
	//EXPRESSION A INSERER
	var expression = "C = thisComp.layer(\"" + controleurname + "\").toWorld(thisComp.layer(\"" + controleurname + "\").anchorPoint);\r\n" +
	"O =  thisLayer.toWorld(thisLayer.anchorPoint);\r\n" +
	"angle = lookAt(C,O);\r\n" +
	"angle[0] > 0 ? angle[0]+angle[1]+value : angle[0]-angle[1]+value;"
	//=========================================================

	bone.transform.rotation.expression = expression;

	//modifier la valeur pour éviter l'offset
	nouvelle = bone.transform.rotation.value;
	bone.transform.rotation.setValue(origine - nouvelle);
	
			//fin du groupe d'annulation			
			app.endUndoGroup();

}

//FONCTION QUI APPLIQUE UN IK SUR DEUX BONES
function twobones(tridi,front){

//récupérer le bone du bout
var boneboutname = app.project.activeItem.selectedLayers[0].name;
var bonebout = app.project.activeItem.selectedLayers[0];
//récupérer le bone racine
var boneracinename = app.project.activeItem.selectedLayers[1].name;
var boneracine = app.project.activeItem.selectedLayers[1];
//récupérer le controleur
var controleurname = app.project.activeItem.selectedLayers[2].name;
var controleur = app.project.activeItem.selectedLayers[2];

//vérifions que les parentées sont bonnes
	if (bonebout.parent == boneracine) {

//  début de groupe d'annulation
			app.beginUndoGroup("IK " + controleurname);
			
//Ajoutons une case a cocher sur le controleur pour choisir le sens de l'IK
coude = controleur.Effects.addProperty("ADBE Checkbox Control");
coude.name = "IK Orientation" + boneracinename.slice(-15);

if (tridi) {
	direction = controleur.Effects.addProperty("ADBE Angle Control");
	direction.name = "IK Direction " +  boneracinename.slice(-15);
	}
	
			//une case a cocher pour l'IK/FK
			ikfk = controleur.Effects.addProperty("ADBE Checkbox Control");
			ikfk.name = getMessage(137);
			ikfk(1).setValue(1);
			//un angle pour le haut
			urot = controleur.Effects.addProperty("ADBE Angle Control");
			urot.name = getMessage(138);
			//un angle pour le bas
			lrot = controleur.Effects.addProperty("ADBE Angle Control");
			lrot.name = getMessage(139);
		
//créer un zéro //TODO juste balancer les valeurs dans l'expression et ne pas créer de zéro !
var zerobout = app.project.activeItem.layers.addNull();
zerobout.threeDLayer = true;
var controleurparent = controleur.parent;
controleur.parent = null;
zerobout.position.setValue(controleur.position.value);
zerobout.name = "IK_zero " + boneboutname.slice(-24);
controleur.parent = controleurparent;

//lier le zéro au bone du bout
zerobout.parent = bonebout;

//verrouiller et masquer le zéro
zerobout.moveToEnd();
zerobout.guideLayer = true;
zerobout.locked = true;
zerobout.enabled = false;
zerobout.shy = true;


//=========================================================
//EXPRESSION A INSERER SUR LE BONE BOUT
var expressionbout = "boneracine = \"" + boneracinename + "\";\n" + 
"bonebout = \"" + boneboutname + "\";\n" + 
"zero = \"" + "IK_zero " + boneboutname.slice(-24) + "\";\n" + 
"controleur = \"" + controleurname + "\";\n" + 
"FK = thisComp.layer(controleur).effect(\"" + getMessage(139) + "\")(1);\n" + 
"IKFK = thisComp.layer(controleur).effect(\"" + getMessage(137) + "\")(1) == 1;\n" + 
"if (thisComp.layer(controleur).effect(\"" + "IK Orientation" + boneracinename.slice(-15) + "\")(1) == 1) {cw = true}else{cw=false}\n" +
"function getWorldPos(theLayerName){\n" + 
"  L = thisComp.layer(theLayerName);\n" + 
"  return L.toWorld(L.anchorPoint);\n" + 
"}\n" + 
"function oriente(a, b, P) {\n" +
"return ((b[0]-a[0])*(P[1]-a[1]) - (P[0]-a[0])*(b[1]-a[1]) );\n" +
"}\n" +
"A = getWorldPos(boneracine);\n" + 
"B = getWorldPos(bonebout);\n" + 
"C = getWorldPos(zero);\n" + 
"E = getWorldPos(controleur);\n" + 
"a = length(B,C);\n" + 
"b = length(E,A);\n" + 
"c = length(A,B);\n" + 
"x = (b*b + c*c - a*a )/(2*b);\n" + 
"alpha = Math.acos(clamp(x/c,-1,1));\n" + 
"y = b - x;\n" + 
"  gamma = Math.acos(clamp(y/a,-1,1));\n" + 
"result = (cw ? 1 : -1)*radiansToDegrees(gamma + alpha);" +
"  V1 = B - A;\n" + 
"  adj1 = radiansToDegrees(Math.atan2(V1[1],V1[0]));\n" + 
"  V2 = C - B;\n" + 
"  adj2 = radiansToDegrees(Math.atan2(V2[1],V2[0]));\n" + 
"  IK = result +  adj1 - adj2 + value;\n" + 
"IKFK ? IK : FK;";
//=========================================================

tridi ? bonebout.transform.zRotation.expression = expressionbout : bonebout.transform.rotation.expression = expressionbout;

//=========================================================
//EXPRESSION A INSERER SUR LE BONE RACINE
var expressionracine = "boneracine = \"" + boneracinename + "\";\n" + 
"bonebout = \"" + boneboutname + "\";\n" + 
"zero = \"" + "IK_zero " + boneboutname.slice(-24) + "\";\n" + 
"controleur = \"" + controleurname + "\";\n" + 
"FK = thisComp.layer(controleur).effect(\"" + getMessage(138) + "\")(1);\n" + 
"IKFK = thisComp.layer(controleur).effect(\"" + getMessage(137) + "\")(1) == 1;\n" + 
"if (thisComp.layer(controleur).effect(\"" + "IK Orientation" + boneracinename.slice(-15) + "\")(1) == 1) {cw = true}else{cw=false}\n" +
"function getWorldPos(theLayerName){\n" + 
"  L = thisComp.layer(theLayerName);\n" + 
"  return L.toWorld(L.anchorPoint);\n" + 
"}\n" + 
"function oriente(a, b, P) {\n" +
"return ((b[0]-a[0])*(P[1]-a[1]) - (P[0]-a[0])*(b[1]-a[1]) );\n" +
"}\n" +
"A = getWorldPos(boneracine);\n" + 
"B = getWorldPos(bonebout);\n" + 
"C = getWorldPos(zero);\n" + 
"E = getWorldPos(controleur);\n" + 
"a = length(B,C);\n" + 
"b = length(E,A);\n" + 
"c = length(A,B);\n" + 
"x = (b*b + c*c - a*a )/(2*b);\n" + 
"alpha = Math.acos(clamp(x/c,-1,1));\n" + 
"D = E - A;\n" + 
"delta = Math.atan2(D[1],D[0]);\n" + 
"result = radiansToDegrees(delta - (cw ? 1 : -1)*alpha);\n" +
"V = B - A;\n" + 
"adj1 = radiansToDegrees(Math.atan2(V[1],V[0]));\n" + 
"IK = result - adj1 + value;\n" + 
"IKFK ? IK : FK;";
//=======================================================

tridi ? boneracine.transform.zRotation.expression = expressionracine : boneracine.transform.rotation.expression = expressionracine;

if (tridi) {
	//si 3D : le zéro de la jambe pour l'orientation
	//créer un zéro
	var zero = app.project.activeItem.layers.addNull();
	zero.threeDLayer = true;
	var calqueparent = boneracine.parent;
	boneracine.parent = null;
	zero.position.setValue(boneracine.position.value);
	zero.name = "Zero_" + boneracine.name.slice(-24);
	//verrouiller et masquer le zéro
	zero.moveToEnd();
	zero.guideLayer = true;
	zero.shy = true;


	if (front) {
		var expressionzero = "controleur =thisComp.layer(\"" + controleurname + "\");\n\n" + 
		"C = controleur.toWorld(controleur.anchorPoint);\n" +
		"Cx = C[0];\n" +
		"Cy = C[1];\n" +
		"Cz = C[2];\n" +
		"L =  thisLayer.toWorld(thisLayer.anchorPoint);\n" +
		"Lx = L[0];\n" +
		"Ly = L[1];\n" +
		"Lz = L[2];" +
		"angle = lookAt([Cz,Cy,Cx],[Lz,Ly,Lx]);\n" +
		"[-angle[1]+90,-angle[0],value[2]]\n"
		} else {
		var expressionzero = "controleur =thisComp.layer(\"" + controleurname + "\");\n\n" + 
		"C = controleur.toWorld(controleur.anchorPoint);\n" +
		"L =  thisLayer.toWorld(thisLayer.anchorPoint);\n" +
		"angle = lookAt(C,L);\n" +
		"[angle[0],angle[1],value[2]]\n"
		}
		zero.transform.orientation.expression = expressionzero;
		zero.transform.xRotation.expression = "thisComp.layer(\"" + controleurname + "\").effect(\"IK Direction " +  boneracinename.slice(-15) + "\")(1)";

		boneracine.parent = zero;
		//lier le zéro au bone du bout
		zero.parent = calqueparent;
		zero.enabled = false;
		zero.locked = true;


}


			//fin du groupe d'annulation
			
			app.endUndoGroup();
			
			
} else { alert(getMessage(9),"Attention",true); }

	}

//FONCTION QUI APPLIQUE UN IK SUR DEUX + UN BONES
function twoplusbones(tridi,front){

//récupérer la main
var mainname = app.project.activeItem.selectedLayers[0].name;
var main = app.project.activeItem.selectedLayers[0];
//récupérer le bone du bout
var boneboutname = app.project.activeItem.selectedLayers[1].name;
var bonebout = app.project.activeItem.selectedLayers[1];
//récupérer le bone racine
var boneracinename = app.project.activeItem.selectedLayers[2].name;
var boneracine = app.project.activeItem.selectedLayers[2];
//récupérer le controleur
var controleurname = app.project.activeItem.selectedLayers[3].name;
var controleur = app.project.activeItem.selectedLayers[3];

//vérifions que les parentées sont bonnes
	if (bonebout.parent == boneracine) { 
		if (main.parent == bonebout) {
			
			//  début de groupe d'annulation
			app.beginUndoGroup("IK " + controleurname);
			
			//une case a cocher pour choisir le sens de l'IK sur le controleur
			coude = controleur.Effects.addProperty("ADBE Checkbox Control");
			coude.name = "IK Orientation " + mainname.slice(-15);
			//un paramètre angle pour la direction en cas de 3D
			if (tridi) {
				direction = controleur.Effects.addProperty("ADBE Angle Control");
				direction.name = "IK Direction " + mainname.slice(-15);
			}
			//une case a cocher pour l'IK/FK
			ikfk = controleur.Effects.addProperty("ADBE Checkbox Control");
			ikfk.name = getMessage(137);
			ikfk(1).setValue(1);
			//un angle pour le haut
			urot = controleur.Effects.addProperty("ADBE Angle Control");
			urot.name = getMessage(138);
			//un angle pour le bas
			lrot = controleur.Effects.addProperty("ADBE Angle Control");
			lrot.name = getMessage(139);
			//un angle pour le goal
			grot = controleur.Effects.addProperty("ADBE Angle Control");
			grot.name = getMessage(140);
			
			
//=========================================================
//EXPRESSION A INSERER SUR LE BONE BOUT
var expressionBout = "boneracine = \"" + boneracinename + "\";\n" +
"bonebout = \"" + boneboutname + "\";\n" +
"zero = \"" + mainname + "\";\n"+
"controleur = \"" + controleurname + "\";\n"+
"FK = thisComp.layer(controleur).effect(\"" + getMessage(139) + "\")(1);\n" + 
"IKFK = thisComp.layer(controleur).effect(\"" + getMessage(137) + "\")(1) == 1;\n" + 
"if (thisComp.layer(controleur).effect(\"" + "IK Orientation " + mainname.slice(-15) + "\")(1) == 1) {cw = true}else{cw=false}\n"+
"function getWorldPos(theLayerName){\n"+
"  L = thisComp.layer(theLayerName);\n"+
"  return L.toWorld(L.anchorPoint);\n" + "}\n"+
"function oriente(a, b, P) {\n"+
"return ((b[0]-a[0])*(P[1]-a[1]) - (P[0]-a[0])*(b[1]-a[1]) );\n"+
"}\n" +"A = getWorldPos(boneracine);\n"+
"B = getWorldPos(bonebout);\n"+
"C = getWorldPos(zero);\n" +
"E = getWorldPos(controleur);\n"+
"a = length(B,C);\n"+
"b = length(E,A);\n" + "c = length(A,B);\n"+
"x = (b*b + c*c - a*a )/(2*b);\n"+
"alpha = Math.acos(clamp(x/c,-1,1));\n"+
"y = b - x;\n"+
"  gamma = Math.acos(clamp(y/a,-1,1));\n"+
"result = (cw ? 1 : -1)*radiansToDegrees(gamma + alpha);"+
"  V1 = B - A;\n" +
"  adj1 = radiansToDegrees(Math.atan2(V1[1],V1[0]));\n"+
"  V2 = C - B;\n"+
"  adj2 = radiansToDegrees(Math.atan2(V2[1],V2[0]));\n" +
"  IK = result +  adj1 - adj2 + value;\n" +
"IKFK ? IK : FK;";
//=========================================================

tridi ? bonebout.transform.zRotation.expression = expressionBout : bonebout.transform.rotation.expression = expressionBout;

//=========================================================
//EXPRESSION A INSERER SUR LE BONE RACINE
var expressionracine = "boneracine = \"" + boneracinename + "\";\n" + 
"bonebout = \"" + boneboutname + "\";\n" + 
"zero = \"" + mainname + "\";\n" + 
"controleur = \"" + controleurname + "\";\n" + 
"FK = thisComp.layer(controleur).effect(\"" + getMessage(138) + "\")(1);\n" + 
"IKFK = thisComp.layer(controleur).effect(\"" + getMessage(137) + "\")(1) == 1;\n" + 
"if (thisComp.layer(controleur).effect(\"" + "IK Orientation " + mainname.slice(-15) + "\")(1) == 1) {cw = true}else{cw=false}\n" +
"function getWorldPos(theLayerName){\n" + 
"  L = thisComp.layer(theLayerName);\n" + 
"  return L.toWorld(L.anchorPoint);\n" + 
"}\n" + 
"function oriente(a, b, P) {\n" +
"return ((b[0]-a[0])*(P[1]-a[1]) - (P[0]-a[0])*(b[1]-a[1]) );\n" +
"}\n" +
"A = getWorldPos(boneracine);\n" + 
"B = getWorldPos(bonebout);\n" + 
"C = getWorldPos(zero);\n" + 
"E = getWorldPos(controleur);\n" + 
"a = length(B,C);\n" + 
"b = length(E,A);\n" + 
"c = length(A,B);\n" + 
"x = (b*b + c*c - a*a )/(2*b);\n" + 
"alpha = Math.acos(clamp(x/c,-1,1));\n" + 
"D = E - A;\n" + 
"delta = Math.atan2(D[1],D[0]);\n" + 
"result = radiansToDegrees(delta - (cw ? 1 : -1)*alpha);\n" +
"V = B - A;\n" + 
"adj1 = radiansToDegrees(Math.atan2(V[1],V[0]));\n" + 
"IK = result - adj1 + value;\n" +
"IKFK ? IK : FK;";
//=======================================================

tridi ? boneracine.transform.zRotation.expression = expressionracine : boneracine.transform.rotation.expression = expressionracine;

if (tridi) {
	main.transform.xRotation.expression = "value + thisComp.layer(\"" + controleurname + "\").transform.xRotation";
	front ? main.transform.yRotation.expression = "value + thisComp.layer(\"" + controleurname + "\").transform.yRotation" : main.transform.yRotation.expression = "value + thisComp.layer(\"" + controleurname + "\").transform.yRotation + 90" ;
	main.transform.zRotation.expression = "value + thisComp.layer(\"" + controleurname + "\").transform.zRotation";
	main.transform.orientation.expression = "value + thisComp.layer(\"" + controleurname + "\").transform.orientation";
	} else {
	main.transform.rotation.expression = "FKu = thisComp.layer(\"" + controleurname + "\").effect(\"" + getMessage(138) + "\")(1);\n" + 
	"FKl = thisComp.layer(\"" + controleurname + "\").effect(\"" + getMessage(139) + "\")(1);\n" + 
	"FKg = thisComp.layer(\"" + controleurname + "\").effect(\"" + getMessage(140) + "\")(1);\n" + 
	"IKFK = thisComp.layer(\"" + controleurname + "\").effect(\"" + getMessage(137) + "\")(1) == 1;\n" + 
	"IKFK ? value + thisComp.layer(\"" + controleurname + "\").transform.rotation : value + FKu + FKl + FKg ;";
	}

if (tridi) {
	//si 3D : le zéro de la jambe pour l'orientation
	//créer un zéro
	var zero = app.project.activeItem.layers.addNull();
	zero.threeDLayer = true;
	var calqueparent = boneracine.parent;
	boneracine.parent = null;
	zero.position.setValue(boneracine.position.value);
	zero.name = "Zero_" + boneracine.name.slice(-24);
	//verrouiller et masquer le zéro
	zero.moveToEnd();
	zero.guideLayer = true;
	zero.shy = true;

	if (front) {
		var expressionzero = "controleur =thisComp.layer(\"" + controleurname + "\");\n\n" + 
		"C = controleur.toWorld(controleur.anchorPoint);\n" +
		"Cx = C[0];\n" +
		"Cy = C[1];\n" +
		"Cz = C[2];\n" +
		"L =  thisLayer.toWorld(thisLayer.anchorPoint);\n" +
		"Lx = L[0];\n" +
		"Ly = L[1];\n" +
		"Lz = L[2];" +
		"angle = lookAt([Cz,Cy,Cx],[Lz,Ly,Lx]);\n" +
		"[-angle[1]+90,-angle[0],value[2]]\n"
		} else {
		var expressionzero = "controleur =thisComp.layer(\"" + controleurname + "\");\n\n" + 
		"C = controleur.toWorld(controleur.anchorPoint);\n" +
		"L =  thisLayer.toWorld(thisLayer.anchorPoint);\n" +
		"angle = lookAt(C,L);\n" +
		"[angle[0],angle[1],value[2]]\n"
		}
		zero.transform.orientation.expression = expressionzero;
		zero.transform.xRotation.expression = "thisComp.layer(\"" + controleurname + "\").effect(\"IK Direction " + mainname.slice(-15) + "\")(1)";

		boneracine.parent = zero;
		//lier le zéro au bone du bout
		zero.parent = calqueparent;
		zero.enabled = false;
		zero.locked = true;

}

	//IK Goal
	//dupliquer le Layer
	var goal = main.duplicate();
	goal.name = main.name + " goal";
	goal.parent = null;
	goal.transform.position.expression = "thisComp.layer(\"" + mainname + "\").toWorld(thisComp.layer(\"" + mainname + "\").anchorPoint)";
	main.enabled = false;
	
	
			//fin du groupe d'annulation
			app.endUndoGroup();

			
} else { alert(getMessage(9),"Attention",true); }
} else { alert(getMessage(9),"Attention",true); }

	}

//FONCTION QUI GOAL LE CALQUE ACTIF
function pregoal(){

if (app.project.activeItem.selectedLayers.length == 1) {	

	//  début de groupe d'annulation
app.beginUndoGroup("IK Goal " + app.project.activeItem.selectedLayers[0].name);

//dupliquer le Layer
var layer = app.project.activeItem.selectedLayers[0]
var goal = layer.duplicate();
goal.name = layer.name + " goal";
goal.parent = null;
goal.transform.position.expression = "thisComp.layer(\"" + layer.name + "\").toWorld(thisComp.layer(\"" + layer.name + "\").anchorPoint)";
layer.enabled = false;

//fin du groupe d'annulation
app.endUndoGroup();

}else{alert(getMessage(10),"Attention",true);}
}

//FONCTION POUR CREER UN CONTROLEUR
function controleur(){
	
	if (verifNoms()) {
 
//vérifions qu'il n'y a qu'un calque sélectionné 
 if (app.project.activeItem.selectedLayers.length == 1) {
	 
	 	//  début de groupe d'annulation
		app.beginUndoGroup("Controleur " + app.project.activeItem.selectedLayers[0].name);
		
		//le calque où placer le contrôleur et sa postion
		var bone = app.project.activeItem.selectedLayers[0];



		var boneparent = bone.parent;
		bone.parent = null;
		var boneposition = bone.transform.position.value;
		bone.parent = boneparent;

	
		//le controleur
		var controleur = app.project.activeItem.layers.addNull();
		controleur.transform.position.setValue(boneposition);
		controleur.name = "C_" + bone.name.slice(-28);
		
		//fin du groupe d'annulation
app.endUndoGroup();
	 
	 } else {alert(getMessage(11));}
	 	} else{alert(getMessage(8));}

	 
	 }

//FONCTION CONF WIGGLE POSITION
function wiggleconfpos(){
	
if (positiontous.value){positionX.enabled = false ; positionY.enabled = false ; positionZ.enabled = false;}
else{positionX.enabled = true ; positionY.enabled = true ; positionZ.enabled = true;}
	
	}

//FONCTION CONF WIGGLE ROTATION
function wiggleconfrot(){
	
if (rotationtous.value){rotationX.enabled = false ; rotationY.enabled = false ; rotationZ.enabled = false;}
else{rotationX.enabled = true ; rotationY.enabled = true ; rotationZ.enabled = true;}
	
	}

//FONCTION CONF WIGGLE ECHELLE
function wiggleconfscale(){
	
if (echelletous.value){echelleX.enabled = false ; echelleY.enabled = false ; }
else{echelleX.enabled = true ; echelleY.enabled = true ;}
	
	}

//FONCTION WIGGLE OK
function wigglevalid(){

//vérifions qu'il n'y a qu'un calque sélectionné
if (app.project.activeItem.selectedLayers.length == 1){
	
			//  début de groupe d'annulation
			app.beginUndoGroup("Wiggle");
			
//le calque sélectionné
var calque = app.project.activeItem.selectedLayers[0];
var calquetridi = calque.threeDLayer;

if (positiontous.value){
	amp = calque.Effects.addProperty("ADBE Slider Control");
	amp.name = "Pos Amplitude";
	freq = calque.Effects.addProperty("ADBE Slider Control");
	freq.name = "Pos Frequency";
	calque.transform.position.expression = "wiggle(effect(\"Pos Frequency\")(1),effect(\"Pos Amplitude\")(1))";
	} else {
		if (calquetridi && positionX.value && positionY.value && positionZ.value){
				amp = calque.Effects.addProperty("ADBE Slider Control");
				amp.name = "XPos Amplitude";
				amp = calque.Effects.addProperty("ADBE Slider Control");
				amp.name = "YPos Amplitude";
				amp = calque.Effects.addProperty("ADBE Slider Control");
				amp.name = "ZPos Amplitude";
				freq = calque.Effects.addProperty("ADBE Slider Control");
				freq.name = "XPos Frequency";
				freq = calque.Effects.addProperty("ADBE Slider Control");
				freq.name = "YPos Frequency";
				freq = calque.Effects.addProperty("ADBE Slider Control");
				freq.name = "ZPos Frequency";
				calque.transform.position.expression = "X=wiggle(effect(\"XPos Frequency\")(1),effect(\"XPos Amplitude\")(1));\n" + "Y=wiggle(effect(\"YPos Frequency\")(1),effect(\"YPos Amplitude\")(1));\n" + "Z=wiggle(effect(\"ZPos Frequency\")(1),effect(\"ZPos sAmplitude\")(1));\n" +  "[X[0],Y[1],Z[2]]";
			}
		if (positionX.value && positionY.value && !positionZ.value){
				amp = calque.Effects.addProperty("ADBE Slider Control");
				amp.name = "XPos Amplitude";
				amp = calque.Effects.addProperty("ADBE Slider Control");
				amp.name = "YPos Amplitude";
				freq = calque.Effects.addProperty("ADBE Slider Control");
				freq.name = "XPos Frequency";
				freq = calque.Effects.addProperty("ADBE Slider Control");
				freq.name = "YPos Frequency";
				if (calquetridi){calque.transform.position.expression = "X=wiggle(effect(\"XPos Frequency\")(1),effect(\"XPos Amplitude\")(1));\n" + "Y=wiggle(effect(\"YPos Frequency\")(1),effect(\"YPos Amplitude\")(1));\n" + "[X[0],Y[1],transform.position[2]]";}
				else {calque.transform.position.expression = "X=wiggle(effect(\"XPos Frequency\")(1),effect(\"XPos Amplitude\")(1));\n" + "Y=wiggle(effect(\"YPos Frequency\")(1),effect(\"YPos Amplitude\")(1));\n" + "[X[0],Y[1]]";}
			}
		if (calquetridi && positionX.value && !positionY.value && positionZ.value){
				amp = calque.Effects.addProperty("ADBE Slider Control");
				amp.name = "XPos Amplitude";
				amp = calque.Effects.addProperty("ADBE Slider Control");
				amp.name = "ZPos Amplitude";
				freq = calque.Effects.addProperty("ADBE Slider Control");
				freq.name = "XPos Frequency";
				freq = calque.Effects.addProperty("ADBE Slider Control");
				freq.name = "ZPos Frequency";
				calque.transform.position.expression = "X=wiggle(effect(\"XPos Frequency\")(1),effect(\"XPos Amplitude\")(1));\n" + "Z=wiggle(effect(\"ZPos Frequency\")(1),effect(\"ZPos Amplitude\")(1));\n" + "[X[0],transform.position[1],Z[2]]";
			}
		if (calquetridi && !positionX.value && positionY.value && positionZ.value) {
			amp = calque.Effects.addProperty("ADBE Slider Control");
				amp.name = "YPos Amplitude";
				amp = calque.Effects.addProperty("ADBE Slider Control");
				amp.name = "ZPos Amplitude";
				freq = calque.Effects.addProperty("ADBE Slider Control");
				freq.name = "YPos Frequency";
				freq = calque.Effects.addProperty("ADBE Slider Control");
				freq.name = "ZPos Frequency";
				calque.transform.position.expression = "Y=wiggle(effect(\"YPos Frequency\")(1),effect(\"YPos Amplitude\")(1));\n" + "Z=wiggle(effect(\"ZPos Frequency\")(1),effect(\"ZPos Amplitude\")(1));\n" + "[transform.position[0],Y[1],Z[2]]";
			}
		if (positionX.value && !positionY.value && !positionZ.value){
				amp = calque.Effects.addProperty("ADBE Slider Control");
				amp.name = "XPos Amplitude";
				freq = calque.Effects.addProperty("ADBE Slider Control");
				freq.name = "XPos Frequency";
				if (calquetridi){calque.transform.position.expression = "X=wiggle(effect(\"XPos Frequency\")(1),effect(\"XPos Amplitude\")(1));\n" + "[X[0],transform.position[1],transform.position[2]]";}
				else {calque.transform.position.expression = "X=wiggle(effect(\"XPos Frequency\")(1),effect(\"XPos Amplitude\")(1));\n" + "[X[0],transform.position[1]]";}
				}
		if (!positionX.value && positionY.value && !positionZ.value){
				amp = calque.Effects.addProperty("ADBE Slider Control");
				amp.name = "YPos Amplitude";
				freq = calque.Effects.addProperty("ADBE Slider Control");
				freq.name = "YPos Frequency";
				if (calquetridi){calque.transform.position.expression = "Y=wiggle(effect(\"YPos Frequency\")(1),effect(\"YPos Amplitude\")(1));\n" + "[transform.position[0],Y[1],transform.position[2]]";}
				else{calque.transform.position.expression = "Y=wiggle(effect(\"YPos Frequency\")(1),effect(\"YPos Amplitude\")(1));\n" + "[transform.position[0],Y[1]]";}
			}
		if (calquetridi && !positionX.value && !positionY.value && positionZ.value){
				amp = calque.Effects.addProperty("ADBE Slider Control");
				amp.name = "ZPos Amplitude";
				freq = calque.Effects.addProperty("ADBE Slider Control");
				freq.name = "ZPos Frequency";
				calque.transform.position.expression = "Z=wiggle(effect(\"ZPos Frequency\")(1),effect(\"ZPos Amplitude\")(1));\n" + "[transform.position[0],transform.position[1],Z[2]]";
			}
		if (!calquetridi && positionZ.value) {alert("Le calque sélectionné n'est pas un calque 3D, impossible d'y ajouter un wiggle sur l'axe Z","Attention !");}
	}

if (echelletous.value){
	amp = calque.Effects.addProperty("ADBE Slider Control");
	amp.name = "Scale Amplitude";
	freq = calque.Effects.addProperty("ADBE Slider Control");
	freq.name = "Scale Frequency";
	calque.transform.scale.expression = "wiggle(effect(\"Scale Frequency\")(1),effect(\"Scale Amplitude\")(1))";
	}else{
		if (echelleX.value){
			amp = calque.Effects.addProperty("ADBE Slider Control");
			amp.name = "Scale X Amplitude";
			freq = calque.Effects.addProperty("ADBE Slider Control");
			freq.name = "Scale X Frequency";
			calque.transform.scale.expression = "X=wiggle(effect(\"Scale X Frequency\")(1),effect(\"Scale X Amplitude\")(1));\n" + "[X[0],transform.scale[1]]";
			}
		if (echelleY.value){
			amp = calque.Effects.addProperty("ADBE Slider Control");
			amp.name = "Scale Y Amplitude";
			freq = calque.Effects.addProperty("ADBE Slider Control");
			freq.name = "Scale Y Frequency";
			calque.transform.scale.expression = "Y=wiggle(effect(\"Scale Y Frequency\")(1),effect(\"Scale Y Amplitude\")(1));\n" + "[transform.scale[0],Y[1]]";
			}
	}

if (rotationtous.value){
	amp = calque.Effects.addProperty("ADBE Slider Control");
	amp.name = "Rot Amplitude";
	freq = calque.Effects.addProperty("ADBE Slider Control");
	freq.name = "Rot Frequency";
	if(calquetridi){calque.transform.orientation.expression = "wiggle(effect(\"Rot Frequency\")(1),effect(\"Rot Amplitude\")(1))";}
	else{calque.transform.rotation.expression = "wiggle(effect(\"Rot Frequency\")(1),effect(\"Rot Amplitude\")(1))";}
	} else {
		if (rotationX.value && rotationY.value && rotationZ.value){
				calque.threeDLayer = true;
				amp = calque.Effects.addProperty("ADBE Slider Control");
				amp.name = "XRot Amplitude";
				amp = calque.Effects.addProperty("ADBE Slider Control");
				amp.name = "YRot Amplitude";
				amp = calque.Effects.addProperty("ADBE Slider Control");
				amp.name = "ZRot Amplitude";
				freq = calque.Effects.addProperty("ADBE Slider Control");
				freq.name = "XRot Frequency";
				freq = calque.Effects.addProperty("ADBE Slider Control");
				freq.name = "YRot Frequency";
				freq = calque.Effects.addProperty("ADBE Slider Control");
				freq.name = "ZRot Frequency";
				calque.transform.orientation.expression = "X=wiggle(effect(\"XRot Frequency\")(1),effect(\"XRot Amplitude\")(1));\n" + "Y=wiggle(effect(\"YRot Frequency\")(1),effect(\"YRot Amplitude\")(1));\n" + "Z=wiggle(effect(\"ZRot Frequency\")(1),effect(\"ZRot Amplitude\")(1));\n" +  "[Y[0],X[1],Z[2]]";
			}
		if (rotationX.value && rotationY.value && !rotationZ.value){
				calque.threeDLayer = true;
				amp = calque.Effects.addProperty("ADBE Slider Control");
				amp.name = "XRot Amplitude";
				amp = calque.Effects.addProperty("ADBE Slider Control");
				amp.name = "YRot Amplitude";
				freq = calque.Effects.addProperty("ADBE Slider Control");
				freq.name = "XRot Frequency";
				freq = calque.Effects.addProperty("ADBE Slider Control");
				freq.name = "YRot Frequency";
				calque.transform.orientation.expression = "X=wiggle(effect(\"XRot Frequency\")(1),effect(\"XRot Amplitude\")(1));\n" + "Y=wiggle(effect(\"YRot Frequency\")(1),effect(\"YRot Amplitude\")(1));\n" + "[Y[0],X[1],transform.orientation[2]]";
			}
		if (rotationX.value && !rotationY.value && rotationZ.value){
				calque.threeDLayer = true;
				amp = calque.Effects.addProperty("ADBE Slider Control");
				amp.name = "XRot Amplitude";
				amp = calque.Effects.addProperty("ADBE Slider Control");
				amp.name = "ZRot Amplitude";
				freq = calque.Effects.addProperty("ADBE Slider Control");
				freq.name = "XRot Frequency";
				freq = calque.Effects.addProperty("ADBE Slider Control");
				freq.name = "ZRot Frequency";
				calque.transform.orientation.expression = "X=wiggle(effect(\"XRot Frequency\")(1),effect(\"XRot Amplitude\")(1));\n" + "Z=wiggle(effect(\"ZRot Frequency\")(1),effect(\"ZRot Amplitude\")(1));\n" + "[transform.orientation[0],X[1],Z[2]]";
			}
		if (!rotationX.value && rotationY.value && rotationZ.value) {
			calque.threeDLayer = true;
			amp = calque.Effects.addProperty("ADBE Slider Control");
				amp.name = "YRot Amplitude";
				amp = calque.Effects.addProperty("ADBE Slider Control");
				amp.name = "ZRot Amplitude";
				freq = calque.Effects.addProperty("ADBE Slider Control");
				freq.name = "YRot Frequency";
				freq = calque.Effects.addProperty("ADBE Slider Control");
				freq.name = "ZRot Frequency";
				calque.transform.orientation.expression = "Y=wiggle(effect(\"YRot Frequency\")(1),effect(\"YRot Amplitude\")(1));\n" + "Z=wiggle(effect(\"ZRot Frequency\")(1),effect(\"ZRot Amplitude\")(1));\n" + "[Y[0],transform.orientation[1],Z[2]]";
			}
		if (rotationX.value && !rotationY.value && !rotationZ.value){
			calque.threeDLayer = true;
				amp = calque.Effects.addProperty("ADBE Slider Control");
				amp.name = "XRot Amplitude";
				freq = calque.Effects.addProperty("ADBE Slider Control");
				freq.name = "XRot Frequency";
				calque.transform.orientation.expression = "X=wiggle(effect(\"XRot Frequency\")(1),effect(\"XRot Amplitude\")(1));\n" + "[transform.orientation[0],X[1],transform.orientation[2]]";
				}
		if (!rotationX.value && rotationY.value && !rotationZ.value){
			calque.threeDLayer = true;
				amp = calque.Effects.addProperty("ADBE Slider Control");
				amp.name = "YRot Amplitude";
				freq = calque.Effects.addProperty("ADBE Slider Control");
				freq.name = "YRot Frequency";
				calque.transform.orientation.expression = "Y=wiggle(effect(\"YRot Frequency\")(1),effect(\"YRot Amplitude\")(1));\n" + "[Y[0],transform.orientation[1],transform.orientation[2]]";
			}
		if (!rotationX.value && !rotationY.value && rotationZ.value){
			calque.threeDLayer = true;
				amp = calque.Effects.addProperty("ADBE Slider Control");
				amp.name = "ZRot Amplitude";
				freq = calque.Effects.addProperty("ADBE Slider Control");
				freq.name = "ZRot Frequency";
				calque.transform.orientation.expression = "Z=wiggle(effect(\"ZRot Frequency\")(1),effect(\"ZRot Amplitude\")(1));\n" + "[transform.orientation[0],transform.orientation[1],Z[2]]";
			}
	}





if (opacitebouton.value){
			amp = calque.Effects.addProperty("ADBE Slider Control");
			amp.name = "Opa Amplitude";
			freq = calque.Effects.addProperty("ADBE Slider Control");
			freq.name = "Opa Frequency";
			calque.transform.opacity.expression = "wiggle(effect(\"Opa Frequency\")(1),effect(\"Opa Amplitude\")(1))";
	}

			//fin du groupe d'annulation			
			app.endUndoGroup();

} else { alert(getMessage(12)); }

fenetrewiggle.close();
}

//FONCTION WIGGLE
function wiggle(){
	fenetrewiggle.show();
	}

	//FONCTION POUR AJOUTER UN BONE
function bone(){
	
		if (verifNoms()) {
	// Vérifions si il n'y a qu'un calque sélectionné
if (app.project.activeItem.selectedLayers.length == 1){

		//  début de groupe d'annulation
		app.beginUndoGroup("Bone");

//le calque sélectionné
var calque = app.project.activeItem.selectedLayers[0] ;
// les effets sélectionnés
var coins = app.project.activeItem.selectedLayers[0].selectedProperties ;

var okaytogo = false;

// vérifions si c'est la position ou le coin qui est sélectionné
if (coins.length == 4){
	
	var coinpos = coins.pop();
	var coin = coins.pop();
	if (coinpos instanceof Property && coinpos.value instanceof Array && coinpos.value.length ==2){okaytogo = true;}

}else{
	
		if (coins.length == 3){
			
		var coin = coins.pop();
		var coinpos = coin.position;
		if (coinpos instanceof Property && coinpos.value instanceof Array && coinpos.value.length ==2){okaytogo = true;}
		}

}
	

if (okaytogo){
//la position du coin
var position = coinpos.value;
//créer le bone
var bone = app.project.activeItem.layers.addSolid([1,0,0],"B_" + coin.name,20,20,1);
//mettre le bone à la position du coin : utiliser une expression pour avoir la position en mode world du coin
var filet = coins.pop();
var marionnette = coins.pop();
bone.position.expression = "thisComp.layer('" + calque.name + "').toWorld(thisComp.layer('" + calque.name + "').effect('" + marionnette.name + "').arap.mesh('" + filet.name + "').deform('" + coin.name + "').position)";
bone.position.setValue(bone.position.value);
bone.position.expression = "";
//nom du bone
bone.name = "B_" + coin.name;
bone.guideLayer = true;
//mettre l'expression dans le coin
coinpos.expression = "bonePos = thisComp.layer(\"" + bone.name + "\").toWorld(thisComp.layer(\"" + bone.name + "\").anchorPoint);\nfromWorld(bonePos)";

} else {alert(getMessage(13),"Attention");}
	
//fin du groupe d'annulation
app.endUndoGroup();


}else{alert(getMessage(13),"Attention");}
} else{alert(getMessage(8));}
}

//FONCTION POUR AFFICHER DE L'AIDE
function help(){
alert(getMessage(14));
//alert(traduction(["This is a beta version, if you encounter any problem,\nplease notify it by email to duduf@duduf.com","Ceci est une version béta, si vous rencontrez le moindre problème,\nenvoyez un message à duduf@duduf.com"]));
}

//FONCTION ROUE
function creroue(){

	rayonfenetre.show();
	
	}

//FONCTION CARRE
function carre(nombre) {
	return Math.pow(nombre,2);
	}

//FONCTION QUI MESURE LE RAYON D'UNE ROUE
function mesurer() {
	
//vérifions qu'il y a deux calques sélectionnés
	if (app.project.activeItem.selectedLayers.length == 2){


	var calqueroue = app.project.activeItem.selectedLayers[0];
	var calquemesure = app.project.activeItem.selectedLayers[1];
	//récupérer les parents
	var parentroue = calqueroue.parent;
	var parentmesure = calquemesure.parent;	
	//défaire les parents pour mesurer les positions
	calqueroue.parent = null;
	calquemesure.parent = null;
	var O = calqueroue.transform.position.value;
	var A = calquemesure.transform.position.value;
	OA = Math.sqrt( carre(O[0]-A[0]) + carre(O[1]-A[1]) );
	rayonbouton.text = Math.round(OA);
	return Math.round(OA);
	//refaire les parents
	calqueroue.parent = parentroue;
	calquemesure.parent = parentmesure;

} else { alert(getMessage(15),"Attention",true); }

	}

//FONCTION DU BOUTON POUR MESURER
function mesure() {
		
		resultat = mesurer();
		if (resultat/resultat == 1) {
		resultattexte.text = getMessage(17) + resultat + " pixels.";
		mesurefenetre.show();
		}
		if (resultat == 0) {
		resultattexte.text = getMessage(16);
		mesurefenetre.show();
		}
		}
		
//FONCTION QUI RECUPERE LE RAYON ENTRE PAR L'UTILISATEUR
function rayon(){
	OA = rayonbouton.text;
	}

//FONCTION QUI CREE UNE ROUE
function roue() {

			//  début de groupe d'annulation
			app.beginUndoGroup(getMessage(18));

			var isnumber = OA/OA;

			if (isnumber == 1) {
				
var calqueroue = app.project.activeItem.selectedLayers[0];
var curseur = calqueroue.Effects.addProperty("ADBE Slider Control");
curseur.name = getMessage(105);
curseur(1).setValue(OA);

calqueroue.transform.rotation.expression = "O = thisLayer.toWorld(thisLayer.anchorPoint);\n" + "R = thisLayer.effect('" + getMessage(105) + "')(1);\n" + "R > 0 ? value + radiansToDegrees(O[0]/R) : 0 ;";

			//  fin de groupe d'annulation
			app.endUndoGroup();

			rayonfenetre.hide();

				} else { alert (getMessage(19),getMessage(20),true); }
	}

//FONCTION TARGET CAM
function controlcam() {
	//vérifier qu'il n'y a qu'un calque sélectionné
if (app.project.activeItem.selectedLayers.length == 1){
	//vérifier que c'est une caméra
	if (app.project.activeItem.selectedLayers[0] instanceof CameraLayer) {

//début du groupe d'annulation
app.beginUndoGroup(getMessage(21));


//récupérer la caméra
var camera = app.project.activeItem.selectedLayers[0];

//créer le target
var target = app.project.activeItem.layers.addNull();
target.name = camera.name + " target";
target.threeDLayer = true;
target.position.setValue(camera.transform.pointOfInterest.value);

//créer la cam
var cam = app.project.activeItem.layers.addNull();
cam.name = camera.name + " position";
cam.threeDLayer = true;
cam.position.setValue(camera.transform.position.value);

//créer celui tout en haut
var controleur = app.project.activeItem.layers.addNull();
controleur.name = "Control_" + camera.name;
controleur.threeDLayer = true;

cam.parent = controleur;
target.parent = controleur;

//définir les expressions
camera.position.expression = "thisComp.layer(\"" + cam.name + "\").toWorld(thisComp.layer(\"" + cam.name + "\").transform.anchorPoint)";
camera.pointOfInterest.expression = "thisComp.layer(\"" + target.name + "\").toWorld(thisComp.layer(\"" + target.name + "\").transform.anchorPoint)";
camera.orientation.expression = "value + thisComp.layer(\"" + cam.name + "\").transform.orientation";
camera.xRotation.expression = "value + thisComp.layer(\"" + cam.name + "\").transform.xRotation";
camera.yRotation.expression = "value + thisComp.layer(\"" + cam.name + "\").transform.yRotation";
camera.rotation.expression = "value + thisComp.layer(\"" + cam.name + "\").transform.rotation";

//bloquer la camera
camera.locked = true;

//fin du groupe d'annulation
app.endUndoGroup();

}
else { alert (getMessage(22),getMessage(23),true); }
}

else { alert (getMessage(22),getMessage(24),true); }
	
	
	
	}

//FONCTION CAM RELIEF
function camrelief() {
	//vérifier qu'il n'y a qu'un calque sélectionné
if (app.project.activeItem.selectedLayers.length == 1){
	//vérifier que c'est une caméra
	if (app.project.activeItem.selectedLayers[0] instanceof CameraLayer) {

//début du groupe d'annulation
app.beginUndoGroup(getMessage(25));


//récupérer la caméra
var camera = app.project.activeItem.selectedLayers[0];

//créer le target
var target = app.project.activeItem.layers.addNull();
target.name = camera.name + " target";
target.threeDLayer = true;
target.position.setValue(camera.transform.pointOfInterest.value);
//ajouter le controleur convergence caméras
var convergence = target.Effects.addProperty("ADBE Angle Control");
convergence.name = getMessage(26);

//créer la cam
var cam = app.project.activeItem.layers.addNull();
cam.name = camera.name + " position";
cam.threeDLayer = true;
cam.position.setValue(camera.transform.position.value);
//ajouter le controleur écartement caméras
var ecart = cam.Effects.addProperty("ADBE Slider Control");
ecart.name = getMessage(27);


//créer les cam droite et gauche
var camdroite = camera.duplicate();
var camgauche = camera.duplicate();
camdroite.name = camera.name + " droite";
camgauche.name = camera.name + " gauche";

//définir les expressions
camera.position.expression = "thisComp.layer(\"" + cam.name + "\").toWorld(thisComp.layer(\"" + cam.name + "\").transform.anchorPoint)";
camera.pointOfInterest.expression = "thisComp.layer(\"" + target.name + "\").toWorld(thisComp.layer(\"" + target.name + "\").transform.anchorPoint)";
camera.orientation.expression = "value + thisComp.layer(\"" + cam.name + "\").transform.orientation";
camera.xRotation.expression = "value + thisComp.layer(\"" + cam.name + "\").transform.xRotation";
camera.yRotation.expression = "value + thisComp.layer(\"" + cam.name + "\").transform.yRotation";
camera.rotation.expression = "value + thisComp.layer(\"" + cam.name + "\").transform.rotation";

camdroite.position.expression = "[thisComp.layer(\"" + camera.name + "\").transform.position[0]+thisComp.layer(\"" + cam.name + "\").effect(\"" + ecart.name + "\")(1),thisComp.layer(\"" + camera.name + "\").transform.position[1],thisComp.layer(\"" + camera.name + "\").transform.position[2]]";
camdroite.pointOfInterest.expression = "thisComp.layer(\"" + target.name + "\").toWorld(thisComp.layer(\"" + target.name + "\").transform.anchorPoint)";
camdroite.orientation.expression = "thisComp.layer(\"" + camera.name + "\").transform.orientation";
camdroite.xRotation.expression = "thisComp.layer(\"" + camera.name + "\").transform.xRotation";
camdroite.yRotation.expression = "thisComp.layer(\"" + camera.name + "\").transform.yRotation-thisComp.layer(\"" + target.name + "\").effect(\"" + convergence.name + "\")(1)";
camdroite.rotation.expression = "thisComp.layer(\"" + camera.name + "\").transform.rotation";
camdroite.zoom.expression = "thisComp.layer(\"" + camera.name + "\").cameraOption.zoom";
camdroite.focusDistance.expression = "thisComp.layer(\"" + camera.name + "\").cameraOption.focusDistance";
camdroite.aperture.expression = "thisComp.layer(\"" + camera.name + "\").cameraOption.aperture";
camdroite.blurLevel.expression = "thisComp.layer(\"" + camera.name + "\").cameraOption.blurLevel";

camgauche.position.expression = "[thisComp.layer(\"" + camera.name + "\").transform.position[0]-thisComp.layer(\"" + cam.name + "\").effect(\"" + ecart.name + "\")(1),thisComp.layer(\"" + camera.name + "\").transform.position[1],thisComp.layer(\"" + camera.name + "\").transform.position[2]]";
camgauche.pointOfInterest.expression = "thisComp.layer(\"" + target.name + "\").toWorld(thisComp.layer(\"" + target.name + "\").transform.anchorPoint)";
camgauche.orientation.expression = "thisComp.layer(\"" + camera.name + "\").transform.orientation";
camgauche.xRotation.expression = "thisComp.layer(\"" + camera.name + "\").transform.xRotation";
camgauche.yRotation.expression = "thisComp.layer(\"" + camera.name + "\").transform.yRotation+thisComp.layer(\"" + target.name + "\").effect(\"" + convergence.name + "\")(1)";
camgauche.rotation.expression = "thisComp.layer(\"" + camera.name + "\").transform.rotation";
camgauche.zoom.expression = "thisComp.layer(\"" + camera.name + "\").cameraOption.zoom";
camgauche.focusDistance.expression = "thisComp.layer(\"" + camera.name + "\").cameraOption.focusDistance";
camgauche.aperture.expression = "thisComp.layer(\"" + camera.name + "\").cameraOption.aperture";
camgauche.blurLevel.expression = "thisComp.layer(\"" + camera.name + "\").cameraOption.blurLevel";


//bloquer la camera
camera.locked = true;

//fin du groupe d'annulation
app.endUndoGroup();

}
else { alert (getMessage(22),getMessage(23),true); }
}

else { alert (getMessage(22),getMessage(24),true); }
	
	
	
	}

//FONCTION MORPHER
function morpher() {

				if (verifNoms()) {

//  début de groupe d'annulation
app.beginUndoGroup(getMessage(28));


//récupérer la sélection d'effets du premier calque, puisqu'elle sera perdue à la création de la glissière..... (voir avec adobe si vous trouvez ca pas pratique)
var selection = [];
    effets =  app.project.activeItem.selectedLayers[0].selectedProperties;
    for (j=0;j<effets.length;j++) {
         if (effets[j].canSetExpression && effets[j].parentProperty.isEffect) {
                 var layerIndex = app.project.activeItem.selectedLayers[0].index;
                 var effetIndex =  effets[j].propertyIndex;
                 var effetParentName = effets[j].parentProperty.name;
                selection.push([layerIndex,effetParentName,effetIndex]);
                delete effetIndex;
                delete effetParentName;
                } 
            }



//créer le curseur
var morpher = app.project.activeItem.selectedLayers[0].Effects.addProperty("ADBE Slider Control");
morpher.name = "Morpher";

//boucle pour appliquer le morpher sur la sélection perdue
for (i=0;i<selection.length;i++) {
    var effet = app.project.activeItem.layer(selection[i][0]).effect(selection[i][1])(selection[i][2]);
    effet.expression = "valueAtTime((thisComp.layer(\"" +  app.project.activeItem.selectedLayers[0].name +"\").effect(\"Morpher\")(1)-thisComp.displayStartTime/thisComp.frameDuration)*thisComp.frameDuration)";
    //la boucle pour créer automatiquement des clefs sur le morpher :
            if (boutonMKey.value) {
                //nombre de clefs
                var nbreClefs = effet.numKeys;
                //durée d'image de la compo
                var ips = app.project.activeItem.frameDuration;
                var temps = 0;
                var prop = effet;
               for (k=1;k<=nbreClefs;k++){                 
                    //récupère l'instant de la clef
                    temps = prop.keyTime(k);
                    //crée une image clef sur le morpher
                    morpher(1).setValueAtTime(temps,temps/ips);
                    }
                delete temps;
                delete prop;
                delete ips;
                delete nbreClefs;   
         }
    }

//boucle pour appliquer le morpher partout
for (i=0;i<app.project.activeItem.selectedLayers.length;i++) {
    for (j=0;j<app.project.activeItem.selectedLayers[i].selectedProperties.length;j++) {
        var effet = app.project.activeItem.selectedLayers[i].selectedProperties[j];
         if (effet.canSetExpression && effet.parentProperty.name != "Morpher") {
              effet.expression = "valueAtTime((thisComp.layer(\"" + app.project.activeItem.selectedLayers[0].name +"\").effect(\"Morpher\")(1)-thisComp.displayStartTime/thisComp.frameDuration)*thisComp.frameDuration)";
              //la boucle pour créer automatiquement des clefs sur le morpher :
            if (boutonMKey.value) {
                //nombre de clefs
                var nbreClefs = effet.numKeys;
                //durée d'image de la compo
                var ips = app.project.activeItem.frameDuration;
                var temps = 0;
                var prop = effet;
               for (k=1;k<=nbreClefs;k++){                 
                    //récupère l'instant de la clef
                    temps = prop.keyTime(k);
                    //crée une image clef sur le morpher
                    morpher(1).setValueAtTime(temps,temps/ips);
                    }
                delete temps;
                delete prop;
                delete ips;
                delete nbreClefs;   
         }
     }
    }
}

delete morpher;
//fin du groupe d'annulation
app.endUndoGroup();

}else{alert(getMessage(8));}
}

//FONCTION LENTILLE
function lentille() {

//les calques sélectionnés :
var calques = app.project.activeItem.selectedLayers
			
			//vérifions qu'il y a plusieurs calques sélectionnés
			if (calques.length > 1){

				if (verifNoms()) {
				

			//  début de groupe d'annulation
			app.beginUndoGroup(getMessage(29));

			
			
			//sortir le premier calque, le centre, et ajouter les contrôleurs
			var centre = calques.shift();
			var nomcentre = centre.name;
			var controleurintensite = centre.Effects.addProperty("ADBE Slider Control");
			controleurintensite.name  = getMessage(30);
			controleurintensite(1).setValue(100);
			var controleurtaille = centre.Effects.addProperty("ADBE Slider Control");
			controleurtaille.name  = getMessage(31);
			controleurtaille(1).setValue(100);

			//l'expression de position
			var positionexpression = "calqueCentre = thisComp.layer(\"" + nomcentre + "\");\n\n" +
"function positionAbs(calque) {\n" +
"return calque.toWorld(calque.anchorPoint)\n" +
"}\n\n" +
"n=effect(\"" + getMessage(32) + "\")(1);\n\n" +
"X = thisComp.width - positionAbs(calqueCentre)[0];\n" +
"Y = thisComp.height - positionAbs(calqueCentre)[1];\n\n" +
"if ( n<100 ) {\n\n" +
"i=n/100;\n" +
"j=1-i;\n\n" +
"value + ( (  [X,Y]*(i/j) + positionAbs(calqueCentre) )*j\n\n )" +
"}\n\n" +
"else {value + [X,Y] }";

		//l'expression d'opacité
		var opaciteexpression = "n=thisComp.layer(\"" + centre.name  + "\").effect(\"" + getMessage(30) + "\")(1);\n" + "value*n/100";
			
		//l'expression d'échelle
		var tailleexpression = "n=thisComp.layer(\"" + nomcentre  + "\").effect(\"" + controleurtaille.name + "\")(1);\n" + "value*n/100";
			
		//appliquer les expressions sur le centre
		centre.transform.opacity.expression = opaciteexpression;
		centre.transform.scale.expression = tailleexpression;

			//la boucle d'application des expressions et contrôleurs
			var nombrecalques = calques.length;
			for (i = 0; i < nombrecalques; i++){
			calque = calques[i];
			calque.position.setValue([0,0]);
			//le controleur de la distance
			controleurposition = calque.Effects.addProperty("ADBE Slider Control");
			controleurposition.name = getMessage(32);
			controleurposition(1).setValue(100/nombrecalques*(i+1));
			
			//appliquer les expressions
			calque.transform.position.expression = positionexpression;
			calque.transform.opacity.expression = opaciteexpression;
			calque.transform.scale.expression = tailleexpression;
			
			//fin de la boucle
			}
			
			
			
			//fin du groupe d'annulation			
			app.endUndoGroup();
			} else{
				alert(getMessage(8));
				}
			} else {
				alert(getMessage(33));
				}
			
			
}

//FONCTION LIEN DE DISTANCE
function distanceLink() {
				
if (verifNoms()) {
//vérifions qu'il n'y a bien que deux calques de sélectionnés
if (app.project.activeItem.selectedLayers.length == 2) {
	

			
//récupérer le nom du calque de référence
var calqueRef = app.project.activeItem.selectedLayers[0];

	
//récupérer le calque de destination
var calque = app.project.activeItem.selectedLayers[1];

//récupérer l'effet
//la sélection est perdue lors de la création de la glissière, il faut donc contourner le problème en récupérant tout le chemin de l'effet pour pouvoir le récupérer après...
//Prendre l'effet
var effet = app.project.activeItem.selectedLayers[1].selectedProperties.pop();
//on vérifie sin on peut mettre une expression, sinon inutile de continuer
if(effet.canSetExpression) {
//  début de groupe d'annulation
app.beginUndoGroup(getMessage(34));


//Le problème ne se pose que si on est sur un effet
if (effet.parentProperty.isEffect){
//index de l'effet
var effetIndex = effet.propertyIndex;
//regarder la profondeur
var effetProfondeur = effet.propertyDepth;
//Récupérer le nom de l'effet
var effetParentName = effet.parentProperty.name;
//les curseurs
var distMinCurseur = calque.Effects.addProperty("ADBE Slider Control");
distMinCurseur.name = getMessage(35);
var distMaxCurseur = calque.Effects.addProperty("ADBE Slider Control");
distMaxCurseur.name = getMessage(36);
var falloffCurseur = calque.Effects.addProperty("ADBE Slider Control");
falloffCurseur.name = getMessage(37);
falloffCurseur(1).setValue(10);
	//l'expression à insérer si la ref est pas une cam
var distanceExpression = "calqueRef = thisComp.layer(\"" + calqueRef.name + "\");\n\n" + 
"function positionAbs(calque) {\n" + 
"return calque.toWorld(calque.anchorPoint);\n" + 
"}\n\n" + 
"distance = length(positionAbs(calqueRef),positionAbs(thisLayer));\n\n" + 
"distMin=Math.abs(effect(\"" + getMessage(35) + "\")(1));\n" + 
"distMax=Math.abs(effect(\"" + getMessage(36) + "\")(1));\n" + 
"falloff=effect(\"" + getMessage(37) + "\")(1);\n\n" + 
"if (distMax>=distMin && falloff!=0){\n" + 
"if (distance <= distMax && distance >=distMin) {value}\n" + 
"if (distance > distMax && distMax!=0) {value + distance/falloff-distMax/falloff}\n" + 
"if (distance < distMin){value + distMin/falloff-distance/falloff}\n" + 
"if (distMax==0){value + distance/falloff}\n" + 
"}else {value}";

	//l'expression à insérer si la ref est une cam
var distanceExpressionCam = "calqueRef = thisComp.layer(\"" + calqueRef.name + "\");\n\n" + 
"function positionAbs(calque) {\n" + 
"return calque.toWorld(calque.anchorPoint);\n" + 
"}\n\n" + 
"distance = length(calqueRef.position,positionAbs(thisLayer));\n\n" + 
"distMin=Math.abs(effect(\"" + getMessage(35) + "\")(1));\n" + 
"distMax=Math.abs(effect(\"" + getMessage(36) + "\")(1));\n" + 
"falloff=effect(\"" + getMessage(37) + "\")(1);\n\n" + 
"if (distMax>=distMin && falloff!=0){\n" + 
"if (distance <= distMax && distance >=distMin) {value}\n" + 
"if (distance > distMax && distMax!=0) {value + distance/falloff-distMax/falloff}\n" + 
"if (distance < distMin){value + distMin/falloff-distance/falloff}\n" + 
"if (distMax==0){value + distance/falloff}\n" + 
"}else {value}";

effet = app.project.activeItem.selectedLayers[1].effect(effetParentName)(effetIndex);

if (calqueRef instanceof CameraLayer) {effet.expression = distanceExpressionCam;}
else {effet.expression = distanceExpression;}
//sinon on le fait à l'ancienne
}else{
//les curseurs
var distMinCurseur = calque.Effects.addProperty("ADBE Slider Control");
var minname = effet.name + getMessage(35);
distMinCurseur.name = minname;
var distMaxCurseur = calque.Effects.addProperty("ADBE Slider Control");
var maxname = effet.name + getMessage(36);
distMaxCurseur.name = maxname;
var falloffCurseur = calque.Effects.addProperty("ADBE Slider Control");
var falloffname = effet.name + getMessage(37);
falloffCurseur.name = falloffname;
falloffCurseur(1).setValue(10);
	//l'expression à insérer si la ref est pas une cam
var distanceExpression = "calqueRef = thisComp.layer(\"" + calqueRef.name + "\");\n\n" + 
"function positionAbs(calque) {\n" + 
"return calque.toWorld(calque.anchorPoint);\n" + 
"}\n\n" + 
"distance = length(positionAbs(calqueRef),positionAbs(thisLayer));\n\n" + 
"distMin=Math.abs(effect(\"" + minname + "\")(1));\n" +
"distMax=Math.abs(effect(\"" + maxname + "\")(1));\n" + 
"falloff=effect(\"" + falloffname + "\")(1);\n\n" + 
"if (distMax>=distMin && falloff!=0){\n" + 
"if (distance <= distMax && distance >=distMin) {value}\n" + 
"if (distance > distMax && distMax!=0) {value + distance/falloff-distMax/falloff}\n" + 
"if (distance < distMin){value + distMin/falloff-distance/falloff}\n" + 
"if (distMax==0){value + distance/falloff}\n" + 
"}else {value}";

	//l'expression à insérer si la ref est une cam
var distanceExpressionCam = "calqueRef = thisComp.layer(\"" + calqueRef.name + "\");\n\n" + 
"function positionAbs(calque) {\n" + 
"return calque.toWorld(calque.anchorPoint);\n" + 
"}\n\n" + 
"distance = length(calqueRef.position,positionAbs(thisLayer));\n\n" + 
"distMin=Math.abs(effect(\"" + minname + "\")(1));\n" + 
"distMax=Math.abs(effect(\"" + maxname + "\")(1));\n" + 
"falloff=effect(\"" + falloffname + "\")(1);\n\n" + 
"if (distMax>=distMin && falloff!=0){\n" + 
"if (distance <= distMax && distance >=distMin) {value}\n" + 
"if (distance > distMax && distMax!=0) {value + distance/falloff-distMax/falloff}\n" + 
"if (distance < distMin){value + distMin/falloff-distance/falloff}\n" + 
"if (distMax==0){value + distance/falloff}\n" + 
"}else {value}";

if (calqueRef instanceof CameraLayer) {effet.expression = distanceExpressionCam;}
else {effet.expression = distanceExpression;}
}
	
	//fin du groupe d'annulation
	app.endUndoGroup();
	
	
	
	}else{alert(getMessage(38),getMessage(39));}
	} else {alert (getMessage(40),"Attention",true);}
	} else{alert(getMessage(8));}
	}

//FONCTION POUR CHOISIR LA LANGUE
function choixLangue() {
	if (boutonlangue.selection == 0) app.settings.saveSetting("duik","lang","FRENCH");
	if (boutonlangue.selection == 1) app.settings.saveSetting("duik","lang","ENGLISH");
	if (boutonlangue.selection == 2) app.settings.saveSetting("duik","lang","SPANISH");
	if (boutonlangue.selection == 3) app.settings.saveSetting("duik","lang","GERMAN");
	if (boutonlangue.selection == 4) app.settings.saveSetting("duik","lang","BAHASA");
	if (boutonlangue.selection == 5) app.settings.saveSetting("duik","lang","PORTUGUESE");
	}

//FONCTION POUR VERIFIER QU'IL NYA PAS DEUX CALQUES PORTANT LE MEME NOM DANS LA COMP
function verifNoms() {
	
var calques = app.project.activeItem.layers;
var nbrecalques = app.project.activeItem.numLayers;
var renamed = false;

	if (nbrecalques > 1){
				for (i=1; i<=nbrecalques; i++) {
					for(j=i+1;j<=nbrecalques;j++){
						if(calques[i].name == calques[j].name) {
							calques[j].name = calques[j].name + "_" ;
							renamed = true;
							}
						}
					}
	}
			if (renamed) alert(getMessage(41));
			return true;
}

//FONCTION SPRING
function spring() {
	
	
	// Vérifions si il n'y a qu'un calque sélectionné
if (app.project.activeItem.selectedLayers.length == 1){
	
var calque = app.project.activeItem.selectedLayers[0];

if (calque.selectedProperties.length != 0){
	
	//Prendre l'effet
var effet = app.project.activeItem.selectedLayers[0].selectedProperties.pop();
//on vérifie sin on peut mettre une expression, sinon inutile de continuer
if(effet.canSetExpression) {
	
//  début de groupe d'annulation
app.beginUndoGroup(getMessage(42));


if (effet.parentProperty.isEffect){
	var effetIndex = effet.propertyIndex;
	var effetProfondeur = effet.propertyDepth;
	var effetParentName = effet.parentProperty.name;
	var elasticite = calque.Effects.addProperty("ADBE Slider Control");
	elasticite.name = getMessage(43);
	elasticite(1).setValue(5);
	var attenuation = calque.Effects.addProperty("ADBE Slider Control");
	attenuation.name = getMessage(44);
	attenuation(1).setValue(5);
    var rebond = calque.Effects.addProperty("ADBE Checkbox Control");
	rebond.name = getMessage(45);
	effet = app.project.activeItem.selectedLayers[0].effect(effetParentName)(effetIndex);
	//=============================================
	//expression a insérer
	var expressionspring = "amorti = effect(\"" + getMessage(44) + "\")(1);\n" + 
"freq = effect(\"" + getMessage(43) + "\")(1);\n\n" + 
"rebond = effect(\"" + getMessage(45) + "\")(1);\n\n" + 
"if (numKeys > 1 && freq != 0 ){\n" + 
"if (nearestKey(time).index == 1) { value }\n" + 
"else {\n\n" + 
"if (length(velocity) == 0) {\n\n" + 
"tempsClefProx = nearestKey(time).time;\n\n" + 
"if ( tempsClefProx <= time ) { tempsDebut = tempsClefProx }\n" + 
"else { tempsDebut = key(nearestKey(time).index-1).time }\n\n" + 
"temps = time - tempsDebut;\n\n" + 
"spring = velocityAtTime(tempsDebut-thisComp.frameDuration) * ( .15/freq * Math.sin(freq * temps * 2 * Math.PI) / Math.exp( temps * amorti ) );\n\n" + 
"if (rebond == 0) valueAtTime(tempsDebut) + spring;\n\n" + 
"if (rebond == 1 &&  valueAtTime(tempsDebut-thisComp.frameDuration) >  valueAtTime(tempsDebut)) valueAtTime(tempsDebut) + Math.abs(spring);\n\n" + 
"if (rebond == 1 &&  valueAtTime(tempsDebut-thisComp.frameDuration) <  valueAtTime(tempsDebut)) valueAtTime(tempsDebut) - Math.abs(spring);\n\n" + 
"}\n" + 
"else { value }\n" + 
"}\n" + 
"}\n" + 
"else { value }";
	//=============================================

effet.expression = expressionspring;

} else {
	
var elasticite = calque.Effects.addProperty("ADBE Slider Control");
elasticite.name = getMessage(43);
elasticite(1).setValue(5);
var attenuation = calque.Effects.addProperty("ADBE Slider Control");
attenuation.name = getMessage(44);
attenuation(1).setValue(5);
var rebond = calque.Effects.addProperty("ADBE Checkbox Control");
rebond.name = getMessage(45);
	//=============================================
	//expression a insérer
var expressionspring = "amorti = effect(\"" + getMessage(44) + "\")(1);\n" + 
"freq = effect(\"" +  getMessage(43) + "\")(1);\n\n" + 
"rebond = effect(\"" + getMessage(45) + "\")(1);\n\n" + 
"if (numKeys > 1 && freq != 0 ){\n" + 
"if (nearestKey(time).index == 1) { value }\n" + 
"else {\n\n" + 
"if (length(velocity) == 0) {\n\n" + 
"tempsClefProx = nearestKey(time).time;\n\n" + 
"if ( tempsClefProx <= time ) { tempsDebut = tempsClefProx }\n" + 
"else { tempsDebut = key(nearestKey(time).index-1).time }\n\n" + 
"temps = time - tempsDebut;\n\n" + 
"spring = velocityAtTime(tempsDebut-thisComp.frameDuration) * ( .15/freq * Math.sin(freq * temps * 2 * Math.PI) / Math.exp( temps * amorti ) );\n\n" + 
"if (rebond == 0) valueAtTime(tempsDebut) + spring;\n\n" + 
"if (rebond == 1 &&  valueAtTime(tempsDebut-thisComp.frameDuration) >  valueAtTime(tempsDebut)) valueAtTime(tempsDebut) + Math.abs(spring);\n\n" + 
"if (rebond == 1 &&  valueAtTime(tempsDebut-thisComp.frameDuration) <  valueAtTime(tempsDebut)) valueAtTime(tempsDebut) - Math.abs(spring);\n\n" + 
"}\n" + 
"else { value }\n" + 
"}\n" + 
"}\n" + 
"else { value }";
	//=============================================

effet.expression = expressionspring;

}

//fin du groupe d'annulation
app.endUndoGroup();	

}else{alert(getMessage(38),getMessage(46));}
}else{alert(getMessage(47),getMessage(48));}
}else{alert(getMessage(47),getMessage(49));}

}

//FONCTION ZERO
function zero(){
	
//vérifions qu'il y a 1 layer sélectionnés
if (app.project.activeItem.selectedLayers.length == 1) {	
	
	
			//  début de groupe d'annulation
			app.beginUndoGroup("ZERO");	
	
	var calque = app.project.activeItem.selectedLayers[0];

	//créer un zéro
var zero = app.project.activeItem.layers.addNull();
var calqueparent = calque.parent;
calque.parent = null;
zero.position.setValue(calque.position.value);
zero.rotation.setValue(calque.rotation.value);
zero.name = "Zero_" + calque.name.slice(-24);
calque.parent = zero;

//lier le zéro au bone du bout
zero.parent = calqueparent;

//verrouiller et masquer le zéro
zero.moveToEnd();
zero.guideLayer = true;
zero.locked = true;
zero.shy = true;
zero.enabled = false;
	
				//  fin de groupe d'annulation
			app.endUndoGroup();
	
	
	
} else { alert(getMessage(50),"Attention",true); }


	}

//FONCTION RENOMMER
function rename() {

if (app.project.activeItem.selectedLayers.length > 0) {
	
		var prefixe = "";
		prefixtexte.value ? prefixe = prefix.text : prefixe = "";
		var nom = "";
		nametexte.value ? nom = name.text : nom = "";
		var suffixe = "";
		suffixtexte.value ? suffixe = suffix.text : suffixe = "";
		
		if (!(!suffixtexte.value && !nametexte.value && !prefixtexte.value && !numerotexte.value)) {
			
			for (i=0;i<app.project.activeItem.selectedLayers.length;i++) {
			nametexte.value ? nom = nom : nom = app.project.activeItem.selectedLayers[i].name;
			if (!numerotexte.value)
			app.project.activeItem.selectedLayers[i].name = prefixe + nom + suffixe;
			else {
				var numbering = eval(numero.text) + i;
				app.project.activeItem.selectedLayers[i].name = prefixe + nom + suffixe + numbering;
				}
			}
			
		}
	
	} else { alert(getMessage(51),"Attention",true); }
	
	
	}

//FONCTION CALC
function calc() {
	
	resultatcalc1.text = resultatcalc2.text;
	
	if (eval(textecalc.text) != null)	
		textecalc.text.length < 15 ? resultatcalc2.text = textecalc.text + " = " + eval(textecalc.text) : resultatcalc2.text = "(...) = " + eval(textecalc.text) ;
	else 
		resultatcalc2.text ="error";

}

//FONCTIONS INTERPOLATIONS
{
function lineaire() {

for (i=0;i<app.project.activeItem.selectedLayers.length;i++) {
    for (j=0;j<app.project.activeItem.selectedLayers[i].selectedProperties.length;j++) {
        if (app.project.activeItem.selectedLayers[i].selectedProperties[j].canVaryOverTime) {
            for (k=0;k<app.project.activeItem.selectedLayers[i].selectedProperties[j].selectedKeys.length;k++) {
                var prop = app.project.activeItem.selectedLayers[i].selectedProperties[j];
                prop.setInterpolationTypeAtKey(prop.selectedKeys[k],KeyframeInterpolationType.LINEAR);

                }
            }
        }
    }
}

function lissageA() {

for (i=0;i<app.project.activeItem.selectedLayers.length;i++) {
    for (j=0;j<app.project.activeItem.selectedLayers[i].selectedProperties.length;j++) {
        if (app.project.activeItem.selectedLayers[i].selectedProperties[j].canVaryOverTime) {
            for (k=0;k<app.project.activeItem.selectedLayers[i].selectedProperties[j].selectedKeys.length;k++) {
                var prop = app.project.activeItem.selectedLayers[i].selectedProperties[j];
                prop.setInterpolationTypeAtKey(prop.selectedKeys[k],KeyframeInterpolationType.BEZIER,KeyframeInterpolationType.LINEAR);

                }
            }
        }
    }
}

function lissageE() {
    
for (i=0;i<app.project.activeItem.selectedLayers.length;i++) {
    for (j=0;j<app.project.activeItem.selectedLayers[i].selectedProperties.length;j++) {
        if (app.project.activeItem.selectedLayers[i].selectedProperties[j].canVaryOverTime) {
            for (k=0;k<app.project.activeItem.selectedLayers[i].selectedProperties[j].selectedKeys.length;k++) {
                var prop = app.project.activeItem.selectedLayers[i].selectedProperties[j];
                prop.setInterpolationTypeAtKey(prop.selectedKeys[k],KeyframeInterpolationType.LINEAR,KeyframeInterpolationType.BEZIER);

                }
            }
        }
    }
}

function lissage() {

for (i=0;i<app.project.activeItem.selectedLayers.length;i++) {
    for (j=0;j<app.project.activeItem.selectedLayers[i].selectedProperties.length;j++) {
        if (app.project.activeItem.selectedLayers[i].selectedProperties[j].canVaryOverTime) {
            for (k=0;k<app.project.activeItem.selectedLayers[i].selectedProperties[j].selectedKeys.length;k++) {
                var prop = app.project.activeItem.selectedLayers[i].selectedProperties[j];
                prop.setInterpolationTypeAtKey(prop.selectedKeys[k],KeyframeInterpolationType.BEZIER);
                prop.setTemporalContinuousAtKey(prop.selectedKeys[k], false);
                var easeIn = new KeyframeEase(0,100/3);
                if (!prop.isSpatial && prop.value.length == 3) { prop.setTemporalEaseAtKey(prop.selectedKeys[k],[easeIn,easeIn,easeIn]); }
                else if (!prop.isSpatial && prop.value.length == 2) { prop.setTemporalEaseAtKey(prop.selectedKeys[k],[easeIn,easeIn]); }
                else { prop.setTemporalEaseAtKey(prop.selectedKeys[k],[easeIn]); }
                }
            }
        }
    }
}

function continu() {
    
for (i=0;i<app.project.activeItem.selectedLayers.length;i++) {
    for (j=0;j<app.project.activeItem.selectedLayers[i].selectedProperties.length;j++) {
        if (app.project.activeItem.selectedLayers[i].selectedProperties[j].canVaryOverTime) {
            for (k=0;k<app.project.activeItem.selectedLayers[i].selectedProperties[j].selectedKeys.length;k++) {
                var prop = app.project.activeItem.selectedLayers[i].selectedProperties[j];
                prop.setInterpolationTypeAtKey(prop.selectedKeys[k],KeyframeInterpolationType.BEZIER);
                prop.setTemporalContinuousAtKey(prop.selectedKeys[k], true);
                prop.setTemporalAutoBezierAtKey(prop.selectedKeys[k], true);
                }
            }
        }
    }
}

function maintien() {
    
for (i=0;i<app.project.activeItem.selectedLayers.length;i++) {
    for (j=0;j<app.project.activeItem.selectedLayers[i].selectedProperties.length;j++) {
        if (app.project.activeItem.selectedLayers[i].selectedProperties[j].canVaryOverTime) {
            for (k=0;k<app.project.activeItem.selectedLayers[i].selectedProperties[j].selectedKeys.length;k++) {
                var prop = app.project.activeItem.selectedLayers[i].selectedProperties[j];
                prop.setInterpolationTypeAtKey(prop.selectedKeys[k],KeyframeInterpolationType.HOLD);

                }
            }
        }
    }
}

function infl(valeur) {
    
for (i=0;i<app.project.activeItem.selectedLayers.length;i++) {
    for (j=0;j<app.project.activeItem.selectedLayers[i].selectedProperties.length;j++) {
        if (app.project.activeItem.selectedLayers[i].selectedProperties[j].canVaryOverTime) {
            for (k=0;k<app.project.activeItem.selectedLayers[i].selectedProperties[j].selectedKeys.length;k++) {
                var prop = app.project.activeItem.selectedLayers[i].selectedProperties[j]; 
                if (!prop.isSpatial && prop.value.length == 3) {
                    var easeIn1 =  new KeyframeEase(prop.keyInTemporalEase(prop.selectedKeys[k])[0].speed,boutonApproche.value ? valeur : prop.keyInTemporalEase(prop.selectedKeys[k])[0].influence);
                    var easeIn2 =  new KeyframeEase(prop.keyInTemporalEase(prop.selectedKeys[k])[1].speed,boutonApproche.value ? valeur : prop.keyInTemporalEase(prop.selectedKeys[k])[1].influence);
                    var easeIn3 =  new KeyframeEase(prop.keyInTemporalEase(prop.selectedKeys[k])[2].speed,boutonApproche.value ? valeur : prop.keyInTemporalEase(prop.selectedKeys[k])[2].influence);
                    var easeOut1 = new KeyframeEase(prop.keyOutTemporalEase(prop.selectedKeys[k])[0].speed,boutonEloignement.value ? valeur : prop.keyOutTemporalEase(prop.selectedKeys[k])[0].influence);
                    var easeOut2 = new KeyframeEase(prop.keyOutTemporalEase(prop.selectedKeys[k])[1].speed,boutonEloignement.value ? valeur : prop.keyOutTemporalEase(prop.selectedKeys[k])[1].influence);
                    var easeOut3 = new KeyframeEase(prop.keyOutTemporalEase(prop.selectedKeys[k])[2].speed,boutonEloignement.value ? valeur : prop.keyOutTemporalEase(prop.selectedKeys[k])[2].influence);
                    prop.setTemporalEaseAtKey(prop.selectedKeys[k],[easeIn1,easeIn2,easeIn3],[easeOut1,easeOut2,easeOut3]);
                    }
                else if (!prop.isSpatial && prop.value.length == 2) {
                    var easeIn1 =  new KeyframeEase(prop.keyInTemporalEase(prop.selectedKeys[k])[0].speed,boutonApproche.value ? valeur : prop.keyInTemporalEase(prop.selectedKeys[k])[0].influence);
                    var easeIn2 =  new KeyframeEase(prop.keyInTemporalEase(prop.selectedKeys[k])[1].speed,boutonApproche.value ? valeur : prop.keyInTemporalEase(prop.selectedKeys[k])[1].influence);
                    var easeOut1 = new KeyframeEase(prop.keyOutTemporalEase(prop.selectedKeys[k])[0].speed,boutonEloignement.value ? valeur : prop.keyOutTemporalEase(prop.selectedKeys[k])[0].influence);
                    var easeOut2 = new KeyframeEase(prop.keyOutTemporalEase(prop.selectedKeys[k])[1].speed,boutonEloignement.value ? valeur : prop.keyOutTemporalEase(prop.selectedKeys[k])[1].influence);
                    prop.setTemporalEaseAtKey(prop.selectedKeys[k],[easeIn1,easeIn2],[easeOut1,easeOut2]);
                    }
                else {
                    var easeIn =  new KeyframeEase(prop.keyInTemporalEase(prop.selectedKeys[k])[0].speed,boutonApproche.value ? valeur : prop.keyInTemporalEase(prop.selectedKeys[k])[0].influence);
                    var easeOut = new KeyframeEase(prop.keyOutTemporalEase(prop.selectedKeys[k])[0].speed,boutonEloignement.value ? valeur : prop.keyOutTemporalEase(prop.selectedKeys[k])[0].influence);
                    prop.setTemporalEaseAtKey(prop.selectedKeys[k],[easeIn],[easeOut]);
                    }
                }
            }
        }
    }     
}
}

//FONCTION OSCILLATION
function oscillation() {
		// Vérifions si il n'y a qu'un calque sélectionné
if (app.project.activeItem.selectedLayers.length == 1){
	
var calque = app.project.activeItem.selectedLayers[0];

if (calque.selectedProperties.length != 0){
	
	//Prendre l'effet
var effet = app.project.activeItem.selectedLayers[0].selectedProperties.pop();
//on vérifie sin on peut mettre une expression, sinon inutile de continuer
if(effet.canSetExpression) {
	
//  début de groupe d'annulation
app.beginUndoGroup(getMessage(52));
	
//TODO vérifier le nombre de dimensions

if (effet.parentProperty.isEffect){
	var effetIndex = effet.propertyIndex;
	var effetProfondeur = effet.propertyDepth;
	var effetParentName = effet.parentProperty.name;
	var amplitude = calque.Effects.addProperty("ADBE Slider Control");
	amplitude.name = getMessage(53);
	amplitude(1).setValue(1);
	var frequence = calque.Effects.addProperty("ADBE Slider Control");
	frequence.name = getMessage(54);
	frequence(1).setValue(1);
    var decalage = calque.Effects.addProperty("ADBE Slider Control");
	decalage.name = getMessage(55);
	var amorti = calque.Effects.addProperty("ADBE Slider Control");
	amorti.name = getMessage(56);
	
	effet = app.project.activeItem.selectedLayers[0].effect(effetParentName)(effetIndex);
	//=============================================
	//expression a insérer
	var expressionosc = "amp = effect('" + getMessage(53) + "')(1);\n" +
"freq = effect('" + getMessage(54) + "')(1)*2*Math.PI;\n" +
"decalage = framesToTime(effect('" + getMessage(55) + "')(1));\n" +
"amorti = Math.abs(effect('" + getMessage(56) + "')(1));\n\n" +
"sin = Math.sin(time*freq+decalage);\n\n" +
"for(i=0;i<amorti;i++) {\n" +
"sin = Math.sin(sin);\n" +
"}\n" +
"sin*amp+value;";
	//=============================================

effet.expression = expressionosc;

} else {
	
	var amplitude = calque.Effects.addProperty("ADBE Slider Control");
	amplitude.name = getMessage(53);
	amplitude(1).setValue(1);
	var frequence = calque.Effects.addProperty("ADBE Slider Control");
	frequence.name = getMessage(54);
	frequence(1).setValue(1);
    var decalage = calque.Effects.addProperty("ADBE Slider Control");
	decalage.name = getMessage(55);
	var amorti = calque.Effects.addProperty("ADBE Slider Control");
	amorti.name = getMessage(56);
	//=============================================
	//expression a insérer
	var expressionosc = "amp = effect('" + getMessage(53) + "')(1);\n" +
"freq = effect('" + getMessage(54) + "')(1)*2*Math.PI;\n" +
"decalage = framesToTime(effect('" + getMessage(55) + "')(1));\n" +
"amorti = Math.abs(effect('" + getMessage(56) + "')(1));\n\n" +
"sin = Math.sin(time*freq+decalage);\n\n" +
"for(i=0;i<amorti;i++) {\n" +
"sin = Math.sin(sin);\n" +
"}\n" +
"sin*amp+value;";
	//=============================================

effet.expression = expressionosc;

}
//fin du groupe d'annulation
app.endUndoGroup();	

}else{alert(getMessage(38),getMessage(46));}
}else{alert(getMessage(47),getMessage(48));}
}else{alert(getMessage(47),getMessage(49));}


	}

//FONCTION EXPOSITION DE LANIM
function nframes() {
    	// Vérifions si il n'y a qu'un calque sélectionné
if (app.project.activeItem.selectedLayers.length == 1){
	
var calque = app.project.activeItem.selectedLayers[0];

if (calque.selectedProperties.length != 0){
	
	//Prendre l'effet
var effet = app.project.activeItem.selectedLayers[0].selectedProperties.pop();
//on vérifie sin on peut mettre une expression, sinon inutile de continuer
if(effet.canSetExpression) {
	
//  début de groupe d'annulation
app.beginUndoGroup(getMessage(57));

if (effet.parentProperty.isEffect){
	var effetIndex = effet.propertyIndex;
	var effetProfondeur = effet.propertyDepth;
	var effetParentName = effet.parentProperty.name;
	var expo = calque.Effects.addProperty("ADBE Slider Control");
	expo.name = getMessage(58);
	expo(1).setValue(1);
	
	effet = app.project.activeItem.selectedLayers[0].effect(effetParentName)(effetIndex);
	//=============================================
	//expression a insérer
	var expressionexpo = "expo = effect(\"" + getMessage(58) + "\")(1);\n" +
"expo == 0 ? expo = 1 : Math.abs(expo);\n" +
"timef = timeToFrames(time);\n" +
"valueAtTime(framesToTime( timef - timef%expo ))";
	//=============================================

effet.expression = expressionexpo;

} else {
	
	var expo = calque.Effects.addProperty("ADBE Slider Control");
	expo.name = getMessage(58);
	expo(1).setValue(1);
	//=============================================
	//expression a insérer
	//expression a insérer
	var expressionexpo = "expo = effect(\"" + getMessage(58) + "\")(1);\n" +
"expo == 0 ? expo = 1 : Math.abs(expo);\n" +
"timef = timeToFrames(time);\n" +
"valueAtTime(framesToTime( timef - timef%expo ))";
	//=============================================

effet.expression = expressionexpo;

}
//fin du groupe d'annulation
app.endUndoGroup();	

}else{alert(getMessage(38),getMessage(59));}
}else{alert(getMessage(60),getMessage(48));}
}else{alert(getMessage(60),getMessage(48));}


	}

//FONCTION PATH FOLLOW
function pathFollow() {
    
    		// Vérifions si il n'y a qu'un calque sélectionné
if (app.project.activeItem.selectedLayers.length == 1){
	
var calque = app.project.activeItem.selectedLayers[0];
	
//  début de groupe d'annulation
app.beginUndoGroup(getMessage(61));
	
	//expression a insérer
	var expressionpf = "ff = framesToTime(1);\r\n" + 
"pos = thisLayer.position;\r\n" + 
"A = pos.valueAtTime(time-ff);\r\n" + 
"B =  pos.valueAtTime(time+ff);\r\n\r\n" + 
"if (pos.key(1).time > time){\r\n" + 
"A = pos.key(1).value;\r\n" + 
"B =pos.valueAtTime(pos.key(1).time+ff);\r\n" + 
"}\r\n\r\n" + 
"if (thisLayer.position.key(thisLayer.position.numKeys).time < time){\r\n" + 
"A = pos.valueAtTime(pos.key(pos.numKeys).time-ff);\r\n" + 
"B = pos.key(pos.numKeys).value;\r\n" + 
"}\r\n\r\n" + 
"angle = lookAt(A,B);\r\n" + 
"angle[0] > 0 ? angle[0]+angle[1]+value : angle[0]-angle[1]+value;\r\n";
	//=============================================

calque.transform.rotation.expression = expressionpf;

app.endUndoGroup();	

}else{alert(getMessage(49));}


    }

//FONCTIONS COPY ANIM
{
//renvoie un tableau descriptif de clef pour la clef à l'index "index" de la propriété "prop". startTime applique un offset sur l'instant de la clef
function getKey(prop, index,startTime)
{
                var clef = [];
                var time = prop.keyTime(index) - startTime;
                var value = prop.keyValue(index);
                var inInterpolationType = prop.keyInInterpolationType(index);
                var outInterpolationType = prop.keyOutInterpolationType(index);
                var spatial = [];
                if ( prop.propertyValueType == PropertyValueType.ThreeD_SPATIAL || prop.propertyValueType == PropertyValueType.TwoD_SPATIAL )
                {
                    spatial.push(true);
                    spatial.push(prop.keyInSpatialTangent(index));
                    spatial.push(prop.keyOutSpatialTangent(index));
                    spatial.push(prop.keySpatialContinuous(index));
                    spatial.push(prop.keySpatialAutoBezier(index));
                    spatial.push(prop.keyRoving(index));
                }
                else spatial.push(false);
                var keyInTemporalEase = prop.keyInTemporalEase(index);
                var keyOutTemporalEase = prop.keyOutTemporalEase(index);
                var keyTemporalContinuous = prop.keyTemporalContinuous(index);
                var keyTemporalAutoBezier = prop.keyTemporalAutoBezier(index);
                clef.push(time, value, inInterpolationType, outInterpolationType, spatial, keyInTemporalEase, keyOutTemporalEase, keyTemporalContinuous, keyTemporalAutoBezier);
    
                return clef;
}

// récupère toutes les anims d'un propertyGroup (recursif)
function getPropertyAnims(prop,startTime,selected,endTime)
{
    var valeurs = [];
    if (prop.propertyType == PropertyType.PROPERTY)
    {
        var cles = getPropertyBaseAnim(prop,startTime,selected,endTime);
        if (cles.length > 1) valeurs.push(cles);
    }
    else if (prop.numProperties > 0)
    {
        for (pi = 1;pi <= prop.numProperties;pi++)
        {
            var newValeurs = getPropertyAnims(prop.property(pi),startTime,selected,endTime);
            if (newValeurs.length > 0)
            {
                valeurs = valeurs.concat(newValeurs);
            }
        }
    }
    return valeurs;
}

// renvoie l'anim d'une propriété sous forme de tableau de clefs (avec le nom de la prop d'abord, et uniquement ce nom si on doit prendre les clefs selectionnées mais qu'il n'y en a pas de selectionnées)
function getPropertyBaseAnim(prop,startTime,selected,endTime)
{
    var cles = [prop.name];
    
    if (prop.elided) return cles;
    
    if (prop.isTimeVarying)
    {
        if (selected)
        {
            for (j = 0; j < prop.selectedKeys ; j++)
            {
                cles.push(getKey(prop,prop.selectedKeys[j],startTime));
            }
        }
        else if (prop.numKeys > 0) //!selected
        {
            for (j = 0; j < prop.numKeys ; j++)
            {
                var index = j+1;
                var time = prop.keyTime(index);
                if (time >= startTime && time <= endTime) cles.push(getKey(prop,index,startTime));
            }
        } 
    }
    else if (!selected) //pas d'anim, prendre juste la valeur
    {
        cles.push([0,prop.valueAtTime(startTime,true)]);
    }
    return cles;
}

// renvoie l'instant de la clef la plus tot dans toutes les propriétés (parmi les clefs sélectionnées)
function getFirstKeyTime(prop)
{
    var firstKeyTime = 86339;
    
    if (prop.propertyType == PropertyType.PROPERTY)
    {
        if (prop.selectedKeys.length > 0)
        {
            firstKeyTime = prop.keyTime(prop.selectedKeys[0]);
        }
    }
    else if (prop.numProperties > 0)
    {
        for (pi = 1;pi <= prop.numProperties;pi++)
        {
            testKeyTime = getFirstKeyTime(prop.property(pi));
            if (testKeyTime < firstKeyTime) firstKeyTime = testKeyTime;
        }
    }

    return firstKeyTime;
}

// regarde si ya des clefs sélectionnées dans les calques sélectionnés
function isKeySelected(prop)
{
    var selected = false;
    
    if (prop.propertyType == PropertyType.PROPERTY)
    {
        if (prop.selectedKeys.length >0)
        {
            selected = true;
        }
    }
    else if (prop.numProperties > 0)
    {
        for (pi = 1;pi <= prop.numProperties;pi++)
        {
            selected = isKeySelected(prop.property(pi));
            if (selected) break;
        }
    }
    
    return selected;
}

// sauvegarde l'anim, soit des clefs sélectionnées si il y en a, sinon toute l'anim dans la zone de travail, renvoie sous forme de tableau
//TODO : uniquement les clefs sélectionnées foire, à corriger, mis en stand by ici
function copyAnim()
{
    var layers = app.project.activeItem.selectedLayers;
    if (layers.length == 0)
    {
        alert("Please select the layers from which you want to save animation");
		return;
    }
    
    var selected = false; // est ce qu'il y a des clefs sélectionnées (ou est ce qu'on fait sur toute l'anim)
    var startTime = 86339; // instant de début de l'anim à sauvegarder
    var endTime = app.project.activeItem.workAreaDuration + app.project.activeItem.workAreaStart;
    var layersSaved = []; // tableau de résultats
    
    // 1 - voir si il y a des clefs sélectionnées //TODO : fait foirer ! (boucle infinie quelque part)
    /*for (i = 0; i < layers.length ; i++)
    {
        selected = isKeySelected(layers[i]);
        if (selected) break;
        selected = isKeySelected(layers[i].transform); //faut recommencer sur les transformations, c'est pas des propriétés comme les autres pour after... #StupidAFX
        if (selected) break;
    }*/
    
    // 2 - chercher l'instant de la première clef dans le temps, si ya des clefs sélectionnées
    if (selected)
    {
        for (i = 0; i < layers.length ; i++)
        {
            var testTime = getFirstKeyTime(layers[i]);
            if (testTime < startTime) startTime = testTime;
            testTime = getFirstKeyTime(layers[i].transform); //faut recommencer sur les transformations, c'est pas des propriétés comme les autres pour after... #StupidAFX
            if (testTime < startTime) startTime = testTime;
        }
    }
    else
    {
        startTime = app.project.activeItem.workAreaStart;
    }
  
    //parcourir tous les calques sélectionnés à la recherche des anims à sauvegarder
    for (i = 0; i < layers.length ; i++)
    {
        var layer = [];
        var l = layers[i];
        layer.push(l.name);
		

        // 1 - sauver l'anim des transformations
        var transform = [];
        transform.push("transform");
        transform = transform.concat(getPropertyAnims(l.transform,startTime,selected,endTime));
        if (transform.length >1) layer.push(transform);

        // 2 - les masques //TODO coince si plusieurs masques ?
        for (j=1;j<=l("Masks").numProperties;j++)
        {
            var masque = ["masks",l("Masks")(j).name];
            masque = masque.concat(getPropertyAnims(l("Masks")(j),startTime,selected,endTime));
            if (masque.length >1) layer.push(masque);
        }

        // 3 - les effets
        for (j=1;j<=l("Effects").numProperties;j++)
        {
            var effet = ["effects",l("Effects")(j).name];
            effet = effet.concat(getPropertyAnims(l("Effects")(j),startTime,selected,endTime));
            if (effet.length >1) layer.push(effet);
        }
        
        if (layer.length > 1) layersSaved.push(layer);
		
    }
	
	alert("Animation copied !\n\nNumber of layers : " + layersSaved.length);
	return layersSaved;
}

}

//FONCTIONS PASTE ANIM
{
// applique le tableau d'anim
function pasteAnim(animation)
{
	app.beginUndoGroup("Duik Paste Anim");
	var totalPasted = 0;
	for (li = 1;li <= app.project.activeItem.numLayers;li++)
	{
		var l = app.project.activeItem.layer(li);
		var load = [];
		//parcourir les animations sauvées pour trouver celle qui matche le calque
		for (si = 0; si < animation.length ; si++)
		{
			if (animation[si][0] == l.name)
			{
				load = animation[si];
				break;
			}
		}
		
		//obligés de faire trois fois la boucle, sinon ne fait pas toutes les itérations... //TODO trouver où est le bug
		if (load.length > 1) //transform
		{
			totalPasted++;
			
			for (i = 1;i < load.length;i) //i est itéré manuellement à la fin, sinon des fois ça bloque....... BUG ADOBE ?
			{
				var prop = load[i];
				var type = prop[0];

				if (type == "transform" && prop.length > 1)
				{
					for (j = 1;j< prop.length; j++)
					{
						loadClefs(l.transform,prop[j]);
					}
					break;
				}
				i++;
			}
		}
		if (load.length > 1) //masks
		{
			for (i = 1;i < load.length;i) //i est itéré manuellement à la fin, sinon des fois ça bloque....... BUG ADOBE ?
			{
				var prop = load[i];
				var type = prop[0];
				
				if (type == "masks" && prop.length > 2)
				{
					for (j = 2;j< prop.length; j++)
					{
						if (l("Masks").numProperties > 0 )
						{
							var exists = false;
							for (k = 1;k<=l("Masks").numProperties;k++)
							{
								if (l("Masks")(k).name == prop[1])
								{
									exists = true;
									break;
								}
							}
							if (exists)
							{
								loadClefs(l("Masks")(prop[1]),prop[j]);
							}
						}
					}
				}
				i++;
			}
		}
		if (load.length > 1) //effects
		{
			for (i = 1;i < load.length;i) //i est itéré manuellement à la fin, sinon des fois ça bloque....... BUG ADOBE ?
			{
			
				var prop = load[i];
				var type = prop[0];
				
				if (type == "effects" && prop.length > 2)
				{
					for (j = 2;j< prop.length; j++)
					{
						//vérifier que l'effet existe
						if (l("Effects").numProperties > 0 )
						{
							var exists = false;
							for (k = 1;k<=l("Effects").numProperties;k++)
							{
								if (l("Effects")(k).name == prop[1])
								{
									exists = true;
									break;
								}
							}
							if (exists)
							{
								loadClefs(l("Effects")(prop[1]),prop[j]);
							}
						}
						
					}
				}
				i++;
			}
			
		}
	}
	app.endUndoGroup();
	
	if (totalPasted != animation.length) alert("Pasted animation on " + totalPasted + " layers.\n\n" + (animation.length-totalPasted) + " layers not found.");
	else alert("Pasted animation on " + totalPasted + " layers.");
}

//charge les clefs
function loadClefs(prop,clefs)
{
    if (clefs.length < 1) return true;
    
    var name = clefs[0];
    	
    //trouver la propriété portant ce nom dans la prop demandée
    if (prop.propertyType == PropertyType.PROPERTY && prop.name == name)
    {
        for (iclef = 1; iclef < clefs.length;iclef++)
        {
            loadClef(prop,clefs [iclef]);
        }
        return true;
    }
    else if (prop.numProperties != undefined)
		if (prop.numProperties > 0)
		{
			for (pi = 1;pi <= prop.numProperties;pi++)
			{
				if (loadClefs(prop.property(pi),clefs)) return true;
			}
		}
    return false;
}

//charge une clef sur la prop
function loadClef(prop,clef)
{
     //     0        1                        2                                  3                          4                   5                                      6                                              7                                        8
     //  time, value, inInterpolationType, outInterpolationType, spatial, keyInTemporalEase, keyOutTemporalEase, keyTemporalContinuous, keyTemporalAutoBezier
     
     //spatial.push(true);
     //spatial.push(prop.keyInSpatialTangent(index));
     //spatial.push(prop.keyOutSpatialTangent(index));
     //spatial.push(prop.keySpatialContinuous(index));
    //spatial.push(prop.keySpatialAutoBezier(index));
    //spatial.push(prop.keyRoving(index));
    
    if (clef.length < 2 || prop.elided) return;
    
    var time = app.project.activeItem.workAreaStart+clef[0];
    try //au cas où on est sur du XPosition alors que le calque est 2D, par exemple
    {
        if (clef.length == 2 )
        {
            prop.setValue(clef[1]);
            return;
        }
        else prop.setValueAtTime(time,clef[1]); 
 
        var index = prop.nearestKeyIndex(time);
        if (clef[4][0] && (prop.propertyValueType == PropertyValueType.ThreeD_SPATIAL || prop.propertyValueType == PropertyValueType.TwoD_SPATIAL))
        {
            prop.setSpatialContinuousAtKey(index,clef[4][3]);
            prop.setSpatialAutoBezierAtKey(index,clef[4][4]);
            prop.setRovingAtKey(index,clef[4][5]);
            prop.setSpatialTangentsAtKey(index,clef[4][1],clef[4][2]);
        }
        prop.setTemporalEaseAtKey(index,clef[5],clef[6]);
        prop.setTemporalContinuousAtKey(index,clef[7]);
        prop.setTemporalAutoBezierAtKey(index,clef[8]);
        prop.setInterpolationTypeAtKey(index,clef[2],clef[3]);
        
    }
    catch (err)
    {}
}

}

//FONCTION ROT MORPH
function rotmorph()
{
// Vérifions si il n'y a qu'un calque sélectionné
if (app.project.activeItem.selectedLayers.length == 1){
	
var calque = app.project.activeItem.selectedLayers[0];

if (calque.selectedProperties.length != 0){
	
//Prendre l'effet
var effet = app.project.activeItem.selectedLayers[0].selectedProperties.pop();
//on vérifie si on peut mettre une expression, sinon inutile de continuer
if(!effet.canSetExpression) { return; }
	
//  début de groupe d'annulation
app.beginUndoGroup("Duik Rotation Morph");
	

if (effet.parentProperty.isEffect){
	var effetIndex = effet.propertyIndex;
	var effetParentName = effet.parentProperty.name;
	var layerSelection = calque.Effects.addProperty("ADBE Layer Control");
	layerSelection.name = "RM " + effetParentName + " Ref";
	var min = calque.Effects.addProperty("ADBE Angle Control");
	min.name = "RM " + effetParentName + " Min";
	min(1).setValue(0);
	var max = calque.Effects.addProperty("ADBE Angle Control");
	max.name = "RM " + effetParentName + " Max";
	max(1).setValue(90);

	effet = app.project.activeItem.selectedLayers[0].effect(effetParentName)(effetIndex);
	//=============================================
	//expression a insérer
	var expressionrm = "r = thisLayer.effect('" + "RM " + effetParentName + " Ref" + "')(1).transform.rotation;\r\n" + 
						"n = timeToFrames(key(numKeys).time);\r\n" + 
						"Min =  thisLayer.effect('" + "RM " + effetParentName + " Min" + "')(1);\r\n" + 
						"Max = thisLayer.effect('" + "RM " + effetParentName + " Max" + "')(1);\r\n" + 
						"div =  (Max - Min) / n;\r\n" + 
						"val = 0;\r\n" + 
						"if (div != 0) val = r/div - (Min/div);\r\n" + 
						"valueAtTime(framesToTime(val));";
	//=============================================
	effet.expression = expressionrm;

} else {
	var effetParentName = effet.parentProperty.name;
	var layerSelection = calque.Effects.addProperty("ADBE Layer Control");
	layerSelection.name = "RM " + effetParentName + " Ref";
	var min = calque.Effects.addProperty("ADBE Angle Control");
	min.name = "RM " + effetParentName + " Min";
	min(1).setValue(0);
	var max = calque.Effects.addProperty("ADBE Angle Control");
	max.name = "RM " + effetParentName + " Max";
	max(1).setValue(90);
	//=============================================
	//expression a insérer
	var expressionrm = "r = thisLayer.effect('" + "RM " + effetParentName + " Ref" + "')(1).transform.rotation;\r\n" + 
						"n = timeToFrames(key(numKeys).time);\r\n" + 
						"Min =  thisLayer.effect('" + "RM " + effetParentName + " Min" + "')(1);\r\n" + 
						"Max = thisLayer.effect('" + "RM " + effetParentName + " Max" + "')(1);\r\n" + 
						"div =  (Max - Min) / n;\r\n" + 
						"val = 0;\r\n" + 
						"if (div != 0) val = r/div - (Min/div);\r\n" + 
						"valueAtTime(framesToTime(val));";
	//=============================================

	effet.expression = expressionrm;
}
}

}
}
}
//===========================================
//UI
//===========================================
{
var dossierIcones = Folder.userData.absoluteURI  + "/DuIK/";
//dossierIcones = "C:/Users/perso/Documents/03_DEVELOPPEMENT/AE Scripts/DuDuF IK Tools/Duik Icons/";
var animationSaved = [];

//une fonction pour ajouter les boutons plus rapidement :
function addIconButton(conteneur,image,text){
	var bouton = conteneur.add("iconbutton",undefined,image);
	bouton.size = [108,22];
	bouton.text = text;
	return bouton;
}
function addButton(conteneur,texte){
	var bouton = conteneur.add("button",undefined,texte);
	bouton.size = [108,18];
	return bouton;
}
//deux fonctions pour ajouter les panneaux plus rapidement :
function addPanel(conteneur){
	var groupe = conteneur.add("group");
	groupe.orientation = "column";
	groupe.alignChildren = ["left","center"];
	groupe.alignment = ["center","top"];
	groupe.spacing = 4;
	groupe.margins = 3;
	return groupe;
}
function addGroup(conteneur){
	var groupe = conteneur.add("group");
	groupe.alignChildren = ["left","center"];
	groupe.spacing = 4;
	groupe.margins = 0;
	return groupe;
}

		//fenètre de résultat de mesure
		{
		var mesurefenetre = new Window ("palette", getMessage(62),undefined);
		var resultattexte = mesurefenetre.add("statictext",undefined,"Distance = " + "" + " pixels");
		}

		//fenètre de la roue
		{
		//on a besoin d'une variable globale...
		var OA = 0;
		var rayonfenetre = new Window ("palette", getMessage(63),undefined, {resizeable:true});
		var groupeRoue = addGroup(rayonfenetre);
		groupeRoue.alignChildren = ["fill","top"];
		//champ de saisie
		var rayonbouton = groupeRoue.add ("edittext", undefined);
		rayonbouton.size = ["100","20"];
		rayonbouton.onChange = rayon;
		rayonbouton.helpTip = getMessage(64);
		//bouton mesurer
		var mesurebouton = groupeRoue.add("button",undefined,getMessage(106));
		mesurebouton.value = false;
		mesurebouton.helpTip = getMessage(65);
		mesurebouton.onClick = mesurer;
		//bouton OK
		var rayonok = rayonfenetre.add("button",undefined,"OK");
		rayonok.onClick = roue;
		
		// On définit le layout et on redessine la fenètre quand elle est resizée
        rayonfenetre.layout.layout(true);
        rayonfenetre.layout.resize();
        rayonfenetre.onResizing = rayonfenetre.onResize = function () {this.layout.resize();}
		}

		// la fenetre du wiggle // TODO à retaper !
		{
		var fenetrewiggle = new Window("palette","Wiggle");
		fenetrewiggle.bounds = [300,300,480,470];
		// position
		var positioncadre = fenetrewiggle.add("panel",[5,5,175,38],"Position");
		//separer ou toutes
		var positiontous = positioncadre.add("checkbox",[0,0,75,25],getMessage(66));
		positiontous.value = true;
		positiontous.onClick = wiggleconfpos;
		//x y z
		var positionX = positioncadre.add("checkbox",[80,0,105,25],"X");
		var positionY = positioncadre.add("checkbox",[110,0,135,25],"Y");
		var positionZ = positioncadre.add("checkbox",[140,0,165,25],"Z");
		positionX.enabled = false;
		positionY.enabled = false;
		positionZ.enabled = false;
		// échelle
		var echellecadre = fenetrewiggle.add("panel",[5,43,175,76],getMessage(67));
		var echelletous = echellecadre.add("checkbox",[5,0,80,25],getMessage(66));
		echelletous.onClick = wiggleconfscale;
		//x y
		var echelleX = echellecadre.add("checkbox",[110,0,135,25],"X");
		var echelleY = echellecadre.add("checkbox",[140,0,165,25],"Y");	
		// rotation
		var rotationcadre = fenetrewiggle.add("panel",[5,81,175,114],"Rotation");
		//separer ou toutes
		var rotationtous = rotationcadre.add("checkbox",[0,0,75,25],getMessage(66));
		rotationtous.value = false;
		rotationtous.onClick = wiggleconfrot;
		//x y z
		var rotationX = rotationcadre.add("checkbox",[80,0,105,25],"X");
		var rotationY = rotationcadre.add("checkbox",[110,0,135,25],"Y");
		var rotationZ = rotationcadre.add("checkbox",[140,0,165,25],"Z");
		// opacité
		var opacitebouton = fenetrewiggle.add("checkbox",[10,119,125,135],getMessage(68));
		//ok
		var wiggleok = fenetrewiggle.add("button",[5,140,50,165],"OK");
		wiggleok.onClick = wigglevalid;
		}
		
		// la fenetre de la calculatrice //TODO Boutons !
		{
			var fenetrecalc = new Window ("palette", getMessage(73),undefined, {resizeable:true});
			fenetrecalc.alignChildren = ["fill","top"];
			fenetrecalc.spacing = 2;
			var resultatcalc1 = fenetrecalc.add("statictext",undefined,"");
			var resultatcalc2 = fenetrecalc.add("statictext",undefined,"");
			var textecalc = fenetrecalc.add ("edittext", undefined);
			textecalc.onChange = calc;
			var ligneCalc1 = addGroup(fenetrecalc);
			ligneCalc1.alignChildren = ["fill","center"];
			var ligneCalc1 = addGroup(fenetrecalc);
			ligneCalc1.alignChildren = ["fill","center"];
			var ligneCalc1 = addGroup(fenetrecalc);
			ligneCalc1.alignChildren = ["fill","center"];
			var ligneCalc1 = addGroup(fenetrecalc);
			ligneCalc1.alignChildren = ["fill","center"];
			var ligneCalc1 = addGroup(fenetrecalc);
			ligneCalc1.alignChildren = ["fill","center"];
			var boutonCalcClose = fenetrecalc.add("button",undefined,"Fermer");
			boutonCalcClose.alignment = ["right","bottom"];
			boutonCalcClose.onClick = function() { fenetrecalc.hide(); };
			fenetrecalc.layout.layout(true);
			fenetrecalc.size = [300,100];
			fenetrecalc.layout.resize();
			fenetrecalc.onResizing = fenetrecalc.onResize = function () {fenetrecalc.layout.resize();};
		}
		
		// la fenetre du bloc notes
		{
			var fenetrenotes = new Window ("palette", getMessage(74),undefined, {resizeable:true,closeButton:false});
			fenetrenotes.alignChildren = ["fill","fill"];
			fenetrenotes.spacing = 2;
			var textenotes = fenetrenotes.add ("edittext", undefined,"",{multiline: true});
			textenotes.helpTip = getMessage(104);
			textenotes.text = app.settings.getSetting("duik","notes");
			textenotes.onChange = function () { app.settings.saveSetting("duik","notes",textenotes.text); };
			var boutonNotesClose = fenetrenotes.add("button",undefined,"Fermer");
			boutonNotesClose.alignment = ["right","bottom"];
			boutonNotesClose.onClick = function() { fenetrenotes.hide(); };
			fenetrenotes.layout.layout(true);
			fenetrenotes.size = [300,100];
			fenetrenotes.layout.resize();
			fenetrenotes.onResizing = fenetrenotes.onResize = function () {fenetrenotes.layout.resize();};
			
		}
		
		// la fenetre du rename
		{
		var fenetrerename = new Window("palette","Rename layers",undefined,{resizeable:true,closeButton:false});
		fenetrerename.spacing = 2;
		fenetrerename.alignChildren = ["fill","top"];
		//prefix
		var groupePrefix = addGroup(fenetrerename);
		groupePrefix.alignChildren = ["fill","center"];
		var prefixtexte = groupePrefix.add("checkbox",undefined,getMessage(107));
		prefixtexte.alignment = ["left","center"];
		prefixtexte.size = [108,18];
		var prefix = groupePrefix.add("edittext",undefined);
		prefix.enabled = false;
		prefixtexte.onClick = function() {
			prefix.enabled = prefixtexte.value;
			}
		//nom
		var groupeNom = addGroup(fenetrerename);
		groupeNom.alignChildren = ["fill","center"];
		var nametexte = groupeNom.add("checkbox",undefined,getMessage(108));
		nametexte.alignment = ["left","center"];
		nametexte.size = [108,18];
		var name = groupeNom.add("edittext",undefined);
		name.enabled = false;
			nametexte.onClick = function() {
			name.enabled = nametexte.value;
			}
		//suffix
		var groupeSuffix = addGroup(fenetrerename);
		groupeSuffix.alignChildren = ["fill","center"];
		var suffixtexte = groupeSuffix.add("checkbox",undefined,getMessage(109));
		suffixtexte.alignment = ["left","center"];
		suffixtexte.size = [108,18];
		var suffix = groupeSuffix.add("edittext",undefined);
		suffix.enabled = false;
			suffixtexte.onClick = function() {
			suffix.enabled = suffixtexte.value;
			}
		//numéros
		var groupeNumeros = addGroup(fenetrerename);
		groupeNumeros.alignChildren = ["fill","center"];
		var numerotexte = groupeNumeros.add("checkbox",undefined,getMessage(110));
		numerotexte.alignment = ["left","center"];
		numerotexte.size = [108,18];
		var numero = groupeNumeros.add("edittext",undefined);
		numero.enabled = false;
			numerotexte.onClick = function() {
			numerotexte.value ? numero.enabled = true : numero.enabled = false ;
			}
		//ok
		var groupeRenameBoutons = addGroup(fenetrerename);
		groupeRenameBoutons.alignChildren = ["fill","center"];
		var renameok = groupeRenameBoutons.add("button",undefined,getMessage(111));
		renameok.alignment = ["left","center"];
		renameok.onClick = rename;
		var renameclose = groupeRenameBoutons.add("button",undefined,getMessage(112));
		renameclose.alignment = ["right","center"];
		renameclose.onClick = function() { fenetrerename.hide(); };
		
		
		fenetrerename.layout.layout(true);
		fenetrerename.size = [300,150];
		fenetrerename.layout.resize();
		fenetrerename.onResizing = fenetrerename.onResize = function () {fenetrerename.layout.resize();};
		}
		
		// la palette IK_Tools
		{	
		var palette = (thisObj instanceof Panel) ? thisObj : new Window("palette","Duik",undefined, {resizeable:true});
		palette.alignChildren = ["fill","fill"];
		//entete
		var entete = palette.add("group");
		entete.alignChildren = ["left","center"];
		entete.alignment = ["fill","top"];
		entete.spacing = 2;
		entete.margins = 0;
		var textVersion = entete.add ("statictext", undefined,  "Duik v" + version);
		var boutonhelp = entete.add ("button",undefined,"?");
		boutonhelp.size = [18,18];
		boutonhelp.onClick = help;
		var boutonNotes = entete.add("iconbutton",undefined,dossierIcones + "btn_notes.png");
		boutonNotes.size = [22,22];
		boutonNotes.alignment = ["right","center"];
		boutonNotes.onClick = function () { if (fenetrenotes.visible) fenetrenotes.hide(); else fenetrenotes.show(); };
		var boutonCalc = entete.add("iconbutton",undefined,dossierIcones + "btn_calc.png");
		boutonCalc.size = [22,22];
		boutonCalc.alignment = ["right","center"];
		boutonCalc.onClick = function () { if (fenetrecalc.visible) fenetrecalc.hide(); else fenetrecalc.show(); };
		var selecteur = entete.add("dropdownlist",undefined,[getMessage(136),getMessage(69),getMessage(70),getMessage(72),getMessage(75)]);
		selecteur.alignment = ["right","center"];
		//les panneaux
		var panos = palette.add("group");
		panos.orientation = "stack";
		panos.alignChildren = ["fill","fill"];
		// ----- Les différents panneaux
		var panoik = addPanel(panos);
		var panoanimation = addPanel(panos);
		panoanimation.visible = false;
		var panointerpo =  addPanel(panos);
		panointerpo.visible = false;
		var panocam = addPanel(panos);
		panocam.visible = false;
        var panonotes = addPanel(panos);
		panonotes.visible = false;
		var panosettings = addPanel(panos);
		panosettings.visible = false;

		selecteur.onChange = function() {
			if (selecteur.selection == 0){
				panoik.visible = true;
				panoanimation.visible = false;
				panointerpo.visible = false;
				panocam.visible = false;
				panosettings.visible = false;
                app.settings.saveSetting("duik","pano","0");
				}
						if (selecteur.selection == 1){
				panoik.visible = false;
				panoanimation.visible = true;
				panointerpo.visible = false;
				panocam.visible = false;
				panosettings.visible = false;
                app.settings.saveSetting("duik","pano","1");
				}
						if (selecteur.selection == 2){
				panoik.visible = false;
				panoanimation.visible = false;
				panointerpo.visible = true;
				panocam.visible = false;
				panosettings.visible = false;
                app.settings.saveSetting("duik","pano","2");
				}
						if (selecteur.selection == 3){
				panoik.visible = false;
				panoanimation.visible = false;
				panointerpo.visible = false;
				panocam.visible = true;
				panosettings.visible = false;
                app.settings.saveSetting("duik","pano","3");
				}
						if (selecteur.selection == 4){
				panoik.visible = false;
				panoanimation.visible = false;
				panointerpo.visible = false;
				panocam.visible = false;
				panosettings.visible = true;
                  app.settings.saveSetting("duik","pano","4");
				}

			}
        selecteur.selection = eval(app.settings.getSetting("duik","pano"));
		
		// PANNEAU SETTINGS -----------------------------------------------------------
		{
		//boutons francais anglais
		var groupeLangues = panosettings.add("group");
		groupeLangues.alignment = ["left","center"];
		groupeLangues.add("statictext",undefined,getMessage(76));
		var boutonlangue = groupeLangues.add("dropdownlist",undefined,["Français","English","Español","Deutsch","Bahasa","Português"]);
		if (app.settings.getSetting("duik", "lang") == "FRENCH") boutonlangue.selection = 0;
		if (app.settings.getSetting("duik", "lang") == "ENGLISH") boutonlangue.selection = 1;
		if (app.settings.getSetting("duik", "lang") == "SPANISH") boutonlangue.selection = 2;
		if (app.settings.getSetting("duik", "lang") == "GERMAN") boutonlangue.selection = 3;
		if (app.settings.getSetting("duik", "lang") == "BAHASA") boutonlangue.selection = 4;
		if (app.settings.getSetting("duik", "lang") == "PORTUGUESE") boutonlangue.selection = 5;
		boutonlangue.onChange = choixLangue;
		//mises a jour
		var boutonVMAJ = panosettings.add("checkbox",undefined,getMessage(77));
		if (app.settings.getSetting("duik", "version") == "oui") {boutonVMAJ.value = true; }
		boutonVMAJ.onClick = function() {
			if (boutonVMAJ.value) {app.settings.saveSetting("duik","version","oui");} else {app.settings.saveSetting("duik","version","non");}
			}
		var boutonMAJ = panosettings.add("button",undefined,getMessage(113));
		boutonMAJ.size = [218,18];
		boutonMAJ.onClick = function() {
			if (MAJ(version)) { alert(getMessage(78)); };
			}
		}
		
		// PANNEAU RIGGING -----------------------------------------------------------
		{
		var boutonautorig = panoik.add("button",undefined,"Auto-Rig");
		boutonautorig.enabled = false; //TODO développer l'autorig
		boutonautorig.size = [220,22];
		var groupeIK = addGroup(panoik);
		//bouton pour créer l'IK
		var boutonik = addIconButton(groupeIK,dossierIcones + "btn_creer.png",getMessage(114));
		boutonik.onClick = ik;
		//bouton pour créer un goal
		var boutongoal = addIconButton(groupeIK,dossierIcones + "btn_goal.png",getMessage(115));
		boutongoal.onClick = pregoal;
		boutongoal.helpTip = getMessage(79);
		//boutons front et right view //TODO détecter si calque 3D et poser la question
		var groupeIK3D = addGroup(panoik);
		groupeIK3D.alignChildren = ["fill","center"];
		groupeIK3D.add("statictext",undefined,"3D:"); //TODO a balancer dans une boite de dialogue à la création ik
		var boutonFront = groupeIK3D.add("radiobutton",undefined,getMessage(80));
		var boutonRight = groupeIK3D.add("radiobutton",undefined,getMessage(81));
		boutonFront.value = true;
		var groupeIK2 = addGroup(panoik);
		//bouton controleur
		var boutoncontroleur2 = addIconButton(groupeIK2,dossierIcones + "btn_controleur.png",getMessage(116));
		boutoncontroleur2.onClick = controleur;
		boutoncontroleur2.helpTip = getMessage(82);
		//bouton bone
		var boutonbone2 = addIconButton(groupeIK2,dossierIcones + "btn_bones.png",getMessage(117));
		boutonbone2.onClick = bone;
		boutonbone2.helpTip = getMessage(83);
		var groupeIK3 = addGroup(panoik);
		//bouton zero
		var boutonzero2 = addIconButton(groupeIK3,dossierIcones + "btn_zero.png",getMessage(118));
		boutonzero2.onClick = zero;
		boutonzero2.helpTip = getMessage(84);
		//bouton rotmorph
		var boutonrotmorph = addButton(groupeIK3,getMessage(119));
		boutonrotmorph.onClick = rotmorph;
		boutonrotmorph.helpTip = getMessage(120);
		var groupeIK4 = addGroup(panoik);
		//bouton liens
		var boutonliens = addIconButton(groupeIK4,dossierIcones + "btn_liens.png",getMessage(133));
		boutonliens.enabled = false; //temporairement désactivé jusqu'au dev du nouvel outil
		//boutonliens.onClick = liens; //TODO nouvel outil liens
		//boutonliens.helpTip = traduction(["Show parent links in a simple tree view","Voir les liens de parentés dans une arborescence simple","Show parent links in a simple tree view"]);
		var groupeIK5 = addGroup(panoik);
		//bouton renommer
		var boutonrename2 = addIconButton(groupeIK5,dossierIcones + "btn_renommer.png",getMessage(111));
		boutonrename2.onClick = function() {fenetrerename.show();}
		boutonrename2.helpTip = getMessage(85);
		//bouton mesurer
		var boutonmesurer = addIconButton(groupeIK5,dossierIcones + "btn_mesurer.png",getMessage(106));
		boutonmesurer.onClick = mesure;
		boutonmesurer.helpTip = getMessage(100);
		}
		
		// PANNEAU INTERPOLATION -----------------------------------------------------------
		{
		var groupeInterpoClefs = addGroup(panointerpo);
		groupeInterpoClefs.add("statictext",undefined,"Type de clefs :");
		var boutonLineaire = groupeInterpoClefs.add("iconbutton",undefined,dossierIcones + "interpo_lineaire.png");
		boutonLineaire.size = [13,12];
        boutonLineaire.onClick = lineaire;
        boutonLineaire.helpTip = "Interpolation Linéaire";
		var boutonLissageA = groupeInterpoClefs.add("iconbutton",undefined,dossierIcones + "interpo_lissagea.png");
		boutonLissageA.size = [13,12];
        boutonLissageA.onClick = lissageA;
        boutonLissageA.helpTip = "Lissage à l'approche";
		var boutonLissageE = groupeInterpoClefs.add("iconbutton",undefined,dossierIcones + "interpo_lissagee.png");
		boutonLissageE.size = [13,12];
        boutonLissageE.onClick = lissageE;
        boutonLissageE.helpTip = "Lissage à l'éloignement";
		var boutonLissage = groupeInterpoClefs.add("iconbutton",undefined,dossierIcones + "interpo_bezier.png");
		boutonLissage.size = [13,12];
        boutonLissage.onClick = lissage;
        boutonLissage.helpTip = "Amorti";
		var boutonContinu = groupeInterpoClefs.add("iconbutton",undefined,dossierIcones + "interpo_continu.png");
		boutonContinu.size = [13,12];
        boutonContinu.onClick = continu;
        boutonContinu.helpTip = "Vitesse continue (Bézier Auto)";
		var boutonMaintien = groupeInterpoClefs.add("iconbutton",undefined,dossierIcones + "interpo_maintien.png");
		boutonMaintien.size = [13,12];
        boutonMaintien.onClick = maintien;
        boutonMaintien.helpTip = "Maintien";
		
		var groupeInterpo = addGroup(panointerpo);
		groupeInterpo.spacing = 2;
		var bouton0 = groupeInterpo.add("button",undefined,"0");
		bouton0.size = [21,20];
        bouton0.onClick = function() {texteInfluence.text = 1;infl(1);};
        bouton0.helpTip = "Influence à 1%";
		var bouton10 = groupeInterpo.add("button",undefined,"10");
		bouton10.size = [21,20];
        bouton10.onClick = function() {texteInfluence.text = 10;infl(10);};
        bouton10.helpTip = "Influence à 10%";
		var bouton25 = groupeInterpo.add("button",undefined,"25");
		bouton25.size = [21,20];
        bouton25.onClick = function() {texteInfluence.text = 25;infl(25);};
        bouton25.helpTip = "Influence à 25%";
		var bouton50 = groupeInterpo.add("button",undefined,"50");
		bouton50.size = [21,20];
        bouton50.onClick = function() {texteInfluence.text = 50;infl(50);};
        bouton50.helpTip = "Influence à 50%";
		var bouton75 = groupeInterpo.add("button",undefined,"75");
		bouton75.size = [21,20];
        bouton75.onClick = function() {texteInfluence.text = 75;infl(75);};
        bouton75.helpTip = "Influence à 75%";
		var bouton90 = groupeInterpo.add("button",undefined,"90");
		bouton90.size = [21,20];
        bouton90.onClick = function() {texteInfluence.text = 90;infl(90);};
        bouton90.helpTip = "Influence à 90%";
		var bouton100 = groupeInterpo.add("button",undefined,"100");
		bouton100.size = [21,20];
        bouton100.onClick = function() {texteInfluence.text = 100;infl(100);};
        bouton100.helpTip = "Influence à 100%";
		var texteInfluence = groupeInterpo.add("edittext",undefined,"-");
		texteInfluence.size = [40,22];
		texteInfluence.onChange = function() {infl(eval(texteInfluence.text));};

		var groupeInterpoInOut = addGroup(panointerpo);
		var boutonApproche = groupeInterpoInOut.add("checkbox",undefined,getMessage(86));
		var boutonEloignement = groupeInterpoInOut.add("checkbox",undefined,getMessage(87));
		boutonApproche.value = true;
		boutonEloignement.value = true;
        boutonApproche.helpTip = getMessage(88);
        boutonEloignement.helpTip = getMessage(89);
		boutonApproche.onClick = function() { if (boutonApproche.value == false) boutonEloignement.value = true; };
		boutonEloignement.onClick = function() { if (boutonEloignement.value == false) boutonApproche.value = true; };
		
		var groupeInterpoMorph = addGroup(panointerpo);
		var boutonMoprher = addIconButton(groupeInterpoMorph,dossierIcones + "btn_morph.png","Morpher");
		boutonMoprher.size = [88,22];
        boutonMoprher.onClick = morpher;
        boutonMoprher.helpTip = getMessage(90);
		var boutonMKey = groupeInterpoMorph.add("checkbox",undefined,getMessage(91));
        boutonMKey.value = true;
		}
		
		// PANNEAU ANIMATION -----------------------------------------------
		{
		var groupeAnimation1 = addGroup(panoanimation);
		//bouton wiggle
 		var boutonwiggle = addIconButton(groupeAnimation1,dossierIcones + "btn_wiggle.png",getMessage(121));
		boutonwiggle.onClick = wiggle;
		boutonwiggle.helpTip = getMessage(92);
		//bouton oscillation
		var boutonosc = addIconButton(groupeAnimation1,dossierIcones + "btn_osc.png",getMessage(122));
		boutonosc.onClick = oscillation;
		boutonosc.helpTip = getMessage(93);
		var groupeAnimation2 = addGroup(panoanimation);
		//bouton nframes
		var boutonnframes = addIconButton(groupeAnimation2,dossierIcones + "btn_expo.png",getMessage(123));
		boutonnframes.onClick = nframes;
		boutonnframes.helpTip = getMessage(94);
		//bouton path follow
		var boutonpathfollow = addIconButton(groupeAnimation2,dossierIcones + "btn_pf.png",getMessage(124));
		boutonpathfollow.onClick = pathFollow;
		boutonpathfollow.helpTip = getMessage(95);
		var groupeAnimation3 = addGroup(panoanimation);
         //bouton roue
		var boutonroue = addIconButton(groupeAnimation3,dossierIcones + "btn_roue.png",getMessage(125));
		boutonroue.onClick = creroue;
		boutonroue.helpTip = getMessage(96);
		//bouton spring
		var boutonspring = addIconButton(groupeAnimation3,dossierIcones + "btn_rebond.png",getMessage(126));
		boutonspring.onClick = spring;
		boutonspring.helpTip = getMessage(97);
		var groupeAnimation4 = addGroup(panoanimation);
        //bouton lien de distance
		var boutondistance = addIconButton(groupeAnimation4,dossierIcones + "btn_lien-de-distance.png",getMessage(127));
		boutondistance.onClick = distanceLink;
		boutondistance.helpTip = getMessage(98);
		//bouton lentille
		var boutonlentille = addIconButton(groupeAnimation4,dossierIcones + "/btn_lentille.png",getMessage(128));
		boutonlentille.onClick = lentille;
		boutonlentille.helpTip = getMessage(99);
		var groupeAnimation5 = addGroup(panoanimation);
		//bouton Copy ANIM
		var boutonCopyAnim = addButton(groupeAnimation5,getMessage(129));
		boutonCopyAnim.onClick = function ca() { animationSaved = copyAnim() };
		boutonCopyAnim.helpTip = getMessage(131);
		//bouton Paste ANIM
		var boutonPasteAnim = addButton(groupeAnimation5,getMessage(130));
		boutonPasteAnim.onClick = function pa() { pasteAnim(animationSaved) };
		boutonPasteAnim.helpTip = getMessage(132);
		}
	
		//PANNEAU CAMERAS -------------------------------------------
		{
 		//bouton pour créer une target cam
		var boutontcam = addIconButton(panocam,dossierIcones + "btn_controleur-cam.png",getMessage(134));
		boutontcam.onClick = controlcam;
		boutontcam.helpTip = getMessage(102);
		//bouton pour créer une cam relief
		var boutontcamrelief = addIconButton(panocam,dossierIcones + "btn_3d.png",getMessage(135));
		boutontcamrelief.onClick = camrelief;
		boutontcamrelief.helpTip = getMessage(103);
		}
	
                // On définit le layout et on redessine la fenètre quand elle est resizée
        palette.layout.layout(true);
        palette.layout.resize();
        palette.onResizing = palette.onResize = function () {this.layout.resize();}
		
		
		}

		if (app.settings.getSetting("duik", "version") == "oui" && app.preferences.getPrefAsLong("Main Pref Section","Pref_SCRIPTING_FILE_NETWORK_SECURITY") == 1) MAJ(version);
		return palette;
}


}

var laPalette = IKtools(wnd);
if (laPalette != null && laPalette instanceof Window) {      
        laPalette.show();
    }



}


DuIK(this);

