using System;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using WinStar.DBUtility;//
namespace WinStar.DAL
{
	/// <summary>
	/// ݷClass
	/// </summary>
	public class Class
	{
		public Class()
		{}
		#region  Ա

		/// <summary>
		/// õID
		/// </summary>
		public int GetMaxId()
		{
		return DbHelperSQL.GetMaxID("Id", "HS_Class"); 
		}

		/// <summary>
		/// Ƿڸü¼
		/// </summary>
		public bool Exists(int Id)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select count(1) from HS_Class");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			return DbHelperSQL.Exists(strSql.ToString(),parameters);
		}


		/// <summary>
		/// һ
		/// </summary>
		public int Add(WinStar.Model.Class model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("insert into HS_Class(");
			strSql.Append("ClassNum,GId)");
			strSql.Append(" values (");
			strSql.Append("@ClassNum,@GId)");
			strSql.Append(";select @@IDENTITY");
			SqlParameter[] parameters = {
					new SqlParameter("@ClassNum", SqlDbType.Int,4),
					new SqlParameter("@GId", SqlDbType.Int,4)};
			parameters[0].Value = model.ClassNum;
			parameters[1].Value = model.GId;

			object obj = DbHelperSQL.GetSingle(strSql.ToString(),parameters);
			if (obj == null)
			{
				return 1;
			}
			else
			{
				return Convert.ToInt32(obj);
			}
		}
		/// <summary>
		/// һ
		/// </summary>
		public void Update(WinStar.Model.Class model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("update HS_Class set ");
			strSql.Append("ClassNum=@ClassNum,");
			strSql.Append("GId=@GId");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4),
					new SqlParameter("@ClassNum", SqlDbType.Int,4),
					new SqlParameter("@GId", SqlDbType.Int,4)};
			parameters[0].Value = model.Id;
			parameters[1].Value = model.ClassNum;
			parameters[2].Value = model.GId;

			DbHelperSQL.ExecuteSql(strSql.ToString(),parameters);
		}

		/// <summary>
		/// ɾһ
		/// </summary>
		public void Delete(int Id)
		{
			
			StringBuilder strSql=new StringBuilder();
			strSql.Append("delete from HS_Class ");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			DbHelperSQL.ExecuteSql(strSql.ToString(),parameters);
		}


		/// <summary>
		/// õһʵ
		/// </summary>
		public WinStar.Model.Class GetModel(int Id)
		{
			
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select  top 1 Id,ClassNum,GId from HS_Class ");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			WinStar.Model.Class model=new WinStar.Model.Class();
			DataSet ds=DbHelperSQL.Query(strSql.ToString(),parameters);
			if(ds.Tables[0].Rows.Count>0)
			{
				if(ds.Tables[0].Rows[0]["Id"].ToString()!="")
				{
					model.Id=int.Parse(ds.Tables[0].Rows[0]["Id"].ToString());
				}
				if(ds.Tables[0].Rows[0]["ClassNum"].ToString()!="")
				{
					model.ClassNum=int.Parse(ds.Tables[0].Rows[0]["ClassNum"].ToString());
				}
				if(ds.Tables[0].Rows[0]["GId"].ToString()!="")
				{
					model.GId=int.Parse(ds.Tables[0].Rows[0]["GId"].ToString());
				}
				return model;
			}
			else
			{
				return null;
			}
		}

		/// <summary>
		/// б
		/// </summary>
		public DataSet GetList(string strWhere)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select Id,ClassNum,GId ");
			strSql.Append(" FROM HS_Class ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			return DbHelperSQL.Query(strSql.ToString());
		}

		/// <summary>
		/// ǰ
		/// </summary>
		public DataSet GetList(int Top,string strWhere,string filedOrder)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select ");
			if(Top>0)
			{
				strSql.Append(" top "+Top.ToString());
			}
			strSql.Append(" Id,ClassNum,GId ");
			strSql.Append(" FROM HS_Class ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			strSql.Append(" order by " + filedOrder);
			return DbHelperSQL.Query(strSql.ToString());
		}

		/*
		/// <summary>
		/// ҳȡб
		/// </summary>
		public DataSet GetList(int PageSize,int PageIndex,string strWhere)
		{
			SqlParameter[] parameters = {
					new SqlParameter("@tblName", SqlDbType.VarChar, 255),
					new SqlParameter("@fldName", SqlDbType.VarChar, 255),
					new SqlParameter("@PageSize", SqlDbType.Int),
					new SqlParameter("@PageIndex", SqlDbType.Int),
					new SqlParameter("@IsReCount", SqlDbType.Bit),
					new SqlParameter("@OrderType", SqlDbType.Bit),
					new SqlParameter("@strWhere", SqlDbType.VarChar,1000),
					};
			parameters[0].Value = "HS_Class";
			parameters[1].Value = "ID";
			parameters[2].Value = PageSize;
			parameters[3].Value = PageIndex;
			parameters[4].Value = 0;
			parameters[5].Value = 0;
			parameters[6].Value = strWhere;	
			return DbHelperSQL.RunProcedure("UP_GetRecordByPage",parameters,"ds");
		}*/

		#endregion  Ա
	}
}

