using System;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using WinStar.DBUtility;//
namespace WinStar.DAL
{
	/// <summary>
	/// ݷConfig
	/// </summary>
	public class Config
	{
		public Config()
		{}
		#region  Ա

		/// <summary>
		/// õID
		/// </summary>
		public int GetMaxId()
		{
		return DbHelperSQL.GetMaxID("Id", "HS_Config"); 
		}

		/// <summary>
		/// Ƿڸü¼
		/// </summary>
		public bool Exists(int Id)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select count(1) from HS_Config");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			return DbHelperSQL.Exists(strSql.ToString(),parameters);
		}


		/// <summary>
		/// һ
		/// </summary>
		public int Add(WinStar.Model.Config model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("insert into HS_Config(");
			strSql.Append("SId,SName,SystemName,Code,Address,Telphone,State)");
			strSql.Append(" values (");
			strSql.Append("@SId,@SName,@SystemName,@Code,@Address,@Telphone,@State)");
			strSql.Append(";select @@IDENTITY");
			SqlParameter[] parameters = {
					new SqlParameter("@SId", SqlDbType.Int,4),
					new SqlParameter("@SName", SqlDbType.VarChar,200),
					new SqlParameter("@SystemName", SqlDbType.VarChar,200),
					new SqlParameter("@Code", SqlDbType.VarChar,50),
					new SqlParameter("@Address", SqlDbType.VarChar,500),
					new SqlParameter("@Telphone", SqlDbType.VarChar,50),
					new SqlParameter("@State", SqlDbType.Int,4)};
			parameters[0].Value = model.SId;
			parameters[1].Value = model.SName;
			parameters[2].Value = model.SystemName;
			parameters[3].Value = model.Code;
			parameters[4].Value = model.Address;
			parameters[5].Value = model.Telphone;
			parameters[6].Value = model.State;

			object obj = DbHelperSQL.GetSingle(strSql.ToString(),parameters);
			if (obj == null)
			{
				return 1;
			}
			else
			{
				return Convert.ToInt32(obj);
			}
		}
		/// <summary>
		/// һ
		/// </summary>
		public void Update(WinStar.Model.Config model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("update HS_Config set ");
			strSql.Append("SId=@SId,");
			strSql.Append("SName=@SName,");
			strSql.Append("SystemName=@SystemName,");
			strSql.Append("Code=@Code,");
			strSql.Append("Address=@Address,");
			strSql.Append("Telphone=@Telphone,");
			strSql.Append("State=@State");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4),
					new SqlParameter("@SId", SqlDbType.Int,4),
					new SqlParameter("@SName", SqlDbType.VarChar,200),
					new SqlParameter("@SystemName", SqlDbType.VarChar,200),
					new SqlParameter("@Code", SqlDbType.VarChar,50),
					new SqlParameter("@Address", SqlDbType.VarChar,500),
					new SqlParameter("@Telphone", SqlDbType.VarChar,50),
					new SqlParameter("@State", SqlDbType.Int,4)};
			parameters[0].Value = model.Id;
			parameters[1].Value = model.SId;
			parameters[2].Value = model.SName;
			parameters[3].Value = model.SystemName;
			parameters[4].Value = model.Code;
			parameters[5].Value = model.Address;
			parameters[6].Value = model.Telphone;
			parameters[7].Value = model.State;

			DbHelperSQL.ExecuteSql(strSql.ToString(),parameters);
		}

		/// <summary>
		/// ɾһ
		/// </summary>
		public void Delete(int Id)
		{
			
			StringBuilder strSql=new StringBuilder();
			strSql.Append("delete from HS_Config ");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			DbHelperSQL.ExecuteSql(strSql.ToString(),parameters);
		}


		/// <summary>
		/// õһʵ
		/// </summary>
		public WinStar.Model.Config GetModel(int Id)
		{
			
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select  top 1 Id,SId,SName,SystemName,Code,Address,Telphone,State from HS_Config ");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			WinStar.Model.Config model=new WinStar.Model.Config();
			DataSet ds=DbHelperSQL.Query(strSql.ToString(),parameters);
			if(ds.Tables[0].Rows.Count>0)
			{
				if(ds.Tables[0].Rows[0]["Id"].ToString()!="")
				{
					model.Id=int.Parse(ds.Tables[0].Rows[0]["Id"].ToString());
				}
				if(ds.Tables[0].Rows[0]["SId"].ToString()!="")
				{
					model.SId=int.Parse(ds.Tables[0].Rows[0]["SId"].ToString());
				}
				model.SName=ds.Tables[0].Rows[0]["SName"].ToString();
				model.SystemName=ds.Tables[0].Rows[0]["SystemName"].ToString();
				model.Code=ds.Tables[0].Rows[0]["Code"].ToString();
				model.Address=ds.Tables[0].Rows[0]["Address"].ToString();
				model.Telphone=ds.Tables[0].Rows[0]["Telphone"].ToString();
				if(ds.Tables[0].Rows[0]["State"].ToString()!="")
				{
					model.State=int.Parse(ds.Tables[0].Rows[0]["State"].ToString());
				}
				return model;
			}
			else
			{
				return null;
			}
		}

		/// <summary>
		/// б
		/// </summary>
		public DataSet GetList(string strWhere)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select Id,SId,SName,SystemName,Code,Address,Telphone,State ");
			strSql.Append(" FROM HS_Config ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			return DbHelperSQL.Query(strSql.ToString());
		}

		/// <summary>
		/// ǰ
		/// </summary>
		public DataSet GetList(int Top,string strWhere,string filedOrder)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select ");
			if(Top>0)
			{
				strSql.Append(" top "+Top.ToString());
			}
			strSql.Append(" Id,SId,SName,SystemName,Code,Address,Telphone,State ");
			strSql.Append(" FROM HS_Config ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			strSql.Append(" order by " + filedOrder);
			return DbHelperSQL.Query(strSql.ToString());
		}

		/*
		/// <summary>
		/// ҳȡб
		/// </summary>
		public DataSet GetList(int PageSize,int PageIndex,string strWhere)
		{
			SqlParameter[] parameters = {
					new SqlParameter("@tblName", SqlDbType.VarChar, 255),
					new SqlParameter("@fldName", SqlDbType.VarChar, 255),
					new SqlParameter("@PageSize", SqlDbType.Int),
					new SqlParameter("@PageIndex", SqlDbType.Int),
					new SqlParameter("@IsReCount", SqlDbType.Bit),
					new SqlParameter("@OrderType", SqlDbType.Bit),
					new SqlParameter("@strWhere", SqlDbType.VarChar,1000),
					};
			parameters[0].Value = "HS_Config";
			parameters[1].Value = "ID";
			parameters[2].Value = PageSize;
			parameters[3].Value = PageIndex;
			parameters[4].Value = 0;
			parameters[5].Value = 0;
			parameters[6].Value = strWhere;	
			return DbHelperSQL.RunProcedure("UP_GetRecordByPage",parameters,"ds");
		}*/

		#endregion  Ա
	}
}

