using System;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using WinStar.DBUtility;//
namespace WinStar.DAL
{
	/// <summary>
	/// ݷExamInfo
	/// </summary>
	public class ExamInfo
	{
		public ExamInfo()
		{}
		#region  Ա

		/// <summary>
		/// õID
		/// </summary>
		public int GetMaxId()
		{
		return DbHelperSQL.GetMaxID("Id", "HS_ExamInfo"); 
		}

		/// <summary>
		/// Ƿڸü¼
		/// </summary>
		public bool Exists(int Id)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select count(1) from HS_ExamInfo");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			return DbHelperSQL.Exists(strSql.ToString(),parameters);
		}


		/// <summary>
		/// һ
		/// </summary>
		public int Add(WinStar.Model.ExamInfo model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("insert into HS_ExamInfo(");
			strSql.Append("ExamName,About,Creatime,ExamClass,Sid,ExamTime,Tid)");
			strSql.Append(" values (");
			strSql.Append("@ExamName,@About,@Creatime,@ExamClass,@Sid,@ExamTime,@Tid)");
			strSql.Append(";select @@IDENTITY");
			SqlParameter[] parameters = {
					new SqlParameter("@ExamName", SqlDbType.VarChar,50),
					new SqlParameter("@About", SqlDbType.Text),
					new SqlParameter("@Creatime", SqlDbType.DateTime),
					new SqlParameter("@ExamClass", SqlDbType.VarChar,50),
					new SqlParameter("@Sid", SqlDbType.Int,4),
					new SqlParameter("@ExamTime", SqlDbType.DateTime),
					new SqlParameter("@Tid", SqlDbType.Int,4)};
			parameters[0].Value = model.ExamName;
			parameters[1].Value = model.About;
			parameters[2].Value = model.Creatime;
			parameters[3].Value = model.ExamClass;
			parameters[4].Value = model.Sid;
			parameters[5].Value = model.ExamTime;
			parameters[6].Value = model.Tid;

			object obj = DbHelperSQL.GetSingle(strSql.ToString(),parameters);
			if (obj == null)
			{
				return 1;
			}
			else
			{
				return Convert.ToInt32(obj);
			}
		}
		/// <summary>
		/// һ
		/// </summary>
		public void Update(WinStar.Model.ExamInfo model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("update HS_ExamInfo set ");
			strSql.Append("ExamName=@ExamName,");
			strSql.Append("About=@About,");
			strSql.Append("Creatime=@Creatime,");
			strSql.Append("ExamClass=@ExamClass,");
			strSql.Append("Sid=@Sid,");
			strSql.Append("ExamTime=@ExamTime,");
			strSql.Append("Tid=@Tid");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4),
					new SqlParameter("@ExamName", SqlDbType.VarChar,50),
					new SqlParameter("@About", SqlDbType.Text),
					new SqlParameter("@Creatime", SqlDbType.DateTime),
					new SqlParameter("@ExamClass", SqlDbType.VarChar,50),
					new SqlParameter("@Sid", SqlDbType.Int,4),
					new SqlParameter("@ExamTime", SqlDbType.DateTime),
					new SqlParameter("@Tid", SqlDbType.Int,4)};
			parameters[0].Value = model.Id;
			parameters[1].Value = model.ExamName;
			parameters[2].Value = model.About;
			parameters[3].Value = model.Creatime;
			parameters[4].Value = model.ExamClass;
			parameters[5].Value = model.Sid;
			parameters[6].Value = model.ExamTime;
			parameters[7].Value = model.Tid;

			DbHelperSQL.ExecuteSql(strSql.ToString(),parameters);
		}

		/// <summary>
		/// ɾһ
		/// </summary>
		public void Delete(int Id)
		{
			
			StringBuilder strSql=new StringBuilder();
			strSql.Append("delete from HS_ExamInfo ");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			DbHelperSQL.ExecuteSql(strSql.ToString(),parameters);
		}


		/// <summary>
		/// õһʵ
		/// </summary>
		public WinStar.Model.ExamInfo GetModel(int Id)
		{
			
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select  top 1 Id,ExamName,About,Creatime,ExamClass,Sid,ExamTime,Tid from HS_ExamInfo ");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			WinStar.Model.ExamInfo model=new WinStar.Model.ExamInfo();
			DataSet ds=DbHelperSQL.Query(strSql.ToString(),parameters);
			if(ds.Tables[0].Rows.Count>0)
			{
				if(ds.Tables[0].Rows[0]["Id"].ToString()!="")
				{
					model.Id=int.Parse(ds.Tables[0].Rows[0]["Id"].ToString());
				}
				model.ExamName=ds.Tables[0].Rows[0]["ExamName"].ToString();
				model.About=ds.Tables[0].Rows[0]["About"].ToString();
				if(ds.Tables[0].Rows[0]["Creatime"].ToString()!="")
				{
					model.Creatime=DateTime.Parse(ds.Tables[0].Rows[0]["Creatime"].ToString());
				}
				model.ExamClass=ds.Tables[0].Rows[0]["ExamClass"].ToString();
				if(ds.Tables[0].Rows[0]["Sid"].ToString()!="")
				{
					model.Sid=int.Parse(ds.Tables[0].Rows[0]["Sid"].ToString());
				}
				if(ds.Tables[0].Rows[0]["ExamTime"].ToString()!="")
				{
					model.ExamTime=DateTime.Parse(ds.Tables[0].Rows[0]["ExamTime"].ToString());
				}
				if(ds.Tables[0].Rows[0]["Tid"].ToString()!="")
				{
					model.Tid=int.Parse(ds.Tables[0].Rows[0]["Tid"].ToString());
				}
				return model;
			}
			else
			{
				return null;
			}
		}

		/// <summary>
		/// б
		/// </summary>
		public DataSet GetList(string strWhere)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select Id,ExamName,About,Creatime,ExamClass,Sid,ExamTime,Tid ");
			strSql.Append(" FROM HS_ExamInfo ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			return DbHelperSQL.Query(strSql.ToString());
		}

		/// <summary>
		/// ǰ
		/// </summary>
		public DataSet GetList(int Top,string strWhere,string filedOrder)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select ");
			if(Top>0)
			{
				strSql.Append(" top "+Top.ToString());
			}
			strSql.Append(" Id,ExamName,About,Creatime,ExamClass,Sid,ExamTime,Tid ");
			strSql.Append(" FROM HS_ExamInfo ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			strSql.Append(" order by " + filedOrder);
			return DbHelperSQL.Query(strSql.ToString());
		}

		/*
		/// <summary>
		/// ҳȡб
		/// </summary>
		public DataSet GetList(int PageSize,int PageIndex,string strWhere)
		{
			SqlParameter[] parameters = {
					new SqlParameter("@tblName", SqlDbType.VarChar, 255),
					new SqlParameter("@fldName", SqlDbType.VarChar, 255),
					new SqlParameter("@PageSize", SqlDbType.Int),
					new SqlParameter("@PageIndex", SqlDbType.Int),
					new SqlParameter("@IsReCount", SqlDbType.Bit),
					new SqlParameter("@OrderType", SqlDbType.Bit),
					new SqlParameter("@strWhere", SqlDbType.VarChar,1000),
					};
			parameters[0].Value = "HS_ExamInfo";
			parameters[1].Value = "ID";
			parameters[2].Value = PageSize;
			parameters[3].Value = PageIndex;
			parameters[4].Value = 0;
			parameters[5].Value = 0;
			parameters[6].Value = strWhere;	
			return DbHelperSQL.RunProcedure("UP_GetRecordByPage",parameters,"ds");
		}*/

		#endregion  Ա
	}
}

