using System;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using WinStar.DBUtility;//
namespace WinStar.DAL
{
	/// <summary>
	/// ݷMessage
	/// </summary>
	public class Message
	{
		public Message()
		{}
		#region  Ա

		/// <summary>
		/// õID
		/// </summary>
		public int GetMaxId()
		{
		return DbHelperSQL.GetMaxID("Id", "HS_Message"); 
		}

		/// <summary>
		/// Ƿڸü¼
		/// </summary>
		public bool Exists(int Id)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select count(1) from HS_Message");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			return DbHelperSQL.Exists(strSql.ToString(),parameters);
		}


		/// <summary>
		/// һ
		/// </summary>
		public int Add(WinStar.Model.Message model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("insert into HS_Message(");
			strSql.Append("Title,Content,Files,SendType,SendId,GetType,GetId,State)");
			strSql.Append(" values (");
			strSql.Append("@Title,@Content,@Files,@SendType,@SendId,@GetType,@GetId,@State)");
			strSql.Append(";select @@IDENTITY");
			SqlParameter[] parameters = {
					new SqlParameter("@Title", SqlDbType.VarChar,200),
					new SqlParameter("@Content", SqlDbType.Text),
					new SqlParameter("@Files", SqlDbType.VarChar,200),
					new SqlParameter("@SendType", SqlDbType.Int,4),
					new SqlParameter("@SendId", SqlDbType.Int,4),
					new SqlParameter("@GetType", SqlDbType.Int,4),
					new SqlParameter("@GetId", SqlDbType.Int,4),
					new SqlParameter("@State", SqlDbType.Int,4)};
			parameters[0].Value = model.Title;
			parameters[1].Value = model.Content;
			parameters[2].Value = model.Files;
			parameters[3].Value = model.SendType;
			parameters[4].Value = model.SendId;
			parameters[5].Value = model.GetType;
			parameters[6].Value = model.GetId;
			parameters[7].Value = model.State;

			object obj = DbHelperSQL.GetSingle(strSql.ToString(),parameters);
			if (obj == null)
			{
				return 1;
			}
			else
			{
				return Convert.ToInt32(obj);
			}
		}
		/// <summary>
		/// һ
		/// </summary>
		public void Update(WinStar.Model.Message model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("update HS_Message set ");
			strSql.Append("Title=@Title,");
			strSql.Append("Content=@Content,");
			strSql.Append("Files=@Files,");
			strSql.Append("SendType=@SendType,");
			strSql.Append("SendId=@SendId,");
			strSql.Append("GetType=@GetType,");
			strSql.Append("GetId=@GetId,");
			strSql.Append("State=@State");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4),
					new SqlParameter("@Title", SqlDbType.VarChar,200),
					new SqlParameter("@Content", SqlDbType.Text),
					new SqlParameter("@Files", SqlDbType.VarChar,200),
					new SqlParameter("@SendType", SqlDbType.Int,4),
					new SqlParameter("@SendId", SqlDbType.Int,4),
					new SqlParameter("@GetType", SqlDbType.Int,4),
					new SqlParameter("@GetId", SqlDbType.Int,4),
					new SqlParameter("@State", SqlDbType.Int,4)};
			parameters[0].Value = model.Id;
			parameters[1].Value = model.Title;
			parameters[2].Value = model.Content;
			parameters[3].Value = model.Files;
			parameters[4].Value = model.SendType;
			parameters[5].Value = model.SendId;
			parameters[6].Value = model.GetType;
			parameters[7].Value = model.GetId;
			parameters[8].Value = model.State;

			DbHelperSQL.ExecuteSql(strSql.ToString(),parameters);
		}

		/// <summary>
		/// ɾһ
		/// </summary>
		public void Delete(int Id)
		{
			
			StringBuilder strSql=new StringBuilder();
			strSql.Append("delete from HS_Message ");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			DbHelperSQL.ExecuteSql(strSql.ToString(),parameters);
		}


		/// <summary>
		/// õһʵ
		/// </summary>
		public WinStar.Model.Message GetModel(int Id)
		{
			
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select  top 1 Id,Title,Content,Files,SendType,SendId,GetType,GetId,State from HS_Message ");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			WinStar.Model.Message model=new WinStar.Model.Message();
			DataSet ds=DbHelperSQL.Query(strSql.ToString(),parameters);
			if(ds.Tables[0].Rows.Count>0)
			{
				if(ds.Tables[0].Rows[0]["Id"].ToString()!="")
				{
					model.Id=int.Parse(ds.Tables[0].Rows[0]["Id"].ToString());
				}
				model.Title=ds.Tables[0].Rows[0]["Title"].ToString();
				model.Content=ds.Tables[0].Rows[0]["Content"].ToString();
				model.Files=ds.Tables[0].Rows[0]["Files"].ToString();
				if(ds.Tables[0].Rows[0]["SendType"].ToString()!="")
				{
					model.SendType=int.Parse(ds.Tables[0].Rows[0]["SendType"].ToString());
				}
				if(ds.Tables[0].Rows[0]["SendId"].ToString()!="")
				{
					model.SendId=int.Parse(ds.Tables[0].Rows[0]["SendId"].ToString());
				}
				if(ds.Tables[0].Rows[0]["GetType"].ToString()!="")
				{
					model.GetType=int.Parse(ds.Tables[0].Rows[0]["GetType"].ToString());
				}
				if(ds.Tables[0].Rows[0]["GetId"].ToString()!="")
				{
					model.GetId=int.Parse(ds.Tables[0].Rows[0]["GetId"].ToString());
				}
				if(ds.Tables[0].Rows[0]["State"].ToString()!="")
				{
					model.State=int.Parse(ds.Tables[0].Rows[0]["State"].ToString());
				}
				return model;
			}
			else
			{
				return null;
			}
		}

		/// <summary>
		/// б
		/// </summary>
		public DataSet GetList(string strWhere)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select Id,Title,Content,Files,SendType,SendId,GetType,GetId,State ");
			strSql.Append(" FROM HS_Message ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			return DbHelperSQL.Query(strSql.ToString());
		}

		/// <summary>
		/// ǰ
		/// </summary>
		public DataSet GetList(int Top,string strWhere,string filedOrder)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select ");
			if(Top>0)
			{
				strSql.Append(" top "+Top.ToString());
			}
			strSql.Append(" Id,Title,Content,Files,SendType,SendId,GetType,GetId,State ");
			strSql.Append(" FROM HS_Message ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			strSql.Append(" order by " + filedOrder);
			return DbHelperSQL.Query(strSql.ToString());
		}

		/*
		/// <summary>
		/// ҳȡб
		/// </summary>
		public DataSet GetList(int PageSize,int PageIndex,string strWhere)
		{
			SqlParameter[] parameters = {
					new SqlParameter("@tblName", SqlDbType.VarChar, 255),
					new SqlParameter("@fldName", SqlDbType.VarChar, 255),
					new SqlParameter("@PageSize", SqlDbType.Int),
					new SqlParameter("@PageIndex", SqlDbType.Int),
					new SqlParameter("@IsReCount", SqlDbType.Bit),
					new SqlParameter("@OrderType", SqlDbType.Bit),
					new SqlParameter("@strWhere", SqlDbType.VarChar,1000),
					};
			parameters[0].Value = "HS_Message";
			parameters[1].Value = "ID";
			parameters[2].Value = PageSize;
			parameters[3].Value = PageIndex;
			parameters[4].Value = 0;
			parameters[5].Value = 0;
			parameters[6].Value = strWhere;	
			return DbHelperSQL.RunProcedure("UP_GetRecordByPage",parameters,"ds");
		}*/

		#endregion  Ա
	}
}

