using System;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using WinStar.DBUtility;//
namespace WinStar.DAL
{
	/// <summary>
	/// ݷNews
	/// </summary>
	public class News
	{
		public News()
		{}
		#region  Ա

		/// <summary>
		/// õID
		/// </summary>
		public int GetMaxId()
		{
		return DbHelperSQL.GetMaxID("Id", "HS_News"); 
		}

		/// <summary>
		/// Ƿڸü¼
		/// </summary>
		public bool Exists(int Id)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select count(1) from HS_News");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			return DbHelperSQL.Exists(strSql.ToString(),parameters);
		}


		/// <summary>
		/// һ
		/// </summary>
		public int Add(WinStar.Model.News model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("insert into HS_News(");
			strSql.Append("ClassId,Title,About,Content,TitlePic,CreateTime,Hits,Author,TypeNews,TypeLevel)");
			strSql.Append(" values (");
			strSql.Append("@ClassId,@Title,@About,@Content,@TitlePic,@CreateTime,@Hits,@Author,@TypeNews,@TypeLevel)");
			strSql.Append(";select @@IDENTITY");
			SqlParameter[] parameters = {
					new SqlParameter("@ClassId", SqlDbType.Int,4),
					new SqlParameter("@Title", SqlDbType.VarChar,500),
					new SqlParameter("@About", SqlDbType.Text),
					new SqlParameter("@Content", SqlDbType.Text),
					new SqlParameter("@TitlePic", SqlDbType.VarChar,200),
					new SqlParameter("@CreateTime", SqlDbType.DateTime),
					new SqlParameter("@Hits", SqlDbType.Int,4),
					new SqlParameter("@Author", SqlDbType.VarChar,50),
					new SqlParameter("@TypeNews", SqlDbType.Int,4),
					new SqlParameter("@TypeLevel", SqlDbType.Int,4)};
			parameters[0].Value = model.ClassId;
			parameters[1].Value = model.Title;
			parameters[2].Value = model.About;
			parameters[3].Value = model.Content;
			parameters[4].Value = model.TitlePic;
			parameters[5].Value = model.CreateTime;
			parameters[6].Value = model.Hits;
			parameters[7].Value = model.Author;
			parameters[8].Value = model.TypeNews;
			parameters[9].Value = model.TypeLevel;

			object obj = DbHelperSQL.GetSingle(strSql.ToString(),parameters);
			if (obj == null)
			{
				return 1;
			}
			else
			{
				return Convert.ToInt32(obj);
			}
		}
		/// <summary>
		/// һ
		/// </summary>
		public void Update(WinStar.Model.News model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("update HS_News set ");
			strSql.Append("ClassId=@ClassId,");
			strSql.Append("Title=@Title,");
			strSql.Append("About=@About,");
			strSql.Append("Content=@Content,");
			strSql.Append("TitlePic=@TitlePic,");
			strSql.Append("CreateTime=@CreateTime,");
			strSql.Append("Hits=@Hits,");
			strSql.Append("Author=@Author,");
			strSql.Append("TypeNews=@TypeNews,");
			strSql.Append("TypeLevel=@TypeLevel");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4),
					new SqlParameter("@ClassId", SqlDbType.Int,4),
					new SqlParameter("@Title", SqlDbType.VarChar,500),
					new SqlParameter("@About", SqlDbType.Text),
					new SqlParameter("@Content", SqlDbType.Text),
					new SqlParameter("@TitlePic", SqlDbType.VarChar,200),
					new SqlParameter("@CreateTime", SqlDbType.DateTime),
					new SqlParameter("@Hits", SqlDbType.Int,4),
					new SqlParameter("@Author", SqlDbType.VarChar,50),
					new SqlParameter("@TypeNews", SqlDbType.Int,4),
					new SqlParameter("@TypeLevel", SqlDbType.Int,4)};
			parameters[0].Value = model.Id;
			parameters[1].Value = model.ClassId;
			parameters[2].Value = model.Title;
			parameters[3].Value = model.About;
			parameters[4].Value = model.Content;
			parameters[5].Value = model.TitlePic;
			parameters[6].Value = model.CreateTime;
			parameters[7].Value = model.Hits;
			parameters[8].Value = model.Author;
			parameters[9].Value = model.TypeNews;
			parameters[10].Value = model.TypeLevel;

			DbHelperSQL.ExecuteSql(strSql.ToString(),parameters);
		}

		/// <summary>
		/// ɾһ
		/// </summary>
		public void Delete(int Id)
		{
			
			StringBuilder strSql=new StringBuilder();
			strSql.Append("delete from HS_News ");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			DbHelperSQL.ExecuteSql(strSql.ToString(),parameters);
		}


		/// <summary>
		/// õһʵ
		/// </summary>
		public WinStar.Model.News GetModel(int Id)
		{
			
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select  top 1 Id,ClassId,Title,About,Content,TitlePic,CreateTime,Hits,Author,TypeNews,TypeLevel from HS_News ");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			WinStar.Model.News model=new WinStar.Model.News();
			DataSet ds=DbHelperSQL.Query(strSql.ToString(),parameters);
			if(ds.Tables[0].Rows.Count>0)
			{
				if(ds.Tables[0].Rows[0]["Id"].ToString()!="")
				{
					model.Id=int.Parse(ds.Tables[0].Rows[0]["Id"].ToString());
				}
				if(ds.Tables[0].Rows[0]["ClassId"].ToString()!="")
				{
					model.ClassId=int.Parse(ds.Tables[0].Rows[0]["ClassId"].ToString());
				}
				model.Title=ds.Tables[0].Rows[0]["Title"].ToString();
				model.About=ds.Tables[0].Rows[0]["About"].ToString();
				model.Content=ds.Tables[0].Rows[0]["Content"].ToString();
				model.TitlePic=ds.Tables[0].Rows[0]["TitlePic"].ToString();
				if(ds.Tables[0].Rows[0]["CreateTime"].ToString()!="")
				{
					model.CreateTime=DateTime.Parse(ds.Tables[0].Rows[0]["CreateTime"].ToString());
				}
				if(ds.Tables[0].Rows[0]["Hits"].ToString()!="")
				{
					model.Hits=int.Parse(ds.Tables[0].Rows[0]["Hits"].ToString());
				}
				model.Author=ds.Tables[0].Rows[0]["Author"].ToString();
				if(ds.Tables[0].Rows[0]["TypeNews"].ToString()!="")
				{
					model.TypeNews=int.Parse(ds.Tables[0].Rows[0]["TypeNews"].ToString());
				}
				if(ds.Tables[0].Rows[0]["TypeLevel"].ToString()!="")
				{
					model.TypeLevel=int.Parse(ds.Tables[0].Rows[0]["TypeLevel"].ToString());
				}
				return model;
			}
			else
			{
				return null;
			}
		}

		/// <summary>
		/// б
		/// </summary>
		public DataSet GetList(string strWhere)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select Id,ClassId,Title,About,Content,TitlePic,CreateTime,Hits,Author,TypeNews,TypeLevel ");
			strSql.Append(" FROM HS_News ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			return DbHelperSQL.Query(strSql.ToString());
		}

		/// <summary>
		/// ǰ
		/// </summary>
		public DataSet GetList(int Top,string strWhere,string filedOrder)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select ");
			if(Top>0)
			{
				strSql.Append(" top "+Top.ToString());
			}
			strSql.Append(" Id,ClassId,Title,About,Content,TitlePic,CreateTime,Hits,Author,TypeNews,TypeLevel ");
			strSql.Append(" FROM HS_News ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			strSql.Append(" order by " + filedOrder);
			return DbHelperSQL.Query(strSql.ToString());
		}

		/*
		/// <summary>
		/// ҳȡб
		/// </summary>
		public DataSet GetList(int PageSize,int PageIndex,string strWhere)
		{
			SqlParameter[] parameters = {
					new SqlParameter("@tblName", SqlDbType.VarChar, 255),
					new SqlParameter("@fldName", SqlDbType.VarChar, 255),
					new SqlParameter("@PageSize", SqlDbType.Int),
					new SqlParameter("@PageIndex", SqlDbType.Int),
					new SqlParameter("@IsReCount", SqlDbType.Bit),
					new SqlParameter("@OrderType", SqlDbType.Bit),
					new SqlParameter("@strWhere", SqlDbType.VarChar,1000),
					};
			parameters[0].Value = "HS_News";
			parameters[1].Value = "ID";
			parameters[2].Value = PageSize;
			parameters[3].Value = PageIndex;
			parameters[4].Value = 0;
			parameters[5].Value = 0;
			parameters[6].Value = strWhere;	
			return DbHelperSQL.RunProcedure("UP_GetRecordByPage",parameters,"ds");
		}*/

		#endregion  Ա
	}
}

