using System;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using WinStar.DBUtility;//
namespace WinStar.DAL
{
	/// <summary>
	/// ݷStarTeacher
	/// </summary>
	public class StarTeacher
	{
		public StarTeacher()
		{}
		#region  Ա

		/// <summary>
		/// õID
		/// </summary>
		public int GetMaxId()
		{
		return DbHelperSQL.GetMaxID("Id", "HS_StarTeacher"); 
		}

		/// <summary>
		/// Ƿڸü¼
		/// </summary>
		public bool Exists(int Id)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select count(1) from HS_StarTeacher");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			return DbHelperSQL.Exists(strSql.ToString(),parameters);
		}


		/// <summary>
		/// һ
		/// </summary>
		public int Add(WinStar.Model.StarTeacher model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("insert into HS_StarTeacher(");
			strSql.Append("TrueName,Sex,Subjects,Aptitude,PicUrl,About)");
			strSql.Append(" values (");
			strSql.Append("@TrueName,@Sex,@Subjects,@Aptitude,@PicUrl,@About)");
			strSql.Append(";select @@IDENTITY");
			SqlParameter[] parameters = {
					new SqlParameter("@TrueName", SqlDbType.VarChar,50),
					new SqlParameter("@Sex", SqlDbType.Bit,1),
					new SqlParameter("@Subjects", SqlDbType.VarChar,50),
					new SqlParameter("@Aptitude", SqlDbType.VarChar,50),
					new SqlParameter("@PicUrl", SqlDbType.VarChar,200),
					new SqlParameter("@About", SqlDbType.Text)};
			parameters[0].Value = model.TrueName;
			parameters[1].Value = model.Sex;
			parameters[2].Value = model.Subjects;
			parameters[3].Value = model.Aptitude;
			parameters[4].Value = model.PicUrl;
			parameters[5].Value = model.About;

			object obj = DbHelperSQL.GetSingle(strSql.ToString(),parameters);
			if (obj == null)
			{
				return 1;
			}
			else
			{
				return Convert.ToInt32(obj);
			}
		}
		/// <summary>
		/// һ
		/// </summary>
		public void Update(WinStar.Model.StarTeacher model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("update HS_StarTeacher set ");
			strSql.Append("TrueName=@TrueName,");
			strSql.Append("Sex=@Sex,");
			strSql.Append("Subjects=@Subjects,");
			strSql.Append("Aptitude=@Aptitude,");
			strSql.Append("PicUrl=@PicUrl,");
			strSql.Append("About=@About");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4),
					new SqlParameter("@TrueName", SqlDbType.VarChar,50),
					new SqlParameter("@Sex", SqlDbType.Bit,1),
					new SqlParameter("@Subjects", SqlDbType.VarChar,50),
					new SqlParameter("@Aptitude", SqlDbType.VarChar,50),
					new SqlParameter("@PicUrl", SqlDbType.VarChar,200),
					new SqlParameter("@About", SqlDbType.Text)};
			parameters[0].Value = model.Id;
			parameters[1].Value = model.TrueName;
			parameters[2].Value = model.Sex;
			parameters[3].Value = model.Subjects;
			parameters[4].Value = model.Aptitude;
			parameters[5].Value = model.PicUrl;
			parameters[6].Value = model.About;

			DbHelperSQL.ExecuteSql(strSql.ToString(),parameters);
		}

		/// <summary>
		/// ɾһ
		/// </summary>
		public void Delete(int Id)
		{
			
			StringBuilder strSql=new StringBuilder();
			strSql.Append("delete from HS_StarTeacher ");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			DbHelperSQL.ExecuteSql(strSql.ToString(),parameters);
		}


		/// <summary>
		/// õһʵ
		/// </summary>
		public WinStar.Model.StarTeacher GetModel(int Id)
		{
			
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select  top 1 Id,TrueName,Sex,Subjects,Aptitude,PicUrl,About from HS_StarTeacher ");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			WinStar.Model.StarTeacher model=new WinStar.Model.StarTeacher();
			DataSet ds=DbHelperSQL.Query(strSql.ToString(),parameters);
			if(ds.Tables[0].Rows.Count>0)
			{
				if(ds.Tables[0].Rows[0]["Id"].ToString()!="")
				{
					model.Id=int.Parse(ds.Tables[0].Rows[0]["Id"].ToString());
				}
				model.TrueName=ds.Tables[0].Rows[0]["TrueName"].ToString();
				if(ds.Tables[0].Rows[0]["Sex"].ToString()!="")
				{
					if((ds.Tables[0].Rows[0]["Sex"].ToString()=="1")||(ds.Tables[0].Rows[0]["Sex"].ToString().ToLower()=="true"))
					{
						model.Sex=true;
					}
					else
					{
						model.Sex=false;
					}
				}
				model.Subjects=ds.Tables[0].Rows[0]["Subjects"].ToString();
				model.Aptitude=ds.Tables[0].Rows[0]["Aptitude"].ToString();
				model.PicUrl=ds.Tables[0].Rows[0]["PicUrl"].ToString();
				model.About=ds.Tables[0].Rows[0]["About"].ToString();
				return model;
			}
			else
			{
				return null;
			}
		}

		/// <summary>
		/// б
		/// </summary>
		public DataSet GetList(string strWhere)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select Id,TrueName,Sex,Subjects,Aptitude,PicUrl,About ");
			strSql.Append(" FROM HS_StarTeacher ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			return DbHelperSQL.Query(strSql.ToString());
		}

		/// <summary>
		/// ǰ
		/// </summary>
		public DataSet GetList(int Top,string strWhere,string filedOrder)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select ");
			if(Top>0)
			{
				strSql.Append(" top "+Top.ToString());
			}
			strSql.Append(" Id,TrueName,Sex,Subjects,Aptitude,PicUrl,About ");
			strSql.Append(" FROM HS_StarTeacher ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			strSql.Append(" order by " + filedOrder);
			return DbHelperSQL.Query(strSql.ToString());
		}

		/*
		/// <summary>
		/// ҳȡб
		/// </summary>
		public DataSet GetList(int PageSize,int PageIndex,string strWhere)
		{
			SqlParameter[] parameters = {
					new SqlParameter("@tblName", SqlDbType.VarChar, 255),
					new SqlParameter("@fldName", SqlDbType.VarChar, 255),
					new SqlParameter("@PageSize", SqlDbType.Int),
					new SqlParameter("@PageIndex", SqlDbType.Int),
					new SqlParameter("@IsReCount", SqlDbType.Bit),
					new SqlParameter("@OrderType", SqlDbType.Bit),
					new SqlParameter("@strWhere", SqlDbType.VarChar,1000),
					};
			parameters[0].Value = "HS_StarTeacher";
			parameters[1].Value = "ID";
			parameters[2].Value = PageSize;
			parameters[3].Value = PageIndex;
			parameters[4].Value = 0;
			parameters[5].Value = 0;
			parameters[6].Value = strWhere;	
			return DbHelperSQL.RunProcedure("UP_GetRecordByPage",parameters,"ds");
		}*/

		#endregion  Ա
	}
}

