using System;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using WinStar.DBUtility;//
namespace WinStar.DAL
{
	/// <summary>
	/// ݷStudent
	/// </summary>
	public class Student
	{
		public Student()
		{}
		#region  Ա

		/// <summary>
		/// õID
		/// </summary>
		public int GetMaxId()
		{
		return DbHelperSQL.GetMaxID("Id", "HS_Student"); 
		}

		/// <summary>
		/// Ƿڸü¼
		/// </summary>
		public bool Exists(int Id)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select count(1) from HS_Student");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			return DbHelperSQL.Exists(strSql.ToString(),parameters);
		}


		/// <summary>
		/// һ
		/// </summary>
		public int Add(WinStar.Model.Student model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("insert into HS_Student(");
			strSql.Append("Num,PassWord,TrueName,Sex,PostId,ParentPWD,ClassId)");
			strSql.Append(" values (");
			strSql.Append("@Num,@PassWord,@TrueName,@Sex,@PostId,@ParentPWD,@ClassId)");
			strSql.Append(";select @@IDENTITY");
			SqlParameter[] parameters = {
					new SqlParameter("@Num", SqlDbType.VarChar,50),
					new SqlParameter("@PassWord", SqlDbType.VarChar,50),
					new SqlParameter("@TrueName", SqlDbType.VarChar,50),
					new SqlParameter("@Sex", SqlDbType.Bit,1),
					new SqlParameter("@PostId", SqlDbType.Int,4),
					new SqlParameter("@ParentPWD", SqlDbType.VarChar,50),
					new SqlParameter("@ClassId", SqlDbType.Int,4)};
			parameters[0].Value = model.Num;
			parameters[1].Value = model.PassWord;
			parameters[2].Value = model.TrueName;
			parameters[3].Value = model.Sex;
			parameters[4].Value = model.PostId;
			parameters[5].Value = model.ParentPWD;
			parameters[6].Value = model.ClassId;

			object obj = DbHelperSQL.GetSingle(strSql.ToString(),parameters);
			if (obj == null)
			{
				return 1;
			}
			else
			{
				return Convert.ToInt32(obj);
			}
		}
		/// <summary>
		/// һ
		/// </summary>
		public void Update(WinStar.Model.Student model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("update HS_Student set ");
			strSql.Append("Num=@Num,");
			strSql.Append("PassWord=@PassWord,");
			strSql.Append("TrueName=@TrueName,");
			strSql.Append("Sex=@Sex,");
			strSql.Append("PostId=@PostId,");
			strSql.Append("ParentPWD=@ParentPWD,");
			strSql.Append("ClassId=@ClassId");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4),
					new SqlParameter("@Num", SqlDbType.VarChar,50),
					new SqlParameter("@PassWord", SqlDbType.VarChar,50),
					new SqlParameter("@TrueName", SqlDbType.VarChar,50),
					new SqlParameter("@Sex", SqlDbType.Bit,1),
					new SqlParameter("@PostId", SqlDbType.Int,4),
					new SqlParameter("@ParentPWD", SqlDbType.VarChar,50),
					new SqlParameter("@ClassId", SqlDbType.Int,4)};
			parameters[0].Value = model.Id;
			parameters[1].Value = model.Num;
			parameters[2].Value = model.PassWord;
			parameters[3].Value = model.TrueName;
			parameters[4].Value = model.Sex;
			parameters[5].Value = model.PostId;
			parameters[6].Value = model.ParentPWD;
			parameters[7].Value = model.ClassId;

			DbHelperSQL.ExecuteSql(strSql.ToString(),parameters);
		}

		/// <summary>
		/// ɾһ
		/// </summary>
		public void Delete(int Id)
		{
			
			StringBuilder strSql=new StringBuilder();
			strSql.Append("delete from HS_Student ");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			DbHelperSQL.ExecuteSql(strSql.ToString(),parameters);
		}


		/// <summary>
		/// õһʵ
		/// </summary>
		public WinStar.Model.Student GetModel(int Id)
		{
			
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select  top 1 Id,Num,PassWord,TrueName,Sex,PostId,ParentPWD,ClassId from HS_Student ");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			WinStar.Model.Student model=new WinStar.Model.Student();
			DataSet ds=DbHelperSQL.Query(strSql.ToString(),parameters);
			if(ds.Tables[0].Rows.Count>0)
			{
				if(ds.Tables[0].Rows[0]["Id"].ToString()!="")
				{
					model.Id=int.Parse(ds.Tables[0].Rows[0]["Id"].ToString());
				}
				model.Num=ds.Tables[0].Rows[0]["Num"].ToString();
				model.PassWord=ds.Tables[0].Rows[0]["PassWord"].ToString();
				model.TrueName=ds.Tables[0].Rows[0]["TrueName"].ToString();
				if(ds.Tables[0].Rows[0]["Sex"].ToString()!="")
				{
					if((ds.Tables[0].Rows[0]["Sex"].ToString()=="1")||(ds.Tables[0].Rows[0]["Sex"].ToString().ToLower()=="true"))
					{
						model.Sex=true;
					}
					else
					{
						model.Sex=false;
					}
				}
				if(ds.Tables[0].Rows[0]["PostId"].ToString()!="")
				{
					model.PostId=int.Parse(ds.Tables[0].Rows[0]["PostId"].ToString());
				}
				model.ParentPWD=ds.Tables[0].Rows[0]["ParentPWD"].ToString();
				if(ds.Tables[0].Rows[0]["ClassId"].ToString()!="")
				{
					model.ClassId=int.Parse(ds.Tables[0].Rows[0]["ClassId"].ToString());
				}
				return model;
			}
			else
			{
				return null;
			}
		}

		/// <summary>
		/// б
		/// </summary>
		public DataSet GetList(string strWhere)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select Id,Num,PassWord,TrueName,Sex,PostId,ParentPWD,ClassId ");
			strSql.Append(" FROM HS_Student ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			return DbHelperSQL.Query(strSql.ToString());
		}

		/// <summary>
		/// ǰ
		/// </summary>
		public DataSet GetList(int Top,string strWhere,string filedOrder)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select ");
			if(Top>0)
			{
				strSql.Append(" top "+Top.ToString());
			}
			strSql.Append(" Id,Num,PassWord,TrueName,Sex,PostId,ParentPWD,ClassId ");
			strSql.Append(" FROM HS_Student ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			strSql.Append(" order by " + filedOrder);
			return DbHelperSQL.Query(strSql.ToString());
		}

		/*
		/// <summary>
		/// ҳȡб
		/// </summary>
		public DataSet GetList(int PageSize,int PageIndex,string strWhere)
		{
			SqlParameter[] parameters = {
					new SqlParameter("@tblName", SqlDbType.VarChar, 255),
					new SqlParameter("@fldName", SqlDbType.VarChar, 255),
					new SqlParameter("@PageSize", SqlDbType.Int),
					new SqlParameter("@PageIndex", SqlDbType.Int),
					new SqlParameter("@IsReCount", SqlDbType.Bit),
					new SqlParameter("@OrderType", SqlDbType.Bit),
					new SqlParameter("@strWhere", SqlDbType.VarChar,1000),
					};
			parameters[0].Value = "HS_Student";
			parameters[1].Value = "ID";
			parameters[2].Value = PageSize;
			parameters[3].Value = PageIndex;
			parameters[4].Value = 0;
			parameters[5].Value = 0;
			parameters[6].Value = strWhere;	
			return DbHelperSQL.RunProcedure("UP_GetRecordByPage",parameters,"ds");
		}*/

		#endregion  Ա
	}
}

