using System;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using WinStar.DBUtility;//
namespace WinStar.DAL
{
	/// <summary>
	/// ݷSubmitWork
	/// </summary>
	public class SubmitWork
	{
		public SubmitWork()
		{}
		#region  Ա

		/// <summary>
		/// õID
		/// </summary>
		public int GetMaxId()
		{
		return DbHelperSQL.GetMaxID("Id", "HS_SubmitWork"); 
		}

		/// <summary>
		/// Ƿڸü¼
		/// </summary>
		public bool Exists(int Id)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select count(1) from HS_SubmitWork");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			return DbHelperSQL.Exists(strSql.ToString(),parameters);
		}


		/// <summary>
		/// һ
		/// </summary>
		public int Add(WinStar.Model.SubmitWork model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("insert into HS_SubmitWork(");
			strSql.Append("HomeWorkId,UserId,About,Content,FileUrl,Comment,CreateTime,EditTime,State)");
			strSql.Append(" values (");
			strSql.Append("@HomeWorkId,@UserId,@About,@Content,@FileUrl,@Comment,@CreateTime,@EditTime,@State)");
			strSql.Append(";select @@IDENTITY");
			SqlParameter[] parameters = {
					new SqlParameter("@HomeWorkId", SqlDbType.Int,4),
					new SqlParameter("@UserId", SqlDbType.VarChar,50),
					new SqlParameter("@About", SqlDbType.VarChar,1000),
					new SqlParameter("@Content", SqlDbType.Text),
					new SqlParameter("@FileUrl", SqlDbType.VarChar,200),
					new SqlParameter("@Comment", SqlDbType.VarChar,2000),
					new SqlParameter("@CreateTime", SqlDbType.DateTime),
					new SqlParameter("@EditTime", SqlDbType.DateTime),
					new SqlParameter("@State", SqlDbType.Int,4)};
			parameters[0].Value = model.HomeWorkId;
			parameters[1].Value = model.UserId;
			parameters[2].Value = model.About;
			parameters[3].Value = model.Content;
			parameters[4].Value = model.FileUrl;
			parameters[5].Value = model.Comment;
			parameters[6].Value = model.CreateTime;
			parameters[7].Value = model.EditTime;
			parameters[8].Value = model.State;

			object obj = DbHelperSQL.GetSingle(strSql.ToString(),parameters);
			if (obj == null)
			{
				return 1;
			}
			else
			{
				return Convert.ToInt32(obj);
			}
		}
		/// <summary>
		/// һ
		/// </summary>
		public void Update(WinStar.Model.SubmitWork model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("update HS_SubmitWork set ");
			strSql.Append("HomeWorkId=@HomeWorkId,");
			strSql.Append("UserId=@UserId,");
			strSql.Append("About=@About,");
			strSql.Append("Content=@Content,");
			strSql.Append("FileUrl=@FileUrl,");
			strSql.Append("Comment=@Comment,");
			strSql.Append("CreateTime=@CreateTime,");
			strSql.Append("EditTime=@EditTime,");
			strSql.Append("State=@State");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4),
					new SqlParameter("@HomeWorkId", SqlDbType.Int,4),
					new SqlParameter("@UserId", SqlDbType.VarChar,50),
					new SqlParameter("@About", SqlDbType.VarChar,1000),
					new SqlParameter("@Content", SqlDbType.Text),
					new SqlParameter("@FileUrl", SqlDbType.VarChar,200),
					new SqlParameter("@Comment", SqlDbType.VarChar,2000),
					new SqlParameter("@CreateTime", SqlDbType.DateTime),
					new SqlParameter("@EditTime", SqlDbType.DateTime),
					new SqlParameter("@State", SqlDbType.Int,4)};
			parameters[0].Value = model.Id;
			parameters[1].Value = model.HomeWorkId;
			parameters[2].Value = model.UserId;
			parameters[3].Value = model.About;
			parameters[4].Value = model.Content;
			parameters[5].Value = model.FileUrl;
			parameters[6].Value = model.Comment;
			parameters[7].Value = model.CreateTime;
			parameters[8].Value = model.EditTime;
			parameters[9].Value = model.State;

			DbHelperSQL.ExecuteSql(strSql.ToString(),parameters);
		}

		/// <summary>
		/// ɾһ
		/// </summary>
		public void Delete(int Id)
		{
			
			StringBuilder strSql=new StringBuilder();
			strSql.Append("delete from HS_SubmitWork ");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			DbHelperSQL.ExecuteSql(strSql.ToString(),parameters);
		}


		/// <summary>
		/// õһʵ
		/// </summary>
		public WinStar.Model.SubmitWork GetModel(int Id)
		{
			
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select  top 1 Id,HomeWorkId,UserId,About,Content,FileUrl,Comment,CreateTime,EditTime,State from HS_SubmitWork ");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			WinStar.Model.SubmitWork model=new WinStar.Model.SubmitWork();
			DataSet ds=DbHelperSQL.Query(strSql.ToString(),parameters);
			if(ds.Tables[0].Rows.Count>0)
			{
				if(ds.Tables[0].Rows[0]["Id"].ToString()!="")
				{
					model.Id=int.Parse(ds.Tables[0].Rows[0]["Id"].ToString());
				}
				if(ds.Tables[0].Rows[0]["HomeWorkId"].ToString()!="")
				{
					model.HomeWorkId=int.Parse(ds.Tables[0].Rows[0]["HomeWorkId"].ToString());
				}
				model.UserId=ds.Tables[0].Rows[0]["UserId"].ToString();
				model.About=ds.Tables[0].Rows[0]["About"].ToString();
				model.Content=ds.Tables[0].Rows[0]["Content"].ToString();
				model.FileUrl=ds.Tables[0].Rows[0]["FileUrl"].ToString();
				model.Comment=ds.Tables[0].Rows[0]["Comment"].ToString();
				if(ds.Tables[0].Rows[0]["CreateTime"].ToString()!="")
				{
					model.CreateTime=DateTime.Parse(ds.Tables[0].Rows[0]["CreateTime"].ToString());
				}
				if(ds.Tables[0].Rows[0]["EditTime"].ToString()!="")
				{
					model.EditTime=DateTime.Parse(ds.Tables[0].Rows[0]["EditTime"].ToString());
				}
				if(ds.Tables[0].Rows[0]["State"].ToString()!="")
				{
					model.State=int.Parse(ds.Tables[0].Rows[0]["State"].ToString());
				}
				return model;
			}
			else
			{
				return null;
			}
		}

		/// <summary>
		/// б
		/// </summary>
		public DataSet GetList(string strWhere)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select Id,HomeWorkId,UserId,About,Content,FileUrl,Comment,CreateTime,EditTime,State ");
			strSql.Append(" FROM HS_SubmitWork ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			return DbHelperSQL.Query(strSql.ToString());
		}

		/// <summary>
		/// ǰ
		/// </summary>
		public DataSet GetList(int Top,string strWhere,string filedOrder)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select ");
			if(Top>0)
			{
				strSql.Append(" top "+Top.ToString());
			}
			strSql.Append(" Id,HomeWorkId,UserId,About,Content,FileUrl,Comment,CreateTime,EditTime,State ");
			strSql.Append(" FROM HS_SubmitWork ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			strSql.Append(" order by " + filedOrder);
			return DbHelperSQL.Query(strSql.ToString());
		}

		/*
		/// <summary>
		/// ҳȡб
		/// </summary>
		public DataSet GetList(int PageSize,int PageIndex,string strWhere)
		{
			SqlParameter[] parameters = {
					new SqlParameter("@tblName", SqlDbType.VarChar, 255),
					new SqlParameter("@fldName", SqlDbType.VarChar, 255),
					new SqlParameter("@PageSize", SqlDbType.Int),
					new SqlParameter("@PageIndex", SqlDbType.Int),
					new SqlParameter("@IsReCount", SqlDbType.Bit),
					new SqlParameter("@OrderType", SqlDbType.Bit),
					new SqlParameter("@strWhere", SqlDbType.VarChar,1000),
					};
			parameters[0].Value = "HS_SubmitWork";
			parameters[1].Value = "ID";
			parameters[2].Value = PageSize;
			parameters[3].Value = PageIndex;
			parameters[4].Value = 0;
			parameters[5].Value = 0;
			parameters[6].Value = strWhere;	
			return DbHelperSQL.RunProcedure("UP_GetRecordByPage",parameters,"ds");
		}*/

		#endregion  Ա
	}
}

