using System;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using WinStar.DBUtility;//
namespace WinStar.DAL
{
	/// <summary>
	/// ݷTerm
	/// </summary>
	public class Term
	{
		public Term()
		{}
		#region  Ա

		/// <summary>
		/// õID
		/// </summary>
		public int GetMaxId()
		{
		return DbHelperSQL.GetMaxID("Id", "HS_Term"); 
		}

		/// <summary>
		/// Ƿڸü¼
		/// </summary>
		public bool Exists(int Id)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select count(1) from HS_Term");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			return DbHelperSQL.Exists(strSql.ToString(),parameters);
		}


		/// <summary>
		/// һ
		/// </summary>
		public int Add(WinStar.Model.Term model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("insert into HS_Term(");
			strSql.Append("SId,Name,OneOrTwo,StartTime,FinishTime,BeginTime,EndTime,IsNow)");
			strSql.Append(" values (");
			strSql.Append("@SId,@Name,@OneOrTwo,@StartTime,@FinishTime,@BeginTime,@EndTime,@IsNow)");
			strSql.Append(";select @@IDENTITY");
			SqlParameter[] parameters = {
					new SqlParameter("@SId", SqlDbType.Int,4),
					new SqlParameter("@Name", SqlDbType.VarChar,50),
					new SqlParameter("@OneOrTwo", SqlDbType.Bit,1),
					new SqlParameter("@StartTime", SqlDbType.DateTime),
					new SqlParameter("@FinishTime", SqlDbType.DateTime),
					new SqlParameter("@BeginTime", SqlDbType.DateTime),
					new SqlParameter("@EndTime", SqlDbType.DateTime),
					new SqlParameter("@IsNow", SqlDbType.Bit,1)};
			parameters[0].Value = model.SId;
			parameters[1].Value = model.Name;
			parameters[2].Value = model.OneOrTwo;
			parameters[3].Value = model.StartTime;
			parameters[4].Value = model.FinishTime;
			parameters[5].Value = model.BeginTime;
			parameters[6].Value = model.EndTime;
			parameters[7].Value = model.IsNow;

			object obj = DbHelperSQL.GetSingle(strSql.ToString(),parameters);
			if (obj == null)
			{
				return 1;
			}
			else
			{
				return Convert.ToInt32(obj);
			}
		}
		/// <summary>
		/// һ
		/// </summary>
		public void Update(WinStar.Model.Term model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("update HS_Term set ");
			strSql.Append("SId=@SId,");
			strSql.Append("Name=@Name,");
			strSql.Append("OneOrTwo=@OneOrTwo,");
			strSql.Append("StartTime=@StartTime,");
			strSql.Append("FinishTime=@FinishTime,");
			strSql.Append("BeginTime=@BeginTime,");
			strSql.Append("EndTime=@EndTime,");
			strSql.Append("IsNow=@IsNow");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4),
					new SqlParameter("@SId", SqlDbType.Int,4),
					new SqlParameter("@Name", SqlDbType.VarChar,50),
					new SqlParameter("@OneOrTwo", SqlDbType.Bit,1),
					new SqlParameter("@StartTime", SqlDbType.DateTime),
					new SqlParameter("@FinishTime", SqlDbType.DateTime),
					new SqlParameter("@BeginTime", SqlDbType.DateTime),
					new SqlParameter("@EndTime", SqlDbType.DateTime),
					new SqlParameter("@IsNow", SqlDbType.Bit,1)};
			parameters[0].Value = model.Id;
			parameters[1].Value = model.SId;
			parameters[2].Value = model.Name;
			parameters[3].Value = model.OneOrTwo;
			parameters[4].Value = model.StartTime;
			parameters[5].Value = model.FinishTime;
			parameters[6].Value = model.BeginTime;
			parameters[7].Value = model.EndTime;
			parameters[8].Value = model.IsNow;

			DbHelperSQL.ExecuteSql(strSql.ToString(),parameters);
		}

		/// <summary>
		/// ɾһ
		/// </summary>
		public void Delete(int Id)
		{
			
			StringBuilder strSql=new StringBuilder();
			strSql.Append("delete from HS_Term ");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			DbHelperSQL.ExecuteSql(strSql.ToString(),parameters);
		}


		/// <summary>
		/// õһʵ
		/// </summary>
		public WinStar.Model.Term GetModel(int Id)
		{
			
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select  top 1 Id,SId,Name,OneOrTwo,StartTime,FinishTime,BeginTime,EndTime,IsNow from HS_Term ");
			strSql.Append(" where Id=@Id ");
			SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)};
			parameters[0].Value = Id;

			WinStar.Model.Term model=new WinStar.Model.Term();
			DataSet ds=DbHelperSQL.Query(strSql.ToString(),parameters);
			if(ds.Tables[0].Rows.Count>0)
			{
				if(ds.Tables[0].Rows[0]["Id"].ToString()!="")
				{
					model.Id=int.Parse(ds.Tables[0].Rows[0]["Id"].ToString());
				}
				if(ds.Tables[0].Rows[0]["SId"].ToString()!="")
				{
					model.SId=int.Parse(ds.Tables[0].Rows[0]["SId"].ToString());
				}
				model.Name=ds.Tables[0].Rows[0]["Name"].ToString();
				if(ds.Tables[0].Rows[0]["OneOrTwo"].ToString()!="")
				{
					if((ds.Tables[0].Rows[0]["OneOrTwo"].ToString()=="1")||(ds.Tables[0].Rows[0]["OneOrTwo"].ToString().ToLower()=="true"))
					{
						model.OneOrTwo=true;
					}
					else
					{
						model.OneOrTwo=false;
					}
				}
				if(ds.Tables[0].Rows[0]["StartTime"].ToString()!="")
				{
					model.StartTime=DateTime.Parse(ds.Tables[0].Rows[0]["StartTime"].ToString());
				}
				if(ds.Tables[0].Rows[0]["FinishTime"].ToString()!="")
				{
					model.FinishTime=DateTime.Parse(ds.Tables[0].Rows[0]["FinishTime"].ToString());
				}
				if(ds.Tables[0].Rows[0]["BeginTime"].ToString()!="")
				{
					model.BeginTime=DateTime.Parse(ds.Tables[0].Rows[0]["BeginTime"].ToString());
				}
				if(ds.Tables[0].Rows[0]["EndTime"].ToString()!="")
				{
					model.EndTime=DateTime.Parse(ds.Tables[0].Rows[0]["EndTime"].ToString());
				}
				if(ds.Tables[0].Rows[0]["IsNow"].ToString()!="")
				{
					if((ds.Tables[0].Rows[0]["IsNow"].ToString()=="1")||(ds.Tables[0].Rows[0]["IsNow"].ToString().ToLower()=="true"))
					{
						model.IsNow=true;
					}
					else
					{
						model.IsNow=false;
					}
				}
				return model;
			}
			else
			{
				return null;
			}
		}

		/// <summary>
		/// б
		/// </summary>
		public DataSet GetList(string strWhere)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select Id,SId,Name,OneOrTwo,StartTime,FinishTime,BeginTime,EndTime,IsNow ");
			strSql.Append(" FROM HS_Term ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			return DbHelperSQL.Query(strSql.ToString());
		}

		/// <summary>
		/// ǰ
		/// </summary>
		public DataSet GetList(int Top,string strWhere,string filedOrder)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select ");
			if(Top>0)
			{
				strSql.Append(" top "+Top.ToString());
			}
			strSql.Append(" Id,SId,Name,OneOrTwo,StartTime,FinishTime,BeginTime,EndTime,IsNow ");
			strSql.Append(" FROM HS_Term ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			strSql.Append(" order by " + filedOrder);
			return DbHelperSQL.Query(strSql.ToString());
		}

		/*
		/// <summary>
		/// ҳȡб
		/// </summary>
		public DataSet GetList(int PageSize,int PageIndex,string strWhere)
		{
			SqlParameter[] parameters = {
					new SqlParameter("@tblName", SqlDbType.VarChar, 255),
					new SqlParameter("@fldName", SqlDbType.VarChar, 255),
					new SqlParameter("@PageSize", SqlDbType.Int),
					new SqlParameter("@PageIndex", SqlDbType.Int),
					new SqlParameter("@IsReCount", SqlDbType.Bit),
					new SqlParameter("@OrderType", SqlDbType.Bit),
					new SqlParameter("@strWhere", SqlDbType.VarChar,1000),
					};
			parameters[0].Value = "HS_Term";
			parameters[1].Value = "ID";
			parameters[2].Value = PageSize;
			parameters[3].Value = PageIndex;
			parameters[4].Value = 0;
			parameters[5].Value = 0;
			parameters[6].Value = strWhere;	
			return DbHelperSQL.RunProcedure("UP_GetRecordByPage",parameters,"ds");
		}*/

		#endregion  Ա
	}
}

