﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Admin_AdminEdit : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                int id = 0;
                try
                {
                    id = Convert.ToInt32(Request.QueryString["id"]);                    
                }
                catch { Common.alert("抱歉，您访问的地址不存在！", "AdminList.aspx"); }

                if (id == 0)
                    Common.alert("抱歉，您访问的地址不存在！", "AdminList.aspx");
                else                
                    this.LoadAdminUserInfo(id);                
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！","AdminList.aspx");
            }
        }
    }
    /// <summary>
    /// 加载用户信息方法
    /// </summary>
    /// <param name="id"></param>
    protected void LoadAdminUserInfo(int id)
    {
        try
        {
            WinStar.Model.Admin model = new WinStar.BLL.Admin().GetModel(id);

            this.ltUserName.Text = model.UserName;
            this.txtTel.Text = model.TelPhone;
            this.txtUserTrueName.Text = model.TrueName;
            this.rdoBtnSexList.SelectedValue = model.Sex == true ? "男" : "女";
            this.ddlGroupList.SelectedValue = model.GroupId.ToString();
            this.ddlState.SelectedValue = model.State.ToString();
        }
        catch { }
    }
    /// <summary>
    /// 提交按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (IsValid)
        {
            try
            {
                WinStar.Model.Admin model = new WinStar.BLL.Admin().GetModel(Convert.ToInt32(Request.QueryString["id"]));

                model.GroupId = Convert.ToInt32(this.ddlGroupList.SelectedValue);
                if (this.txtUserPwd.Text.Trim() != "")
                    model.PassWord = Common.Md5(this.txtUserPwd.Text.Trim());
                model.Sex = this.rdoBtnSexList.SelectedValue == "男" ? true : false;
                model.State = Convert.ToInt32(this.ddlState.SelectedValue);
                model.TelPhone = this.txtTel.Text.Trim();
                model.TrueName = this.txtUserTrueName.Text.Trim();

                new WinStar.BLL.Admin().Update(model);

                Common.alert("修改成功！","AdminList.aspx");
            }
            catch { Common.alert("修改失败，请重试！"); }
        }
    }
}