﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Admin_AdminList : AdminPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                int id = 0;
                try
                {
                    id = Convert.ToInt32(Request.QueryString["id"]);
                }
                catch { }

                if (id != 0)
                {
                    if (!this.DelAdminById(id))
                    {
                        Common.alert("删除失败，请重试！");
                    }
                }
            }
            this.LoadAdminList();
        }
    }
    /// <summary>
    /// 删除管理员
    /// </summary>
    /// <param name="id">管理员id</param>
    /// <returns>返回bool类型值，标识是否删除成功</returns>
    private bool DelAdminById(int id)
    {
        bool result = false;
        try
        {
            new WinStar.BLL.Admin().Delete(id);
            result = true;
        }
        catch { }
        return result;
    }
    /// <summary>
    /// 加载管理员列表
    /// </summary>
    protected void LoadAdminList()
    {
        try
        {
            WinStar.BLL.Admin bll = new WinStar.BLL.Admin();

            PagedDataSource pds = new PagedDataSource();
            DataTable dt = bll.GetAllList().Tables[0];

            pds.DataSource = dt.DefaultView;
            this.AspNetPager1.RecordCount = pds.Count;
            pds.AllowPaging = true;
            pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
            pds.PageSize = AspNetPager1.PageSize;

            this.rptAdminList.DataSource = pds;
            this.rptAdminList.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 分页控件页索引更改事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        this.LoadAdminList();
    }
    /// <summary>
    /// 删除所选按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnDeleteAll_Click(object sender, EventArgs e)
    {
        try
        {
            System.Text.StringBuilder sql = new System.Text.StringBuilder();
            sql.Append("delete from HS_Admin where");
            sql.Append(" Id in ");
            sql.Append(this.hidSelectedIds.Value);

            System.Collections.Hashtable hashtable = new System.Collections.Hashtable();
            hashtable.Add(sql, null);

            WinStar.DBUtility.DbHelperSQL.ExecuteSqlTran(hashtable);

            Common.alert("删除成功！", "AdminList.aspx");
        }
        catch { Common.alert("删除失败，请重试！"); }
    }
}