﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Admin_ClassList : AdminPageBase
{
    WinStar.BLL.Class t = new WinStar.BLL.Class();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Request["Id"] != "" && Request["Id"] != null)
            {
                ViewState["Id"] = Request["Id"];
                BindList();
                if (Request["Action"] != "" && Request["Action"] != null)
                {
                    DeleteData(ViewState["Id"].ToString(), Request["ClassId"].ToString());
                }
            }
            else
            {
                Common.alert("请用正确的浏览方式浏览", "GradeList.aspx");
            }
        }
    }
    protected void BindList()
    {
        try
        {
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query("Select g.TypeAge,g.YearIn,c.Id,c.ClassNum,c.GId From HS_Class c,HS_Grade g Where c.GId=g.Id And c.GId=" + ViewState["Id"] + " Order by c.ClassNum ASC").Tables[0];
            
            this.Repeater1.DataSource = dt;
            this.Repeater1.DataBind();
        }
        catch { }
    } 
    /// <summary>
    /// 删 除
    /// </summary>
    /// <param name="id"></param>
    protected void DeleteData(string id, string classid)
    {
        try
        {
            t.Delete(int.Parse(classid));
            //更新班级数目
            WinStar.Model.Grade g = new WinStar.BLL.Grade().GetModel(int.Parse(ViewState["Id"].ToString()));//读取年级信息
            g.Num = t.GetList("GId=" + ViewState["Id"]).Tables[0].Rows.Count;//读取班级数目
            new WinStar.BLL.Grade().Update(g);//更新年级信息；

            Response.Redirect("ClassList.aspx?Id=" + ViewState["Id"]);
        }
        catch { Common.alert("删除失败，请重试！"); }
    }
    
    protected string GetStudentNum(string Id)
    {
        int num = new WinStar.BLL.Student().GetList("ClassId=" + Id).Tables[0].Rows.Count;
        return num.ToString() + "人";
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="yein">入学年份</param>
    /// <param name="isgrade">学段</param>
    /// <returns></returns>
    protected string GetGradeName(string yein, int isgrade)
    {
        int nowterm;//当前学期年份
        bool onetwo;//当前学期是第一学期还是第二学期
        DataTable dt = new WinStar.BLL.Term().GetList("IsNow=1").Tables[0];
        if (dt.Rows.Count > 0)
        {
            nowterm = DateTime.Parse(dt.Rows[0]["StartTime"].ToString()).Year;
            onetwo = Boolean.Parse(dt.Rows[0]["OneOrTwo"].ToString());
            return GetHowGrade(nowterm, int.Parse(yein), onetwo, isgrade);

        }
        else
        {
            return "<font color=red>请先设置好学期</font> <a href=TermList.aspx>点击这里</a>";
        }
    }
    /// <summary>
    /// 获取当前是几年级
    /// </summary>
    /// <param name="NowTerm">目前设置的学期是哪一年的</param>
    /// <param name="YeIn">入学年份</param>
    /// <param name="onetwo">目前是第一学期[false]还是第二学期[true] </param>
    /// <param name="isgrade">学段1 小学 2初中 3 高中</param>
    /// <returns></returns>
    protected string GetHowGrade(int NowTerm, int YeIn, bool onetwo, int isgrade)
    {
        int isclass, ot;
        if (!onetwo)
        {
            ot = 1;
        }
        else
        {
            ot = 0;
        }
        isclass = NowTerm - YeIn + ot;
        if (isclass <= 0)
        {
            return "<font color=red>还没开学</font>";
        }
        else if (isclass > 6 && isgrade == 1)
        {

            return "<font color=red>已经毕业</font>";
        }
        else if (isclass > 3 && (isgrade == 2 || isgrade == 3))
        {

            return "<font color=red>已经毕业</font>";
        }
        else
        {
            return GetTypeAge(isgrade.ToString()) + isclass.ToString() + "年级";
        }
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="str">年级数字</param>
    /// <returns></returns>
    protected string GetTypeAge(string str)
    {
        if (str == "1")
        {
            return "小学";
        }
        else if (str == "2")
        {
            return "初中";
        }
        else
        {
            return "高中";
        }
    }
}