﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Admin_DataTypeList : AdminPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Request["Type"] != null && Request["Type"].ToString() == "Del")
            {
                if (!string.IsNullOrEmpty(Request.QueryString["id"]))
                {
                    TypeDel(Request.QueryString["id"]);
                }
            }
            else
            {
                bindlist();
            }
        }
    }
    
    protected void bindlist()
    {
        try
        {
            WinStar.BLL.DataType n = new WinStar.BLL.DataType();
            this.noticeList.DataSource = n.GetList("");
            PagedDataSource pds = new PagedDataSource();
            DataTable dt = n.GetList("1=1 order by id desc").Tables[0];

            dt.Columns.Add("Num");
            for (int i = 0; i < dt.Rows.Count;i++ )
            {
                dt.Rows[i]["Num"] = i + 1;
            }

            pds.DataSource = dt.DefaultView;
            this.AspNetPager1.RecordCount = pds.Count;
            pds.AllowPaging = true;

            pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
            pds.PageSize = AspNetPager1.PageSize;

            this.noticeList.DataSource = pds;
            this.noticeList.DataBind();
        }
        catch { }
    }

    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        bindlist();
    }
    
    protected void TypeDel(string id)
    {
        try
        {
            WinStar.BLL.DataType u = new WinStar.BLL.DataType();

            u.Delete(int.Parse(id));
            Common.alert("删除成功", "DataTypeList.aspx");
        }
        catch {}
    }
}