﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Admin_GradeAdd : AdminPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }
    protected void btn1_Click(object sender, EventArgs e)
    {
        try
        {
            //首先判断年份输入是否在指定范围
            //获取当前年份，条件一：设置的当前学期是哪个年份的
            int fanwei;
            DataTable dt = new WinStar.BLL.Term().GetList("IsNow=1").Tables[0];
            if (dt.Rows.Count > 0)
            {
                fanwei = DateTime.Parse(dt.Rows[0]["StartTime"].ToString()).Year;
            }
            else
            {
                Common.alert("请先设置好当前学期是哪个学期！", "TermList.aspx");
                return;
            }

            //判断范围
            if (this.TypeAge.Text == "1")
            {
                if (int.Parse(this.YearIn.Text) < (fanwei - 6) || int.Parse(this.YearIn.Text) > (fanwei + 1))
                {
                    Common.alert("小学的入学年份范围是" + (fanwei - 6) + "到" + (fanwei + 1) + "，请重新输入！");
                    return;
                }
            }
            else
            {
                if (int.Parse(this.YearIn.Text) < (fanwei - 3) || int.Parse(this.YearIn.Text) > (fanwei + 1))
                {
                    Common.alert("初中和高中的入学年份范围是" + (fanwei - 3) + "到" + (fanwei + 1) + "请重新输入！");
                    return;
                }
            }

            WinStar.BLL.Grade g = new WinStar.BLL.Grade();

            //判断是否存在这样的年级
            DataTable dt1 = g.GetList("YearIn=" + this.YearIn.Text + " and TypeAge=" + this.TypeAge.SelectedValue).Tables[0];
            if (dt1.Rows.Count > 0)
            {
                Common.alert("已经存在这样的年级，请重新输入!");
                return;
            }

            WinStar.Model.Grade gr = new WinStar.Model.Grade();
            gr.Num = int.Parse(this.Num.Text);
            gr.SId = 1;
            gr.TypeAge = int.Parse(this.TypeAge.SelectedValue);
            gr.YearIn = int.Parse(this.YearIn.Text);

            int num = g.Add(gr);
            if (num > 0)
            {
                for (int i = 1; i <= int.Parse(this.Num.Text); i++)
                {
                    AddClass(num, i);
                }
                Common.alert("年级添加成功！", "GradeList.aspx");
            }
            else
            {
                Common.alert("添加失败，请重试或者联系管理员！");
            }
        }
        catch { Common.alert("添加失败，请重试！"); }
    }
    /// <summary>
    /// 班级添加
    /// </summary>
    /// <param name="num">年级ID</param>
    /// <param name="isNum">第几个班级</param>
    protected void AddClass(int num,int isNum)
    {
        WinStar.BLL.Class c = new WinStar.BLL.Class();
        WinStar.Model.Class cl = new WinStar.Model.Class();
        cl.ClassNum = isNum;
        cl.GId = num;
        c.Add(cl);
    }
}