﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Admin_GradeList : AdminPageBase
{
    WinStar.BLL.Grade t = new WinStar.BLL.Grade();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["Id"]))
            {
                DeleteData(Request.QueryString["Id"]);
            }
            else
            {
                BindList();
            }
        }
    }
    protected void BindList()
    {
        try
        {
            DataTable dt = t.GetList("1=1").Tables[0];
            this.Repeater1.DataSource = t.GetList("1=1");
            this.Repeater1.DataBind();
        }
        catch{}
    }
    /// <summary>
    /// 删除
    /// </summary>
    /// <param name="id"></param>
    protected void DeleteData(string id)
    {
        try
        {
            t.Delete(int.Parse(id));
            Response.Redirect("GradeList.aspx");
        }
        catch {}
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="yein">入学年份</param>
    /// <param name="isgrade">学段</param>
    /// <returns></returns>
    protected string GetGradeName(string yein, int isgrade)
    {
        int nowterm;//当前学期年份
        bool onetwo;//当前学期是第一学期还是第二学期
        DataTable dt = new WinStar.BLL.Term().GetList("IsNow=1").Tables[0];
        if (dt.Rows.Count > 0)
        {
            nowterm = DateTime.Parse(dt.Rows[0]["StartTime"].ToString()).Year;
            onetwo = Boolean.Parse(dt.Rows[0]["OneOrTwo"].ToString());
            return GetHowGrade(nowterm, int.Parse(yein), onetwo, isgrade);

        }
        else
        {
            return "<font color=red>请先设置好学期</font> <a href=TermList.aspx>点击这里</a>";
        }
    }
    /// <summary>
    /// 获取当前是几年级
    /// </summary>
    /// <param name="NowTerm">目前设置的学期是哪一年的</param>
    /// <param name="YeIn">入学年份</param>
    /// <param name="onetwo">目前是第一学期[false]还是第二学期[true] </param>
    /// <param name="isgrade">学段1 小学 2初中 3 高中</param>
    /// <returns></returns>
    protected string GetHowGrade(int NowTerm, int YeIn, bool onetwo, int isgrade)
    {
        int isclass, ot;
        if (!onetwo) 
        { 
            ot = 1; 
        }
        else { 
            ot = 0; 
        }
        isclass = NowTerm - YeIn + ot;
        if (isclass <= 0)
        {
            return "<font color=red>还没开学</font>";
        }
        else if (isclass > 6 && isgrade == 1)
        {

            return "<font color=red>已经毕业</font>";
        }
        else if (isclass > 3 && (isgrade == 2 || isgrade == 3))
        {

            return "<font color=red>已经毕业</font>";
        }
        else
        {
            return GetTypeAge(isgrade.ToString()) + isclass.ToString() + "年级";
        }
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="str">年级数字</param>
    /// <returns></returns>
    protected string GetTypeAge(string str)
    {
        if (str == "1")
        {
            return "小学";
        }
        else if (str == "2")
        {
            return "初中";
        }
        else
        {
            return "高中";
        }
    }
}