﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Admin_Login : System.Web.UI.Page
{
    protected string TitleString = "家校互通平台 - 后台登录";
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            //加载系统信息
            this.GetSysInfo();
        }
    }
    /// <summary>
    /// 登录按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnLogin_Click(object sender, EventArgs e)
    {
        if (IsValid)
        {
            //比对验证码
            string verCode = this.txtImgCode.Text.Trim();

            if (Session["randCode"] == null)
            {
                Common.alert("验证码失效");
            }
            else if (!verCode.ToLower().Equals(Session["randCode"].ToString().ToLower()))
            {
                Common.alert("验证码错误");
            }
            else
            {
                try
                {
                    WinStar.BLL.Admin bll = new WinStar.BLL.Admin();
                    string sqlWhere = string.Format(" UserName='{0}'", this.txtLoginName.Text.Trim());
                    List<WinStar.Model.Admin> list = bll.GetModelList(sqlWhere);

                    if (list.Count > 0)
                    {
                        WinStar.Model.Admin model = list[0];

                        if (model.PassWord == Common.Md5(this.txtLoginPwd.Text.Trim())) //比对用户密码是否输入正确
                        {
                            if (model.State != 1)
                            {
                                Common.alert("当前帐户已被禁用");
                            }
                            else
                            {
                                HttpCookie cookie = new HttpCookie("AdminMaster");
                                cookie.Values["UserName"] = model.UserName;
                                cookie.Values["AdminId"] = model.Id.ToString();
                                cookie.Values["GroupId"] = model.GroupId.ToString();

                                Response.Cookies.Add(cookie);
                                Session["UserName"] = model.UserName; //用户名
                                Session["AdminId"] = model.Id.ToString();
                                Session["GroupId"] = model.GroupId.ToString();

                                Response.Redirect("Default.aspx");
                            }
                        }
                        else //密码错误
                        {
                            Common.alert("用户名或密码不正确");
                        }
                    }
                    else //未查询到结果
                    {
                        Common.alert("用户名或密码不正确");
                    }
                }
                catch { }
            }
        }
    }
    /// <summary>
    /// 读取信息方法
    /// </summary>
    private void GetSysInfo()
    {
        try
        {
            WinStar.Model.Config model=new WinStar.BLL.Config().GetModel(1);
            this.ltSchoolName.Text = model.SName;
            this.ltSysName.Text = model.SystemName;

            this.TitleString = model.SystemName + " - 后台登录";
        }
        catch { }
    }
}