﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Admin_NewsList : AdminPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Request["Type"] != null && Request["Type"].ToString() == "Del")
            {
                if (!string.IsNullOrEmpty(Request.QueryString["id"]))
                {
                    TypeDel(Request.QueryString["id"]);
                }
            }
            else
            {
                bindlist();
            }
        }
    }
    
    protected void bindlist()
    {
        try
        {
            WinStar.BLL.News n = new WinStar.BLL.News();
            this.newsList.DataSource = n.GetList("");
            PagedDataSource pds = new PagedDataSource();
            string str = "select n.*,t.name from HS_News n,HS_NewsType t where n.classid=t.id order by n.id desc ";
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(str).Tables[0];
            pds.DataSource = dt.DefaultView;
            this.AspNetPager1.RecordCount = pds.Count;
            pds.AllowPaging = true;

            pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
            pds.PageSize = AspNetPager1.PageSize;

            this.newsList.DataSource = pds;
            this.newsList.DataBind();
        }
        catch { }
    }

    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        bindlist();
    }
    
    protected void TypeDel(string id)
    {
        try
        {
            WinStar.BLL.News u = new WinStar.BLL.News();

            u.Delete(int.Parse(id));
            Common.alert("删除成功", "NewsList.aspx");
        }
        catch{}
    }

    /// <summary>
    /// 批量删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnRpt_Click(object sender, EventArgs e)
    {
        try
        {
            foreach (RepeaterItem Item in this.newsList.Items)
            {
                System.Web.UI.HtmlControls.HtmlInputCheckBox chk = (System.Web.UI.HtmlControls.HtmlInputCheckBox)Item.FindControl("ckbIndex");
                if (chk.Checked)
                {
                    new WinStar.BLL.News().Delete(int.Parse(chk.Value));
                }
            }
            Common.alert("删除成功！", "NewsList.aspx");
        }
        catch
        {
            Common.alert("删除失败，请重试！");
        }
    }
}