﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Admin_NoticeList : AdminPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Request["Type"] != null && Request["Type"].ToString() == "Del")
            {
                if (!string.IsNullOrEmpty(Request.QueryString["id"]))
                {
                    NoticeDel(Request.QueryString["id"]);
                }
            }
            else
            {
                bindlist();
            }
        }
    }
    protected void bindlist()
    {
        try
        {
            WinStar.BLL.Notice n = new WinStar.BLL.Notice();
            this.noticeList.DataSource = n.GetList("");
            PagedDataSource pds = new PagedDataSource();
            DataTable dt = n.GetList("classid=0 order by id desc").Tables[0];
            pds.DataSource = dt.DefaultView;
            this.AspNetPager1.RecordCount = pds.Count;
            pds.AllowPaging = true;

            pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
            pds.PageSize = AspNetPager1.PageSize;

            this.noticeList.DataSource = pds;
            this.noticeList.DataBind();
        }
        catch { }
    }
    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        bindlist();
    }
    protected void NoticeDel(string id)
    {
        try
        {
            WinStar.BLL.Notice u = new WinStar.BLL.Notice();

            u.Delete(int.Parse(id));
        }
        catch { Common.alert("删除失败，请重试！"); }
    }

    /// <summary>
    /// 批量删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnRpt_Click(object sender, EventArgs e)
    {
        try
        {
            foreach (RepeaterItem Item in this.noticeList.Items)
            {
                System.Web.UI.HtmlControls.HtmlInputCheckBox chk = (System.Web.UI.HtmlControls.HtmlInputCheckBox)Item.FindControl("ckbIndex");
                if (chk.Checked)
                {
                    new WinStar.BLL.Notice().Delete(int.Parse(chk.Value));
                }
            }
            Common.alert("删除成功", "NoticeList.aspx");
        }
        catch
        {
            Common.alert("删除出错，请重试");
        }
    }
}