﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Admin_StarTeacherEdit : AdminPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {

        if (!IsPostBack)
        {
            subjieclist();
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                LoadStarTeacherInfo();
            }
        }
    }

    private void LoadStarTeacherInfo()
    {
        try
        {
            WinStar.BLL.StarTeacher n = new WinStar.BLL.StarTeacher();
            WinStar.Model.StarTeacher mn = n.GetModel(int.Parse(Request["id"].ToString()));
            ViewState["Nid"] = Request["id"].ToString();
            this.truename.Text = mn.TrueName;
            if (mn.Sex == true)
            {
                this.RadioButton1.Checked = true;
            }
            else
            {
                this.RadioButton2.Checked = true;
            }
            this.Aptitude.Text = mn.Aptitude;
            this.Summary.Value = mn.About;

            string[] sArray = mn.Subjects.Split(',');
            foreach (string x in sArray)
            {
                for (int i = 0; i < this.CheckBoxList1.Items.Count; i++)
                {
                    if (x.ToString().IndexOf(CheckBoxList1.Items[i].Text) > -1)
                    {
                        CheckBoxList1.Items[i].Selected = true;
                    }
                }
            }
        }
        catch {}
    }
    protected void subjieclist()
    {
        this.CheckBoxList1.DataSource = new WinStar.BLL.Subject().GetAllList();
        this.CheckBoxList1.DataTextField = "name";
        this.CheckBoxList1.DataValueField = "id";
        this.CheckBoxList1.DataBind();
    }

    protected void btn1_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                string PicURL = string.Empty;
                if (!string.IsNullOrEmpty(this.FileUpload1.PostedFile.FileName))
                {
                    string filename1 = FileUpload1.PostedFile.FileName;
                    string ext = filename1.Substring(filename1.LastIndexOf(".")).ToLower();
                    if (ext != ".gif" && ext != ".jpg" && ext != ".jpeg" && ext != ".bmp" && ext != ".png")
                    {
                        Response.Write("<script>alert('图片文件格式不对!支持JPG、GIF、PNG、BMP格式。');history.back(-1);</script>");
                        return;
                    }
                    else
                    {
                        string filename2 = DateTime.Now.ToString("yyyyMMddhhmmss");
                        string path = Server.MapPath("/UploadFile/teacher/");
                        if (!Directory.Exists(path))
                        {
                            Directory.CreateDirectory(path);
                        }
                        string fpath = path + filename2 + ext;
                        FileUpload1.SaveAs(fpath);
                        PicURL = "/UploadFile/teacher/" + filename2 + ext;
                    }
                }

                string content = this.Summary.Value;
                WinStar.BLL.StarTeacher n = new WinStar.BLL.StarTeacher();
                WinStar.Model.StarTeacher m = n.GetModel(int.Parse(ViewState["Nid"].ToString()));
                m.TrueName = this.truename.Text;
                m.About = content;
                if (this.RadioButton1.Checked)
                {
                    m.Sex = true;
                }
                else
                {
                    m.Sex = false;
                }
                if (PicURL != "")
                {
                    m.PicUrl = PicURL;
                }
                m.Aptitude = this.Aptitude.Text;
                string subject = string.Empty;
                for (int i = 0; i <= this.CheckBoxList1.Items.Count - 1; i++)
                {
                    if (this.CheckBoxList1.Items[i].Selected)
                    {
                        subject += this.CheckBoxList1.Items[i].Text.ToString() + ",";
                    }
                }
                m.Subjects = subject.TrimEnd(',');
                n.Update(m);
                Common.alert("修改成功！", "StarTeacherlist.aspx");
            }
            catch { Common.alert("修改失败，请重试！"); }
        }
    }
}