﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Admin_StarTeacherList : AdminPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Request["Type"] != null && Request["Type"].ToString() == "Del")
            {
                if (!string.IsNullOrEmpty(Request.QueryString["id"]))
                {
                    TeacherDel(Request.QueryString["id"]);
                }
            }
            else
            {
                bindlist();
            }
        }
    }
    protected void bindlist()
    {
        try
        {
            WinStar.BLL.StarTeacher n = new WinStar.BLL.StarTeacher();
            this.teacherList.DataSource = n.GetList("");
            PagedDataSource pds = new PagedDataSource();
            DataTable dt = n.GetList("1=1 order by id desc").Tables[0];
            pds.DataSource = dt.DefaultView;
            this.AspNetPager1.RecordCount = pds.Count;
            pds.AllowPaging = true;

            pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
            pds.PageSize = AspNetPager1.PageSize;

            this.teacherList.DataSource = pds;
            this.teacherList.DataBind();
        }
        catch { }
    }
    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        bindlist();
    }
    protected void TeacherDel(string id)
    {
        try
        {
            WinStar.BLL.StarTeacher u = new WinStar.BLL.StarTeacher();

            u.Delete(int.Parse(id));
        }
        catch { Common.alert("删除失败，请重试！"); }
    }

    /// <summary>
    /// 批量删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnRpt_Click(object sender, EventArgs e)
    {
        try
        {
            foreach (RepeaterItem Item in this.teacherList.Items)
            {
                System.Web.UI.HtmlControls.HtmlInputCheckBox chk = (System.Web.UI.HtmlControls.HtmlInputCheckBox)Item.FindControl("ckbIndex");
                if (chk.Checked)
                {
                    new WinStar.BLL.StarTeacher().Delete(int.Parse(chk.Value));
                }
            }
            Common.alert("删除成功！", "StarTeacherList.aspx");
        }
        catch
        {
            Common.alert("删除失败，请重试！");
        }
    }
}