﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Admin_StudentAdd : AdminPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            getPost();
            typeAdd();
            typeSelect();
            gradeSelect();
        }
    }

    public void typeAdd()
    {
        ddlType.Items.Clear();
        ddlType.Items.Add(new ListItem("小学", "1"));
        ddlType.Items.Add(new ListItem("初中", "2"));
        ddlType.Items.Add(new ListItem("高中", "3"));
    }

    public void getPost()
    {
        WinStar.BLL.StudentPost bll = new WinStar.BLL.StudentPost();
        dplPost.DataSource = bll.GetAllList().Tables[0];
        dplPost.DataValueField = "Id";//显示的文字
        dplPost.DataTextField = "Name";//选项值
        dplPost.DataBind();
        dplPost.Items.Add(new ListItem("无职务", "0"));
    }

    protected void btn1_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                WinStar.Model.Student info = new WinStar.Model.Student();
                info.Num = txtnum.Text;
                info.PassWord = txtpwd.Text;
                info.TrueName = txttruename.Text;
                if (radiom.Checked)
                {
                    info.Sex = true;
                }
                else if (radiow.Checked)
                {
                    info.Sex = false;
                }
                if (dplPost.SelectedValue.ToString() == "无职务")
                {
                    info.PostId = 0;
                }
                else
                {
                    info.PostId = Convert.ToInt32(dplPost.SelectedValue);
                }
                info.ParentPWD = txtpwd.Text;
                info.ClassId = Convert.ToInt32(ddlClass.SelectedValue);
                int count = new WinStar.BLL.Student().Add(info);
                if (count > 0)
                {
                    Common.alert("添加成功！", "StudentList.aspx");
                }
                else
                {
                    Common.alert("添加失败，请重试！", "StudentAdd.aspx");
                }
            }
            catch { Common.alert("添加失败，请重试！"); }
        }
    }

    protected string getG(int NowTerm, int YeIn, bool onetwo, int isgrade)
    {
        int isclass, ot;
        if (!onetwo)
        {
            ot = 0;
        }
        else
        {
            ot = 1;
        }
        isclass = NowTerm - YeIn + ot;
        isclass = isclass + 1;
        if (isclass <= 0)
        {
            return "";
        }
        else if (isclass > 6 && isgrade == 1)
        {

            return "";
        }
        else if (isclass > 3 && (isgrade == 2 || isgrade == 3))
        {

            return "";
        }
        else
        {
            return isclass.ToString();
        }
    }


    public void typeSelect()
    {
        int typeAge = Convert.ToInt32(ddlType.SelectedValue);
        int nowterm = 0;//当前学期年份
        bool onetwo = true;//当前学期是第一学期还是第二学期
        DataTable dt1 = new WinStar.BLL.Term().GetList("IsNow=1").Tables[0];
        if (dt1.Rows.Count > 0)
        {
            nowterm = DateTime.Parse(dt1.Rows[0]["StartTime"].ToString()).Year;
            onetwo = Boolean.Parse(dt1.Rows[0]["OneOrTwo"].ToString());
        }
        string isclass = "";
        DataTable dt = new WinStar.BLL.Grade().GetList("TypeAge=" + typeAge).Tables[0];
        List<int> list = new List<int>();
        List<int> listid = new List<int>();
        foreach (DataRow row in dt.Rows)
        {
            isclass = getG(nowterm, Convert.ToInt32(row["YearIn"]), onetwo, typeAge);
            if (isclass != "")
            {
                list.Add(Convert.ToInt32(isclass));
                listid.Add(Convert.ToInt32(row["Id"]));
            }
        }
        if (list.Count > 0)
        {
            ddlGrade.Items.Clear();
            for (int i = 0; i < list.Count; i++)
            {
                if (list[i] <= 3)
                {
                    ddlGrade.Items.Add(new ListItem(list[i].ToString(), listid[i].ToString()));
                }

            }
        }
        else
        {
            ddlGrade.Items.Clear();
            ddlGrade.Items.Add(new ListItem("暂无年级", "0"));
            ddlClass.Items.Clear();
            ddlClass.Items.Add(new ListItem("暂无班级", "0"));
        }





        //if (Convert.ToInt32(ddlType.SelectedValue) == 1)
        //{
        //    ddlGrade.Items.Clear();
        //    ddlGrade.Items.Add("1");
        //    ddlGrade.Items.Add("2");
        //    ddlGrade.Items.Add("3");
        //    ddlGrade.Items.Add("4");
        //    ddlGrade.Items.Add("5");
        //    ddlGrade.Items.Add("6");
        //}
        //else if (Convert.ToInt32(ddlType.SelectedValue) == 0)
        //{
        //    ddlGrade.Items.Clear();
        //    ddlClass.Items.Clear();
        //}

        //else
        //{
        //    ddlGrade.Items.Clear();
        //    ddlGrade.Items.Add("1");
        //    ddlGrade.Items.Add("2");
        //    ddlGrade.Items.Add("3");
        //}
    }
    protected void ddlType_SelectedIndexChanged(object sender, EventArgs e)
    {
        typeSelect();
        gradeSelect();
    }

    public void gradeSelect()
    {

        //int typeAge = Convert.ToInt32(ddlType.SelectedValue);
        //ddlGrade.Visible = true;
        //ddlGrade.DataSource = new WinStar.BLL.Grade().GetList("TypeAge=" + typeAge).Tables[0];
        //ddlGrade.DataBind();

        int typeAge = Convert.ToInt32(ddlType.SelectedValue);
        if (Convert.ToInt32(ddlGrade.SelectedValue) != 0)
        {
            int? yearin = new WinStar.BLL.Grade().GetModel(Convert.ToInt32(ddlGrade.SelectedValue)).YearIn;
            int gid = 0;
            DataTable dt = new WinStar.BLL.Grade().GetList("TypeAge =" + typeAge + " and YearIn = " + yearin).Tables[0];
            if (dt.Rows.Count == 0)
            {
                ddlClass.Items.Clear();
                ddlClass.Items.Add(new ListItem("暂无班级", "0"));
            }
            else
            {
                gid = Convert.ToInt32(dt.Rows[0]["Id"]);
                ddlClass.DataSource = new WinStar.BLL.Class().GetList("GId=" + gid + " order by ClassNum asc");
                ddlClass.DataTextField = "ClassNum";
                ddlClass.DataValueField = "Id";
                ddlClass.DataBind();
            }
        }
        else
        {
            ddlClass.Items.Clear();
            ddlClass.Items.Add(new ListItem("暂无班级", "0"));
        }


    }

    protected void ddlGrade_SelectedIndexChanged(object sender, EventArgs e)
    {
        gradeSelect();
    }

    /// <summary>
    /// 检测用户名验证事件
    /// </summary>
    /// <param name="source"></param>
    /// <param name="args"></param>
    protected void cvNum_ServerValidate(object source, ServerValidateEventArgs args)
    {
        try
        {
            string name = txtnum.Text;
            DataTable dt = new WinStar.BLL.Student().GetList("Num = '" + name + "'").Tables[0];
            int count = dt.Rows.Count;

            args.IsValid = count > 0 ? false : true;
        }
        catch { }
    }
}