﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.IO;
using System.Data.OleDb;
using System.Text;

public partial class Admin_StudentAllAdd : AdminPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            typeAdd();
            typeSelect();
            gradeSelect();
        }
    }

    public void typeAdd()
    {
        ddlType.Items.Clear();
        ddlType.Items.Add(new ListItem("小学", "1"));
        ddlType.Items.Add(new ListItem("初中", "2"));
        ddlType.Items.Add(new ListItem("高中", "3"));
    }
    protected string getG(int NowTerm, int YeIn, bool onetwo, int isgrade)
    {
        int isclass, ot;
        if (!onetwo)
        {
            ot = 0;
        }
        else
        {
            ot = 1;
        }
        isclass = NowTerm - YeIn + ot;
        isclass = isclass + 1;
        if (isclass <= 0)
        {
            return "";
        }
        else if (isclass > 6 && isgrade == 1)
        {

            return "";
        }
        else if (isclass > 3 && (isgrade == 2 || isgrade == 3))
        {

            return "";
        }
        else
        {
            return isclass.ToString();
        }
    }

    public void typeSelect()
    {
        int typeAge = Convert.ToInt32(ddlType.SelectedValue);
        int nowterm = 0;//当前学期年份
        bool onetwo = true;//当前学期是第一学期还是第二学期
        DataTable dt1 = new WinStar.BLL.Term().GetList("IsNow=1").Tables[0];
        if (dt1.Rows.Count > 0)
        {
            nowterm = DateTime.Parse(dt1.Rows[0]["StartTime"].ToString()).Year;
            onetwo = Boolean.Parse(dt1.Rows[0]["OneOrTwo"].ToString());
        }
        string isclass = "";
        DataTable dt = new WinStar.BLL.Grade().GetList("TypeAge=" + typeAge).Tables[0];
        List<int> list = new List<int>();
        List<int> listid = new List<int>();
        foreach (DataRow row in dt.Rows)
        {
            isclass = getG(nowterm, Convert.ToInt32(row["YearIn"]), onetwo, typeAge);
            if (isclass != "")
            {
                list.Add(Convert.ToInt32(isclass));
                listid.Add(Convert.ToInt32(row["Id"]));
            }
        }
        if (list.Count > 0)
        {
            ddlGrade.Items.Clear();
            for (int i = 0; i < list.Count; i++)
            {
                if (list[i] <= 3)
                {
                    ddlGrade.Items.Add(new ListItem(list[i].ToString(), listid[i].ToString()));
                }

            }
        }
        else
        {
            ddlGrade.Items.Clear();
            ddlGrade.Items.Add(new ListItem("暂无年级", "0"));
            ddlClass.Items.Clear();
            ddlClass.Items.Add(new ListItem("暂无班级", "0"));
        }
    }

    public void gradeSelect()
    {
        int typeAge = Convert.ToInt32(ddlType.SelectedValue);
        if (Convert.ToInt32(ddlGrade.SelectedValue) != 0)
        {
            int? yearin = new WinStar.BLL.Grade().GetModel(Convert.ToInt32(ddlGrade.SelectedValue)).YearIn;
            int gid = 0;
            DataTable dt = new WinStar.BLL.Grade().GetList("TypeAge =" + typeAge + " and YearIn = " + yearin).Tables[0];
            if (dt.Rows.Count == 0)
            {
                ddlClass.Items.Clear();
                ddlClass.Items.Add(new ListItem("暂无班级", "0"));
            }
            else
            {
                gid = Convert.ToInt32(dt.Rows[0]["Id"]);
                ddlClass.DataSource = new WinStar.BLL.Class().GetList("GId=" + gid + " order by ClassNum asc");
                ddlClass.DataTextField = "ClassNum";
                ddlClass.DataValueField = "Id";
                ddlClass.DataBind();
            }
        }
        else
        {
            ddlClass.Items.Clear();
            ddlClass.Items.Add(new ListItem("暂无班级", "0"));
        }
    }

    protected void down_Click(object sender, EventArgs e)
    {
        Response.Redirect("excel_upload/StudentModel.xls");
    }
    protected void ddlType_SelectedIndexChanged(object sender, EventArgs e)
    {
        typeSelect();
        gradeSelect();
    }
    protected void ddlGrade_SelectedIndexChanged(object sender, EventArgs e)
    {
        gradeSelect();
    }
    protected void btn2_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                if (this.FileUpload1.PostedFile != null)
                {
                    string filename1 = FileUpload1.PostedFile.FileName;
                    string ext = filename1.Substring(filename1.LastIndexOf(".")).ToLower();
                    if (ext != ".xls")
                    {
                        Common.alert("文件格式不对，请上传EXCEL文件", "");
                    }
                    else
                    {
                        string filename2 = DateTime.Now.ToString("yyyyMMddhhmmss") + ext;
                        if (!Directory.Exists(Server.MapPath(@"excel_upload\")))
                        {
                            Directory.CreateDirectory(Server.MapPath(@"excel_upload\"));
                        }
                        string fpath = Server.MapPath(@"excel_upload\") + filename2;
                        FileUpload1.SaveAs(fpath);
                        string conn = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + fpath + ";Extended Properties=Excel 8.0";
                        string sqlin = "SELECT * FROM [Sheet1$]";
                        OleDbCommand olecommand = new OleDbCommand(sqlin, new OleDbConnection(conn));
                        OleDbDataAdapter adapterin = new OleDbDataAdapter(olecommand);
                        DataSet dsin = new DataSet();
                        adapterin.Fill(dsin);
                        DataTable d = dsin.Tables[0];//连接并读取excel数据
                        int i = count(d);
                        if (i > 0)
                        {
                            File.Delete(fpath);
                            Common.alert("导入成功!初始密码均为：888888", "StudentList.aspx");
                        }
                        else
                        {
                            File.Delete(fpath);
                            Common.alert("数据导入错误，请检查Excel文件!");
                        }
                    }
                }
            }
            catch { Common.alert("导入失败，请重试！"); }
        }
    }

    protected int count(DataTable d)
    {
        int i = 0;
        WinStar.BLL.Student stu = new WinStar.BLL.Student();
        WinStar.Model.Student mr = new WinStar.Model.Student();
        try
        {
            for (i = 0; i < d.Rows.Count; i++)//将Excel文件中第一个工作表的数据导入到sql数据库 相应表中
            {
                if (getName(d.Rows[i][0].ToString()) == 0)
                {
                    mr.Num = d.Rows[i][0].ToString();
                    mr.PassWord = "888888";
                    mr.ParentPWD = "888888";
                    mr.PostId = 0;
                    mr.ClassId = Convert.ToInt32(ddlClass.SelectedValue);
                    mr.TrueName = d.Rows[i][1].ToString();
                    mr.Sex = Convert.ToBoolean(d.Rows[i][2]);
                    stu.Add(mr);
                }
                else
                {
                    Common.alert(d.Rows[i][0].ToString()+","+d.Rows[i][1].ToString()+"学号重复！");
                }

            }
            return i + 1;
        }
        catch (Exception ex)
        {
            throw ex;
            //PageError("数据导入错误，请检查Excel文件!", "");
        }

    }
    
    public int getName(string num)
    {
        try
        {
            string name = num;
            DataTable dt = new WinStar.BLL.Student().GetList("Num = '" + name + "'").Tables[0];
            int count = dt.Rows.Count;

            return count;
        }
        catch { return 0; }
    }
}