﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Admin_StudentList : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            typeAdd();
            typeSelect();
            gradeSelect();

            this.LoadStudentList();
        }
    }

    public void typeAdd()
    {
        ddlType.Items.Clear();
        ddlType.Items.Add(new ListItem("小学", "1"));
        ddlType.Items.Add(new ListItem("初中", "2"));
        ddlType.Items.Add(new ListItem("高中", "3"));
    }
    /// <summary>
    /// 加载学生列表
    /// </summary>
    private void LoadStudentList() 
    {
        try
        {
            string sql = string.Format("select * from hs_student where 1=1");
            if (!string.IsNullOrEmpty(this.txtSerch.Text.Trim()))
            {
                sql += string.Format(" and TrueName like '%{0}%'",txtSerch.Text.Trim());
            }
            if (!string.IsNullOrEmpty(this.ddlClass.SelectedValue))
            {
                sql += string.Format(" and ClassId={0}",this.ddlClass.SelectedValue);
            }
            if (!string.IsNullOrEmpty(this.ddlGrade.SelectedValue) && string.IsNullOrEmpty(this.ddlClass.SelectedValue))
            {
                sql += string.Format(" and ClassId in (select Id from hs_class where Gid={0})",this.ddlGrade.SelectedValue);
            }

            PagedDataSource pds = new PagedDataSource();
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];

            pds.DataSource = dt.DefaultView;
            this.AspNetPager1.RecordCount = pds.Count;
            pds.AllowPaging = true;
            pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
            pds.PageSize = AspNetPager1.PageSize;
            teacherList.DataSource = pds;
            teacherList.DataBind();
        }
        catch { }
    }
  
    private void bindddl()
    {
        try
        {
            WinStar.BLL.Grade bll = new WinStar.BLL.Grade();
            PagedDataSource pds = new PagedDataSource();
            DataTable dt = bll.GetAllList().Tables[0];
            pds.DataSource = dt.DefaultView;
            ddlType.DataSource = pds;
            ddlType.DataBind();
        }
        catch { }
    }

    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        this.LoadStudentList();
    }

    public string getPostName(int postID)
    {
        string postname = "";
        try
        {
            if (postID == 0)
            {
                postname = "无";
            }
            else
            {
                postname = new WinStar.BLL.StudentPost().GetModel(postID).Name;
            }
        }
        catch { }
        return postname;
    }

    protected string GetCname(int classID)
    {
        string yein = "";
        int isgrade = 0;
        WinStar.Model.Class sclass = new WinStar.BLL.Class().GetModel(classID);
        int gid = Convert.ToInt32(sclass.GId);
        WinStar.Model.Grade grade = new WinStar.BLL.Grade().GetModel(gid);
        yein = grade.YearIn.ToString();
        isgrade =Convert.ToInt32(grade.TypeAge);
        return GetGradeName(yein, isgrade);

    }

    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="yein">入学年份</param>
    /// <param name="isgrade">学段</param>
    /// <returns></returns>
    protected string GetGradeName(string yein, int isgrade)
    {
        int nowterm;//当前学期年份
        bool onetwo;//当前学期是第一学期还是第二学期
        DataTable dt = new WinStar.BLL.Term().GetList("IsNow=1").Tables[0];
        if (dt.Rows.Count > 0)
        {
            nowterm = DateTime.Parse(dt.Rows[0]["StartTime"].ToString()).Year;
            onetwo = Boolean.Parse(dt.Rows[0]["OneOrTwo"].ToString());
            return GetHowGrade(nowterm, int.Parse(yein), onetwo, isgrade);

        }
        else
        {
            return "<font color=red>请先设置好学期</font> <a href=TermList.aspx>点击这里</a>";
        }
    }
    /// <summary>
    /// 获取当前是几年级
    /// </summary>
    /// <param name="NowTerm">目前设置的学期是哪一年的</param>
    /// <param name="YeIn">入学年份</param>
    /// <param name="onetwo">目前是第一学期[false]还是第二学期[true] </param>
    /// <param name="isgrade">学段1 小学 2初中 3 高中</param>
    /// <returns></returns>
    protected string GetHowGrade(int NowTerm, int YeIn, bool onetwo, int isgrade)
    {
        int isclass, ot;
        if (!onetwo)
        {
            ot = 1;
        }
        else
        {
            ot = 0;
        }
        isclass = NowTerm - YeIn + ot;
        if (isclass <= 0)
        {
            return "<font color=red>还没开学</font>";
        }
        else if (isclass > 6 && isgrade == 1)
        {

            return "<font color=red>已经毕业</font>";
        }
        else if (isclass > 3 && (isgrade == 2 || isgrade == 3))
        {

            return "<font color=red>已经毕业</font>";
        }
        else
        {
            return GetTypeAge(isgrade.ToString()) + isclass.ToString() + "年级";
        }
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="str">年级数字</param>
    /// <returns></returns>
    protected string GetTypeAge(string str)
    {
        if (str == "1")
        {
            return "小学";
        }
        else if (str == "2")
        {
            return "初中";
        }
        else
        {
            return "高中";

        }
    }
    
    protected void Button1_Click(object sender, EventArgs e)
    {
        Response.Redirect("StudentAdd.aspx");
    }

    protected string getG(int NowTerm, int YeIn, bool onetwo, int isgrade)
    {
        int isclass, ot;
        if (!onetwo)
        {
            ot = 0;
        }
        else
        {
            ot = 1;
        }
        isclass = NowTerm - YeIn + ot;
        isclass = isclass + 1;
        if (isclass <= 0)
        {
            return "";
        }
        else if (isclass > 6 && isgrade == 1)
        {

            return "";
        }
        else if (isclass > 3 && (isgrade == 2 || isgrade == 3))
        {

            return "";
        }
        else
        {
            return isclass.ToString() ;
        }
    }

    public void typeSelect()
    {
        int typeAge = Convert.ToInt32(ddlType.SelectedValue);
        int nowterm = 0;//当前学期年份
        bool onetwo=true;//当前学期是第一学期还是第二学期
        DataTable dt1 = new WinStar.BLL.Term().GetList("IsNow=1").Tables[0];
        if (dt1.Rows.Count > 0)
        {
            nowterm = DateTime.Parse(dt1.Rows[0]["StartTime"].ToString()).Year;
            onetwo = Boolean.Parse(dt1.Rows[0]["OneOrTwo"].ToString());
        }
        string isclass = "";
        DataTable dt = new WinStar.BLL.Grade().GetList("TypeAge=" + typeAge).Tables[0];
        List<int> list = new List<int>();
        List<int> listid = new List<int>();
        foreach (DataRow row in dt.Rows)
        {
            isclass = getG(nowterm, Convert.ToInt32(row["YearIn"]), onetwo, typeAge);
            if (isclass != "")
            {
                list.Add(Convert.ToInt32(isclass));
                listid.Add(Convert.ToInt32(row["Id"]));
            }
        }
        if (list.Count > 0)
        {
            ddlGrade.Items.Clear();
            for (int i = 0; i < list.Count; i++)
            {
                if (list[i] <= 3)
                {
                    ddlGrade.Items.Add(new ListItem(list[i].ToString(), listid[i].ToString()));
                }
                
            }
        }
        else
        {
            ddlGrade.Items.Clear();
            ddlGrade.Items.Add(new ListItem("暂无年级", "0"));
            ddlClass.Items.Clear();
            ddlClass.Items.Add(new ListItem("暂无班级", "0"));
        }
    }
    
    protected void ddlType_SelectedIndexChanged(object sender, EventArgs e)
    {
        typeSelect();
        gradeSelect();
    }

    public void gradeSelect()
    {
        int typeAge = Convert.ToInt32(ddlType.SelectedValue);
        if (Convert.ToInt32(ddlGrade.SelectedValue) != 0)
        {
            int? yearin = new WinStar.BLL.Grade().GetModel(Convert.ToInt32(ddlGrade.SelectedValue)).YearIn;
            int gid = 0;
            DataTable dt = new WinStar.BLL.Grade().GetList("TypeAge =" + typeAge + " and YearIn = " + yearin).Tables[0];
            if (dt.Rows.Count == 0)
            {
                ddlClass.Items.Clear();
                ddlClass.Items.Add(new ListItem("暂无班级", "0"));
            }
            else
            {
                gid = Convert.ToInt32(dt.Rows[0]["Id"]);
                ddlClass.DataSource = new WinStar.BLL.Class().GetList("GId=" + gid + " order by ClassNum asc");
                ddlClass.DataTextField = "ClassNum";
                ddlClass.DataValueField = "Id";
                ddlClass.DataBind();
            }
        }
        else
        {
            ddlClass.Items.Clear();
            ddlClass.Items.Add(new ListItem("暂无班级", "0"));
        }
    }
    
    protected void ddlGrade_SelectedIndexChanged(object sender, EventArgs e)
    {
        gradeSelect();
    }
    
    protected void Button3_Click(object sender, EventArgs e)
    {
        this.LoadStudentList();
    }
    
    protected void Button4_Click(object sender, EventArgs e)
    {
        Response.Redirect("excel_upload/StudentModel.xls");
    }
    
    protected void Button5_Click(object sender, EventArgs e)
    {
        Response.Redirect("StudentAllAdd.aspx");
    }
}