﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Admin_SubjectGrade : AdminPageBase
{
    public string SubjectStr="";
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!string.IsNullOrEmpty(Request.QueryString["Id"]))
        {
            ViewState["Id"] = Request["Id"];
            LoadSubject();
        }
        else
        {
            Common.alert("请用正确的浏览方式查看！", "GradeList.aspx");
        }
    }
    /// <summary>
    /// 加载学科
    /// </summary>
    protected void LoadSubject()
    {
        try
        {
            WinStar.BLL.Subject s = new WinStar.BLL.Subject();
            DataTable dt = s.GetAllList().Tables[0];
            if (dt.Rows.Count > 0)
            {
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    SubjectStr += "&nbsp;<input id=\"CheckBox_" + dt.Rows[i]["Id"] + "\" " + LoadSubjectChecked(dt.Rows[i]["Id"].ToString()) + " value=\"" + dt.Rows[i]["Id"] + "\" onclick=\"AddSubject()\" type=\"checkbox\" name=\"CheckBox1\"/>&nbsp;" + dt.Rows[i]["Name"] + "&nbsp;&nbsp;&nbsp;&nbsp;";
                }
            }
            else
            {
                Common.alert("请先添加学科！", "SubjectList.aspx");
            }
        }
        catch {}
    }
    /// <summary>
    /// 加载是否选中了该学科
    /// </summary>
    /// <param name="SubjectId">学科ID</param>
    protected string LoadSubjectChecked(string SubjectId)
    {
        string returnStr = "";
        DataTable dt = new WinStar.BLL.SubjectGrade().GetList("GId=" + ViewState["Id"]).Tables[0];
        if (dt.Rows.Count > 0)
        {
            string[] ad = dt.Rows[0]["SubjectId"].ToString().Split(',');
            if (ad.Length > 0)
            {
                for (int i = 0; i < ad.Length; i++)
                {
                    if (ad[i] == SubjectId) {
                        returnStr= "Checked=\"Checked\"";
                    }
                }
            }
        }
        return returnStr;
    }
    protected void btn1_Click(object sender, EventArgs e)
    {
        try
        {
            WinStar.BLL.SubjectGrade t = new WinStar.BLL.SubjectGrade();
            WinStar.Model.SubjectGrade te = new WinStar.Model.SubjectGrade();

            te.GId = int.Parse(ViewState["Id"].ToString());
            te.SubjectId = this.getSubjectId.Value.TrimEnd(',');

            //判断是否存在记录
            DataTable dt = t.GetList("GId=" + ViewState["Id"]).Tables[0];
            if (dt.Rows.Count > 0)
            {
                te.Id = int.Parse(dt.Rows[0]["Id"].ToString());
                t.Update(te);
            }
            else
            {
                t.Add(te);
            }
            Common.alert("年级学科设置成功！", "GradeList.aspx");
        }
        catch { Common.alert("年级学科设置失败，请重试！"); }
    }
}