﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Admin_TeacherClass : AdminPageBase
{
    public string SubjectStr = "";
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!string.IsNullOrEmpty(Request.QueryString["Id"]))
        {
            ViewState["Id"] = Request["Id"];
            if (!string.IsNullOrEmpty(Request.QueryString["ClassId"]))
            {
                ViewState["ClassId"] = Request["ClassId"];
                LoadSubject();
            }
        }
        else
        {
            Common.alert("请用正确的浏览方式查看！", "GradeList.aspx");
        }
    }
    /// <summary>
    /// 加载老师
    /// </summary>
    protected void LoadSubject()
    {
        try
        {
            WinStar.BLL.Teacher s = new WinStar.BLL.Teacher();
            DataTable dt = s.GetAllList().Tables[0];
            if (dt.Rows.Count > 0)
            {
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    SubjectStr += "&nbsp;<input id=\"CheckBox_" + dt.Rows[i]["Id"] + "\" " + LoadSubjectChecked(dt.Rows[i]["Id"].ToString()) + " value=\"" + dt.Rows[i]["Id"] + "\" onclick=\"AddSubject('" + dt.Rows[i]["Id"] + "')\" type=\"radio\" name=\"radio1\"/>&nbsp;" + dt.Rows[i]["TrueName"] + "&nbsp;&nbsp;&nbsp;&nbsp;";
                }
            }
            else
            {
                Common.alert("请先添加老师！", "TeacherList.aspx");
            }
        }
        catch {}
    }
    /// <summary>
    /// 加载是否选中了该老师
    /// </summary>
    /// <param name="SubjectId">老师ID</param>
    protected string LoadSubjectChecked(string SubjectId)
    {
        string returnStr = "";
        DataTable dt = new WinStar.BLL.TeacherClass().GetList("ClassId=" + ViewState["ClassId"]+" And TeacherId="+SubjectId).Tables[0];
        if (dt.Rows.Count > 0)
        {
            returnStr = "Checked=\"Checked\"";
        }
        return returnStr;
    }
    protected void btn1_Click(object sender, EventArgs e)
    {
        try
        {
            WinStar.BLL.TeacherClass t = new WinStar.BLL.TeacherClass();
            WinStar.Model.TeacherClass te = new WinStar.Model.TeacherClass();

            te.ClassId = int.Parse(ViewState["ClassId"].ToString());
            te.TeacherId = int.Parse(this.getTeacherId.Value);

            //判断是否存在记录
            DataTable dt = t.GetList("ClassId=" + ViewState["ClassId"]).Tables[0];
            if (dt.Rows.Count > 0)
            {
                te.Id = int.Parse(dt.Rows[0]["Id"].ToString());
                t.Update(te);
            }
            else
            {
                t.Add(te);
            }

            Common.alert("班主任设置成功！", "ClassList.aspx?Id=" + ViewState["Id"]);
        }
        catch { Common.alert("班主任设置失败，请重试！"); }
    }
}