﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Admin_TeacherEdit : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                int id = 0;
                try
                {
                    id = Convert.ToInt32(Request.QueryString["id"]);
                }
                catch { Common.alert("抱歉，您访问的地址不存在！", "AdminList.aspx"); }

                if (id == 0)
                    Common.alert("抱歉，您访问的地址不存在！", "AdminList.aspx");
                else
                    this.LoadTeacherUserInfo(id);
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！", "AdminList.aspx");
            }
        }
    }
    protected void LoadTeacherUserInfo(int id)
    {
        try
        {
            WinStar.Model.Teacher model = new WinStar.BLL.Teacher().GetModel(id);

            this.ltUserName.Text = model.UserName;
            this.txtTel.Text = model.TelPhone;
            this.txtUserTrueName.Text = model.TrueName;
            this.rdoBtnSexList.SelectedValue = model.Sex == true ? "男" : "女";
           
        }
        catch { }
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (IsValid)
        {
            try
            {
                WinStar.Model.Teacher model = new WinStar.BLL.Teacher().GetModel(Convert.ToInt32(Request.QueryString["id"]));
                if (this.txtUserPwd.Text.Trim() != "")
                    model.PassWord = this.txtUserPwd.Text.Trim();
                model.Sex = this.rdoBtnSexList.SelectedValue == "男" ? true : false;
                model.TelPhone = this.txtTel.Text.Trim();
                model.TrueName = this.txtUserTrueName.Text.Trim();

                new WinStar.BLL.Teacher().Update(model);

                Common.alert("修改成功", "TeacherList.aspx");
            }
            catch { Common.alert("修改失败，请重试！"); }
        }
    }
}