﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Admin_TermEdit : AdminPageBase
{
    WinStar.BLL.Term t = new WinStar.BLL.Term();
    WinStar.Model.Term te = new WinStar.Model.Term();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["Id"]))
            {
                ViewState["Id"] = Request["Id"];
                LoadData(ViewState["Id"].ToString());
            }
            else
            {
                Common.alert("请用正确的浏览方式查看！","TermList.aspx");
            }
        }
    }
    /// <summary>
    /// 加载学期信息
    /// </summary>
    /// <param name="Id">信息ID</param>
    protected void LoadData(string Id)
    {
        try
        {
            WinStar.Model.Term d = t.GetModel(int.Parse(Id));
            if (d.OneOrTwo)
            {
                this.OneOrTwo.SelectedValue = "2";
            }
            else { this.OneOrTwo.SelectedValue = "1"; }
            this.StartTime.Text = d.StartTime.Value.ToShortDateString();
            this.FinishTime.Text = d.FinishTime.Value.ToShortDateString();
            this.BeginTime.Text = d.BeginTime.Value.ToShortDateString();
            this.EndTime.Text = d.EndTime.Value.ToShortDateString();
            this.IsNow.Checked = d.IsNow;
        }
        catch {}
    }
    protected void btn1_Click(object sender, EventArgs e)
    {
        try
        {
            te.BeginTime = DateTime.Parse(this.BeginTime.Text);
            te.EndTime = DateTime.Parse(this.EndTime.Text);

            //是否当前学期判断
            if (this.IsNow.Checked)
            {
                te.IsNow = true;
                EditIsNow();
            }
            else { te.IsNow = false; }

            //第几学期判断
            string OT = "";
            if (this.OneOrTwo.SelectedValue == "1")
            {
                te.OneOrTwo = false;
                OT = "第一学期";
            }
            else
            {
                te.OneOrTwo = true;
                OT = "第二学期";
            }
            te.Name = DateTime.Parse(this.StartTime.Text).Year.ToString() + " - " + DateTime.Parse(this.FinishTime.Text).Year.ToString() + OT;
            te.StartTime = DateTime.Parse(this.StartTime.Text);
            te.FinishTime = DateTime.Parse(this.FinishTime.Text);
            te.SId = 1;
            te.Id = int.Parse(ViewState["Id"].ToString());
            try
            {
                t.Update(te);
                Common.alert("学期修改成功！", "TermList.aspx");
            }
            catch
            {
                Common.alert("修改失败，请重试或者联系管理员！", "TermList.aspx");
            }
        }
        catch { Common.alert("修改失败，请重试！"); }
    }
    /// <summary>
    /// 修改当前学期状态
    /// </summary>
    protected void EditIsNow()
    {
        DataTable dt = WinStar.DBUtility.DbHelperSQL.Query("Select Id From HS_Term Where IsNow=1").Tables[0];
        if (dt.Rows.Count > 0)
        {
            WinStar.DBUtility.DbHelperSQL.ExecuteSql("Update HS_Term Set IsNow=0 Where Id=" + dt.Rows[0]["Id"]);
        }
    }
}