﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Admin_VerifyCode : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        string randCode = this.GetRandCode(4); //获取随即字符串
        Session["randCode"] = randCode;
        this.SetPageNoCache();
        this.CreateVerifyCodeImg(randCode);
    }

    protected void SetPageNoCache()
    {
        Response.Buffer = true;
        Response.ExpiresAbsolute = System.DateTime.Now.AddSeconds(-1);
        Response.Expires = 0;
        Response.CacheControl = "no-cache";
        Response.AppendHeader("Pragma", "No-Cache");
    }

    protected string GetRandCode(int codeCount)
    {
        string randCode = string.Empty;

        string allChar = "2,3,4,5,6,7,8,9,A,B,C,D,E,F,G,H,i,J,K,M,N,P,Q,R,S,T,U,W,X,Y,Z";
        string[] charArray = allChar.Split(',');

        int temp = -1;

        Random rand = new Random();
        for (int i = 0; i < codeCount; i++)
        {
            int t = rand.Next(charArray.Length - 1);

            while (t == temp)
            {
                t = rand.Next(charArray.Length - 1);
            }

            temp = t;

            randCode += charArray[t];
        }

        return randCode;
    }

    protected void CreateVerifyCodeImg(string checkCode)
    {
        System.Drawing.Bitmap image = new System.Drawing.Bitmap(80, 20); //实例化一个图形对象

        System.Drawing.Graphics gpi = System.Drawing.Graphics.FromImage(image); //实例化一块画布

        System.Drawing.Font font = new System.Drawing.Font("宋体", 16, System.Drawing.FontStyle.Regular); //设置字体，Arial

        Random rand = new Random();

        System.Drawing.Brush br = new System.Drawing.SolidBrush(System.Drawing.Color.FromArgb(rand.Next(255), 0, rand.Next(255))); //实例化一个刷子对象

        gpi.Clear(System.Drawing.ColorTranslator.FromHtml("#F0F3F8")); //设置画布背景颜色

        char[] strArr = checkCode.ToCharArray();

        for (int i = 0; i < strArr.Length; i++)
        {
            gpi.DrawString(strArr[i].ToString(), font, br, (i * 18) + 5, 0); //将验证码字符串逐个添加到画布上
        }

        System.IO.MemoryStream ms = new System.IO.MemoryStream(); //实例化一个内存流对象

        image.Save(ms, System.Drawing.Imaging.ImageFormat.Jpeg); //将当前绘制的图像保存到内存流中

        Response.Cache.SetNoStore(); //设置http标头
        Response.ClearContent(); //清除缓冲区流的所有内容输出
        Response.ContentType = "image/jpeg";
        Response.BinaryWrite(ms.ToArray()); //将内存流转换成二进制字符串写入http输出流

        gpi.Dispose();
        image.Dispose();
    }
}