﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Text.RegularExpressions;
using System.Security.Cryptography;
using System.Text;
using System.Data;

/// <summary>
///Common 的摘要说明
/// </summary>
public class Common
{
    public Common()
    {
        //
        //TODO: 在此处添加构造函数逻辑
        //
    }

    /// <summary>
    /// 32位 md5 加密函数
    /// </summary>
    /// <param name="txt"></param>
    /// <returns></returns>
    public static string Md5(string txt)
    {
        return txt = FormsAuthentication.HashPasswordForStoringInConfigFile(txt, "MD5").ToLower();
    }

    /// <summary>
    /// 获得老师、学生、家长名称
    /// </summary>
    /// <param name="type">用户类型1学生，2家长，3班主任，4科任老师</param>
    /// <param name="uid">老师、学生id</param>
    /// <returns></returns>
    public static string GetUserName(object type,object uid)
    {
        string name = "";
        try
        {
            switch (type.ToString())
            {
                case "1":
                    name = "<a href=\"" + Common.getUrl() + "Student/Default.aspx\" target=\"_blank\">" + WinStar.DBUtility.DbHelperSQL.GetSingle("select TrueName from HS_Student where Id=" + uid).ToString() + "(同学)</a>";
                    break;
                case "2":
                    name = "<a href=\"" + Common.getUrl() + "HomeMaster/Default.aspx\" target=\"_blank\">" + WinStar.DBUtility.DbHelperSQL.GetSingle("select TrueName from HS_Student where Id=" + uid).ToString() + "(同学的家长)</a>";
                    break;
                case "3":
                    name = "<a href=\"" + Common.getUrl() + "Hteacher/Default.aspx\" target=\"_blank\">" + WinStar.DBUtility.DbHelperSQL.GetSingle("select TrueName from HS_Teacher where Id=" + uid).ToString() + "(班主任)</a>";
                    break;
                case "4":
                    name = "<a href=\"" + Common.getUrl() + "Teacher/Default.aspx\" target=\"_blank\">" + WinStar.DBUtility.DbHelperSQL.GetSingle("select TrueName from HS_Teacher where Id=" + uid).ToString() + "(科任老师)</a>";
                    break;
            }
        }
        catch { }
        return name;
    }

    /// <summary>
    /// 获得老师、学生、家长名称
    /// </summary>
    /// <param name="type">用户类型1老师，2学生，3家长</param>
    /// <param name="uid">老师、学生id</param>
    /// <returns></returns>
    public static string GetUsers(object type, object uid)
    {
        string name = "";
        try
        {
            switch (type.ToString())
            {
                case "1":
                    name = "<a href=\"" + Common.getUrl() + "Hteacher/Default.aspx\" target=\"_blank\">" + WinStar.DBUtility.DbHelperSQL.GetSingle("select TrueName from HS_Teacher where Id=" + uid).ToString() + "(老师)</a>";
                    break;
                case "2":
                    name = "<a href=\"" + Common.getUrl() + "Student/Default.aspx\" target=\"_blank\">" + WinStar.DBUtility.DbHelperSQL.GetSingle("select TrueName from HS_Student where Id=" + uid).ToString() + "(同学)</a>";
                    break;
                case "3":
                    name = "<a href=\"" + Common.getUrl() + "HomeMaster/Default.aspx\" target=\"_blank\">" + WinStar.DBUtility.DbHelperSQL.GetSingle("select TrueName from HS_Student where Id=" + uid).ToString() + "(同学的家长)</a>";
                    break;
            }
        }
        catch { }
        return name;
    }

    /// <summary>
    /// 获得科目名称
    /// </summary>
    /// <returns></returns>
    public static string GetSubject(object sid)
    {
        return WinStar.DBUtility.DbHelperSQL.GetSingle("select Name from HS_Subject Where Id="+sid).ToString();
    }

    /// <summary>
    /// 获得班级信息
    /// </summary>
    /// <param name="?"></param>
    /// <returns></returns>
    public static string GetClassInfo(WinStar.Model.Class cla)
    {
        WinStar.Model.Grade grade = new WinStar.BLL.Grade().GetModel(int.Parse(cla.GId.ToString()));
        int nowterm;//当前学期年份
        bool onetwo;//当前学期是第一学期还是第二学期
        DataTable dt = new WinStar.BLL.Term().GetList("IsNow=1").Tables[0];
        nowterm = DateTime.Parse(dt.Rows[0]["StartTime"].ToString()).Year;
        onetwo = Boolean.Parse(dt.Rows[0]["OneOrTwo"].ToString());
        int isclass, ot;
        if (!onetwo)
        {
            ot = 1;
        }
        else
        {
            ot = 0;
        }
        isclass = nowterm - int.Parse(grade.YearIn.ToString()) + ot;

        return GetTypeAge(grade.TypeAge.ToString()) + ConvertGradeNum(isclass) + "年级(" + cla.ClassNum + ")班";
    }

    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="str">年级数字</param>
    /// <returns></returns>
    public static string GetTypeAge(string str)
    {
        if (str == "1")
        {
            return "小学";
        }
        else if (str == "2")
        {
            return "初中";
        }
        else
        {
            return "高中";
        }
    }
    /// <summary>
    /// 将年级的数字转换成中文
    /// </summary>
    /// <param name="num"></param>
    /// <returns></returns>
    protected static string ConvertGradeNum(int num)
    {
        string str = string.Empty;
        try
        {
            switch (num)
            {
                case 1:
                    str = "一";
                    break;
                case 2:
                    str = "二";
                    break;
                case 3:
                    str = "三";
                    break;
                case 4:
                    str = "四";
                    break;
                case 5:
                    str = "五";
                    break;
                case 6:
                    str = "六";
                    break;
                case 7:
                    str = "七";
                    break;
                case 8:
                    str = "八";
                    break;
                case 9:
                    str = "九";
                    break;
            }
        }
        catch { }

        return str;
    }
    /// <summary>
    /// 获得班级学生人数
    /// </summary>
    /// <param name="claid"></param>
    /// <returns></returns>
    public static string GetClaStuNum(object claid)
    {
        return WinStar.DBUtility.DbHelperSQL.GetSingle("select count(*) from HS_Student where ClassId="+claid).ToString();
    }

    /// <summary>
    /// 格式化时间
    /// 
    /// </summary>
    /// <returns></returns>
    public static string formatTime(object obj)
    {
        return Convert.ToDateTime(obj.ToString()).ToString("yyyy-MM-dd");
    }

    /// <summary>
    /// 16位 md5 加密函数
    /// </summary>
    /// <param name="txt"></param>
    /// <returns></returns>
    public static string Md5_16(string txt)
    {
        return txt = FormsAuthentication.HashPasswordForStoringInConfigFile(txt, "MD5").ToLower().Substring(8, 16);
    }

    /// <summary>
    /// 填充Datelist数据方法
    /// 2009-10-28 候文军
    /// </summary>
    /// <param name="obj"></param>
    /// <returns></returns>
    public static string PadDate(object obj)
    {
        if (string.IsNullOrEmpty(obj.ToString().Trim())) return "暂无数据";

        if (obj.ToString().Trim().Length > 9)

            return obj.ToString().Substring(0, 9) + "...";

        else

            return obj.ToString();
    }

    public static void alert(string info, string url)
    {
        System.Web.HttpContext.Current.Response.Write("<script>alert('" + info + "');location.href='" + url + "'</script>");
    }
    public static void alert(string info, string url, int parent)
    {
        System.Web.HttpContext.Current.Response.Write("<script>alert('" + info + "');parent.location.href='" + url + "'</script>");
    }
    public static void alert(string info)
    {
        System.Web.HttpContext.Current.Response.Write("<script>alert('" + info + "');history.back(-1);</script>");
    }

    /// <summary>
    /// 得到站点用户IP, IpSTR = HttpContext.Current.Request.ServerVariables["REMOTE_ADDR"].ToString()
    /// </summary>
    /// <returns></returns>
    public static string getUserIP()
    {
        return HttpContext.Current.Request.ServerVariables["REMOTE_ADDR"].ToString();
    }

    /// <summary>
    /// 标题按长度显示
    /// </summary>
    /// <param name="title">传入的字符</param>
    /// <param name="len">显示的长度</param>
    /// <returns>字符串</returns>
    public static string CuteTitle(string title, int len)
    {
        if (title.Length > len)
        {
            return title.Substring(0, len) + "…";
        }
        else
        {
            return title;
        }
    }

    public string CkReq(string str)
    {
        if (str.Length == 0)
        {
            System.Web.HttpContext.Current.Response.Write("<script>alert('参数错误!');location.href='/'</script>");
        }
        else
        {
            if (SqlIn(str))
            {
                System.Web.HttpContext.Current.Response.Write("<script>alert('参数错误!');location.href='/'</script>");
            }
        }
        return str;
    }

    /// <summary>
    /// 过滤SQL InJection
    /// </summary>
    /// <param name="str">字符串</param>
    /// <returns>bool</returns>
    public static bool SqlIn(string str)
    {

        if (str != null)
        {
            str = str.ToLower();
            string Fy_In = "'|;|and|(|)|exec|insert|select|delete|update|count|*|%|chr|mid|master|truncate|char|declare";
            string[] fy_inf = Fy_In.Split('|');

            for (int i = 0; i < fy_inf.Length; i++)
            {
                if (str.IndexOf(fy_inf[i]) != -1)
                {
                    return true;
                }
            }
        }
        return false;
    }

    public static string pd_url(string purl)
    {
        string pic_url = "";
        if (purl != "")
        {

            if (purl.Substring(0, 7).ToLower() != "http://")
            {
                pic_url = "../pic_upfile/" + purl;
            }
            else
            {
                pic_url = purl;
            }
        }
        return pic_url;
    }

    public static string Cute_String(string str, int len)
    {
        int intLen = str.Length;
        int start = 0;
        int end = intLen;
        int single = 0;
        char[] chars = str.ToCharArray();
        for (int i = 0; i < chars.Length; i++)
        {
            if (Convert.ToInt32(chars[i]) > 255)
            {
                start += 2;
            }
            else
            {
                start += 1;
                single++;
            }
            if (start >= len)
            {

                if (end % 2 == 0)
                {
                    if (single % 2 == 0)
                    {
                        end = i + 1;
                    }
                    else
                    {
                        end = i;
                    }
                }
                else
                {
                    end = i + 1;
                }
                break;
            }
        }
        string temp = str.Substring(0, end);
        if (str.Length > end)
        {
            return temp + "...";
        }
        else
        {
            return temp;
        }
    }


    /// <summary>
    /// 处理URL中参数，并返回Int值。为空或其他异常则返回0。
    /// </summary>
    /// <param name="s"></param>
    /// <returns></returns>
    public static int getPara(string s)
    {
        int i = 0;

        try
        {
            i = int.Parse(s);
        }
        catch
        {
            i = 0;
        }

        return i;
    }




    /// <summary>
    /// 过滤HTML标签
    /// </summary>
    /// <param name="html">要过滤的内容</param>
    /// <returns>返回过滤之后的内容</returns>
    public static string FilterHtml(string html)
    {
        System.Text.RegularExpressions.Regex regex1 = new System.Text.RegularExpressions.Regex(@"<script[\s\S]+</script *>", System.Text.RegularExpressions.RegexOptions.IgnoreCase);
        System.Text.RegularExpressions.Regex regex2 = new System.Text.RegularExpressions.Regex(@" href *= *[\s\S]*script *:", System.Text.RegularExpressions.RegexOptions.IgnoreCase);
        System.Text.RegularExpressions.Regex regex3 = new System.Text.RegularExpressions.Regex(@" no[\s\S]*=", System.Text.RegularExpressions.RegexOptions.IgnoreCase);
        System.Text.RegularExpressions.Regex regex4 = new System.Text.RegularExpressions.Regex(@"<iframe[\s\S]+</iframe *>", System.Text.RegularExpressions.RegexOptions.IgnoreCase);
        System.Text.RegularExpressions.Regex regex5 = new System.Text.RegularExpressions.Regex(@"<frameset[\s\S]+</frameset *>", System.Text.RegularExpressions.RegexOptions.IgnoreCase);
        System.Text.RegularExpressions.Regex regex6 = new System.Text.RegularExpressions.Regex(@"\<img[^\>]+\>", System.Text.RegularExpressions.RegexOptions.IgnoreCase);


        System.Text.RegularExpressions.Regex regex7 = new System.Text.RegularExpressions.Regex(@"</p>", System.Text.RegularExpressions.RegexOptions.IgnoreCase);
        System.Text.RegularExpressions.Regex regex8 = new System.Text.RegularExpressions.Regex(@"<p>", System.Text.RegularExpressions.RegexOptions.IgnoreCase);
        System.Text.RegularExpressions.Regex regex9 = new System.Text.RegularExpressions.Regex(@"<[^>]*>", System.Text.RegularExpressions.RegexOptions.IgnoreCase);
        html = regex1.Replace(html, ""); //过滤<script></script>标记 
        html = regex2.Replace(html, ""); //过滤href=javascript: (<A>) 属性 网管网bitsCN.com 
        html = regex3.Replace(html, " _disibledevent="); //过滤其它控件的on...事件 
        html = regex4.Replace(html, ""); //过滤iframe 
        html = regex5.Replace(html, ""); //过滤frameset 
        html = regex6.Replace(html, ""); //过滤frameset 
        html = regex7.Replace(html, ""); //过滤frameset 
        html = regex8.Replace(html, ""); //过滤frameset 
        html = regex9.Replace(html, "");
        html = html.Replace(" ", "");


        html = html.Replace("</strong>", "");
        html = html.Replace("<strong>", "");
        html = html.Replace("&ldquo;", "“");
        html = html.Replace("&rdquo;", "”");

        return html;
    }

    /// <summary>
    /// 数组中，过滤重复字符串
    /// </summary>
    /// <param name="myData">要过滤的数组</param>
    /// <returns>返回过滤之后的内容</returns>
    public static String[] RemoveDup(string[] myData)
    {

        if (myData.Length > 0)
        {
            Array.Sort(myData);//用了数组的排序,个人感觉在数组元素很多的时候能够提高一点效率吧!

            int size = 1; //at least 1 
            for (int i = 1; i < myData.Length; i++)
                if (myData[i] != myData[i - 1])
                    size++;

            String[] myTempData = new String[size];

            int j = 0;

            myTempData[j++] = myData[0];

            for (int i = 1; i < myData.Length; i++)
                if (myData[i] != myData[i - 1])
                    myTempData[j++] = myData[i];

            return myTempData;
        }

        return myData;
    }

    /// <summary>
    /// 取本页URL地址
    /// </summary>
    /// <param name="url">如果url==1 ，获取当前地址包括参数！如果url==2 ，获取域名！如果url==3 ，获取域名和地址，不获取参数！，如果url==4 ，只获取地址，获取域名和参数 </param>
    /// <returns>返回过滤之后的内容</returns>
    public static string GetUrl(int url)
    {
        //取本页URL地址
        string strTemp = "";
        if (System.Web.HttpContext.Current.Request.ServerVariables["HTTPS"] == "off")
        {
            strTemp = "http://";
        }
        else
        {
            strTemp = "https://";
        }

        strTemp = strTemp + System.Web.HttpContext.Current.Request.ServerVariables["SERVER_NAME"];

        if (System.Web.HttpContext.Current.Request.ServerVariables["SERVER_PORT"] != "80")
        {
            strTemp = strTemp + ":" + System.Web.HttpContext.Current.Request.ServerVariables["SERVER_PORT"];
        }

        if (url == 1)
        {
            strTemp = strTemp + System.Web.HttpContext.Current.Request.ServerVariables["URL"];

            if (System.Web.HttpContext.Current.Request.QueryString != null)
            {
                strTemp = strTemp + "?" + System.Web.HttpContext.Current.Request.QueryString;
            }
        }
        if (url == 3)
        {
            strTemp = strTemp + System.Web.HttpContext.Current.Request.ServerVariables["URL"];
        }
        if (url == 4)
        {
            strTemp = System.Web.HttpContext.Current.Request.ServerVariables["URL"];
        }
        return strTemp;
    }


    /// <summary>
    /// 过滤script脚本，iframe,frameset
    /// </summary>
    /// <param name="str"></param>
    /// <returns></returns>
    public static string DeleteScript(string str)
    {

        System.Text.RegularExpressions.Regex regex1 = new System.Text.RegularExpressions.Regex(@"<script[\s\S]+</script *>", System.Text.RegularExpressions.RegexOptions.IgnoreCase);
        System.Text.RegularExpressions.Regex regex2 = new System.Text.RegularExpressions.Regex(@" href *= *[\s\S]*script *:", System.Text.RegularExpressions.RegexOptions.IgnoreCase);
        System.Text.RegularExpressions.Regex regex3 = new System.Text.RegularExpressions.Regex(@" on[\s\S]*=", System.Text.RegularExpressions.RegexOptions.IgnoreCase);
        System.Text.RegularExpressions.Regex regex4 = new System.Text.RegularExpressions.Regex(@"<iframe[\s\S]+</iframe *>", System.Text.RegularExpressions.RegexOptions.IgnoreCase);
        System.Text.RegularExpressions.Regex regex5 = new System.Text.RegularExpressions.Regex(@"<frameset[\s\S]+</frameset *>", System.Text.RegularExpressions.RegexOptions.IgnoreCase);
        string html = str;
        html = regex1.Replace(html, ""); //过滤<script></script>标记 
        html = regex2.Replace(html, ""); //过滤href=javascript: (<A>) 属性 
        html = regex3.Replace(html, " _disibledevent="); //过滤其它控件的on事件 
        html = regex4.Replace(html, ""); //过滤iframe 
        html = regex5.Replace(html, ""); //过滤frameset 

        return html;

    }

    /// <summary>
    /// 过滤html
    /// </summary>
    /// <param name="str"></param>
    /// <returns></returns>
    public static string DeleteHtml(string str)
    {
        string s = System.Text.RegularExpressions.Regex.Replace(str, "<[^>]+>", "");
        return s;
    }

    public static string CheckStringLength(string stringToCheck, int maxLength, bool key)
    {
        string checkedString = null;

        if (stringToCheck.Length <= maxLength)
            return stringToCheck;

        if ((stringToCheck.Length > maxLength) && (stringToCheck.IndexOf(" ") == -1))
        {
            checkedString = stringToCheck.Substring(0, maxLength);
        }
        else if (stringToCheck.Length > 0)
        {
            if (key)
            {
                checkedString = stringToCheck.Substring(0, maxLength) + "...";
            }
            else
            {
                checkedString = stringToCheck.Substring(0, maxLength);
            }

        }
        else
        {
            checkedString = stringToCheck;
        }

        return checkedString;
    }

    /// <summary>
    /// 清除所有HTML标签
    /// </summary>
    /// <param name="html">html代码</param>
    public static string RemoveHtml(string html)
    {
        if (string.IsNullOrEmpty(html))
            return string.Empty;

        return Regex.Replace(html, @"<.+?/?>", "", RegexOptions.IgnoreCase | RegexOptions.Singleline);
    }

    /// <summary>
    /// 获取站点路径
    /// </summary>
    /// <returns></returns>
    public static string getUrl()
    {
        if (System.Web.HttpContext.Current.Request.ApplicationPath.Length == 1)
        {
            return "http://" + System.Web.HttpContext.Current.Request.Url.Host + (System.Web.HttpContext.Current.Request.Url.Port == 80 ? "" : ":" + System.Web.HttpContext.Current.Request.Url.Port.ToString()) + "/";
        }
        else
        {
            return "http://" + System.Web.HttpContext.Current.Request.Url.Host + (System.Web.HttpContext.Current.Request.Url.Port == 80 ? "" : ":" + System.Web.HttpContext.Current.Request.Url.Port.ToString()) + System.Web.HttpContext.Current.Request.ApplicationPath + "/";

        }

    }

    /// <summary>
    /// 获取站点域名
    /// </summary>
    /// <returns></returns>
    public static string getDomain()
    {
        return "http://" + System.Web.HttpContext.Current.Request.Url.Host + (System.Web.HttpContext.Current.Request.Url.Port == 80 ? "" : ":" + System.Web.HttpContext.Current.Request.Url.Port.ToString());
    }

    /// <summary>
    /// 截取字符串函数
    /// </summary>
    /// <param name="Str">所要截取的字符串</param>
    /// <param name="Num">截取字符串的长度</param>
    /// <returns></returns>
    public static string GetSubString(string Str, int Num)
    {
        if (Str == null || Str == "")
            return "";
        string outstr = "";
        int n = 0;
        foreach (char ch in Str)
        {
            n += System.Text.Encoding.Default.GetByteCount(ch.ToString());
            if (n > Num)
                break;
            else
                outstr += ch;
        }
        return outstr;
    }

    /// <summary>
    /// 截取字符串函数
    /// </summary>
    /// <param name="Str">所要截取的字符串</param>
    /// <param name="Num">截取字符串的长度</param>
    /// <param name="Num">截取字符串后省略部分的字符串</param>
    /// <returns></returns>
    public static string GetSubString(string Str, int Num, string LastStr)
    {
        return (Str.Length > Num) ? Str.Substring(0, Num) + LastStr : Str;
    }

    /// <summary>
    /// 
    /// </summary>
    /// <param name="text"></param>
    /// <param name="key"></param>
    /// <returns></returns>
    public static string DESEncrypt(string text, string key)
    {
        DESCryptoServiceProvider des = new DESCryptoServiceProvider();
        des.Mode = System.Security.Cryptography.CipherMode.ECB;
        des.Padding = PaddingMode.Zeros;
        des.Key = ASCIIEncoding.ASCII.GetBytes(key);

        byte[] inputBuffer = Encoding.GetEncoding("UTF-8").GetBytes(text);
        byte[] outputBuffer = des.CreateEncryptor().TransformFinalBlock(inputBuffer, 0, inputBuffer.Length);

        return Convert.ToBase64String(outputBuffer);
    }

    public static string DESDecrypt(string text, string key)
    {

        DESCryptoServiceProvider des = new DESCryptoServiceProvider();
        des.Mode = System.Security.Cryptography.CipherMode.ECB;
        des.Padding = PaddingMode.Zeros;
        des.Key = ASCIIEncoding.ASCII.GetBytes(key);

        byte[] inputBuffer = Convert.FromBase64String(text);
        byte[] outputBuffer = des.CreateDecryptor().TransformFinalBlock(inputBuffer, 0, inputBuffer.Length);

        return Encoding.GetEncoding("UTF-8").GetString(outputBuffer);
    }

    /// <summary>
    /// 获取参数值 Form
    /// </summary>
    /// <param name="Key"></param>
    /// <returns></returns>
    public static string Post(string Key)
    {
        if (HttpContext.Current.Request.Form[Key] != null)
        {
            return HttpContext.Current.Request.Form[Key].ToString();
        }
        return "";
    }
   

    /// <summary>
    /// 设置页面不被缓存
    /// </summary>
    public static void SetPageNoCache()
    {
        HttpContext.Current.Response.Buffer = true;
        HttpContext.Current.Response.ExpiresAbsolute = System.DateTime.Now.AddSeconds(-1);
        HttpContext.Current.Response.Expires = 0;
        HttpContext.Current.Response.CacheControl = "no-cache";
        HttpContext.Current.Response.AppendHeader("Pragma", "No-Cache");
    }
    /// <summary>
    /// 前台用户登录判断
    /// </summary>
    public static string IsLoginEd()
    {
        string str = "";
        if (HttpContext.Current.Session["Type"] != null)
        {
            switch (HttpContext.Current.Session["Type"].ToString())
            {
                case "1":
                    str = Common.GetUserName("1", HttpContext.Current.Session["UserId"]);
                    break;
                case "2":
                    str = Common.GetUserName("2", HttpContext.Current.Session["ParId"]);
                    break;
                case "3":
                    str = Common.GetUserName("3", HttpContext.Current.Session["HteacherId"]);
                    break;
                case "4":
                    str = Common.GetUserName("4", HttpContext.Current.Session["TeacherId"]);
                    break;
                default:
                    break;
            }
            str += "<li><a href=\"" + Common.getUrl() + "LogOut.aspx\">退出</a></li>";
        }
        else {
            str = "<li><a href=\"" + Common.getUrl() + "ClassShow/Login.aspx\">登录</a></li>";
        }
        return str;
    }
}
