﻿using System;
using System.Collections.Generic;
using System.Web;

/// <summary>
///PageBase 所有页面的基类
/// </summary>
/// 
public class PageBase : System.Web.UI.Page
{
    public PageBase()
    {
        //
        //TODO: 在此处添加构造函数逻辑
        //
    }

    /// <summary>
    /// 获取站点域名
    /// </summary>
    /// <returns></returns>
    public string getDomain()
    {
        return "http://" + Request.Url.Host + (Request.Url.Port == 80 ? "" : ":" + Request.Url.Port.ToString());

    }

    /// <summary>
    /// 获取站点路径
    /// </summary>
    /// <returns></returns>
    public string getUrl()
    {
        return "http://" + Request.Url.Host + (Request.Url.Port == 80 ? "" : ":" + Request.Url.Port.ToString()) + Request.ApplicationPath;

    }

    /// <summary>
    /// 执行一个JS语句
    /// </summary>
    /// <param name="sentence">要执行的语句</param>
    protected void ExecuteJs(string sentence)
    {
        Context.Response.Write("<script language=\"javascript\" type=\"text/javascript\">");
        Context.Response.Write(sentence);
        Context.Response.Write("</script>");
    }

    /// <summary>
    /// 弹出JS警告
    /// </summary>
    /// <param name="sentence"></param>
    protected void AlertJs(string sentence)
    {
        Context.Response.Write("<script language=\"javascript\" type=\"text/javascript\">");
        Context.Response.Write("alert('" + sentence + "')");
        Context.Response.Write("</script>");
    }

    protected void AlertJsClose(string sentence)
    {
        Context.Response.Write("<script language=\"javascript\" type=\"text/javascript\">");
        Context.Response.Write("alert('" + sentence + "');window.close();");
        Context.Response.Write("</script>");
    }

    protected void AlertBackJs(string sentence)
    {
        Context.Response.Write("<script language=\"javascript\" type=\"text/javascript\">");
        Context.Response.Write("alert('" + sentence + "');history.back(-1)");
        Context.Response.Write("</script>");
        Context.Response.End();
    }

    protected void AlertRedirectJs(string sentence, string url)
    {
        Context.Response.Write("<script language=\"javascript\" type=\"text/javascript\">");
        Context.Response.Write("alert('" + sentence + "');location.href='" + url + "'");
        Context.Response.Write("</script>");
        Context.Response.End();
    }
}
