﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using System.Text.RegularExpressions;

/// <summary>
///Pagination 分页查询类
/// </summary>
/// 
public class Pagination
{

    public static int Timeout = 30;

    public Pagination()
    {
        //
        //TODO: 在此处添加构造函数逻辑
        //
    }

    public static void SetTimeoutDefault()
    {
        Timeout = 30;
    }


    public static DataTable GetPageList(string[] Sql, int PageIndex, int PageSize, out int RecordCount, out int PageCount, List<SqlParameter> SqlCondition)
    {
        try
        {
            //string[] Sql = GetSqlSentence(PageName);
            string IndexField = Sql[0];
            string AllFields = Sql[1];
            string Condition = Sql[2];
            string OrderFields = Sql[3];

            List<SqlParameter> param = new List<SqlParameter>();
            if (SqlCondition != null && SqlCondition.Count > 0)
            {
                param = SqlCondition;
            }
            return ExecutePage(AllFields, Condition, IndexField, OrderFields, PageIndex, PageSize, out RecordCount, out PageCount, param.ToArray());
        }
        catch (SqlException e)
        {
            throw e;
        }
        catch (Exception e)
        {
            throw new Exception("用于分页的SQL语句无效:" + e.Message);
        }
    }


    /// <summary>
    /// 执行对默认数据库有自定义排序的分页的查询
    /// </summary>
    /// <param name="SqlAllFields">查询字段，如果是多表查询，请将必要的表名或别名加上，如:a.id,a.name,b.score</param>
    /// <param name="SqlTablesAndWhere">查询的表如果包含查询条件，也将条件带上，但不要包含order by子句，也不要包含"from"关键字，如:students a inner join achievement b on a.... where ....</param>
    /// <param name="IndexField">用以分页的不能重复的索引字段名，最好是主表的自增长字段，如果是多表查询，请带上表名或别名，如:a.id</param>
    /// <param name="OrderASC">排序方式,如果为true则按升序排序,false则按降序排</param>
    /// <param name="OrderFields">排序字段以及方式如：a.OrderID desc,CnName desc</OrderFields>
    /// <param name="PageIndex">当前页的页码</param>
    /// <param name="PageSize">每页记录数</param>
    /// <param name="RecordCount">输出参数，返回查询的总记录条数</param>
    /// <param name="PageCount">输出参数，返回查询的总页数</param>
    /// <returns>返回查询结果</returns>
    public static DataTable ExecutePage(string SqlAllFields, string SqlTablesAndWhere, string IndexField, string OrderFields, int PageIndex, int PageSize, out int RecordCount, out int PageCount, params DbParameter[] commandParameters)
    {
        return ExecutePage(WinStar.DBUtility.DbHelperSQL.connectionString, SqlAllFields, SqlTablesAndWhere, IndexField, OrderFields, PageIndex, PageSize, out  RecordCount, out  PageCount, commandParameters);
    }

    /// <summary>
    /// 执行有自定义排序的分页的查询
    /// </summary>
    /// <param name="connectionString">SQL数据库连接字符串</param>
    /// <param name="SqlAllFields">查询字段，如果是多表查询，请将必要的表名或别名加上，如:a.id,a.name,b.score</param>
    /// <param name="SqlTablesAndWhere">查询的表如果包含查询条件，也将条件带上，但不要包含order by子句，也不要包含"from"关键字，如:students a inner join achievement b on a.... where ....</param>
    /// <param name="IndexField">用以分页的不能重复的索引字段名，最好是主表的自增长字段，如果是多表查询，请带上表名或别名，如:a.id</param>
    /// <param name="OrderASC">排序方式,如果为true则按升序排序,false则按降序排</param>
    /// <param name="OrderFields">排序字段以及方式如：a.OrderID desc,CnName desc</OrderFields>
    /// <param name="PageIndex">当前页的页码</param>
    /// <param name="PageSize">每页记录数</param>
    /// <param name="RecordCount">输出参数，返回查询的总记录条数</param>
    /// <param name="PageCount">输出参数，返回查询的总页数</param>
    /// <returns>返回查询结果</returns>
    public static DataTable ExecutePage(string connectionString, string SqlAllFields, string SqlTablesAndWhere, string IndexField, string OrderFields, int PageIndex, int PageSize, out int RecordCount, out int PageCount, params DbParameter[] commandParameters)
    {
        using (SqlConnection connection = new SqlConnection(connectionString))
        {
            connection.ConnectionString = connectionString;
            try
            {
                connection.Open();
                return ExecutePage(connection, SqlAllFields, SqlTablesAndWhere, IndexField, OrderFields, PageIndex, PageSize, out RecordCount, out PageCount, commandParameters);
            }
            finally {
                connection.Close();
            }
        }
    }

    /// <summary>
    /// 执行有自定义排序的分页的查询
    /// </summary>
    /// <param name="connection">SQL数据库连接对象</param>
    /// <param name="SqlAllFields">查询字段，如果是多表查询，请将必要的表名或别名加上，如:a.id,a.name,b.score</param>
    /// <param name="SqlTablesAndWhere">查询的表如果包含查询条件，也将条件带上，但不要包含order by子句，也不要包含"from"关键字，如:students a inner join achievement b on a.... where ....</param>
    /// <param name="IndexField">用以分页的不能重复的索引字段名，最好是主表的自增长字段，如果是多表查询，请带上表名或别名，如:a.id</param>
    /// <param name="OrderASC">排序方式,如果为true则按升序排序,false则按降序排</param>
    /// <param name="OrderFields">排序字段以及方式如：a.OrderID desc,CnName desc</OrderFields>
    /// <param name="PageIndex">当前页的页码</param>
    /// <param name="PageSize">每页记录数</param>
    /// <param name="RecordCount">输出参数，返回查询的总记录条数</param>
    /// <param name="PageCount">输出参数，返回查询的总页数</param>
    /// <returns>返回查询结果</returns>
    public static DataTable ExecutePage(DbConnection connection, string SqlAllFields, string SqlTablesAndWhere, string IndexField, string OrderFields, int PageIndex, int PageSize, out int RecordCount, out int PageCount, params DbParameter[] commandParameters)
    {
        SqlCommand cmd = new SqlCommand();
        PrepareCommand(cmd, connection, null, CommandType.Text, "", commandParameters);
        string Sql = GetPageSql(connection, cmd, SqlAllFields, SqlTablesAndWhere, IndexField, OrderFields, PageIndex, PageSize, out  RecordCount, out  PageCount);
        cmd.CommandText = Sql;
        SqlDataAdapter ap = new SqlDataAdapter();
        ap.SelectCommand = cmd;
        DataSet st = new DataSet();
        ap.Fill(st, "PageResult");
        cmd.Parameters.Clear();
        return st.Tables["PageResult"];
    }

    /// <summary>
    /// 返回字符串在字符串中出现的次数
    /// </summary>
    /// <param name="Char">要检测出现的字符</param>
    /// <param name="String">要检测的字符串</param>
    /// <returns>出现次数</returns>

    public static int GetCharInStringCount(string Char, string String)
    {
        string str = String.Replace(Char, "");
        return (String.Length - str.Length) / Char.Length;

    }
    /// <summary>
    /// 取得分页的SQL语句
    /// </summary>
    /// <param name="connection"></param>
    /// <param name="cmd"></param>
    /// <param name="SqlAllFields"></param>
    /// <param name="SqlTablesAndWhere"></param>
    /// <param name="IndexField"></param>
    /// <param name="OrderFields"></param>
    /// <param name="PageIndex"></param>
    /// <param name="PageSize"></param>
    /// <param name="RecordCount"></param>
    /// <param name="PageCount"></param>
    /// <returns></returns>
    public static string GetPageSql(DbConnection connection, DbCommand cmd, string SqlAllFields, string SqlTablesAndWhere, string IndexField, string OrderFields, int PageIndex, int PageSize, out int RecordCount, out int PageCount)
    {
        RecordCount = 0;
        PageCount = 0;
        if (PageSize <= 0)
        {
            PageSize = 10;
        }
        string SqlCount = "select count(" + IndexField + ") from " + SqlTablesAndWhere;
        cmd.CommandText = SqlCount;
        RecordCount = (int)cmd.ExecuteScalar();
        if (RecordCount % PageSize == 0)
        {
            PageCount = RecordCount / PageSize;
        }
        else
        {
            PageCount = RecordCount / PageSize + 1;
        }
        if (PageIndex > PageCount)
            PageIndex = PageCount;
        if (PageIndex < 1)
            PageIndex = 1;
        string Sql = null;
        if (PageIndex == 1)
        {
            Sql = "select top " + PageSize + " " + SqlAllFields + " from " + SqlTablesAndWhere + " " + OrderFields;
        }
        else
        {
            Sql = "select top " + PageSize + " " + SqlAllFields + " from ";
            if (SqlTablesAndWhere.ToLower().IndexOf(" where ") > 0)
            {
                string _where = Regex.Replace(SqlTablesAndWhere, @"\ where\ ", " where (", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                Sql += _where;
                int y = GetCharInStringCount("where", SqlTablesAndWhere.ToLower());

                for (int x = 0; x < y; x++)
                {
                    Sql += ")";
                }
                Sql += " and (";
            }
            else
            {
                Sql += SqlTablesAndWhere + " where (";
            }
            Sql += IndexField + " not in (select top " + (PageIndex - 1) * PageSize + " " + IndexField + " from " + SqlTablesAndWhere + " " + OrderFields;
            Sql += ")) " + OrderFields;
        }
        return Sql;
    }

    private static void PrepareCommand(DbCommand cmd, DbConnection conn, DbTransaction trans, CommandType cmdType, string cmdText, DbParameter[] cmdParms)
    {

        if (conn.State != ConnectionState.Open)
            conn.Open();

        cmd.Connection = conn;
        cmd.CommandText = cmdText;

        if (trans != null)
            cmd.Transaction = trans;

        cmd.CommandType = cmdType;
        cmd.CommandTimeout = Timeout;
        if (cmdParms != null)
        {
            foreach (DbParameter parm in cmdParms)
                if (parm != null)
                    cmd.Parameters.Add(parm);
        }
    }
}
