﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class ClassList : IndexPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            this.LoadSystem();
            this.LoadNewsType();
            this.LoadClassList();
        }
    }
    /// <summary>
    /// 加载班级列表
    /// </summary>
    protected void LoadClassList()
    {
        try
        {
            DataTable cladt = WinStar.DBUtility.DbHelperSQL.Query("select cla.Id cid,cla.ClassNum clanum,cla.GId gid from HS_Class cla,HS_Grade gra where cla.GId=gra.Id order by gra.TypeAge,cla.GId,cla.ClassNum").Tables[0];
            this.ClassListAll.DataSource = GetTable(cladt);
            this.ClassListAll.DataBind();
        }
        catch { }
  
    }
    /// <summary>
    /// 对 DataTable 进行加工 过滤不要的东西
    /// </summary>
    /// <param name="table"></param>
    /// <returns></returns>
    public DataTable GetTable(DataTable table)
    {
        table.Columns.Add("ClassName");
        foreach (DataRow row in table.Rows)
        {
            string CName = GetCname(int.Parse(row["cid"].ToString()));
            if (CName != "<font color=red>已经毕业</font>" && CName != "<font color=red>还没开学</font>")
            {
                int count = 0;
                //判断是否是所带的班级
                if (Session["Type"] != null && !string.IsNullOrEmpty(Session["Type"].ToString()))
                {
                    if (Session["Type"].ToString() == "1")
                    {
                        count = int.Parse(WinStar.DBUtility.DbHelperSQL.GetSingle("select count(*) from HS_Student where Id=" + Session["UserId"] + " and ClassId=" + row["cid"].ToString()).ToString());
                    }
                    if (Session["Type"].ToString() == "2")
                    {
                        count = int.Parse(WinStar.DBUtility.DbHelperSQL.GetSingle("select count(*) from HS_Student where Id=" + Session["ParId"] + " and ClassId=" + row["cid"].ToString()).ToString());
                    }
                    if (Session["Type"].ToString() == "3")
                    {
                        count = int.Parse(WinStar.DBUtility.DbHelperSQL.GetSingle("select count(*) from HS_TeacherClass where TeacherId=" + Session["HteacherId"] + " and ClassId=" + row["cid"].ToString()).ToString());
                    }
                    if (Session["Type"].ToString() == "4")
                    {
                        count = int.Parse(WinStar.DBUtility.DbHelperSQL.GetSingle("select count(*) from HS_TeacherSubject where TeacherId=" +  Session["TeacherId"] + " and ClassId=" + row["cid"].ToString()).ToString());
                    }
                }

                if (count > 0)
                {
                    row["ClassName"] = "<span style='color:red;'>" + CName + "（" + row["clanum"] + "）班</span>";
                }
                else {
                    row["ClassName"] = CName + "（" + row["clanum"] + "）班";
                }
            }
            else
            {
                row.Delete();
            }
        }
        return table;

    }
    /// <summary>
    /// 获取班级名称
    /// </summary>
    /// <param name="classID">获取班级Id</param>
    /// <returns></returns>
    protected string GetCname(int classID)
    {
        try
        {
            string yein = "";
            int isgrade = 0;
            WinStar.Model.Class sclass = new WinStar.BLL.Class().GetModel(classID);
            int gid = Convert.ToInt32(sclass.GId);
            WinStar.Model.Grade grade = new WinStar.BLL.Grade().GetModel(gid);
            yein = grade.YearIn.ToString();
            isgrade = Convert.ToInt32(grade.TypeAge);
            return GetGradeName(yein, isgrade);
        }
        catch { return ""; }
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="yein">入学年份</param>
    /// <param name="isgrade">学段</param>
    /// <returns></returns>
    protected string GetGradeName(string yein, int isgrade)
    {
        int nowterm;//当前学期年份
        bool onetwo;//当前学期是第一学期还是第二学期
        DataTable dt = new WinStar.BLL.Term().GetList("IsNow=1").Tables[0];
        if (dt.Rows.Count > 0)
        {
            nowterm = DateTime.Parse(dt.Rows[0]["StartTime"].ToString()).Year;
            onetwo = Boolean.Parse(dt.Rows[0]["OneOrTwo"].ToString());
            return GetHowGrade(nowterm, int.Parse(yein), onetwo, isgrade);

        }
        else
        {
            return "<font color=\"red\">管理员暂未设置好学期</font>";
        }
    }
    /// <summary>
    /// 获取当前是几年级
    /// </summary>
    /// <param name="NowTerm">目前设置的学期是哪一年的</param>
    /// <param name="YeIn">入学年份</param>
    /// <param name="onetwo">目前是第一学期[false]还是第二学期[true] </param>
    /// <param name="isgrade">学段1 小学 2初中 3 高中</param>
    /// <returns></returns>
    protected string GetHowGrade(int NowTerm, int YeIn, bool onetwo, int isgrade)
    {
        int isclass, ot;
        if (!onetwo)
        {
            ot = 1;
        }
        else
        {
            ot = 0;
        }
        isclass = NowTerm - YeIn + ot;
        if (isclass <= 0)
        {
            return "<font color=red>还没开学</font>";
        }
        else if (isclass > 6 && isgrade == 1)
        {

            return "<font color=red>已经毕业</font>";
        }
        else if (isclass > 3 && (isgrade == 2 || isgrade == 3))
        {

            return "<font color=red>已经毕业</font>";
        }
        else
        {
            return GetTypeAge(isgrade.ToString()) + this.Temp(isclass) + "年级";
        }
    }
    protected string Temp(int num)
    {
        string str = string.Empty;
        try
        {
            switch (num)
            {
                case 1:
                    str = "一";
                    break;
                case 2:
                    str = "二";
                    break;
                case 3:
                    str = "三";
                    break;
                case 4:
                    str = "四";
                    break;
                case 5:
                    str = "五";
                    break;
                case 6:
                    str = "六";
                    break;
                case 7:
                    str = "七";
                    break;
                case 8:
                    str = "八";
                    break;
                case 9:
                    str = "九";
                    break;
            }
        }
        catch { }

        return str;
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="str">年级数字</param>
    /// <returns></returns>
    protected string GetTypeAge(string str)
    {
        if (str == "1")
        {
            return "小学";
        }
        else if (str == "2")
        {
            return "初中";
        }
        else
        {
            return "高中";

        }
    }
    /// <summary>
    /// 加载新闻分类
    /// </summary>
    protected void LoadNewsType()
    {
        try
        {
            DataTable dt = new WinStar.BLL.NewsType().GetAllList().Tables[0];
            this.NewsType.DataSource = dt;
            this.NewsType.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 加载配置信息
    /// </summary>
    protected void LoadSystem()
    {
        WinStar.Model.Config c = new WinStar.BLL.Config().GetModel(1);
        ViewState["SystemName"] = c.SystemName;
        ViewState["SchoolName"] = c.SName;
    }
}