﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class ClassShow_AskInfo : IndexPageBase
{
    public DataTable askdt;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            this.LoadSystem();
            this.LoadNewsType();
            if (!string.IsNullOrEmpty(Request.QueryString["id"]) && !string.IsNullOrEmpty(Request.QueryString["aid"]))
            {
                //设置为最佳答案
                SetBest();

                int classid = int.Parse(Request.QueryString["id"].ToString());//班级id
                ViewState["cid"] = classid;

                //教师管理权限
                ViewState["canManage"] = "0";
                if (Session["Type"] != null)
                {
                    if (Session["Type"].ToString() == "4")
                    {
                        ViewState["canManage"] = WinStar.DBUtility.DbHelperSQL.GetSingle("Select count(id) From HS_TeacherSubject Where ClassId=" + classid + " And TeacherId=" + Session["TeacherId"] + "");
                    }
                }
                //根据班级id获得班级对象信息
                WinStar.Model.Class cla = new WinStar.BLL.Class().GetModel(classid);

                //班级基本信息
                classlab.Text = Common.GetClassInfo(cla);

                //获得班级最新公告
                DataTable notice = WinStar.DBUtility.DbHelperSQL.Query("select top 1 * from HS_Notice where ClassId=" + classid + " order by CreateTime desc").Tables[0];
                Noticelab.Text = notice.Rows.Count > 0 ? "<span style='color:#999999;'>标题：</span>" + notice.Rows[0]["Title"] + "<br/>" + "<span>" + notice.Rows[0]["Content"] + "</span>" : "暂无公告信息！";

                //获得班级新闻最新5条新闻
                DataTable clnew = WinStar.DBUtility.DbHelperSQL.Query("select top 10 * from HS_News where ClassId=" + classid + " and TypeLevel=2 order by CreateTime desc").Tables[0];
                clnew.Columns.Add("num");
                for (int i = 0; i < clnew.Rows.Count; i++)
                {
                    clnew.Rows[i]["num"] = i + 1;
                }
                newlist.DataSource = clnew;
                newlist.DataBind();

                //获得班级答疑最新5条新闻
                DataTable clask = WinStar.DBUtility.DbHelperSQL.Query("select top 10 * from HS_Ask where ClassId=" + classid + " order by CreateTime desc").Tables[0];
                clask.Columns.Add("num");
                for (int i = 0; i < clask.Rows.Count; i++)
                {
                    clask.Rows[i]["num"] = i + 1;
                }
                asklist.DataSource = clask;
                asklist.DataBind();

                //获得班级答疑
                askdt = WinStar.DBUtility.DbHelperSQL.Query("select * from HS_Ask where Id=" + Request.QueryString["aid"]).Tables[0];
                AskInfoList.DataSource = askdt;
                AskInfoList.DataBind();
                ShowBest(askdt);

                //回复信息
                DataTable Replydt = WinStar.DBUtility.DbHelperSQL.Query("select * from HS_AskAnswer where AskId=" + Request.QueryString["aid"] + "  order by IsBest desc,CreateTime desc").Tables[0];
                ReplyList.DataSource = Replydt;
                ReplyList.DataBind();
                Rcountlab.Text = Replydt.Rows.Count>0?Replydt.Rows.Count.ToString():"0";
            }
            else
            {
                Response.Redirect("../Default.aspx");
            }
        }
    }
    /// <summary>
    /// 加载新闻分类
    /// </summary>
    protected void LoadNewsType()
    {
        try
        {
            DataTable dt = new WinStar.BLL.NewsType().GetAllList().Tables[0];
            this.NewsType.DataSource = dt;
            this.NewsType.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 加载配置信息
    /// </summary>
    protected void LoadSystem()
    {
        WinStar.Model.Config c = new WinStar.BLL.Config().GetModel(1);
        ViewState["SystemName"] = c.SystemName;
        ViewState["SchoolName"] = c.SName;
    }
    /// <summary>
    /// 设置最佳答案
    /// </summary>
    private void SetBest()
    {
        if (Session["Type"]!=null&&!string.IsNullOrEmpty(Request.QueryString["rid"]))
        {
            WinStar.DBUtility.DbHelperSQL.ExecuteSql("update HS_Ask set State=2 where Id=" + Request.QueryString["aid"]);
            WinStar.DBUtility.DbHelperSQL.ExecuteSql("update HS_AskAnswer set IsBest=1 where Id=" + Request.QueryString["rid"]);
            Common.alert("设置最佳答案成功！", "AskInfo.aspx?id=" + Request.QueryString["id"] + "&aid=" + Request.QueryString["aid"]);
        }
    }

    /// <summary>
    /// 是否显示设置最佳答案
    /// </summary>
    /// <param name="dt"></param>
    protected string ShowBest(object rid)
    {
        if (askdt.Rows[0]["State"].ToString() == "1" && Session["Type"] != null)
        {
            if (Session["Type"].ToString() == "1" || Session["Type"].ToString() == "3" || Session["Type"].ToString() == "4")
            {
                if (Session["Type"].ToString() == "1"&&Session["UserId"].ToString() == askdt.Rows[0]["UserId"].ToString())
                {
                    return "<div style=\"height: 15px;\"></div><a href=\"javascript:void(0)\" onclick=\"window.location.href='AskInfo.aspx?id=" + Request.QueryString["id"] + "&aid=" + Request.QueryString["aid"] + "&rid=" + rid + "'\">设置为最佳答案</a>";
                }
                rediv.Style["display"] = "block";
            }
        }

        return "";
    }

    /// <summary>
    /// 点击回复按钮事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Button1_Click(object sender, EventArgs e)
    {
        if (Session["Type"] != null)
        {
            WinStar.Model.AskAnswer ask = new WinStar.Model.AskAnswer();

            ask.AskId = int.Parse(Request.QueryString["aid"].ToString());
            ask.Content = ReplyTxt.Text;
            ask.CreateTime = DateTime.Now;
            ask.IsBest = false;
            ask.Title = "";
            ask.UserType = Session["Type"].ToString() == "1" ? 2 : 1;
            switch (Session["Type"].ToString())
            {
                case "1":
                    ask.UserId = int.Parse(Session["UserId"].ToString());
                    break;
                case "3":
                    ask.UserId = int.Parse(Session["HteacherId"].ToString());
                    break;
                case "4":
                    ask.UserId = int.Parse(Session["TeacherId"].ToString());
                    break;
            }

            new WinStar.BLL.AskAnswer().Add(ask);

            Common.alert("设置回复成功！", "AskInfo.aspx?id=" + Request.QueryString["id"] + "&aid=" + Request.QueryString["aid"]);
        }
        else
        {
            Common.alert("请先登录！", "Login.aspx");
        }
    }
}