﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class ClassShow_AskList : IndexPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        #region 分页调用函数
        this.PageNavigator1.OnPageChange += new PageChangeHandler(PageNavigator1_PageChange);
        #endregion
        if (!Page.IsPostBack)
        {
            this.LoadSystem();
            this.LoadNewsType();
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                int classid = int.Parse(Request.QueryString["id"].ToString());//班级id
                ViewState["cid"] = classid;
                //教师管理权限
                ViewState["canManage"] = "0";
                if (Session["Type"] != null)
                {
                    if(Session["Type"].ToString()=="4"){
                        ViewState["canManage"] = WinStar.DBUtility.DbHelperSQL.GetSingle("Select count(id) From HS_TeacherSubject Where ClassId=" + classid + " And TeacherId=" + Session["TeacherId"] + "");
                    }
                }
                //根据班级id获得班级对象信息
                WinStar.Model.Class cla = new WinStar.BLL.Class().GetModel(classid);

                //班级基本信息
                classlab.Text = Common.GetClassInfo(cla);

                //获得班级最新公告
                DataTable notice = WinStar.DBUtility.DbHelperSQL.Query("select top 1 * from HS_Notice where ClassId=" + classid + " order by CreateTime desc").Tables[0];
                Noticelab.Text = notice.Rows.Count > 0 ? "<span style='color:#999999;'>标题：</span>" + notice.Rows[0]["Title"] + "<br/>" + "<span>" + notice.Rows[0]["Content"] + "</span>" : "暂无公告信息！";

                //获得班级新闻最新10条新闻
                DataTable clnew = WinStar.DBUtility.DbHelperSQL.Query("select top 10 * from HS_News where ClassId=" + classid + " and TypeLevel=2 order by CreateTime desc").Tables[0];
                clnew.Columns.Add("num");
                for (int i = 0; i < clnew.Rows.Count; i++)
                {
                    clnew.Rows[i]["num"] = i + 1;
                }
                newlist.DataSource = clnew;
                newlist.DataBind();

                //获得班级答疑最新10条新闻
                DataTable clask = WinStar.DBUtility.DbHelperSQL.Query("select top 10 * from HS_Ask where ClassId=" + classid + " order by CreateTime desc").Tables[0];
                clask.Columns.Add("num");
                for (int i = 0; i < clask.Rows.Count; i++)
                {
                    clask.Rows[i]["num"] = i + 1;
                }
                asklist.DataSource = clask;
                asklist.DataBind();

                GetAskList(1);
            }
            else
            {
                Response.Redirect("../Default.aspx");
            }
        }
    }
    /// <summary>
    /// 加载新闻分类
    /// </summary>
    protected void LoadNewsType()
    {
        try
        {
            DataTable dt = new WinStar.BLL.NewsType().GetAllList().Tables[0];
            this.NewsType.DataSource = dt;
            this.NewsType.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 加载配置信息
    /// </summary>
    protected void LoadSystem()
    {
        WinStar.Model.Config c = new WinStar.BLL.Config().GetModel(1);
        ViewState["SystemName"] = c.SystemName;
        ViewState["SchoolName"] = c.SName;
    }
    /// <summary>
    /// 获得班级答疑
    /// </summary>
    /// <param name="classid"></param>
    private void GetAskList(int PageIndex)
    {
        //获得班级答疑
        int i, j;
        string[] Works_List = { "Id", "*", "HS_Ask where ClassId=" + Request.QueryString["id"], " ORDER BY CreateTime DESC" };
        DataTable dt = Pagination.GetPageList(Works_List, PageIndex, 20, out i, out j, null);
        this.PageNavigator1.PageCount = j;
        this.PageNavigator1.PageIndex = PageIndex;
        this.PageNavigator1.RecordCount = i;
        NoticeList.DataSource = dt;
        NoticeList.DataBind();
    }

    /// <summary>
    /// 控件分页
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="PageIndex"></param>
    public void PageNavigator1_PageChange(object sender, int PageIndex)
    {
        GetAskList(PageIndex);
    }

}