﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class ClassShow_Index : IndexPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        #region 分页调用函数
        this.PageNavigator1.OnPageChange += new PageChangeHandler(PageNavigator1_PageChange);
        #endregion
        if (!Page.IsPostBack)
        {
            this.LoadSystem();
            this.LoadNewsType();
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                LoginInfo();
                int classid = int.Parse(Request.QueryString["id"].ToString());//班级id
                //根据班级id获得班级对象信息
                WinStar.Model.Class cla = new WinStar.BLL.Class().GetModel(classid);

                //回复留言
                if (!string.IsNullOrEmpty(Request.QueryString["fid"]) && !string.IsNullOrEmpty(Request.Form["comment" + Request.QueryString["fid"]]))
                {
                    Reply(int.Parse(Request.QueryString["fid"]));
                }

                //发布留言
                if (!string.IsNullOrEmpty(Request.QueryString["send"]) && !string.IsNullOrEmpty(Request.Form["Mcontent"]))
                {
                    Sent();
                }

                //班级基本信息
                classlab.Text = Common.GetClassInfo(cla);
                class2lab.Text = classlab.Text;
                Stunum.Text = Common.GetClaStuNum(classid);//班级学员人数

                //获得班级最新公告
                DataTable notice = WinStar.DBUtility.DbHelperSQL.Query("select top 1 * from HS_Notice where ClassId=" + classid + " order by CreateTime desc").Tables[0];
                Noticelab.Text = notice.Rows.Count > 0 ? "<span style='color:#999999;'>标题：</span>" + notice.Rows[0]["Title"] + "<br/>" + "<span>" + notice.Rows[0]["Content"] + "</span>" : "暂无公告信息！";

                //获得班级新闻最新5条新闻
                DataTable clnew = WinStar.DBUtility.DbHelperSQL.Query("select top 10 * from HS_News where ClassId=" + classid + " and TypeLevel=2 order by CreateTime desc").Tables[0];
                clnew.Columns.Add("num");
                for (int i = 0; i < clnew.Rows.Count; i++)
                {
                    clnew.Rows[i]["num"] = i + 1;
                }
                newlist.DataSource = clnew;
                newlist.DataBind();

                //获得班级答疑最新5条新闻
                DataTable clask = WinStar.DBUtility.DbHelperSQL.Query("select top 10 * from HS_Ask where ClassId=" + classid + " order by CreateTime desc").Tables[0];
                clask.Columns.Add("num");
                for (int i = 0; i < clask.Rows.Count; i++)
                {
                    clask.Rows[i]["num"] = i + 1;
                }
                asklist.DataSource = clask;
                asklist.DataBind();

                // 获得班级留言信息
                int pageindex=1;
                if (!string.IsNullOrEmpty(Request.QueryString["pid"]))
                {
                    pageindex = int.Parse(Request.QueryString["pid"].ToString());
                }
                GetMessList(pageindex);
            }
            else
            {
                Response.Redirect("../Default.aspx");
            }
        }
    }
    /// <summary>
    /// 加载新闻分类
    /// </summary>
    protected void LoadNewsType()
    {
        try
        {
            DataTable dt = new WinStar.BLL.NewsType().GetAllList().Tables[0];
            this.NewsType.DataSource = dt;
            this.NewsType.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 加载配置信息
    /// </summary>
    protected void LoadSystem()
    {
        WinStar.Model.Config c = new WinStar.BLL.Config().GetModel(1);
        ViewState["SystemName"] = c.SystemName;
        ViewState["SchoolName"] = c.SName;
    }
    /// <summary>
    /// 获得班级留言信息
    /// </summary>
    /// <param name="classid"></param>
    private void GetMessList(int PageIndex)
    {
        //获得班级留言信息
        int i, j;
        string[] Works_List = { "Id", "*", "HS_ForumList where ClassId=" + Request.QueryString["id"], " ORDER BY CreateTime DESC" };
        DataTable dt = Pagination.GetPageList(Works_List, PageIndex,20, out i, out j, null);
        this.PageNavigator1.PageCount = j;
        this.PageNavigator1.PageIndex = PageIndex;
        this.PageNavigator1.RecordCount = i;
        messlist.DataSource = dt;
        messlist.DataBind();
    }

    /// <summary>
    /// 控件分页
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="PageIndex"></param>
    public void PageNavigator1_PageChange(object sender, int PageIndex)
    {
        LoginInfo();
        Pindex.Value =PageIndex.ToString();
        GetMessList(PageIndex);
    }

    /// <summary>
    /// 获得留言信息的回复信息
    /// </summary>
    /// <param name="messid"></param>
    protected DataTable  GetAnswer(object messid)
    {
        DataTable answer = WinStar.DBUtility.DbHelperSQL.Query("select * from HS_ForumReply where FId=" + messid + " order by CreateTime desc").Tables[0];

        string count = answer.Rows.Count.ToString();

        return answer;
    }
    /// <summary>
    /// 获得登录信息
    /// </summary>
    protected void LoginInfo()
    {
        if (Session["Type"] != null)
        {
            switch (Session["Type"].ToString())
            {
                case "1":
                    uid.Value = Session["UserId"].ToString();
                    Ruid.Value = Session["UserId"].ToString();
                    type.Value = "2";
                    Rtype.Value = "2";
                    break;
                case "2":
                    uid.Value = Session["ParId"].ToString();
                    Ruid.Value = Session["ParId"].ToString();
                    type.Value = "3";
                    Rtype.Value = "3";
                    break;
                case "3":
                    uid.Value = Session["HteacherId"].ToString();
                    Ruid.Value = Session["HteacherId"].ToString();
                    type.Value = "1";
                    Rtype.Value = "1";
                    break;
                case "4":
                    uid.Value = Session["TeacherId"].ToString();
                    Ruid.Value = Session["TeacherId"].ToString();
                    type.Value = "1";
                    Rtype.Value = "1";
                    break;
                default:
                    break;
            }
        }
    }

    /// <summary>
    /// 点击发布留言按钮事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Sent()
    {
        if (Session["Type"] != null && !string.IsNullOrEmpty(Request.Form["Rtype"]) && !string.IsNullOrEmpty(Request.Form["Ruid"]))
        {
            try
            {
                string Mcon = Request.Form["Mcontent"];
                WinStar.Model.ForumList flist = new WinStar.Model.ForumList();
                flist.ClassId = int.Parse(Request.QueryString["id"].ToString());
                flist.Content = Mcon;
                flist.CreateTime = DateTime.Now;
                flist.State = 1;
                flist.Title = "";
                flist.UserType = int.Parse(Request.Form["type"]);
                flist.UserId = int.Parse(Request.Form["uid"]);
                new WinStar.BLL.ForumList().Add(flist);
                Common.alert("发布成功！", "Default.aspx?id=" + Request.QueryString["id"]);
            }
            catch (Exception)
            {
            }
        }
        else
        {
            Common.alert("请先登录！", "Login.aspx");
        }
    }

    /// <summary>
    /// 回复信息
    /// </summary>
    /// <param name="fid"></param>
    protected void Reply(int fid)
    {
        if (Session["Type"] != null && !string.IsNullOrEmpty(Request.Form["Rtype"]) && !string.IsNullOrEmpty(Request.Form["Ruid"]))
        {
            try
            {
                string ReCon = Request.Form["comment" + fid];
                WinStar.Model.ForumReply reply = new WinStar.Model.ForumReply();
                reply.Title = "";
                reply.Content = ReCon;
                reply.CreateTime = DateTime.Now;
                reply.FId = fid;
                reply.UserType = int.Parse(Request.Form["Rtype"]);
                reply.UserId = int.Parse(Request.Form["Ruid"]);
                new WinStar.BLL.ForumReply().Add(reply);
                string a = Request.Form["Pindex"];
                Common.alert("回复成功！", "Default.aspx?id=" + Request.QueryString["id"] + "&pid=" + Request.Form["Pindex"]);
            }
            catch (Exception)
            {
            }
        }
        else
        {
            Common.alert("请先登录！", "Login.aspx");
        }
    }
}