﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class ClassShow_LessonList : IndexPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            this.LoadSystem();
            this.LoadNewsType();
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                int classid = int.Parse(Request.QueryString["id"].ToString());//班级id
                //根据班级id获得班级对象信息
                WinStar.Model.Class cla = new WinStar.BLL.Class().GetModel(classid);
                //班级基本信息
                classlab.Text = Common.GetClassInfo(cla);
                LoadCourseList(classid);
            }
            else
            {
                Response.Redirect("../Default.aspx");
            }
        }
    }

    /// <summary>
    /// 加载新闻分类
    /// </summary>
    protected void LoadNewsType()
    {
        try
        {
            DataTable dt = new WinStar.BLL.NewsType().GetAllList().Tables[0];
            this.NewsType.DataSource = dt;
            this.NewsType.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 加载配置信息
    /// </summary>
    protected void LoadSystem()
    {
        WinStar.Model.Config c = new WinStar.BLL.Config().GetModel(1);
        ViewState["SystemName"] = c.SystemName;
        ViewState["SchoolName"] = c.SName;
    }

    protected void LoadCourseList(int cid)
    {
        try
        {
            DataTable c = new WinStar.BLL.CourseTable().GetList("ClassId=" + cid + "").Tables[0];
            if (c.Rows.Count > 0)
            {
                System.Text.StringBuilder listStr = new System.Text.StringBuilder();


                listStr.AppendLine("<ul class='ulTab " + this.getXq("星期一") + "'>");
                listStr.AppendLine("<li class='liXq'>星期一</li>");
                listStr.AppendLine("<li class='liSw'>上午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][2] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][3] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][4] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][5] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][6] + "</li>");
                listStr.AppendLine("<li class='liSw'>下午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][7] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][8] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][9] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][10] + "</li>");
                listStr.AppendLine("<li class='liSw'>自修</li>");
                listStr.AppendLine("<li>" + c.Rows[0][11] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][12] + "</li>");
                listStr.AppendLine("</ul>");

                listStr.AppendLine("<ul class='ulTab " + this.getXq("星期二") + "'>");
                listStr.AppendLine("<li class='liXq'>星期二</li>");
                listStr.AppendLine("<li class='liSw'>上午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][13] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][14] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][15] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][16] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][17] + "</li>");
                listStr.AppendLine("<li class='liSw'>下午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][18] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][19] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][20] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][21] + "</li>");
                listStr.AppendLine("<li class='liSw'>自修</li>");
                listStr.AppendLine("<li>" + c.Rows[0][22] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][23] + "</li>");
                listStr.AppendLine("</ul>");

                listStr.AppendLine("<ul class='ulTab " + this.getXq("星期三") + "'>");
                listStr.AppendLine("<li class='liXq'>星期三</li>");
                listStr.AppendLine("<li class='liSw'>上午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][24] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][25] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][26] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][27] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][28] + "</li>");
                listStr.AppendLine("<li class='liSw'>下午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][29] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][30] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][31] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][32] + "</li>");
                listStr.AppendLine("<li class='liSw'>自修</li>");
                listStr.AppendLine("<li>" + c.Rows[0][33] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][34] + "</li>");
                listStr.AppendLine("</ul>");

                listStr.AppendLine("<ul class='ulTab " + this.getXq("星期四") + "'>");
                listStr.AppendLine("<li class='liXq'>星期四</li>");
                listStr.AppendLine("<li class='liSw'>上午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][35] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][36] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][37] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][38] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][39] + "</li>");
                listStr.AppendLine("<li class='liSw'>下午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][40] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][41] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][42] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][43] + "</li>");
                listStr.AppendLine("<li class='liSw'>自修</li>");
                listStr.AppendLine("<li>" + c.Rows[0][44] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][45] + "</li>");
                listStr.AppendLine("</ul>");

                listStr.AppendLine("<ul class='ulTab " + this.getXq("星期五") + "'>");
                listStr.AppendLine("<li class='liXq'>星期五</li>");
                listStr.AppendLine("<li class='liSw'>上午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][46] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][47] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][48] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][49] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][50] + "</li>");
                listStr.AppendLine("<li class='liSw'>下午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][51] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][52] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][53] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][54] + "</li>");
                listStr.AppendLine("<li class='liSw'>自修</li>");
                listStr.AppendLine("<li>" + c.Rows[0][55] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][56] + "</li>");
                listStr.AppendLine("</ul>");

                listStr.AppendLine("<ul class='ulTab " + this.getXq("星期六") + "'>");
                listStr.AppendLine("<li class='liXq'>星期六</li>");
                listStr.AppendLine("<li class='liSw'>上午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][57] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][58] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][59] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][60] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][61] + "</li>");
                listStr.AppendLine("<li class='liSw'>下午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][62] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][63] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][64] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][65] + "</li>");
                listStr.AppendLine("<li class='liSw'>自修</li>");
                listStr.AppendLine("<li>" + c.Rows[0][66] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][67] + "</li>");
                listStr.AppendLine("</ul>");

                listStr.AppendLine("<ul class='ulTab " + this.getXq("星期日") + "'>");
                listStr.AppendLine("<li class='liXq'>星期天</li>");
                listStr.AppendLine("<li class='liSw'>上午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][68] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][69] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][70] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][71] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][72] + "</li>");
                listStr.AppendLine("<li class='liSw'>下午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][73] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][74] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][75] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][76] + "</li>");
                listStr.AppendLine("<li class='liSw'>自修</li>");
                listStr.AppendLine("<li>" + c.Rows[0][77] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][78] + "</li>");
                listStr.AppendLine("</ul>");
                this.tdCourseList.InnerHtml = listStr.ToString();
            }
            else
            {
                this.tdCourseList.InnerHtml = "<center>班主任还没有设置课程表，请过段时间来看！</center>";
            }

        }
        catch
        {

        }
    }

    protected string getXq(string Xq)
    {
        string abc = DateTime.Now.GetDateTimeFormats('D')[2].ToString().Substring(0, 3);
        if (Xq == abc)
        {
            return "isSelect";
        }
        else
        {
            return "";
        }
    }
}