﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;

public partial class ClassShow_Login : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            this.LoadSystem();
            this.LoadNewsType();
            if (Request.Cookies["State"] != null)
            {
                if (Request.Cookies["State"].Value == "1")
                {
                    if (Request.Cookies["StateName"] != null && Request.Cookies["StateType"] != null)
                    {
                        this.Nametxt.Text = Request.Cookies["StateName"].Value;
                        this.TypeList.SelectedValue = Request.Cookies["StateType"].Value;
                    }
                }
            }
        }
    }
    /// <summary>
    /// 加载新闻分类
    /// </summary>
    protected void LoadNewsType()
    {
        try
        {
            DataTable dt = new WinStar.BLL.NewsType().GetAllList().Tables[0];
            this.NewsType.DataSource = dt;
            this.NewsType.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 加载配置信息
    /// </summary>
    protected void LoadSystem()
    {
        WinStar.Model.Config c = new WinStar.BLL.Config().GetModel(1);
        ViewState["SystemName"] = c.SystemName;
        ViewState["SchoolName"] = c.SName;
    }
    /// <summary>
    /// 点击登录按钮
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Button1_Click(object sender, System.EventArgs e)
    {
        string logintype = TypeList.SelectedValue;//登录类型
        string username = this.Nametxt.Text.Trim();//用户名
        string password = this.Passwordtxt.Text.Trim();//密码

        //数据查询匹配
        SqlParameter param = new SqlParameter("@UserName", SqlDbType.VarChar);
        param.Value = username;
        string sql = "";
        switch (logintype)
        {
            case "student":
                sql = "SELECT Id,Num,TrueName,ClassId,PassWord as pw FROM HS_Student WHERE Num=@UserName";
                break;
            case "parents":
                sql = "SELECT Id,Num,TrueName,ClassId,ParentPWD as pw FROM HS_Student WHERE Num=@UserName";
                break;
            case "hteacher":
                sql = "SELECT Id,TrueName,UserName,PassWord as pw FROM HS_Teacher WHERE UserName=@UserName";
                break;
            case "teacher":
                sql = "SELECT Id,TrueName,UserName,PassWord as pw FROM HS_Teacher WHERE UserName=@UserName";
                break;
        }
        DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql, param).Tables[0];
        if (dt != null && dt.Rows.Count > 0)
        {
            if (dt.Rows[0]["pw"].ToString().Equals(password))
            {
                //设置COOKIE
                if (logintype == "student")//学生
                {
                    HttpCookie cookie = new HttpCookie("StudentMaster");
                    cookie.Values["UserId"] = dt.Rows[0]["Id"].ToString();
                    cookie.Values["Num"] = dt.Rows[0]["Num"].ToString();
                    cookie.Values["ClassId"] = dt.Rows[0]["ClassId"].ToString();
                    Response.Cookies["Type"].Value = "1";
                    Response.Cookies["State"].Value = Request.Form["loginstate"] == "on" ? "1" : "0";//1记住用户登录状态
                    Response.Cookies["State"].Expires = DateTime.Now.AddDays(365);
                    Response.Cookies["StateName"].Value = dt.Rows[0]["Num"].ToString();//记住用户名
                    Response.Cookies["StateName"].Expires = DateTime.Now.AddDays(365);
                    Response.Cookies["StateType"].Value = "student";//登录类型
                    Response.Cookies["StateType"].Expires = DateTime.Now.AddDays(365);
                    Response.Cookies.Add(cookie);
                    Session["UserId"] = dt.Rows[0]["Id"].ToString();
                    Session["Num"] = dt.Rows[0]["Num"].ToString();
                    Session["ClassId"] = dt.Rows[0]["ClassId"].ToString();
                    Session["Type"] = "1";
                    Session["State"] = Request.Form["loginstate"] == "on" ? "1" : "0";//1记住用户登录状态
                    Response.Redirect("Default.aspx?id=" + dt.Rows[0]["ClassId"]);
                }
                else if (logintype == "parents")//家长
                {
                    HttpCookie cookie = new HttpCookie("ParentsMaster");
                    cookie.Values["ParId"] = dt.Rows[0]["Id"].ToString();
                    cookie.Values["ParNum"] = dt.Rows[0]["Num"].ToString();
                    cookie.Values["ParClassId"] = dt.Rows[0]["ClassId"].ToString();
                    Response.Cookies["Type"].Value = "2";
                    Response.Cookies["State"].Value = Request.Form["loginstate"] == "on" ? "1" : "0";//1记住用户登录状态
                    Response.Cookies["State"].Expires = DateTime.Now.AddDays(365);
                    Response.Cookies["StateName"].Value = dt.Rows[0]["Num"].ToString();//记住用户名
                    Response.Cookies["StateName"].Expires = DateTime.Now.AddDays(365);
                    Response.Cookies["StateType"].Value = "parents";//登录类型
                    Response.Cookies["StateType"].Expires = DateTime.Now.AddDays(365);
                    Response.Cookies.Add(cookie);
                    Session["ParId"] = dt.Rows[0]["Id"].ToString();
                    Session["ParNum"] = dt.Rows[0]["Num"].ToString();
                    Session["ParClassId"] = dt.Rows[0]["ClassId"].ToString();
                    Session["Type"] = "2";
                    Session["State"] = Request.Form["loginstate"] == "on" ? "1" : "0";//1记住用户登录状态
                    Response.Redirect("Default.aspx?id=" + dt.Rows[0]["ClassId"]);
                }
                else if (logintype == "hteacher")//老师
                {
                    HttpCookie cookie = new HttpCookie("HteacherMaster");
                    cookie.Values["HteacherId"] = dt.Rows[0]["Id"].ToString();
                    Session["HteacherId"] = dt.Rows[0]["Id"].ToString();
                    cookie.Values["HuserName"] = dt.Rows[0]["UserName"].ToString();
                    Session["HuserName"] = dt.Rows[0]["UserName"].ToString();
                    Response.Cookies["State"].Value = Request.Form["loginstate"] == "on" ? "1" : "0";//1记住用户登录状态
                    Session["State"] = Request.Form["loginstate"] == "on" ? "1" : "0";//1记住用户登录状态
                    Response.Cookies["Type"].Value = "3";
                    Session["Type"] = "3";
                    Response.Cookies["State"].Expires = DateTime.Now.AddDays(365);
                    Response.Cookies["StateName"].Value = dt.Rows[0]["UserName"].ToString();//记住用户名
                    Response.Cookies["StateName"].Expires = DateTime.Now.AddDays(365);
                    Response.Cookies["StateType"].Value = "hteacher";//登录类型
                    Response.Cookies["StateType"].Expires = DateTime.Now.AddDays(365);
                    Response.Cookies.Add(cookie);
                    Response.Redirect("../ClassList.aspx");
                }
                else
                {
                    HttpCookie cookie = new HttpCookie("TeacherMaster");
                    cookie.Values["TeacherId"] = dt.Rows[0]["Id"].ToString();
                    Session["TeacherId"] = dt.Rows[0]["Id"].ToString();
                    cookie.Values["UserName"] = dt.Rows[0]["UserName"].ToString();
                    Session["UserName"] = dt.Rows[0]["UserName"].ToString();
                    Response.Cookies["State"].Value = Request.Form["loginstate"] == "on" ? "1" : "0";//1记住用户登录状态
                    Session["State"] = Request.Form["loginstate"] == "on" ? "1" : "0";//1记住用户登录状态
                    Response.Cookies["Type"].Value = "4";
                    Session["Type"] = "4";
                    Response.Cookies["State"].Expires = DateTime.Now.AddDays(365);
                    Response.Cookies["StateName"].Value = dt.Rows[0]["UserName"].ToString();//记住用户名
                    Response.Cookies["StateName"].Expires = DateTime.Now.AddDays(365);
                    Response.Cookies["StateType"].Value = "teacher";//登录类型
                    Response.Cookies["StateType"].Expires = DateTime.Now.AddDays(365);
                    Response.Cookies.Add(cookie);
                    Response.Redirect("../ClassList.aspx");
                }
            }
            else
            {
                Common.alert("用户名或密码错误!");
            }
        }
        else
        {
            Common.alert("不存在的用户名!");
        }
    }
}