﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class ClassShow_MemberList : IndexPageBase
{
    public string Stuinfo = "";
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            this.LoadSystem();
            this.LoadNewsType();
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                int classid = int.Parse(Request.QueryString["id"].ToString());//班级id
                //根据班级id获得班级对象信息
                WinStar.Model.Class cla = new WinStar.BLL.Class().GetModel(classid);

                //班级基本信息
                classlab.Text = Common.GetClassInfo(cla);

                //班级成员信息
                DataTable dt = WinStar.DBUtility.DbHelperSQL.Query("select * from HS_Student where ClassId="+classid).Tables[0];
                StuList.DataSource = dt;
                StuList.DataBind();
                int body = 0; int girl = 0;//男生，女生个数
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    if (Convert.ToBoolean(dt.Rows[i]["Sex"]))
                        body+=1;
                    else
                        girl+=1;
                }
                Stuinfo = "共" + dt.Rows.Count + "人&nbsp;" + "男" + body + "&nbsp;女" + girl+"";
            }
            else
            {
                Response.Redirect("../Default.aspx");
            }
        }
    }
    /// <summary>
    /// 加载新闻分类
    /// </summary>
    protected void LoadNewsType()
    {
        try
        {
            DataTable dt = new WinStar.BLL.NewsType().GetAllList().Tables[0];
            this.NewsType.DataSource = dt;
            this.NewsType.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 加载配置信息
    /// </summary>
    protected void LoadSystem()
    {
        WinStar.Model.Config c = new WinStar.BLL.Config().GetModel(1);
        ViewState["SystemName"] = c.SystemName;
        ViewState["SchoolName"] = c.SName;
    }

    /// <summary>
    /// 获得学生职务
    /// </summary>
    /// <param name="sid"></param>
    /// <returns></returns>
    protected string StuPost(object sid)
    {
        return WinStar.DBUtility.DbHelperSQL.GetSingle("select Name from HS_StudentPost where Id="+ sid.ToString()).ToString();
    }
}