﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class ClassShow_NewsInfo : IndexPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            this.LoadSystem();
            this.LoadNewsType();
            if (!string.IsNullOrEmpty(Request.QueryString["id"]) && !string.IsNullOrEmpty(Request.QueryString["nid"]))
            {
                int classid = int.Parse(Request.QueryString["id"].ToString());//班级id
                //根据班级id获得班级对象信息
                WinStar.Model.Class cla = new WinStar.BLL.Class().GetModel(classid);

                //班级基本信息
                classlab.Text = Common.GetClassInfo(cla);

                //获得班级最新公告
                DataTable notice = WinStar.DBUtility.DbHelperSQL.Query("select top 1 * from HS_Notice where ClassId=" + classid + " order by CreateTime desc").Tables[0];
                Noticelab.Text = notice.Rows.Count > 0 ? "<span style='color:#999999;'>标题：</span>" + notice.Rows[0]["Title"] + "<br/>" + "<span>" + notice.Rows[0]["Content"] + "</span>" : "暂无公告信息！";

                //获得班级新闻最新5条新闻
                DataTable clnew = WinStar.DBUtility.DbHelperSQL.Query("select top 10 * from HS_News where ClassId=" + classid + " and TypeLevel=2 order by CreateTime desc").Tables[0];
                clnew.Columns.Add("num");
                for (int i = 0; i < clnew.Rows.Count; i++)
                {
                    clnew.Rows[i]["num"] = i + 1;
                }
                newlist.DataSource = clnew;
                newlist.DataBind();

                //获得班级答疑最新5条新闻
                DataTable clask = WinStar.DBUtility.DbHelperSQL.Query("select top 10 * from HS_Ask where ClassId=" + classid + " order by CreateTime desc").Tables[0];
                clask.Columns.Add("num");
                for (int i = 0; i < clask.Rows.Count; i++)
                {
                    clask.Rows[i]["num"] = i + 1;
                }
                asklist.DataSource = clask;
                asklist.DataBind();

                //获得班级新闻
                DataTable dt =WinStar.DBUtility.DbHelperSQL.Query("select * from HS_News where Id=" + Request.QueryString["nid"]).Tables[0];
                NoticeList.DataSource = dt;
                NoticeList.DataBind();

                //新闻查看加1
                WinStar.Model.News news = new WinStar.BLL.News().GetModel(int.Parse(Request.QueryString["nid"].ToString()));
                if (string.IsNullOrEmpty(news.Hits.ToString()))
                {
                    news.Hits = 1;
                }
                else
                {
                    news.Hits = news.Hits + 1;
                }
                new WinStar.BLL.News().Update(news);
            }
            else
            {
                Response.Redirect("../Default.aspx");
            }
        }
    }
    /// <summary>
    /// 加载新闻分类
    /// </summary>
    protected void LoadNewsType()
    {
        try
        {
            DataTable dt = new WinStar.BLL.NewsType().GetAllList().Tables[0];
            this.NewsType.DataSource = dt;
            this.NewsType.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 加载配置信息
    /// </summary>
    protected void LoadSystem()
    {
        WinStar.Model.Config c = new WinStar.BLL.Config().GetModel(1);
        ViewState["SystemName"] = c.SystemName;
        ViewState["SchoolName"] = c.SName;
    }
}