﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class ClassShow_PhotoList : IndexPageBase
{
    public string Login = "";
    protected void Page_Load(object sender, EventArgs e)
    {
        #region 分页调用函数
        this.PageNavigator1.OnPageChange += new PageChangeHandler(PageNavigator1_PageChange);
        #endregion
        if (!Page.IsPostBack)
        {
            LoadSystem(); LoadNewsType();
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                int classid = int.Parse(Request.QueryString["id"].ToString());//班级id
                //根据班级id获得班级对象信息
                WinStar.Model.Class cla = new WinStar.BLL.Class().GetModel(classid);
                //班级基本信息
                classlab.Text = Common.GetClassInfo(cla);
                //获得班级图片信息
                GetNoticeList(1);
            }
            else
            {
                Response.Redirect("../Default.aspx");
            }
        }
    }

    /// <summary>
    /// 加载新闻分类
    /// </summary>
    protected void LoadNewsType()
    {
        try
        {
            DataTable dt = new WinStar.BLL.NewsType().GetAllList().Tables[0];
            this.NewsType.DataSource = dt;
            this.NewsType.DataBind();
        }
        catch { }
    }

    /// <summary>
    /// 加载配置信息
    /// </summary>
    protected void LoadSystem()
    {
        WinStar.Model.Config c = new WinStar.BLL.Config().GetModel(1);
        ViewState["SystemName"] = c.SystemName;
        ViewState["SchoolName"] = c.SName;
    }

    /// <summary>
    /// 获得班级新闻
    /// </summary>
    /// <param name="classid"></param>
    private void GetNoticeList(int PageIndex)
    {
        //获得班级新闻
        int i, j;
        index.Value = PageIndex.ToString();
        string[] Works_List = { "Id", "*", "HS_ClassPhoto where ClassId=" + Request.QueryString["id"], " ORDER BY CreateTime DESC" };
        DataTable dt = Pagination.GetPageList(Works_List, PageIndex, 60, out i, out j, null);
        this.PageNavigator1.PageCount = j;
        this.PageNavigator1.PageIndex = PageIndex;
        this.PageNavigator1.RecordCount = i;
        dt.Columns.Add("num");
        for (int k = 0; k < dt.Rows.Count; k++)
        {
            dt.Rows[k]["num"] =k+1;
        }
        PicList.DataSource = dt;
        PicList.DataBind();
    }

    /// <summary>
    /// 控件分页
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="PageIndex"></param>
    public void PageNavigator1_PageChange(object sender, int PageIndex)
    {
        GetNoticeList(PageIndex);
    }

    /// <summary>
    /// 获得图片链接url
    /// </summary>
    /// <returns></returns>
    protected string GetUrl(object num)
    {
        return "PhotoInfo.aspx?id=" + Request.QueryString["id"] + "&num=" + num + "&index=" + index.Value;
    }

    /// <summary>
    /// 图片标题
    /// </summary>
    /// <param name="title"></param>
    /// <returns></returns>
    protected string GetTitle(object title)
    {
        return !string.IsNullOrEmpty(title.ToString())?title.ToString():"无标题";
    }
}