﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.IO;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class ClassShow_PhotoManage : IndexPageBase
{
    public string Login = "";
    protected void Page_Load(object sender, EventArgs e)
    {
        #region 分页调用函数
        this.PageNavigator1.OnPageChange += new PageChangeHandler(PageNavigator1_PageChange);
        #endregion
        if (!Page.IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]) && Session["Type"] != null)
            {
                LoadSystem(); LoadNewsType();
                if (!string.IsNullOrEmpty(Request.QueryString["pid"]))
                {
                    int pid = int.Parse(Request.QueryString["pid"].ToString());//图片id
                    //获得图片对象删除图片,释放资源
                    WinStar.Model.ClassPhoto Cphoto = new WinStar.BLL.ClassPhoto().GetModel(pid);
                    if (File.Exists(Server.MapPath(@"upfile\" + Cphoto.FileUrl)))
                    {
                        File.Delete(Server.MapPath(@"upfile\" + Cphoto.FileUrl));
                    }
                    if (File.Exists(Server.MapPath(@"upfile\0" + Cphoto.FileUrl)))
                    {
                        File.Delete(Server.MapPath(@"upfile\0" + Cphoto.FileUrl));
                    }
                    if (File.Exists(Server.MapPath(@"upfile\" + Cphoto.SmailUrl)))
                    {
                        File.Delete(Server.MapPath(@"upfile\" + Cphoto.SmailUrl));
                    }
                    new WinStar.BLL.ClassPhoto().Delete(pid);
                    Response.Redirect("PhotoManage.aspx?id=" + Request.QueryString["id"]);
                }

                int classid = int.Parse(Request.QueryString["id"].ToString());//班级id
                //根据班级id获得班级对象信息
                WinStar.Model.Class cla = new WinStar.BLL.Class().GetModel(classid);

                //班级基本信息
                classlab.Text = Common.GetClassInfo(cla);

                //获得班级图片信息
                GetNoticeList(1);
            }
            else
            {
                Response.Redirect("../Default.aspx");
            }
        }
    }

    /// <summary>
    /// 加载新闻分类
    /// </summary>
    protected void LoadNewsType()
    {
        try
        {
            DataTable dt = new WinStar.BLL.NewsType().GetAllList().Tables[0];
            this.NewsType.DataSource = dt;
            this.NewsType.DataBind();
        }
        catch { }
    }

    /// <summary>
    /// 加载配置信息
    /// </summary>
    protected void LoadSystem()
    {
        WinStar.Model.Config c = new WinStar.BLL.Config().GetModel(1);
        ViewState["SystemName"] = c.SystemName;
        ViewState["SchoolName"] = c.SName;
    }

    /// <summary>
    /// 获得班级新闻
    /// </summary>
    /// <param name="classid"></param>
    private void GetNoticeList(int PageIndex)
    {
        //获得班级新闻
        int i, j;
        string sql = "";
        switch (Session["Type"].ToString())
        {
            case "1":
                sql = " and UserType=2 and UserId=" + Session["UserId"];
                break;
            case "2":
                sql = " and UserType=3 and UserId=" + Session["ParId"];
                break;
            case "3":
                sql = " and UserType=1 and UserId=" + Session["HteacherId"];
                break;
            case "4":
                sql = " and UserType=1 and UserId=" + Session["TeacherId"];
                break;
        }
        string[] Works_List = { "Id", "*", "HS_ClassPhoto where ClassId=" + Request.QueryString["id"] + sql, " ORDER BY CreateTime DESC" };
        DataTable dt = Pagination.GetPageList(Works_List, PageIndex, 10, out i, out j, null);
        this.PageNavigator1.PageCount = j;
        this.PageNavigator1.PageIndex = PageIndex;
        this.PageNavigator1.RecordCount = i;
        dt.Columns.Add("num");
        for (int k = 0; k < dt.Rows.Count; k++)
        {
            dt.Rows[k]["num"] = k + 1 + (PageIndex - 1) * 10;
        }
        PicList.DataSource = dt;
        PicList.DataBind();
    }

    /// <summary>
    /// 控件分页
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="PageIndex"></param>
    public void PageNavigator1_PageChange(object sender, int PageIndex)
    {
        GetNoticeList(PageIndex);
    }

    /// <summary>
    /// 点击保存按钮事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Button1_Click(object sender, EventArgs e)
    {
        string id = Request.Form["ids"];
        string title = Request.Form["title"];
        string con = Request.Form["con"];

        if (!string.IsNullOrEmpty(id))
        {
            string[] ids = id.Split(',');
            string[] titles = title.Split(',');
            string[] cons = con.Split(',');

            for (int i = 0; i < ids.Length; i++)
            {
                WinStar.Model.ClassPhoto Cphoto = new WinStar.BLL.ClassPhoto().GetModel(int.Parse(ids[i]));
                Cphoto.Title = titles[i];
                Cphoto.Content = cons[i];
                new WinStar.BLL.ClassPhoto().Update(Cphoto);
            }
        }
        Common.alert("保存成功！", "PhotoManage.aspx?id=" + Request.QueryString["id"]);

    }
}