﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class ClassShow_UpPicture : IndexPageBase
{
    public string Login = "";
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]) && Session["Type"] != null)
            {
                LoadSystem(); LoadNewsType();
                int classid = int.Parse(Request.QueryString["id"]);//班级id
                if (Session["Type"].ToString() == "3")
                {
                    Response.Cookies["HclassId"].Value = classid.ToString();
                }
                if (Session["Type"].ToString() == "4")
                {
                    Response.Cookies["TclassId"].Value = classid.ToString();
                }
                
                //根据班级id获得班级对象信息
                WinStar.Model.Class cla = new WinStar.BLL.Class().GetModel(classid);

                //班级基本信息
                classlab.Text = Common.GetClassInfo(cla);
            }
            else
            {
                Response.Redirect("../Default.aspx");
            }
        }
    }

    /// <summary>
    /// 加载新闻分类
    /// </summary>
    protected void LoadNewsType()
    {
        try
        {
            DataTable dt = new WinStar.BLL.NewsType().GetAllList().Tables[0];
            this.NewsType.DataSource = dt;
            this.NewsType.DataBind();
        }
        catch { }
    }

    /// <summary>
    /// 加载配置信息
    /// </summary>
    protected void LoadSystem()
    {
        WinStar.Model.Config c = new WinStar.BLL.Config().GetModel(1);
        ViewState["SystemName"] = c.SystemName;
        ViewState["SchoolName"] = c.SName;
    }
}