﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class ClassShow_SelClassShow : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["Tid"]))
            {
                if (Session["Type"] != null)
                {
                    if (Session["Type"].ToString() != "1" || Session["Type"].ToString() != "2")
                    {
                        DataTable cladt = WinStar.DBUtility.DbHelperSQL.Query("select cla.Id cid,cla.ClassNum clanum,cla.GId gid from HS_Class cla,HS_Grade gra where cla.GId=gra.Id order by gra.TypeAge,cla.GId,cla.ClassNum").Tables[0];
                        ClassList.DataSource = cladt;
                        ClassList.DataBind();
                    }
                    else
                    {
                        Common.alert("请先以老师资格登录", "Login.aspx");
                    }
                }
                else
                {
                    Common.alert("请先登录","Login.aspx");
                }
            }
        }
    }

    /// <summary>
    /// 获得班级信息
    /// </summary>
    /// <param name="?"></param>
    /// <returns></returns>
    protected string GetClassInfo(object cid,object gid,object num)
    {
        WinStar.Model.Grade grade = new WinStar.BLL.Grade().GetModel(int.Parse(gid.ToString()));
        int nowterm;//当前学期年份
        bool onetwo;//当前学期是第一学期还是第二学期
        DataTable dt = new WinStar.BLL.Term().GetList("IsNow=1").Tables[0];
        nowterm = DateTime.Parse(dt.Rows[0]["StartTime"].ToString()).Year;
        onetwo = Boolean.Parse(dt.Rows[0]["OneOrTwo"].ToString());
        int isclass, ot;
        if (!onetwo)
        {
            ot = 1;
        }
        else
        {
            ot = 0;
        }
        isclass = nowterm - int.Parse(grade.YearIn.ToString()) + ot;

        //判断是否是所带的班级
        string tid = Session["Type"].ToString() == "3" ? Session["HteacherId"].ToString() : Session["TeacherId"].ToString();
        int count = int.Parse(WinStar.DBUtility.DbHelperSQL.GetSingle("select count(*) from HS_TeacherClass where TeacherId=" + tid + " and ClassId=" + cid).ToString());
        return count > 0 ?"<span style='color:red;'>"+GetTypeAge(grade.TypeAge.ToString()) + isclass.ToString() + "年级" + num + "班"+"</span>" : GetTypeAge(grade.TypeAge.ToString()) + isclass.ToString() + "年级" + num + "班";
    }

    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="str">年级数字</param>
    /// <returns></returns>
    protected string GetTypeAge(string str)
    {
        if (str == "1")
        {
            return "小学";
        }
        else if (str == "2")
        {
            return "初中";
        }
        else
        {
            return "高中";
        }
    }
}